/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAICreeperSwell;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCreeper
extends EntityMob {
    private static final DataParameter<Integer> STATE = EntityDataManager.createKey(EntityCreeper.class, DataSerializers.VARINT);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.createKey(EntityCreeper.class, DataSerializers.BOOLEAN);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.createKey(EntityCreeper.class, DataSerializers.BOOLEAN);
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 3;
    private int droppedSkulls;

    public EntityCreeper(World p_i1733_1_) {
        super(p_i1733_1_);
        this.setSize(0.6f, 1.7f);
    }

    @Override
    protected void initEntityAI() {
        this.tasks.addTask(1, new EntityAISwimming(this));
        this.tasks.addTask(2, new EntityAICreeperSwell(this));
        this.tasks.addTask(3, new EntityAIAvoidEntity<EntityOcelot>(this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.tasks.addTask(4, new EntityAIAttackMelee(this, 1.0, false));
        this.tasks.addTask(5, new EntityAIWanderAvoidWater(this, 0.8));
        this.tasks.addTask(6, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(6, new EntityAILookIdle(this));
        this.targetTasks.addTask(1, new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true));
        this.targetTasks.addTask(2, new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.25);
    }

    @Override
    public int getMaxFallHeight() {
        if (this.getAttackTarget() == null) {
            return 3;
        }
        return 3 + (int)(this.getHealth() - 1.0f);
    }

    @Override
    public void fall(float p_fall_1_, float p_fall_2_) {
        super.fall(p_fall_1_, p_fall_2_);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + p_fall_1_ * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(STATE, -1);
        this.dataManager.register(POWERED, false);
        this.dataManager.register(IGNITED, false);
    }

    public static void registerFixesCreeper(DataFixer p_registerFixesCreeper_0_) {
        EntityLiving.registerFixesMob(p_registerFixesCreeper_0_, EntityCreeper.class);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        if (this.dataManager.get(POWERED).booleanValue()) {
            p_writeEntityToNBT_1_.setBoolean("powered", true);
        }
        p_writeEntityToNBT_1_.setShort("Fuse", (short)this.fuseTime);
        p_writeEntityToNBT_1_.setByte("ExplosionRadius", (byte)this.explosionRadius);
        p_writeEntityToNBT_1_.setBoolean("ignited", this.hasIgnited());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.dataManager.set(POWERED, p_readEntityFromNBT_1_.getBoolean("powered"));
        if (p_readEntityFromNBT_1_.hasKey("Fuse", 99)) {
            this.fuseTime = p_readEntityFromNBT_1_.getShort("Fuse");
        }
        if (p_readEntityFromNBT_1_.hasKey("ExplosionRadius", 99)) {
            this.explosionRadius = p_readEntityFromNBT_1_.getByte("ExplosionRadius");
        }
        if (p_readEntityFromNBT_1_.getBoolean("ignited")) {
            this.ignite();
        }
    }

    @Override
    public void onUpdate() {
        if (this.isEntityAlive()) {
            int lvt_1_1_;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((lvt_1_1_ = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.playSound(SoundEvents.ENTITY_CREEPER_PRIMED, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += lvt_1_1_;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        super.onUpdate();
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_CREEPER_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_CREEPER_DEATH;
    }

    @Override
    public void onDeath(DamageSource p_onDeath_1_) {
        super.onDeath(p_onDeath_1_);
        if (this.world.getGameRules().getBoolean("doMobLoot")) {
            if (p_onDeath_1_.getEntity() instanceof EntitySkeleton) {
                int lvt_2_1_ = Item.getIdFromItem(Items.RECORD_13);
                int lvt_3_1_ = Item.getIdFromItem(Items.RECORD_WAIT);
                int lvt_4_1_ = lvt_2_1_ + this.rand.nextInt(lvt_3_1_ - lvt_2_1_ + 1);
                this.dropItem(Item.getItemById(lvt_4_1_), 1);
            } else if (p_onDeath_1_.getEntity() instanceof EntityCreeper && p_onDeath_1_.getEntity() != this && ((EntityCreeper)p_onDeath_1_.getEntity()).getPowered() && ((EntityCreeper)p_onDeath_1_.getEntity()).isAIEnabled()) {
                ((EntityCreeper)p_onDeath_1_.getEntity()).incrementDroppedSkulls();
                this.entityDropItem(new ItemStack(Items.SKULL, 1, 4), 0.0f);
            }
        }
    }

    @Override
    public boolean attackEntityAsMob(Entity p_attackEntityAsMob_1_) {
        return true;
    }

    public boolean getPowered() {
        return this.dataManager.get(POWERED);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float p_getCreeperFlashIntensity_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_getCreeperFlashIntensity_1_) / (float)(this.fuseTime - 2);
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_CREEPER;
    }

    public int getCreeperState() {
        return this.dataManager.get(STATE);
    }

    public void setCreeperState(int p_setCreeperState_1_) {
        this.dataManager.set(STATE, p_setCreeperState_1_);
    }

    @Override
    public void onStruckByLightning(EntityLightningBolt p_onStruckByLightning_1_) {
        super.onStruckByLightning(p_onStruckByLightning_1_);
        this.dataManager.set(POWERED, true);
    }

    @Override
    protected boolean processInteract(EntityPlayer p_processInteract_1_, EnumHand p_processInteract_2_) {
        ItemStack lvt_3_1_ = p_processInteract_1_.getHeldItem(p_processInteract_2_);
        if (lvt_3_1_.getItem() == Items.FLINT_AND_STEEL) {
            this.world.playSound(p_processInteract_1_, this.posX, this.posY, this.posZ, SoundEvents.ITEM_FLINTANDSTEEL_USE, this.getSoundCategory(), 1.0f, this.rand.nextFloat() * 0.4f + 0.8f);
            p_processInteract_1_.swingArm(p_processInteract_2_);
            if (!this.world.isRemote) {
                this.ignite();
                lvt_3_1_.damageItem(1, p_processInteract_1_);
                return true;
            }
        }
        return super.processInteract(p_processInteract_1_, p_processInteract_2_);
    }

    private void explode() {
        if (!this.world.isRemote) {
            boolean lvt_1_1_ = this.world.getGameRules().getBoolean("mobGriefing");
            float lvt_2_1_ = this.getPowered() ? 2.0f : 1.0f;
            this.dead = true;
            this.world.createExplosion(this, this.posX, this.posY, this.posZ, (float)this.explosionRadius * lvt_2_1_, lvt_1_1_);
            this.setDead();
            this.spawnLingeringCloud();
        }
    }

    private void spawnLingeringCloud() {
        Collection<PotionEffect> lvt_1_1_ = this.getActivePotionEffects();
        if (!lvt_1_1_.isEmpty()) {
            EntityAreaEffectCloud lvt_2_1_ = new EntityAreaEffectCloud(this.world, this.posX, this.posY, this.posZ);
            lvt_2_1_.setRadius(2.5f);
            lvt_2_1_.setRadiusOnUse(-0.5f);
            lvt_2_1_.setWaitTime(10);
            lvt_2_1_.setDuration(lvt_2_1_.getDuration() / 2);
            lvt_2_1_.setRadiusPerTick(-lvt_2_1_.getRadius() / (float)lvt_2_1_.getDuration());
            for (PotionEffect lvt_4_1_ : lvt_1_1_) {
                lvt_2_1_.addEffect(new PotionEffect(lvt_4_1_));
            }
            this.world.spawnEntity(lvt_2_1_);
        }
    }

    public boolean hasIgnited() {
        return this.dataManager.get(IGNITED);
    }

    public void ignite() {
        this.dataManager.set(IGNITED, true);
    }

    public boolean isAIEnabled() {
        return this.droppedSkulls < 1 && this.world.getGameRules().getBoolean("doMobLoot");
    }

    public void incrementDroppedSkulls() {
        ++this.droppedSkulls;
    }
}

