/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityElderGuardian
extends EntityGuardian {
    public EntityElderGuardian(World p_i47288_1_) {
        super(p_i47288_1_);
        this.setSize(this.width * 2.35f, this.height * 2.35f);
        this.enablePersistence();
        if (this.wander != null) {
            this.wander.setExecutionChance(400);
        }
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.3f);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(8.0);
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(80.0);
    }

    public static void registerFixesElderGuardian(DataFixer p_registerFixesElderGuardian_0_) {
        EntityLiving.registerFixesMob(p_registerFixesElderGuardian_0_, EntityElderGuardian.class);
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_ELDER_GUARDIAN;
    }

    @Override
    public int getAttackDuration() {
        return 60;
    }

    @SideOnly(value=Side.CLIENT)
    public void setGhost() {
        this.clientSideSpikesAnimationO = this.clientSideSpikesAnimation = 1.0f;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return this.isInWater() ? SoundEvents.ENTITY_ELDER_GUARDIAN_AMBIENT : SoundEvents.ENTITY_ELDERGUARDIAN_AMBIENTLAND;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return this.isInWater() ? SoundEvents.ENTITY_ELDER_GUARDIAN_HURT : SoundEvents.ENTITY_ELDER_GUARDIAN_HURT_LAND;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return this.isInWater() ? SoundEvents.ENTITY_ELDER_GUARDIAN_DEATH : SoundEvents.ENTITY_ELDER_GUARDIAN_DEATH_LAND;
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.ENTITY_ELDER_GUARDIAN_FLOP;
    }

    @Override
    protected void updateAITasks() {
        super.updateAITasks();
        int lvt_1_1_ = 1200;
        if ((this.ticksExisted + this.getEntityId()) % 1200 == 0) {
            Potion lvt_2_1_ = MobEffects.MINING_FATIGUE;
            List<EntityPlayerMP> lvt_3_1_ = this.world.getPlayers(EntityPlayerMP.class, new Predicate<EntityPlayerMP>(){

                public boolean apply(EntityPlayerMP p_apply_1_) {
                    return EntityElderGuardian.this.getDistanceSqToEntity(p_apply_1_) < 2500.0 && p_apply_1_.interactionManager.survivalOrAdventure();
                }

                public /* synthetic */ boolean apply(Object p_apply_1_) {
                    return this.apply((EntityPlayerMP)p_apply_1_);
                }
            });
            int lvt_4_1_ = 2;
            int lvt_5_1_ = 6000;
            int lvt_6_1_ = 1200;
            for (EntityPlayerMP lvt_8_1_ : lvt_3_1_) {
                if (lvt_8_1_.isPotionActive(lvt_2_1_) && lvt_8_1_.getActivePotionEffect(lvt_2_1_).getAmplifier() >= 2 && lvt_8_1_.getActivePotionEffect(lvt_2_1_).getDuration() >= 1200) continue;
                lvt_8_1_.connection.sendPacket(new SPacketChangeGameState(10, 0.0f));
                lvt_8_1_.addPotionEffect(new PotionEffect(lvt_2_1_, 6000, 2));
            }
        }
        if (!this.hasHome()) {
            this.setHomePosAndDistance(new BlockPos(this), 16);
        }
    }
}

