/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityEvoker
extends EntityMob {
    protected static final DataParameter<Byte> DATA_SPELL_CASTING_ID = EntityDataManager.createKey(EntityEvoker.class, DataSerializers.BYTE);
    private int spellCastingTickCount;
    private int spellCastId;
    private EntitySheep wololoTarget;

    public EntityEvoker(World p_i47287_1_) {
        super(p_i47287_1_);
        this.setSize(0.6f, 1.95f);
        this.experienceValue = 10;
    }

    @Override
    protected void initEntityAI() {
        super.initEntityAI();
        this.tasks.addTask(0, new EntityAISwimming(this));
        this.tasks.addTask(1, new AICastingSpell());
        this.tasks.addTask(2, new EntityAIAvoidEntity<EntityPlayer>(this, EntityPlayer.class, 8.0f, 0.6, 1.0));
        this.tasks.addTask(4, new AISummonSpell());
        this.tasks.addTask(5, new AIAttackSpell());
        this.tasks.addTask(6, new AIWololoSpell());
        this.tasks.addTask(8, new EntityAIWander(this, 0.6));
        this.tasks.addTask(9, new EntityAIWatchClosest(this, EntityPlayer.class, 3.0f, 1.0f));
        this.tasks.addTask(10, new EntityAIWatchClosest(this, EntityLiving.class, 8.0f));
        this.targetTasks.addTask(1, new EntityAIHurtByTarget((EntityCreature)this, true, EntityEvoker.class));
        this.targetTasks.addTask(2, new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true).setUnseenMemoryTicks(300));
        this.targetTasks.addTask(3, new EntityAINearestAttackableTarget<EntityVillager>((EntityCreature)this, EntityVillager.class, false).setUnseenMemoryTicks(300));
        this.targetTasks.addTask(3, new EntityAINearestAttackableTarget<EntityIronGolem>((EntityCreature)this, EntityIronGolem.class, false));
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.5);
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(12.0);
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(24.0);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(DATA_SPELL_CASTING_ID, (byte)0);
    }

    public static void registerFixesEvoker(DataFixer p_registerFixesEvoker_0_) {
        EntityLiving.registerFixesMob(p_registerFixesEvoker_0_, EntityEvoker.class);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.spellCastingTickCount = p_readEntityFromNBT_1_.getInteger("SpellTicks");
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setInteger("SpellTicks", this.spellCastingTickCount);
    }

    @Override
    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.ILLAGER;
    }

    @Override
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_EVOCATION_ILLAGER;
    }

    public boolean isCastingSpell() {
        if (this.world.isRemote) {
            return this.dataManager.get(DATA_SPELL_CASTING_ID) > 0;
        }
        return this.spellCastingTickCount > 0;
    }

    public void setIsCastingSpell(int p_setIsCastingSpell_1_) {
        this.dataManager.set(DATA_SPELL_CASTING_ID, (byte)p_setIsCastingSpell_1_);
    }

    private int getSpellCastingTime() {
        return this.spellCastingTickCount;
    }

    @Override
    protected void updateAITasks() {
        super.updateAITasks();
        if (this.spellCastingTickCount > 0) {
            --this.spellCastingTickCount;
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.world.isRemote && this.isCastingSpell()) {
            byte lvt_1_1_ = this.dataManager.get(DATA_SPELL_CASTING_ID);
            double lvt_2_1_ = 0.7;
            double lvt_4_1_ = 0.5;
            double lvt_6_1_ = 0.2;
            if (lvt_1_1_ == 2) {
                lvt_2_1_ = 0.4;
                lvt_4_1_ = 0.3;
                lvt_6_1_ = 0.35;
            } else if (lvt_1_1_ == 1) {
                lvt_2_1_ = 0.7;
                lvt_4_1_ = 0.7;
                lvt_6_1_ = 0.8;
            }
            float lvt_8_1_ = this.renderYawOffset * ((float)Math.PI / 180) + MathHelper.cos((float)this.ticksExisted * 0.6662f) * 0.25f;
            float lvt_9_1_ = MathHelper.cos(lvt_8_1_);
            float lvt_10_1_ = MathHelper.sin(lvt_8_1_);
            this.world.spawnParticle(EnumParticleTypes.SPELL_MOB, this.posX + (double)lvt_9_1_ * 0.6, this.posY + 1.8, this.posZ + (double)lvt_10_1_ * 0.6, lvt_2_1_, lvt_4_1_, lvt_6_1_, new int[0]);
            this.world.spawnParticle(EnumParticleTypes.SPELL_MOB, this.posX - (double)lvt_9_1_ * 0.6, this.posY + 1.8, this.posZ - (double)lvt_10_1_ * 0.6, lvt_2_1_, lvt_4_1_, lvt_6_1_, new int[0]);
        }
    }

    @Override
    public boolean isOnSameTeam(Entity p_isOnSameTeam_1_) {
        if (p_isOnSameTeam_1_ == null) {
            return false;
        }
        if (p_isOnSameTeam_1_ == this) {
            return true;
        }
        if (super.isOnSameTeam(p_isOnSameTeam_1_)) {
            return true;
        }
        if (p_isOnSameTeam_1_ instanceof EntityVex) {
            return this.isOnSameTeam(((EntityVex)p_isOnSameTeam_1_).getOwner());
        }
        if (p_isOnSameTeam_1_ instanceof EntityLivingBase && ((EntityLivingBase)p_isOnSameTeam_1_).getCreatureAttribute() == EnumCreatureAttribute.ILLAGER) {
            return this.getTeam() == null && p_isOnSameTeam_1_.getTeam() == null;
        }
        return false;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_EVOCATION_ILLAGER_AMBIENT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.EVOCATION_ILLAGER_DEATH;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_EVOCATION_ILLAGER_HURT;
    }

    private void setWololoTarget(EntitySheep p_setWololoTarget_1_) {
        this.wololoTarget = p_setWololoTarget_1_;
    }

    @Nullable
    private EntitySheep getWololoTarget() {
        return this.wololoTarget;
    }

    public class AIWololoSpell
    extends AIUseSpell {
        final Predicate<EntitySheep> wololoSelector;

        public AIWololoSpell() {
            this.wololoSelector = new Predicate<EntitySheep>(){

                public boolean apply(EntitySheep p_apply_1_) {
                    return p_apply_1_.getFleeceColor() == EnumDyeColor.BLUE;
                }

                public /* synthetic */ boolean apply(Object p_apply_1_) {
                    return this.apply((EntitySheep)p_apply_1_);
                }
            };
        }

        @Override
        public boolean shouldExecute() {
            if (EntityEvoker.this.getAttackTarget() != null) {
                return false;
            }
            if (EntityEvoker.this.isCastingSpell()) {
                return false;
            }
            if (EntityEvoker.this.ticksExisted < this.nextCastTime) {
                return false;
            }
            if (!EntityEvoker.this.world.getGameRules().getBoolean("mobGriefing")) {
                return false;
            }
            List<EntitySheep> lvt_1_1_ = EntityEvoker.this.world.getEntitiesWithinAABB(EntitySheep.class, EntityEvoker.this.getEntityBoundingBox().expand(16.0, 4.0, 16.0), this.wololoSelector);
            if (lvt_1_1_.isEmpty()) {
                return false;
            }
            EntityEvoker.this.setWololoTarget(lvt_1_1_.get(EntityEvoker.this.rand.nextInt(lvt_1_1_.size())));
            return true;
        }

        @Override
        public boolean continueExecuting() {
            return EntityEvoker.this.getWololoTarget() != null && this.spellWarmup > 0;
        }

        @Override
        public void resetTask() {
            super.resetTask();
            EntityEvoker.this.setWololoTarget(null);
        }

        @Override
        protected void castSpell() {
            EntitySheep lvt_1_1_ = EntityEvoker.this.getWololoTarget();
            if (lvt_1_1_ != null && lvt_1_1_.isEntityAlive()) {
                lvt_1_1_.setFleeceColor(EnumDyeColor.RED);
            }
        }

        @Override
        protected int getCastWarmupTime() {
            return 40;
        }

        @Override
        protected int getCastingTime() {
            return 60;
        }

        @Override
        protected int getCastingInterval() {
            return 140;
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOCATION_ILLAGER_PREPARE_WOLOLO;
        }

        @Override
        protected int getSpellId() {
            return 3;
        }
    }

    class AISummonSpell
    extends AIUseSpell {
        private AISummonSpell() {
        }

        @Override
        public boolean shouldExecute() {
            if (!super.shouldExecute()) {
                return false;
            }
            int lvt_1_1_ = EntityEvoker.this.world.getEntitiesWithinAABB(EntityVex.class, EntityEvoker.this.getEntityBoundingBox().expandXyz(16.0)).size();
            return EntityEvoker.this.rand.nextInt(8) + 1 > lvt_1_1_;
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastingInterval() {
            return 340;
        }

        @Override
        protected void castSpell() {
            for (int lvt_1_1_ = 0; lvt_1_1_ < 3; ++lvt_1_1_) {
                BlockPos lvt_2_1_ = new BlockPos(EntityEvoker.this).add(-2 + EntityEvoker.this.rand.nextInt(5), 1, -2 + EntityEvoker.this.rand.nextInt(5));
                EntityVex lvt_3_1_ = new EntityVex(EntityEvoker.this.world);
                lvt_3_1_.moveToBlockPosAndAngles(lvt_2_1_, 0.0f, 0.0f);
                lvt_3_1_.onInitialSpawn(EntityEvoker.this.world.getDifficultyForLocation(lvt_2_1_), null);
                lvt_3_1_.setOwner(EntityEvoker.this);
                lvt_3_1_.setBoundOrigin(lvt_2_1_);
                lvt_3_1_.setLimitedLife(20 * (30 + EntityEvoker.this.rand.nextInt(90)));
                EntityEvoker.this.world.spawnEntity(lvt_3_1_);
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOCATION_ILLAGER_PREPARE_SUMMON;
        }

        @Override
        protected int getSpellId() {
            return 1;
        }
    }

    class AIAttackSpell
    extends AIUseSpell {
        private AIAttackSpell() {
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 100;
        }

        @Override
        protected void castSpell() {
            EntityLivingBase lvt_1_1_ = EntityEvoker.this.getAttackTarget();
            double lvt_2_1_ = Math.min(lvt_1_1_.posY, EntityEvoker.this.posY);
            double lvt_4_1_ = Math.max(lvt_1_1_.posY, EntityEvoker.this.posY) + 1.0;
            float lvt_6_1_ = (float)MathHelper.atan2(lvt_1_1_.posZ - EntityEvoker.this.posZ, lvt_1_1_.posX - EntityEvoker.this.posX);
            if (EntityEvoker.this.getDistanceSqToEntity(lvt_1_1_) < 9.0) {
                for (int lvt_7_1_ = 0; lvt_7_1_ < 5; ++lvt_7_1_) {
                    float lvt_8_1_ = lvt_6_1_ + (float)lvt_7_1_ * (float)Math.PI * 0.4f;
                    this.spawnFangs(EntityEvoker.this.posX + (double)MathHelper.cos(lvt_8_1_) * 1.5, EntityEvoker.this.posZ + (double)MathHelper.sin(lvt_8_1_) * 1.5, lvt_2_1_, lvt_4_1_, lvt_8_1_, 0);
                }
                for (int lvt_7_2_ = 0; lvt_7_2_ < 8; ++lvt_7_2_) {
                    float lvt_8_2_ = lvt_6_1_ + (float)lvt_7_2_ * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.spawnFangs(EntityEvoker.this.posX + (double)MathHelper.cos(lvt_8_2_) * 2.5, EntityEvoker.this.posZ + (double)MathHelper.sin(lvt_8_2_) * 2.5, lvt_2_1_, lvt_4_1_, lvt_8_2_, 3);
                }
            } else {
                for (int lvt_7_3_ = 0; lvt_7_3_ < 16; ++lvt_7_3_) {
                    double lvt_8_3_ = 1.25 * (double)(lvt_7_3_ + 1);
                    int lvt_10_1_ = 1 * lvt_7_3_;
                    this.spawnFangs(EntityEvoker.this.posX + (double)MathHelper.cos(lvt_6_1_) * lvt_8_3_, EntityEvoker.this.posZ + (double)MathHelper.sin(lvt_6_1_) * lvt_8_3_, lvt_2_1_, lvt_4_1_, lvt_6_1_, lvt_10_1_);
                }
            }
        }

        private void spawnFangs(double p_spawnFangs_1_, double p_spawnFangs_3_, double p_spawnFangs_5_, double p_spawnFangs_7_, float p_spawnFangs_9_, int p_spawnFangs_10_) {
            BlockPos lvt_11_1_ = new BlockPos(p_spawnFangs_1_, p_spawnFangs_7_, p_spawnFangs_3_);
            boolean lvt_12_1_ = false;
            double lvt_13_1_ = 0.0;
            do {
                IBlockState lvt_15_1_;
                AxisAlignedBB lvt_16_1_;
                if (EntityEvoker.this.world.isBlockNormalCube(lvt_11_1_, true) || !EntityEvoker.this.world.isBlockNormalCube(lvt_11_1_.down(), true)) continue;
                if (!EntityEvoker.this.world.isAirBlock(lvt_11_1_) && (lvt_16_1_ = (lvt_15_1_ = EntityEvoker.this.world.getBlockState(lvt_11_1_)).getCollisionBoundingBox(EntityEvoker.this.world, lvt_11_1_)) != null) {
                    lvt_13_1_ = lvt_16_1_.maxY;
                }
                lvt_12_1_ = true;
                break;
            } while ((lvt_11_1_ = lvt_11_1_.down()).getY() >= MathHelper.floor(p_spawnFangs_5_) - 1);
            if (lvt_12_1_) {
                EntityEvokerFangs lvt_15_2_ = new EntityEvokerFangs(EntityEvoker.this.world, p_spawnFangs_1_, (double)lvt_11_1_.getY() + lvt_13_1_, p_spawnFangs_3_, p_spawnFangs_9_, p_spawnFangs_10_, EntityEvoker.this);
                EntityEvoker.this.world.spawnEntity(lvt_15_2_);
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOCATION_ILLAGER_PREPARE_ATTACK;
        }

        @Override
        protected int getSpellId() {
            return 2;
        }
    }

    abstract class AIUseSpell
    extends EntityAIBase {
        protected int spellWarmup;
        protected int nextCastTime;

        private AIUseSpell() {
        }

        @Override
        public boolean shouldExecute() {
            if (EntityEvoker.this.getAttackTarget() == null) {
                return false;
            }
            if (EntityEvoker.this.isCastingSpell()) {
                return false;
            }
            return EntityEvoker.this.ticksExisted >= this.nextCastTime;
        }

        @Override
        public boolean continueExecuting() {
            return EntityEvoker.this.getAttackTarget() != null && this.spellWarmup > 0;
        }

        @Override
        public void startExecuting() {
            this.spellWarmup = this.getCastWarmupTime();
            EntityEvoker.this.spellCastingTickCount = this.getCastingTime();
            this.nextCastTime = EntityEvoker.this.ticksExisted + this.getCastingInterval();
            EntityEvoker.this.playSound(this.getSpellPrepareSound(), 1.0f, 1.0f);
            EntityEvoker.this.spellCastId = this.getSpellId();
        }

        @Override
        public void updateTask() {
            --this.spellWarmup;
            if (this.spellWarmup == 0) {
                this.castSpell();
                EntityEvoker.this.playSound(SoundEvents.EVOCATION_ILLAGER_CAST_SPELL, 1.0f, 1.0f);
            }
        }

        protected abstract void castSpell();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        protected abstract SoundEvent getSpellPrepareSound();

        protected abstract int getSpellId();
    }

    class AICastingSpell
    extends EntityAIBase {
        public AICastingSpell() {
            this.setMutexBits(3);
        }

        @Override
        public boolean shouldExecute() {
            return EntityEvoker.this.getSpellCastingTime() > 0;
        }

        @Override
        public void startExecuting() {
            super.startExecuting();
            EntityEvoker.this.setIsCastingSpell(EntityEvoker.this.spellCastId);
            EntityEvoker.this.navigator.clearPathEntity();
        }

        @Override
        public void resetTask() {
            super.resetTask();
            EntityEvoker.this.setIsCastingSpell(0);
        }

        @Override
        public void updateTask() {
            if (EntityEvoker.this.getAttackTarget() != null) {
                EntityEvoker.this.getLookHelper().setLookPositionWithEntity(EntityEvoker.this.getAttackTarget(), EntityEvoker.this.getHorizontalFaceSpeed(), EntityEvoker.this.getVerticalFaceSpeed());
            } else if (EntityEvoker.this.getWololoTarget() != null) {
                EntityEvoker.this.getLookHelper().setLookPositionWithEntity(EntityEvoker.this.getWololoTarget(), EntityEvoker.this.getHorizontalFaceSpeed(), EntityEvoker.this.getVerticalFaceSpeed());
            }
        }
    }
}

