/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.stats.AchievementList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGhast
extends EntityFlying
implements IMob {
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.createKey(EntityGhast.class, DataSerializers.BOOLEAN);
    private int explosionStrength = 1;

    public EntityGhast(World p_i1735_1_) {
        super(p_i1735_1_);
        this.setSize(4.0f, 4.0f);
        this.isImmuneToFire = true;
        this.experienceValue = 5;
        this.moveHelper = new GhastMoveHelper(this);
    }

    @Override
    protected void initEntityAI() {
        this.tasks.addTask(5, new AIRandomFly(this));
        this.tasks.addTask(7, new AILookAround(this));
        this.tasks.addTask(7, new AIFireballAttack(this));
        this.targetTasks.addTask(1, new EntityAIFindEntityNearestPlayer(this));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAttacking() {
        return this.dataManager.get(ATTACKING);
    }

    public void setAttacking(boolean p_setAttacking_1_) {
        this.dataManager.set(ATTACKING, p_setAttacking_1_);
    }

    public int getFireballStrength() {
        return this.explosionStrength;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.world.isRemote && this.world.getDifficulty() == EnumDifficulty.PEACEFUL) {
            this.setDead();
        }
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        if (this.isEntityInvulnerable(p_attackEntityFrom_1_)) {
            return false;
        }
        if ("fireball".equals(p_attackEntityFrom_1_.getDamageType()) && p_attackEntityFrom_1_.getEntity() instanceof EntityPlayer) {
            super.attackEntityFrom(p_attackEntityFrom_1_, 1000.0f);
            ((EntityPlayer)p_attackEntityFrom_1_.getEntity()).addStat(AchievementList.GHAST);
            return true;
        }
        return super.attackEntityFrom(p_attackEntityFrom_1_, p_attackEntityFrom_2_);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(ATTACKING, false);
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(10.0);
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(100.0);
    }

    @Override
    public SoundCategory getSoundCategory() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_GHAST_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_GHAST_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_GHAST_DEATH;
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_GHAST;
    }

    @Override
    protected float getSoundVolume() {
        return 10.0f;
    }

    @Override
    public boolean getCanSpawnHere() {
        return this.rand.nextInt(20) == 0 && super.getCanSpawnHere() && this.world.getDifficulty() != EnumDifficulty.PEACEFUL;
    }

    @Override
    public int getMaxSpawnedInChunk() {
        return 1;
    }

    public static void registerFixesGhast(DataFixer p_registerFixesGhast_0_) {
        EntityLiving.registerFixesMob(p_registerFixesGhast_0_, EntityGhast.class);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setInteger("ExplosionPower", this.explosionStrength);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        if (p_readEntityFromNBT_1_.hasKey("ExplosionPower", 99)) {
            this.explosionStrength = p_readEntityFromNBT_1_.getInteger("ExplosionPower");
        }
    }

    @Override
    public float getEyeHeight() {
        return 2.6f;
    }

    static class AIFireballAttack
    extends EntityAIBase {
        private final EntityGhast parentEntity;
        public int attackTimer;

        public AIFireballAttack(EntityGhast p_i45837_1_) {
            this.parentEntity = p_i45837_1_;
        }

        @Override
        public boolean shouldExecute() {
            return this.parentEntity.getAttackTarget() != null;
        }

        @Override
        public void startExecuting() {
            this.attackTimer = 0;
        }

        @Override
        public void resetTask() {
            this.parentEntity.setAttacking(false);
        }

        @Override
        public void updateTask() {
            EntityLivingBase lvt_1_1_ = this.parentEntity.getAttackTarget();
            double lvt_2_1_ = 64.0;
            if (lvt_1_1_.getDistanceSqToEntity(this.parentEntity) < 4096.0 && this.parentEntity.canEntityBeSeen(lvt_1_1_)) {
                World lvt_4_1_ = this.parentEntity.world;
                ++this.attackTimer;
                if (this.attackTimer == 10) {
                    lvt_4_1_.playEvent(null, 1015, new BlockPos(this.parentEntity), 0);
                }
                if (this.attackTimer == 20) {
                    double lvt_5_1_ = 4.0;
                    Vec3d lvt_7_1_ = this.parentEntity.getLook(1.0f);
                    double lvt_8_1_ = lvt_1_1_.posX - (this.parentEntity.posX + lvt_7_1_.xCoord * 4.0);
                    double lvt_10_1_ = lvt_1_1_.getEntityBoundingBox().minY + (double)(lvt_1_1_.height / 2.0f) - (0.5 + this.parentEntity.posY + (double)(this.parentEntity.height / 2.0f));
                    double lvt_12_1_ = lvt_1_1_.posZ - (this.parentEntity.posZ + lvt_7_1_.zCoord * 4.0);
                    lvt_4_1_.playEvent(null, 1016, new BlockPos(this.parentEntity), 0);
                    EntityLargeFireball lvt_14_1_ = new EntityLargeFireball(lvt_4_1_, this.parentEntity, lvt_8_1_, lvt_10_1_, lvt_12_1_);
                    lvt_14_1_.explosionPower = this.parentEntity.getFireballStrength();
                    lvt_14_1_.posX = this.parentEntity.posX + lvt_7_1_.xCoord * 4.0;
                    lvt_14_1_.posY = this.parentEntity.posY + (double)(this.parentEntity.height / 2.0f) + 0.5;
                    lvt_14_1_.posZ = this.parentEntity.posZ + lvt_7_1_.zCoord * 4.0;
                    lvt_4_1_.spawnEntity(lvt_14_1_);
                    this.attackTimer = -40;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            this.parentEntity.setAttacking(this.attackTimer > 10);
        }
    }

    static class AILookAround
    extends EntityAIBase {
        private final EntityGhast parentEntity;

        public AILookAround(EntityGhast p_i45839_1_) {
            this.parentEntity = p_i45839_1_;
            this.setMutexBits(2);
        }

        @Override
        public boolean shouldExecute() {
            return true;
        }

        @Override
        public void updateTask() {
            if (this.parentEntity.getAttackTarget() == null) {
                this.parentEntity.renderYawOffset = this.parentEntity.rotationYaw = -((float)MathHelper.atan2(this.parentEntity.motionX, this.parentEntity.motionZ)) * 57.295776f;
            } else {
                EntityLivingBase lvt_1_1_ = this.parentEntity.getAttackTarget();
                double lvt_2_1_ = 64.0;
                if (lvt_1_1_.getDistanceSqToEntity(this.parentEntity) < 4096.0) {
                    double lvt_4_1_ = lvt_1_1_.posX - this.parentEntity.posX;
                    double lvt_6_1_ = lvt_1_1_.posZ - this.parentEntity.posZ;
                    this.parentEntity.renderYawOffset = this.parentEntity.rotationYaw = -((float)MathHelper.atan2(lvt_4_1_, lvt_6_1_)) * 57.295776f;
                }
            }
        }
    }

    static class AIRandomFly
    extends EntityAIBase {
        private final EntityGhast parentEntity;

        public AIRandomFly(EntityGhast p_i45836_1_) {
            this.parentEntity = p_i45836_1_;
            this.setMutexBits(1);
        }

        @Override
        public boolean shouldExecute() {
            double lvt_6_1_;
            double lvt_4_1_;
            EntityMoveHelper lvt_1_1_ = this.parentEntity.getMoveHelper();
            if (!lvt_1_1_.isUpdating()) {
                return true;
            }
            double lvt_2_1_ = lvt_1_1_.getX() - this.parentEntity.posX;
            double lvt_8_1_ = lvt_2_1_ * lvt_2_1_ + (lvt_4_1_ = lvt_1_1_.getY() - this.parentEntity.posY) * lvt_4_1_ + (lvt_6_1_ = lvt_1_1_.getZ() - this.parentEntity.posZ) * lvt_6_1_;
            return lvt_8_1_ < 1.0 || lvt_8_1_ > 3600.0;
        }

        @Override
        public boolean continueExecuting() {
            return false;
        }

        @Override
        public void startExecuting() {
            Random lvt_1_1_ = this.parentEntity.getRNG();
            double lvt_2_1_ = this.parentEntity.posX + (double)((lvt_1_1_.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double lvt_4_1_ = this.parentEntity.posY + (double)((lvt_1_1_.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double lvt_6_1_ = this.parentEntity.posZ + (double)((lvt_1_1_.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.getMoveHelper().setMoveTo(lvt_2_1_, lvt_4_1_, lvt_6_1_, 1.0);
        }
    }

    static class GhastMoveHelper
    extends EntityMoveHelper {
        private final EntityGhast parentEntity;
        private int courseChangeCooldown;

        public GhastMoveHelper(EntityGhast p_i45838_1_) {
            super(p_i45838_1_);
            this.parentEntity = p_i45838_1_;
        }

        @Override
        public void onUpdateMoveHelper() {
            if (this.action != EntityMoveHelper.Action.MOVE_TO) {
                return;
            }
            double lvt_1_1_ = this.posX - this.parentEntity.posX;
            double lvt_3_1_ = this.posY - this.parentEntity.posY;
            double lvt_5_1_ = this.posZ - this.parentEntity.posZ;
            double lvt_7_1_ = lvt_1_1_ * lvt_1_1_ + lvt_3_1_ * lvt_3_1_ + lvt_5_1_ * lvt_5_1_;
            if (this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.parentEntity.getRNG().nextInt(5) + 2;
                if (this.isNotColliding(this.posX, this.posY, this.posZ, lvt_7_1_ = (double)MathHelper.sqrt(lvt_7_1_))) {
                    this.parentEntity.motionX += lvt_1_1_ / lvt_7_1_ * 0.1;
                    this.parentEntity.motionY += lvt_3_1_ / lvt_7_1_ * 0.1;
                    this.parentEntity.motionZ += lvt_5_1_ / lvt_7_1_ * 0.1;
                } else {
                    this.action = EntityMoveHelper.Action.WAIT;
                }
            }
        }

        private boolean isNotColliding(double p_isNotColliding_1_, double p_isNotColliding_3_, double p_isNotColliding_5_, double p_isNotColliding_7_) {
            double lvt_9_1_ = (p_isNotColliding_1_ - this.parentEntity.posX) / p_isNotColliding_7_;
            double lvt_11_1_ = (p_isNotColliding_3_ - this.parentEntity.posY) / p_isNotColliding_7_;
            double lvt_13_1_ = (p_isNotColliding_5_ - this.parentEntity.posZ) / p_isNotColliding_7_;
            AxisAlignedBB lvt_15_1_ = this.parentEntity.getEntityBoundingBox();
            int lvt_16_1_ = 1;
            while ((double)lvt_16_1_ < p_isNotColliding_7_) {
                if (!this.parentEntity.world.getCollisionBoxes(this.parentEntity, lvt_15_1_ = lvt_15_1_.offset(lvt_9_1_, lvt_11_1_, lvt_13_1_)).isEmpty()) {
                    return false;
                }
                ++lvt_16_1_;
            }
            return true;
        }
    }
}

