/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGuardian
extends EntityMob {
    private static final DataParameter<Boolean> MOVING = EntityDataManager.createKey(EntityGuardian.class, DataSerializers.BOOLEAN);
    private static final DataParameter<Integer> TARGET_ENTITY = EntityDataManager.createKey(EntityGuardian.class, DataSerializers.VARINT);
    protected float clientSideTailAnimation;
    protected float clientSideTailAnimationO;
    protected float clientSideTailAnimationSpeed;
    protected float clientSideSpikesAnimation;
    protected float clientSideSpikesAnimationO;
    private EntityLivingBase targetedEntity;
    private int clientSideAttackTime;
    private boolean clientSideTouchedGround;
    protected EntityAIWander wander;

    public EntityGuardian(World p_i45835_1_) {
        super(p_i45835_1_);
        this.experienceValue = 10;
        this.setSize(0.85f, 0.85f);
        this.moveHelper = new GuardianMoveHelper(this);
        this.clientSideTailAnimationO = this.clientSideTailAnimation = this.rand.nextFloat();
    }

    @Override
    protected void initEntityAI() {
        EntityAIMoveTowardsRestriction lvt_1_1_ = new EntityAIMoveTowardsRestriction(this, 1.0);
        this.wander = new EntityAIWander(this, 1.0, 80);
        this.tasks.addTask(4, new AIGuardianAttack(this));
        this.tasks.addTask(5, lvt_1_1_);
        this.tasks.addTask(7, this.wander);
        this.tasks.addTask(8, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(8, new EntityAIWatchClosest(this, EntityGuardian.class, 12.0f, 0.01f));
        this.tasks.addTask(9, new EntityAILookIdle(this));
        this.wander.setMutexBits(3);
        lvt_1_1_.setMutexBits(3);
        this.targetTasks.addTask(1, new EntityAINearestAttackableTarget<EntityLivingBase>(this, EntityLivingBase.class, 10, true, false, new GuardianTargetSelector(this)));
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(6.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.5);
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(16.0);
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(30.0);
    }

    public static void registerFixesGuardian(DataFixer p_registerFixesGuardian_0_) {
        EntityLiving.registerFixesMob(p_registerFixesGuardian_0_, EntityGuardian.class);
    }

    @Override
    protected PathNavigate createNavigator(World p_createNavigator_1_) {
        return new PathNavigateSwimmer(this, p_createNavigator_1_);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(MOVING, false);
        this.dataManager.register(TARGET_ENTITY, 0);
    }

    public boolean isMoving() {
        return this.dataManager.get(MOVING);
    }

    private void setMoving(boolean p_setMoving_1_) {
        this.dataManager.set(MOVING, p_setMoving_1_);
    }

    public int getAttackDuration() {
        return 80;
    }

    private void setTargetedEntity(int p_setTargetedEntity_1_) {
        this.dataManager.set(TARGET_ENTITY, p_setTargetedEntity_1_);
    }

    public boolean hasTargetedEntity() {
        return this.dataManager.get(TARGET_ENTITY) != 0;
    }

    @Nullable
    public EntityLivingBase getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.world.isRemote) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity lvt_1_1_ = this.world.getEntityByID(this.dataManager.get(TARGET_ENTITY));
            if (lvt_1_1_ instanceof EntityLivingBase) {
                this.targetedEntity = (EntityLivingBase)lvt_1_1_;
                return this.targetedEntity;
            }
            return null;
        }
        return this.getAttackTarget();
    }

    @Override
    public void notifyDataManagerChange(DataParameter<?> p_notifyDataManagerChange_1_) {
        super.notifyDataManagerChange(p_notifyDataManagerChange_1_);
        if (TARGET_ENTITY.equals(p_notifyDataManagerChange_1_)) {
            this.clientSideAttackTime = 0;
            this.targetedEntity = null;
        }
    }

    @Override
    public int getTalkInterval() {
        return 160;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return this.isInWater() ? SoundEvents.ENTITY_GUARDIAN_AMBIENT : SoundEvents.ENTITY_GUARDIAN_AMBIENT_LAND;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return this.isInWater() ? SoundEvents.ENTITY_GUARDIAN_HURT : SoundEvents.ENTITY_GUARDIAN_HURT_LAND;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return this.isInWater() ? SoundEvents.ENTITY_GUARDIAN_DEATH : SoundEvents.ENTITY_GUARDIAN_DEATH_LAND;
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    public float getEyeHeight() {
        return this.height * 0.5f;
    }

    @Override
    public float getBlockPathWeight(BlockPos p_getBlockPathWeight_1_) {
        if (this.world.getBlockState(p_getBlockPathWeight_1_).getMaterial() == Material.WATER) {
            return 10.0f + this.world.getLightBrightness(p_getBlockPathWeight_1_) - 0.5f;
        }
        return super.getBlockPathWeight(p_getBlockPathWeight_1_);
    }

    @Override
    public void onLivingUpdate() {
        if (this.world.isRemote) {
            this.clientSideTailAnimationO = this.clientSideTailAnimation;
            if (!this.isInWater()) {
                this.clientSideTailAnimationSpeed = 2.0f;
                if (this.motionY > 0.0 && this.clientSideTouchedGround && !this.isSilent()) {
                    this.world.playSound(this.posX, this.posY, this.posZ, this.getFlopSound(), this.getSoundCategory(), 1.0f, 1.0f, false);
                }
                this.clientSideTouchedGround = this.motionY < 0.0 && this.world.isBlockNormalCube(new BlockPos(this).down(), false);
            } else {
                this.clientSideTailAnimationSpeed = this.isMoving() ? (this.clientSideTailAnimationSpeed < 0.5f ? 4.0f : (this.clientSideTailAnimationSpeed += (0.5f - this.clientSideTailAnimationSpeed) * 0.1f)) : (this.clientSideTailAnimationSpeed += (0.125f - this.clientSideTailAnimationSpeed) * 0.2f);
            }
            this.clientSideTailAnimation += this.clientSideTailAnimationSpeed;
            this.clientSideSpikesAnimationO = this.clientSideSpikesAnimation;
            this.clientSideSpikesAnimation = !this.isInWater() ? this.rand.nextFloat() : (this.isMoving() ? (this.clientSideSpikesAnimation += (0.0f - this.clientSideSpikesAnimation) * 0.25f) : (this.clientSideSpikesAnimation += (1.0f - this.clientSideSpikesAnimation) * 0.06f));
            if (this.isMoving() && this.isInWater()) {
                Vec3d lvt_1_1_ = this.getLook(0.0f);
                for (int lvt_2_1_ = 0; lvt_2_1_ < 2; ++lvt_2_1_) {
                    this.world.spawnParticle(EnumParticleTypes.WATER_BUBBLE, this.posX + (this.rand.nextDouble() - 0.5) * (double)this.width - lvt_1_1_.xCoord * 1.5, this.posY + this.rand.nextDouble() * (double)this.height - lvt_1_1_.yCoord * 1.5, this.posZ + (this.rand.nextDouble() - 0.5) * (double)this.width - lvt_1_1_.zCoord * 1.5, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            if (this.hasTargetedEntity()) {
                EntityLivingBase lvt_1_2_;
                if (this.clientSideAttackTime < this.getAttackDuration()) {
                    ++this.clientSideAttackTime;
                }
                if ((lvt_1_2_ = this.getTargetedEntity()) != null) {
                    this.getLookHelper().setLookPositionWithEntity(lvt_1_2_, 90.0f, 90.0f);
                    this.getLookHelper().onUpdateLook();
                    double lvt_2_2_ = this.getAttackAnimationScale(0.0f);
                    double lvt_4_1_ = lvt_1_2_.posX - this.posX;
                    double lvt_6_1_ = lvt_1_2_.posY + (double)(lvt_1_2_.height * 0.5f) - (this.posY + (double)this.getEyeHeight());
                    double lvt_8_1_ = lvt_1_2_.posZ - this.posZ;
                    double lvt_10_1_ = Math.sqrt(lvt_4_1_ * lvt_4_1_ + lvt_6_1_ * lvt_6_1_ + lvt_8_1_ * lvt_8_1_);
                    lvt_4_1_ /= lvt_10_1_;
                    lvt_6_1_ /= lvt_10_1_;
                    lvt_8_1_ /= lvt_10_1_;
                    double lvt_12_1_ = this.rand.nextDouble();
                    while (lvt_12_1_ < lvt_10_1_) {
                        this.world.spawnParticle(EnumParticleTypes.WATER_BUBBLE, this.posX + lvt_4_1_ * (lvt_12_1_ += 1.8 - lvt_2_2_ + this.rand.nextDouble() * (1.7 - lvt_2_2_)), this.posY + lvt_6_1_ * lvt_12_1_ + (double)this.getEyeHeight(), this.posZ + lvt_8_1_ * lvt_12_1_, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
        }
        if (this.inWater) {
            this.setAir(300);
        } else if (this.onGround) {
            this.motionY += 0.5;
            this.motionX += (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 0.4f);
            this.motionZ += (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 0.4f);
            this.rotationYaw = this.rand.nextFloat() * 360.0f;
            this.onGround = false;
            this.isAirBorne = true;
        }
        if (this.hasTargetedEntity()) {
            this.rotationYaw = this.rotationYawHead;
        }
        super.onLivingUpdate();
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.ENTITY_GUARDIAN_FLOP;
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailAnimation(float p_getTailAnimation_1_) {
        return this.clientSideTailAnimationO + (this.clientSideTailAnimation - this.clientSideTailAnimationO) * p_getTailAnimation_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSpikesAnimation(float p_getSpikesAnimation_1_) {
        return this.clientSideSpikesAnimationO + (this.clientSideSpikesAnimation - this.clientSideSpikesAnimationO) * p_getSpikesAnimation_1_;
    }

    public float getAttackAnimationScale(float p_getAttackAnimationScale_1_) {
        return ((float)this.clientSideAttackTime + p_getAttackAnimationScale_1_) / (float)this.getAttackDuration();
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_GUARDIAN;
    }

    @Override
    protected boolean isValidLightLevel() {
        return true;
    }

    @Override
    public boolean isNotColliding() {
        return this.world.checkNoEntityCollision(this.getEntityBoundingBox(), this) && this.world.getCollisionBoxes(this, this.getEntityBoundingBox()).isEmpty();
    }

    @Override
    public boolean getCanSpawnHere() {
        return (this.rand.nextInt(20) == 0 || !this.world.canBlockSeeSky(new BlockPos(this))) && super.getCanSpawnHere();
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        if (!this.isMoving() && !p_attackEntityFrom_1_.isMagicDamage() && p_attackEntityFrom_1_.getSourceOfDamage() instanceof EntityLivingBase) {
            EntityLivingBase lvt_3_1_ = (EntityLivingBase)p_attackEntityFrom_1_.getSourceOfDamage();
            if (!p_attackEntityFrom_1_.isExplosion()) {
                lvt_3_1_.attackEntityFrom(DamageSource.causeThornsDamage(this), 2.0f);
            }
        }
        if (this.wander != null) {
            this.wander.makeUpdate();
        }
        return super.attackEntityFrom(p_attackEntityFrom_1_, p_attackEntityFrom_2_);
    }

    @Override
    public int getVerticalFaceSpeed() {
        return 180;
    }

    @Override
    public void moveEntityWithHeading(float p_moveEntityWithHeading_1_, float p_moveEntityWithHeading_2_) {
        if (this.isServerWorld() && this.isInWater()) {
            this.moveRelative(p_moveEntityWithHeading_1_, p_moveEntityWithHeading_2_, 0.1f);
            this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)0.9f;
            this.motionY *= (double)0.9f;
            this.motionZ *= (double)0.9f;
            if (!this.isMoving() && this.getAttackTarget() == null) {
                this.motionY -= 0.005;
            }
        } else {
            super.moveEntityWithHeading(p_moveEntityWithHeading_1_, p_moveEntityWithHeading_2_);
        }
    }

    static class GuardianMoveHelper
    extends EntityMoveHelper {
        private final EntityGuardian entityGuardian;

        public GuardianMoveHelper(EntityGuardian p_i45831_1_) {
            super(p_i45831_1_);
            this.entityGuardian = p_i45831_1_;
        }

        @Override
        public void onUpdateMoveHelper() {
            if (this.action != EntityMoveHelper.Action.MOVE_TO || this.entityGuardian.getNavigator().noPath()) {
                this.entityGuardian.setAIMoveSpeed(0.0f);
                this.entityGuardian.setMoving(false);
                return;
            }
            double lvt_1_1_ = this.posX - this.entityGuardian.posX;
            double lvt_3_1_ = this.posY - this.entityGuardian.posY;
            double lvt_5_1_ = this.posZ - this.entityGuardian.posZ;
            double lvt_7_1_ = MathHelper.sqrt(lvt_1_1_ * lvt_1_1_ + lvt_3_1_ * lvt_3_1_ + lvt_5_1_ * lvt_5_1_);
            lvt_3_1_ /= lvt_7_1_;
            float lvt_9_1_ = (float)(MathHelper.atan2(lvt_5_1_, lvt_1_1_) * 57.2957763671875) - 90.0f;
            this.entityGuardian.renderYawOffset = this.entityGuardian.rotationYaw = this.limitAngle(this.entityGuardian.rotationYaw, lvt_9_1_, 90.0f);
            float lvt_10_1_ = (float)(this.speed * this.entityGuardian.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).getAttributeValue());
            this.entityGuardian.setAIMoveSpeed(this.entityGuardian.getAIMoveSpeed() + (lvt_10_1_ - this.entityGuardian.getAIMoveSpeed()) * 0.125f);
            double lvt_11_1_ = Math.sin((double)(this.entityGuardian.ticksExisted + this.entityGuardian.getEntityId()) * 0.5) * 0.05;
            double lvt_13_1_ = Math.cos(this.entityGuardian.rotationYaw * ((float)Math.PI / 180));
            double lvt_15_1_ = Math.sin(this.entityGuardian.rotationYaw * ((float)Math.PI / 180));
            this.entityGuardian.motionX += lvt_11_1_ * lvt_13_1_;
            this.entityGuardian.motionZ += lvt_11_1_ * lvt_15_1_;
            lvt_11_1_ = Math.sin((double)(this.entityGuardian.ticksExisted + this.entityGuardian.getEntityId()) * 0.75) * 0.05;
            this.entityGuardian.motionY += lvt_11_1_ * (lvt_15_1_ + lvt_13_1_) * 0.25;
            this.entityGuardian.motionY += (double)this.entityGuardian.getAIMoveSpeed() * lvt_3_1_ * 0.1;
            EntityLookHelper lvt_17_1_ = this.entityGuardian.getLookHelper();
            double lvt_18_1_ = this.entityGuardian.posX + lvt_1_1_ / lvt_7_1_ * 2.0;
            double lvt_20_1_ = (double)this.entityGuardian.getEyeHeight() + this.entityGuardian.posY + lvt_3_1_ / lvt_7_1_;
            double lvt_22_1_ = this.entityGuardian.posZ + lvt_5_1_ / lvt_7_1_ * 2.0;
            double lvt_24_1_ = lvt_17_1_.getLookPosX();
            double lvt_26_1_ = lvt_17_1_.getLookPosY();
            double lvt_28_1_ = lvt_17_1_.getLookPosZ();
            if (!lvt_17_1_.getIsLooking()) {
                lvt_24_1_ = lvt_18_1_;
                lvt_26_1_ = lvt_20_1_;
                lvt_28_1_ = lvt_22_1_;
            }
            this.entityGuardian.getLookHelper().setLookPosition(lvt_24_1_ + (lvt_18_1_ - lvt_24_1_) * 0.125, lvt_26_1_ + (lvt_20_1_ - lvt_26_1_) * 0.125, lvt_28_1_ + (lvt_22_1_ - lvt_28_1_) * 0.125, 10.0f, 40.0f);
            this.entityGuardian.setMoving(true);
        }
    }

    static class AIGuardianAttack
    extends EntityAIBase {
        private final EntityGuardian theEntity;
        private int tickCounter;
        private final boolean isElder;

        public AIGuardianAttack(EntityGuardian p_i45833_1_) {
            this.theEntity = p_i45833_1_;
            this.isElder = p_i45833_1_ instanceof EntityElderGuardian;
            this.setMutexBits(3);
        }

        @Override
        public boolean shouldExecute() {
            EntityLivingBase lvt_1_1_ = this.theEntity.getAttackTarget();
            return lvt_1_1_ != null && lvt_1_1_.isEntityAlive();
        }

        @Override
        public boolean continueExecuting() {
            return super.continueExecuting() && (this.isElder || this.theEntity.getDistanceSqToEntity(this.theEntity.getAttackTarget()) > 9.0);
        }

        @Override
        public void startExecuting() {
            this.tickCounter = -10;
            this.theEntity.getNavigator().clearPathEntity();
            this.theEntity.getLookHelper().setLookPositionWithEntity(this.theEntity.getAttackTarget(), 90.0f, 90.0f);
            this.theEntity.isAirBorne = true;
        }

        @Override
        public void resetTask() {
            this.theEntity.setTargetedEntity(0);
            this.theEntity.setAttackTarget(null);
            this.theEntity.wander.makeUpdate();
        }

        @Override
        public void updateTask() {
            EntityLivingBase lvt_1_1_ = this.theEntity.getAttackTarget();
            this.theEntity.getNavigator().clearPathEntity();
            this.theEntity.getLookHelper().setLookPositionWithEntity(lvt_1_1_, 90.0f, 90.0f);
            if (!this.theEntity.canEntityBeSeen(lvt_1_1_)) {
                this.theEntity.setAttackTarget(null);
                return;
            }
            ++this.tickCounter;
            if (this.tickCounter == 0) {
                this.theEntity.setTargetedEntity(this.theEntity.getAttackTarget().getEntityId());
                this.theEntity.world.setEntityState(this.theEntity, (byte)21);
            } else if (this.tickCounter >= this.theEntity.getAttackDuration()) {
                float lvt_2_1_ = 1.0f;
                if (this.theEntity.world.getDifficulty() == EnumDifficulty.HARD) {
                    lvt_2_1_ += 2.0f;
                }
                if (this.isElder) {
                    lvt_2_1_ += 2.0f;
                }
                lvt_1_1_.attackEntityFrom(DamageSource.causeIndirectMagicDamage(this.theEntity, this.theEntity), lvt_2_1_);
                lvt_1_1_.attackEntityFrom(DamageSource.causeMobDamage(this.theEntity), (float)this.theEntity.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).getAttributeValue());
                this.theEntity.setAttackTarget(null);
            }
            super.updateTask();
        }
    }

    static class GuardianTargetSelector
    implements Predicate<EntityLivingBase> {
        private final EntityGuardian parentEntity;

        public GuardianTargetSelector(EntityGuardian p_i45832_1_) {
            this.parentEntity = p_i45832_1_;
        }

        public boolean apply(EntityLivingBase p_apply_1_) {
            return (p_apply_1_ instanceof EntityPlayer || p_apply_1_ instanceof EntitySquid) && p_apply_1_.getDistanceSqToEntity(this.parentEntity) > 9.0;
        }

        public /* synthetic */ boolean apply(Object p_apply_1_) {
            return this.apply((EntityLivingBase)p_apply_1_);
        }
    }
}

