/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public abstract class EntityMob
extends EntityCreature
implements IMob {
    public EntityMob(World p_i1738_1_) {
        super(p_i1738_1_);
        this.experienceValue = 5;
    }

    @Override
    public SoundCategory getSoundCategory() {
        return SoundCategory.HOSTILE;
    }

    @Override
    public void onLivingUpdate() {
        this.updateArmSwingProgress();
        float lvt_1_1_ = this.getBrightness(1.0f);
        if (lvt_1_1_ > 0.5f) {
            this.entityAge += 2;
        }
        super.onLivingUpdate();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.world.isRemote && this.world.getDifficulty() == EnumDifficulty.PEACEFUL) {
            this.setDead();
        }
    }

    @Override
    protected SoundEvent getSwimSound() {
        return SoundEvents.ENTITY_HOSTILE_SWIM;
    }

    @Override
    protected SoundEvent getSplashSound() {
        return SoundEvents.ENTITY_HOSTILE_SPLASH;
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        if (this.isEntityInvulnerable(p_attackEntityFrom_1_)) {
            return false;
        }
        return super.attackEntityFrom(p_attackEntityFrom_1_, p_attackEntityFrom_2_);
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_HOSTILE_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_HOSTILE_DEATH;
    }

    @Override
    protected SoundEvent getFallSound(int p_getFallSound_1_) {
        if (p_getFallSound_1_ > 4) {
            return SoundEvents.ENTITY_HOSTILE_BIG_FALL;
        }
        return SoundEvents.ENTITY_HOSTILE_SMALL_FALL;
    }

    @Override
    public boolean attackEntityAsMob(Entity p_attackEntityAsMob_1_) {
        boolean lvt_4_1_;
        float lvt_2_1_ = (float)this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).getAttributeValue();
        int lvt_3_1_ = 0;
        if (p_attackEntityAsMob_1_ instanceof EntityLivingBase) {
            lvt_2_1_ += EnchantmentHelper.getModifierForCreature(this.getHeldItemMainhand(), ((EntityLivingBase)p_attackEntityAsMob_1_).getCreatureAttribute());
            lvt_3_1_ += EnchantmentHelper.getKnockbackModifier(this);
        }
        if (lvt_4_1_ = p_attackEntityAsMob_1_.attackEntityFrom(DamageSource.causeMobDamage(this), lvt_2_1_)) {
            int lvt_5_1_;
            if (lvt_3_1_ > 0 && p_attackEntityAsMob_1_ instanceof EntityLivingBase) {
                ((EntityLivingBase)p_attackEntityAsMob_1_).knockBack(this, (float)lvt_3_1_ * 0.5f, MathHelper.sin(this.rotationYaw * ((float)Math.PI / 180)), -MathHelper.cos(this.rotationYaw * ((float)Math.PI / 180)));
                this.motionX *= 0.6;
                this.motionZ *= 0.6;
            }
            if ((lvt_5_1_ = EnchantmentHelper.getFireAspectModifier(this)) > 0) {
                p_attackEntityAsMob_1_.setFire(lvt_5_1_ * 4);
            }
            if (p_attackEntityAsMob_1_ instanceof EntityPlayer) {
                ItemStack lvt_8_1_;
                EntityPlayer lvt_6_1_ = (EntityPlayer)p_attackEntityAsMob_1_;
                ItemStack lvt_7_1_ = this.getHeldItemMainhand();
                ItemStack itemStack = lvt_8_1_ = lvt_6_1_.isHandActive() ? lvt_6_1_.getActiveItemStack() : ItemStack.EMPTY;
                if (!lvt_7_1_.isEmpty() && !lvt_8_1_.isEmpty() && lvt_7_1_.getItem() instanceof ItemAxe && lvt_8_1_.getItem() == Items.SHIELD) {
                    float lvt_9_1_ = 0.25f + (float)EnchantmentHelper.getEfficiencyModifier(this) * 0.05f;
                    if (this.rand.nextFloat() < lvt_9_1_) {
                        lvt_6_1_.getCooldownTracker().setCooldown(Items.SHIELD, 100);
                        this.world.setEntityState(lvt_6_1_, (byte)30);
                    }
                }
            }
            this.applyEnchantments(this, p_attackEntityAsMob_1_);
        }
        return lvt_4_1_;
    }

    @Override
    public float getBlockPathWeight(BlockPos p_getBlockPathWeight_1_) {
        return 0.5f - this.world.getLightBrightness(p_getBlockPathWeight_1_);
    }

    protected boolean isValidLightLevel() {
        BlockPos lvt_1_1_ = new BlockPos(this.posX, this.getEntityBoundingBox().minY, this.posZ);
        if (this.world.getLightFor(EnumSkyBlock.SKY, lvt_1_1_) > this.rand.nextInt(32)) {
            return false;
        }
        int lvt_2_1_ = this.world.getLightFromNeighbors(lvt_1_1_);
        if (this.world.isThundering()) {
            int lvt_3_1_ = this.world.getSkylightSubtracted();
            this.world.setSkylightSubtracted(10);
            lvt_2_1_ = this.world.getLightFromNeighbors(lvt_1_1_);
            this.world.setSkylightSubtracted(lvt_3_1_);
        }
        return lvt_2_1_ <= this.rand.nextInt(8);
    }

    @Override
    public boolean getCanSpawnHere() {
        return this.world.getDifficulty() != EnumDifficulty.PEACEFUL && this.isValidLightLevel() && super.getCanSpawnHere();
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.ATTACK_DAMAGE);
    }

    @Override
    protected boolean canDropLoot() {
        return true;
    }
}

