/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityPigZombie
extends EntityZombie {
    private static final UUID ATTACK_SPEED_BOOST_MODIFIER_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier ATTACK_SPEED_BOOST_MODIFIER = new AttributeModifier(ATTACK_SPEED_BOOST_MODIFIER_UUID, "Attacking speed boost", 0.05, 0).setSaved(false);
    private int angerLevel;
    private int randomSoundDelay;
    private UUID angerTargetUUID;

    public EntityPigZombie(World p_i1739_1_) {
        super(p_i1739_1_);
        this.isImmuneToFire = true;
    }

    @Override
    public void setRevengeTarget(EntityLivingBase p_setRevengeTarget_1_) {
        super.setRevengeTarget(p_setRevengeTarget_1_);
        if (p_setRevengeTarget_1_ != null) {
            this.angerTargetUUID = p_setRevengeTarget_1_.getUniqueID();
        }
    }

    @Override
    protected void applyEntityAI() {
        this.targetTasks.addTask(1, new AIHurtByAggressor(this));
        this.targetTasks.addTask(2, new AITargetAggressor(this));
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SPAWN_REINFORCEMENTS_CHANCE).setBaseValue(0.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.23f);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(5.0);
    }

    @Override
    protected void updateAITasks() {
        IAttributeInstance lvt_1_1_ = this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED);
        if (this.isAngry()) {
            if (!this.isChild() && !lvt_1_1_.hasModifier(ATTACK_SPEED_BOOST_MODIFIER)) {
                lvt_1_1_.applyModifier(ATTACK_SPEED_BOOST_MODIFIER);
            }
            --this.angerLevel;
        } else if (lvt_1_1_.hasModifier(ATTACK_SPEED_BOOST_MODIFIER)) {
            lvt_1_1_.removeModifier(ATTACK_SPEED_BOOST_MODIFIER);
        }
        if (this.randomSoundDelay > 0 && --this.randomSoundDelay == 0) {
            this.playSound(SoundEvents.ENTITY_ZOMBIE_PIG_ANGRY, this.getSoundVolume() * 2.0f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) * 1.8f);
        }
        if (this.angerLevel > 0 && this.angerTargetUUID != null && this.getAITarget() == null) {
            EntityPlayer lvt_2_1_ = this.world.getPlayerEntityByUUID(this.angerTargetUUID);
            this.setRevengeTarget(lvt_2_1_);
            this.attackingPlayer = lvt_2_1_;
            this.recentlyHit = this.getRevengeTimer();
        }
        super.updateAITasks();
    }

    @Override
    public boolean getCanSpawnHere() {
        return this.world.getDifficulty() != EnumDifficulty.PEACEFUL;
    }

    @Override
    public boolean isNotColliding() {
        return this.world.checkNoEntityCollision(this.getEntityBoundingBox(), this) && this.world.getCollisionBoxes(this, this.getEntityBoundingBox()).isEmpty() && !this.world.containsAnyLiquid(this.getEntityBoundingBox());
    }

    public static void registerFixesPigZombie(DataFixer p_registerFixesPigZombie_0_) {
        EntityLiving.registerFixesMob(p_registerFixesPigZombie_0_, EntityPigZombie.class);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setShort("Anger", (short)this.angerLevel);
        if (this.angerTargetUUID != null) {
            p_writeEntityToNBT_1_.setString("HurtBy", this.angerTargetUUID.toString());
        } else {
            p_writeEntityToNBT_1_.setString("HurtBy", "");
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.angerLevel = p_readEntityFromNBT_1_.getShort("Anger");
        String lvt_2_1_ = p_readEntityFromNBT_1_.getString("HurtBy");
        if (!lvt_2_1_.isEmpty()) {
            this.angerTargetUUID = UUID.fromString(lvt_2_1_);
            EntityPlayer lvt_3_1_ = this.world.getPlayerEntityByUUID(this.angerTargetUUID);
            this.setRevengeTarget(lvt_3_1_);
            if (lvt_3_1_ != null) {
                this.attackingPlayer = lvt_3_1_;
                this.recentlyHit = this.getRevengeTimer();
            }
        }
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        if (this.isEntityInvulnerable(p_attackEntityFrom_1_)) {
            return false;
        }
        Entity lvt_3_1_ = p_attackEntityFrom_1_.getEntity();
        if (lvt_3_1_ instanceof EntityPlayer) {
            this.becomeAngryAt(lvt_3_1_);
        }
        return super.attackEntityFrom(p_attackEntityFrom_1_, p_attackEntityFrom_2_);
    }

    private void becomeAngryAt(Entity p_becomeAngryAt_1_) {
        this.angerLevel = 400 + this.rand.nextInt(400);
        this.randomSoundDelay = this.rand.nextInt(40);
        if (p_becomeAngryAt_1_ instanceof EntityLivingBase) {
            this.setRevengeTarget((EntityLivingBase)p_becomeAngryAt_1_);
        }
    }

    public boolean isAngry() {
        return this.angerLevel > 0;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_ZOMBIE_PIG_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_ZOMBIE_PIG_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_ZOMBIE_PIG_DEATH;
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_ZOMBIE_PIGMAN;
    }

    @Override
    public boolean processInteract(EntityPlayer p_processInteract_1_, EnumHand p_processInteract_2_) {
        return false;
    }

    @Override
    protected void setEquipmentBasedOnDifficulty(DifficultyInstance p_setEquipmentBasedOnDifficulty_1_) {
        this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.GOLDEN_SWORD));
    }

    @Override
    protected ItemStack getSkullDrop() {
        return ItemStack.EMPTY;
    }

    static class AITargetAggressor
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        public AITargetAggressor(EntityPigZombie p_i45829_1_) {
            super((EntityCreature)p_i45829_1_, EntityPlayer.class, true);
        }

        @Override
        public boolean shouldExecute() {
            return ((EntityPigZombie)this.taskOwner).isAngry() && super.shouldExecute();
        }
    }

    static class AIHurtByAggressor
    extends EntityAIHurtByTarget {
        public AIHurtByAggressor(EntityPigZombie p_i45828_1_) {
            super((EntityCreature)p_i45828_1_, true, new Class[0]);
        }

        @Override
        protected void setEntityAttackTarget(EntityCreature p_setEntityAttackTarget_1_, EntityLivingBase p_setEntityAttackTarget_2_) {
            super.setEntityAttackTarget(p_setEntityAttackTarget_1_, p_setEntityAttackTarget_2_);
            if (p_setEntityAttackTarget_1_ instanceof EntityPigZombie) {
                ((EntityPigZombie)p_setEntityAttackTarget_1_).becomeAngryAt(p_setEntityAttackTarget_2_);
            }
        }
    }
}

