/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityShulker
extends EntityGolem
implements IMob {
    private static final UUID COVERED_ARMOR_BONUS_ID = UUID.fromString("7E0292F2-9434-48D5-A29F-9583AF7DF27F");
    private static final AttributeModifier COVERED_ARMOR_BONUS_MODIFIER = new AttributeModifier(COVERED_ARMOR_BONUS_ID, "Covered armor bonus", 20.0, 0).setSaved(false);
    protected static final DataParameter<EnumFacing> ATTACHED_FACE = EntityDataManager.createKey(EntityShulker.class, DataSerializers.FACING);
    protected static final DataParameter<Optional<BlockPos>> ATTACHED_BLOCK_POS = EntityDataManager.createKey(EntityShulker.class, DataSerializers.OPTIONAL_BLOCK_POS);
    protected static final DataParameter<Byte> PEEK_TICK = EntityDataManager.createKey(EntityShulker.class, DataSerializers.BYTE);
    protected static final DataParameter<Byte> COLOR = EntityDataManager.createKey(EntityShulker.class, DataSerializers.BYTE);
    public static final EnumDyeColor DEFAULT_COLOR = EnumDyeColor.PURPLE;
    private float prevPeekAmount;
    private float peekAmount;
    private BlockPos currentAttachmentPosition;
    private int clientSideTeleportInterpolation;

    public EntityShulker(World p_i46779_1_) {
        super(p_i46779_1_);
        this.setSize(1.0f, 1.0f);
        this.prevRenderYawOffset = 180.0f;
        this.renderYawOffset = 180.0f;
        this.isImmuneToFire = true;
        this.currentAttachmentPosition = null;
        this.experienceValue = 5;
    }

    @Override
    @Nullable
    public IEntityLivingData onInitialSpawn(DifficultyInstance p_onInitialSpawn_1_, IEntityLivingData p_onInitialSpawn_2_) {
        this.renderYawOffset = 180.0f;
        this.prevRenderYawOffset = 180.0f;
        this.rotationYaw = 180.0f;
        this.prevRotationYaw = 180.0f;
        this.rotationYawHead = 180.0f;
        this.prevRotationYawHead = 180.0f;
        return super.onInitialSpawn(p_onInitialSpawn_1_, p_onInitialSpawn_2_);
    }

    @Override
    protected void initEntityAI() {
        this.tasks.addTask(1, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(4, new AIAttack());
        this.tasks.addTask(7, new AIPeek());
        this.tasks.addTask(8, new EntityAILookIdle(this));
        this.targetTasks.addTask(1, new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.targetTasks.addTask(2, new AIAttackNearest(this));
        this.targetTasks.addTask(3, new AIDefenseAttack(this));
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    public SoundCategory getSoundCategory() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_SHULKER_AMBIENT;
    }

    @Override
    public void playLivingSound() {
        if (!this.isClosed()) {
            super.playLivingSound();
        }
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_SHULKER_DEATH;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return this.isClosed() ? SoundEvents.ENTITY_SHULKER_HURT_CLOSED : SoundEvents.ENTITY_SHULKER_HURT;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(ATTACHED_FACE, EnumFacing.DOWN);
        this.dataManager.register(ATTACHED_BLOCK_POS, Optional.absent());
        this.dataManager.register(PEEK_TICK, (byte)0);
        this.dataManager.register(COLOR, (byte)DEFAULT_COLOR.getMetadata());
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(30.0);
    }

    @Override
    protected EntityBodyHelper createBodyHelper() {
        return new BodyHelper(this);
    }

    public static void registerFixesShulker(DataFixer p_registerFixesShulker_0_) {
        EntityLiving.registerFixesMob(p_registerFixesShulker_0_, EntityShulker.class);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.dataManager.set(ATTACHED_FACE, EnumFacing.getFront(p_readEntityFromNBT_1_.getByte("AttachFace")));
        this.dataManager.set(PEEK_TICK, p_readEntityFromNBT_1_.getByte("Peek"));
        this.dataManager.set(COLOR, p_readEntityFromNBT_1_.getByte("Color"));
        if (p_readEntityFromNBT_1_.hasKey("APX")) {
            int i = p_readEntityFromNBT_1_.getInteger("APX");
            int j = p_readEntityFromNBT_1_.getInteger("APY");
            int k = p_readEntityFromNBT_1_.getInteger("APZ");
            this.dataManager.set(ATTACHED_BLOCK_POS, Optional.of((Object)new BlockPos(i, j, k)));
        } else {
            this.dataManager.set(ATTACHED_BLOCK_POS, Optional.absent());
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setByte("AttachFace", (byte)this.dataManager.get(ATTACHED_FACE).getIndex());
        p_writeEntityToNBT_1_.setByte("Peek", this.dataManager.get(PEEK_TICK));
        p_writeEntityToNBT_1_.setByte("Color", this.dataManager.get(COLOR));
        BlockPos blockpos = this.getAttachmentPos();
        if (blockpos != null) {
            p_writeEntityToNBT_1_.setInteger("APX", blockpos.getX());
            p_writeEntityToNBT_1_.setInteger("APY", blockpos.getY());
            p_writeEntityToNBT_1_.setInteger("APZ", blockpos.getZ());
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        BlockPos blockpos = (BlockPos)this.dataManager.get(ATTACHED_BLOCK_POS).orNull();
        if (blockpos == null && !this.world.isRemote) {
            blockpos = new BlockPos(this);
            this.dataManager.set(ATTACHED_BLOCK_POS, Optional.of((Object)blockpos));
        }
        if (this.isRiding()) {
            float f;
            blockpos = null;
            this.rotationYaw = f = this.getRidingEntity().rotationYaw;
            this.renderYawOffset = f;
            this.prevRenderYawOffset = f;
            this.clientSideTeleportInterpolation = 0;
        } else if (!this.world.isRemote) {
            BlockPos blockpos2;
            BlockPos blockpos1;
            IBlockState iblockstate = this.world.getBlockState(blockpos);
            if (iblockstate.getMaterial() != Material.AIR) {
                if (iblockstate.getBlock() == Blocks.PISTON_EXTENSION) {
                    EnumFacing enumfacing = iblockstate.getValue(BlockPistonBase.FACING);
                    if (this.world.isAirBlock(blockpos.offset(enumfacing))) {
                        blockpos = blockpos.offset(enumfacing);
                        this.dataManager.set(ATTACHED_BLOCK_POS, Optional.of((Object)blockpos));
                    } else {
                        this.tryTeleportToNewPosition();
                    }
                } else if (iblockstate.getBlock() == Blocks.PISTON_HEAD) {
                    EnumFacing enumfacing3 = iblockstate.getValue(BlockPistonExtension.FACING);
                    if (this.world.isAirBlock(blockpos.offset(enumfacing3))) {
                        blockpos = blockpos.offset(enumfacing3);
                        this.dataManager.set(ATTACHED_BLOCK_POS, Optional.of((Object)blockpos));
                    } else {
                        this.tryTeleportToNewPosition();
                    }
                } else {
                    this.tryTeleportToNewPosition();
                }
            }
            if (!this.world.isBlockNormalCube(blockpos1 = blockpos.offset(this.getAttachmentFacing()), false)) {
                boolean flag = false;
                for (EnumFacing enumfacing1 : EnumFacing.values()) {
                    blockpos1 = blockpos.offset(enumfacing1);
                    if (!this.world.isBlockNormalCube(blockpos1, false)) continue;
                    this.dataManager.set(ATTACHED_FACE, enumfacing1);
                    flag = true;
                    break;
                }
                if (!flag) {
                    this.tryTeleportToNewPosition();
                }
            }
            if (this.world.isBlockNormalCube(blockpos2 = blockpos.offset(this.getAttachmentFacing().getOpposite()), false)) {
                this.tryTeleportToNewPosition();
            }
        }
        float f1 = (float)this.getPeekTick() * 0.01f;
        this.prevPeekAmount = this.peekAmount;
        if (this.peekAmount > f1) {
            this.peekAmount = MathHelper.clamp(this.peekAmount - 0.05f, f1, 1.0f);
        } else if (this.peekAmount < f1) {
            this.peekAmount = MathHelper.clamp(this.peekAmount + 0.05f, 0.0f, f1);
        }
        if (blockpos != null) {
            List<Entity> list;
            if (this.world.isRemote) {
                if (this.clientSideTeleportInterpolation > 0 && this.currentAttachmentPosition != null) {
                    --this.clientSideTeleportInterpolation;
                } else {
                    this.currentAttachmentPosition = blockpos;
                }
            }
            this.posX = (double)blockpos.getX() + 0.5;
            this.posY = blockpos.getY();
            this.posZ = (double)blockpos.getZ() + 0.5;
            this.prevPosX = this.posX;
            this.prevPosY = this.posY;
            this.prevPosZ = this.posZ;
            this.lastTickPosX = this.posX;
            this.lastTickPosY = this.posY;
            this.lastTickPosZ = this.posZ;
            double d3 = 0.5 - (double)MathHelper.sin((0.5f + this.peekAmount) * (float)Math.PI) * 0.5;
            double d4 = 0.5 - (double)MathHelper.sin((0.5f + this.prevPeekAmount) * (float)Math.PI) * 0.5;
            double d5 = d3 - d4;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            EnumFacing enumfacing2 = this.getAttachmentFacing();
            switch (enumfacing2) {
                case DOWN: {
                    this.setEntityBoundingBox(new AxisAlignedBB(this.posX - 0.5, this.posY, this.posZ - 0.5, this.posX + 0.5, this.posY + 1.0 + d3, this.posZ + 0.5));
                    d1 = d5;
                    break;
                }
                case UP: {
                    this.setEntityBoundingBox(new AxisAlignedBB(this.posX - 0.5, this.posY - d3, this.posZ - 0.5, this.posX + 0.5, this.posY + 1.0, this.posZ + 0.5));
                    d1 = -d5;
                    break;
                }
                case NORTH: {
                    this.setEntityBoundingBox(new AxisAlignedBB(this.posX - 0.5, this.posY, this.posZ - 0.5, this.posX + 0.5, this.posY + 1.0, this.posZ + 0.5 + d3));
                    d2 = d5;
                    break;
                }
                case SOUTH: {
                    this.setEntityBoundingBox(new AxisAlignedBB(this.posX - 0.5, this.posY, this.posZ - 0.5 - d3, this.posX + 0.5, this.posY + 1.0, this.posZ + 0.5));
                    d2 = -d5;
                    break;
                }
                case WEST: {
                    this.setEntityBoundingBox(new AxisAlignedBB(this.posX - 0.5, this.posY, this.posZ - 0.5, this.posX + 0.5 + d3, this.posY + 1.0, this.posZ + 0.5));
                    d0 = d5;
                    break;
                }
                case EAST: {
                    this.setEntityBoundingBox(new AxisAlignedBB(this.posX - 0.5 - d3, this.posY, this.posZ - 0.5, this.posX + 0.5, this.posY + 1.0, this.posZ + 0.5));
                    d0 = -d5;
                }
            }
            if (d5 > 0.0 && !(list = this.world.getEntitiesWithinAABBExcludingEntity(this, this.getEntityBoundingBox())).isEmpty()) {
                for (Entity entity : list) {
                    if (entity instanceof EntityShulker || entity.noClip) continue;
                    entity.move(MoverType.SHULKER, d0, d1, d2);
                }
            }
        }
    }

    @Override
    public void move(MoverType p_move_1_, double p_move_2_, double p_move_4_, double p_move_6_) {
        if (p_move_1_ == MoverType.SHULKER_BOX) {
            this.tryTeleportToNewPosition();
        } else {
            super.move(p_move_1_, p_move_2_, p_move_4_, p_move_6_);
        }
    }

    @Override
    public void setPosition(double p_setPosition_1_, double p_setPosition_3_, double p_setPosition_5_) {
        super.setPosition(p_setPosition_1_, p_setPosition_3_, p_setPosition_5_);
        if (this.dataManager != null && this.ticksExisted != 0) {
            Optional<BlockPos> optional = this.dataManager.get(ATTACHED_BLOCK_POS);
            Optional optional1 = Optional.of((Object)new BlockPos(p_setPosition_1_, p_setPosition_3_, p_setPosition_5_));
            if (!optional1.equals(optional)) {
                this.dataManager.set(ATTACHED_BLOCK_POS, optional1);
                this.dataManager.set(PEEK_TICK, (byte)0);
                this.isAirBorne = true;
            }
        }
    }

    protected boolean tryTeleportToNewPosition() {
        if (!this.isAIDisabled() && this.isEntityAlive()) {
            BlockPos blockpos = new BlockPos(this);
            for (int i = 0; i < 5; ++i) {
                BlockPos blockpos1 = blockpos.add(8 - this.rand.nextInt(17), 8 - this.rand.nextInt(17), 8 - this.rand.nextInt(17));
                if (blockpos1.getY() <= 0 || !this.world.isAirBlock(blockpos1) || !this.world.func_191503_g(this) || !this.world.getCollisionBoxes(this, new AxisAlignedBB(blockpos1)).isEmpty()) continue;
                boolean flag = false;
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    if (!this.world.isBlockNormalCube(blockpos1.offset(enumfacing), false)) continue;
                    this.dataManager.set(ATTACHED_FACE, enumfacing);
                    flag = true;
                    break;
                }
                if (flag) {
                    EnderTeleportEvent event = new EnderTeleportEvent(this, blockpos1.getX(), blockpos1.getY(), blockpos1.getZ(), 0.0f);
                    if (MinecraftForge.EVENT_BUS.post(event)) {
                        flag = false;
                    }
                    blockpos1 = new BlockPos(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                }
                if (!flag) continue;
                this.playSound(SoundEvents.ENTITY_SHULKER_TELEPORT, 1.0f, 1.0f);
                this.dataManager.set(ATTACHED_BLOCK_POS, Optional.of((Object)blockpos1));
                this.dataManager.set(PEEK_TICK, (byte)0);
                this.setAttackTarget(null);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevRenderYawOffset = 180.0f;
        this.renderYawOffset = 180.0f;
        this.rotationYaw = 180.0f;
    }

    @Override
    public void notifyDataManagerChange(DataParameter<?> p_notifyDataManagerChange_1_) {
        BlockPos blockpos;
        if (ATTACHED_BLOCK_POS.equals(p_notifyDataManagerChange_1_) && this.world.isRemote && !this.isRiding() && (blockpos = this.getAttachmentPos()) != null) {
            if (this.currentAttachmentPosition == null) {
                this.currentAttachmentPosition = blockpos;
            } else {
                this.clientSideTeleportInterpolation = 6;
            }
            this.posX = (double)blockpos.getX() + 0.5;
            this.posY = blockpos.getY();
            this.posZ = (double)blockpos.getZ() + 0.5;
            this.prevPosX = this.posX;
            this.prevPosY = this.posY;
            this.prevPosZ = this.posZ;
            this.lastTickPosX = this.posX;
            this.lastTickPosY = this.posY;
            this.lastTickPosZ = this.posZ;
        }
        super.notifyDataManagerChange(p_notifyDataManagerChange_1_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotationDirect(double p_setPositionAndRotationDirect_1_, double p_setPositionAndRotationDirect_3_, double p_setPositionAndRotationDirect_5_, float p_setPositionAndRotationDirect_7_, float p_setPositionAndRotationDirect_8_, int p_setPositionAndRotationDirect_9_, boolean p_setPositionAndRotationDirect_10_) {
        this.newPosRotationIncrements = 0;
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        Entity entity;
        if (this.isClosed() && (entity = p_attackEntityFrom_1_.getSourceOfDamage()) instanceof EntityArrow) {
            return false;
        }
        if (super.attackEntityFrom(p_attackEntityFrom_1_, p_attackEntityFrom_2_)) {
            if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.5 && this.rand.nextInt(4) == 0) {
                this.tryTeleportToNewPosition();
            }
            return true;
        }
        return false;
    }

    private boolean isClosed() {
        return this.getPeekTick() == 0;
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox() {
        return this.isEntityAlive() ? this.getEntityBoundingBox() : null;
    }

    public EnumFacing getAttachmentFacing() {
        return this.dataManager.get(ATTACHED_FACE);
    }

    @Nullable
    public BlockPos getAttachmentPos() {
        return (BlockPos)this.dataManager.get(ATTACHED_BLOCK_POS).orNull();
    }

    public void setAttachmentPos(BlockPos p_setAttachmentPos_1_) {
        this.dataManager.set(ATTACHED_BLOCK_POS, Optional.fromNullable((Object)p_setAttachmentPos_1_));
    }

    public int getPeekTick() {
        return this.dataManager.get(PEEK_TICK).byteValue();
    }

    public void updateArmorModifier(int p_updateArmorModifier_1_) {
        if (!this.world.isRemote) {
            this.getEntityAttribute(SharedMonsterAttributes.ARMOR).removeModifier(COVERED_ARMOR_BONUS_MODIFIER);
            if (p_updateArmorModifier_1_ == 0) {
                this.getEntityAttribute(SharedMonsterAttributes.ARMOR).applyModifier(COVERED_ARMOR_BONUS_MODIFIER);
                this.playSound(SoundEvents.ENTITY_SHULKER_CLOSE, 1.0f, 1.0f);
            } else {
                this.playSound(SoundEvents.ENTITY_SHULKER_OPEN, 1.0f, 1.0f);
            }
        }
        this.dataManager.set(PEEK_TICK, (byte)p_updateArmorModifier_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public float getClientPeekAmount(float p_getClientPeekAmount_1_) {
        return this.prevPeekAmount + (this.peekAmount - this.prevPeekAmount) * p_getClientPeekAmount_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public int getClientTeleportInterp() {
        return this.clientSideTeleportInterpolation;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockPos getOldAttachPos() {
        return this.currentAttachmentPosition;
    }

    @Override
    public float getEyeHeight() {
        return 0.5f;
    }

    @Override
    public int getVerticalFaceSpeed() {
        return 180;
    }

    @Override
    public int getHorizontalFaceSpeed() {
        return 180;
    }

    @Override
    public void applyEntityCollision(Entity p_applyEntityCollision_1_) {
    }

    @Override
    public float getCollisionBorderSize() {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAttachedToBlock() {
        return this.currentAttachmentPosition != null && this.getAttachmentPos() != null;
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_SHULKER;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumDyeColor getColor() {
        return EnumDyeColor.byMetadata(this.dataManager.get(COLOR).byteValue());
    }

    class BodyHelper
    extends EntityBodyHelper {
        public BodyHelper(EntityLivingBase p_i47062_2_) {
            super(p_i47062_2_);
        }

        @Override
        public void updateRenderAngles() {
        }
    }

    class AIPeek
    extends EntityAIBase {
        private int peekTime;

        private AIPeek() {
        }

        @Override
        public boolean shouldExecute() {
            return EntityShulker.this.getAttackTarget() == null && EntityShulker.this.rand.nextInt(40) == 0;
        }

        @Override
        public boolean continueExecuting() {
            return EntityShulker.this.getAttackTarget() == null && this.peekTime > 0;
        }

        @Override
        public void startExecuting() {
            this.peekTime = 20 * (1 + EntityShulker.this.rand.nextInt(3));
            EntityShulker.this.updateArmorModifier(30);
        }

        @Override
        public void resetTask() {
            if (EntityShulker.this.getAttackTarget() == null) {
                EntityShulker.this.updateArmorModifier(0);
            }
        }

        @Override
        public void updateTask() {
            --this.peekTime;
        }
    }

    static class AIDefenseAttack
    extends EntityAINearestAttackableTarget<EntityLivingBase> {
        public AIDefenseAttack(EntityShulker p_i47061_1_) {
            super(p_i47061_1_, EntityLivingBase.class, 10, true, false, new Predicate<EntityLivingBase>(){

                public boolean apply(EntityLivingBase p_apply_1_) {
                    return p_apply_1_ instanceof IMob;
                }
            });
        }

        @Override
        public boolean shouldExecute() {
            return this.taskOwner.getTeam() == null ? false : super.shouldExecute();
        }

        @Override
        protected AxisAlignedBB getTargetableArea(double p_getTargetableArea_1_) {
            EnumFacing enumfacing = ((EntityShulker)this.taskOwner).getAttachmentFacing();
            return enumfacing.getAxis() == EnumFacing.Axis.X ? this.taskOwner.getEntityBoundingBox().expand(4.0, p_getTargetableArea_1_, p_getTargetableArea_1_) : (enumfacing.getAxis() == EnumFacing.Axis.Z ? this.taskOwner.getEntityBoundingBox().expand(p_getTargetableArea_1_, p_getTargetableArea_1_, 4.0) : this.taskOwner.getEntityBoundingBox().expand(p_getTargetableArea_1_, 4.0, p_getTargetableArea_1_));
        }
    }

    class AIAttackNearest
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        public AIAttackNearest(EntityShulker p_i47060_2_) {
            super((EntityCreature)p_i47060_2_, EntityPlayer.class, true);
        }

        @Override
        public boolean shouldExecute() {
            return EntityShulker.this.world.getDifficulty() == EnumDifficulty.PEACEFUL ? false : super.shouldExecute();
        }

        @Override
        protected AxisAlignedBB getTargetableArea(double p_getTargetableArea_1_) {
            EnumFacing enumfacing = ((EntityShulker)this.taskOwner).getAttachmentFacing();
            return enumfacing.getAxis() == EnumFacing.Axis.X ? this.taskOwner.getEntityBoundingBox().expand(4.0, p_getTargetableArea_1_, p_getTargetableArea_1_) : (enumfacing.getAxis() == EnumFacing.Axis.Z ? this.taskOwner.getEntityBoundingBox().expand(p_getTargetableArea_1_, p_getTargetableArea_1_, 4.0) : this.taskOwner.getEntityBoundingBox().expand(p_getTargetableArea_1_, 4.0, p_getTargetableArea_1_));
        }
    }

    class AIAttack
    extends EntityAIBase {
        private int attackTime;

        public AIAttack() {
            this.setMutexBits(3);
        }

        @Override
        public boolean shouldExecute() {
            EntityLivingBase entitylivingbase = EntityShulker.this.getAttackTarget();
            return entitylivingbase != null && entitylivingbase.isEntityAlive() ? EntityShulker.this.world.getDifficulty() != EnumDifficulty.PEACEFUL : false;
        }

        @Override
        public void startExecuting() {
            this.attackTime = 20;
            EntityShulker.this.updateArmorModifier(100);
        }

        @Override
        public void resetTask() {
            EntityShulker.this.updateArmorModifier(0);
        }

        @Override
        public void updateTask() {
            if (EntityShulker.this.world.getDifficulty() != EnumDifficulty.PEACEFUL) {
                --this.attackTime;
                EntityLivingBase entitylivingbase = EntityShulker.this.getAttackTarget();
                EntityShulker.this.getLookHelper().setLookPositionWithEntity(entitylivingbase, 180.0f, 180.0f);
                double d0 = EntityShulker.this.getDistanceSqToEntity(entitylivingbase);
                if (d0 < 400.0) {
                    if (this.attackTime <= 0) {
                        this.attackTime = 20 + EntityShulker.this.rand.nextInt(10) * 20 / 2;
                        EntityShulkerBullet entityshulkerbullet = new EntityShulkerBullet(EntityShulker.this.world, EntityShulker.this, entitylivingbase, EntityShulker.this.getAttachmentFacing().getAxis());
                        EntityShulker.this.world.spawnEntity(entityshulkerbullet);
                        EntityShulker.this.playSound(SoundEvents.ENTITY_SHULKER_SHOOT, 2.0f, (EntityShulker.this.rand.nextFloat() - EntityShulker.this.rand.nextFloat()) * 0.2f + 1.0f);
                    }
                } else {
                    EntityShulker.this.setAttackTarget(null);
                }
                super.updateTask();
            }
        }
    }
}

