/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntitySilverfish
extends EntityMob {
    private AISummonSilverfish summonSilverfish;

    public EntitySilverfish(World p_i1740_1_) {
        super(p_i1740_1_);
        this.setSize(0.4f, 0.3f);
    }

    public static void registerFixesSilverfish(DataFixer p_registerFixesSilverfish_0_) {
        EntityLiving.registerFixesMob(p_registerFixesSilverfish_0_, EntitySilverfish.class);
    }

    @Override
    protected void initEntityAI() {
        this.summonSilverfish = new AISummonSilverfish(this);
        this.tasks.addTask(1, new EntityAISwimming(this));
        this.tasks.addTask(3, this.summonSilverfish);
        this.tasks.addTask(4, new EntityAIAttackMelee(this, 1.0, false));
        this.tasks.addTask(5, new AIHideInStone(this));
        this.targetTasks.addTask(1, new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.targetTasks.addTask(2, new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    public double getYOffset() {
        return 0.1;
    }

    @Override
    public float getEyeHeight() {
        return 0.1f;
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(8.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.25);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(1.0);
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_SILVERFISH_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_SILVERFISH_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_SILVERFISH_DEATH;
    }

    @Override
    protected void playStepSound(BlockPos p_playStepSound_1_, Block p_playStepSound_2_) {
        this.playSound(SoundEvents.ENTITY_SILVERFISH_STEP, 0.15f, 1.0f);
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        if (this.isEntityInvulnerable(p_attackEntityFrom_1_)) {
            return false;
        }
        if ((p_attackEntityFrom_1_ instanceof EntityDamageSource || p_attackEntityFrom_1_ == DamageSource.MAGIC) && this.summonSilverfish != null) {
            this.summonSilverfish.notifyHurt();
        }
        return super.attackEntityFrom(p_attackEntityFrom_1_, p_attackEntityFrom_2_);
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_SILVERFISH;
    }

    @Override
    public void onUpdate() {
        this.renderYawOffset = this.rotationYaw;
        super.onUpdate();
    }

    @Override
    public void setRenderYawOffset(float p_setRenderYawOffset_1_) {
        this.rotationYaw = p_setRenderYawOffset_1_;
        super.setRenderYawOffset(p_setRenderYawOffset_1_);
    }

    @Override
    public float getBlockPathWeight(BlockPos p_getBlockPathWeight_1_) {
        if (this.world.getBlockState(p_getBlockPathWeight_1_.down()).getBlock() == Blocks.STONE) {
            return 10.0f;
        }
        return super.getBlockPathWeight(p_getBlockPathWeight_1_);
    }

    @Override
    protected boolean isValidLightLevel() {
        return true;
    }

    @Override
    public boolean getCanSpawnHere() {
        if (super.getCanSpawnHere()) {
            EntityPlayer lvt_1_1_ = this.world.getNearestPlayerNotCreative(this, 5.0);
            return lvt_1_1_ == null;
        }
        return false;
    }

    @Override
    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    static class AIHideInStone
    extends EntityAIWander {
        private EnumFacing facing;
        private boolean doMerge;

        public AIHideInStone(EntitySilverfish p_i45827_1_) {
            super(p_i45827_1_, 1.0, 10);
            this.setMutexBits(1);
        }

        @Override
        public boolean shouldExecute() {
            if (this.entity.getAttackTarget() != null) {
                return false;
            }
            if (!this.entity.getNavigator().noPath()) {
                return false;
            }
            Random lvt_1_1_ = this.entity.getRNG();
            if (this.entity.world.getGameRules().getBoolean("mobGriefing") && lvt_1_1_.nextInt(10) == 0) {
                this.facing = EnumFacing.random(lvt_1_1_);
                BlockPos lvt_2_1_ = new BlockPos(this.entity.posX, this.entity.posY + 0.5, this.entity.posZ).offset(this.facing);
                IBlockState lvt_3_1_ = this.entity.world.getBlockState(lvt_2_1_);
                if (BlockSilverfish.canContainSilverfish(lvt_3_1_)) {
                    this.doMerge = true;
                    return true;
                }
            }
            this.doMerge = false;
            return super.shouldExecute();
        }

        @Override
        public boolean continueExecuting() {
            if (this.doMerge) {
                return false;
            }
            return super.continueExecuting();
        }

        @Override
        public void startExecuting() {
            if (!this.doMerge) {
                super.startExecuting();
                return;
            }
            World lvt_1_1_ = this.entity.world;
            BlockPos lvt_2_1_ = new BlockPos(this.entity.posX, this.entity.posY + 0.5, this.entity.posZ).offset(this.facing);
            IBlockState lvt_3_1_ = lvt_1_1_.getBlockState(lvt_2_1_);
            if (BlockSilverfish.canContainSilverfish(lvt_3_1_)) {
                lvt_1_1_.setBlockState(lvt_2_1_, Blocks.MONSTER_EGG.getDefaultState().withProperty(BlockSilverfish.VARIANT, BlockSilverfish.EnumType.forModelBlock(lvt_3_1_)), 3);
                this.entity.spawnExplosionParticle();
                this.entity.setDead();
            }
        }
    }

    static class AISummonSilverfish
    extends EntityAIBase {
        private final EntitySilverfish silverfish;
        private int lookForFriends;

        public AISummonSilverfish(EntitySilverfish p_i45826_1_) {
            this.silverfish = p_i45826_1_;
        }

        public void notifyHurt() {
            if (this.lookForFriends == 0) {
                this.lookForFriends = 20;
            }
        }

        @Override
        public boolean shouldExecute() {
            return this.lookForFriends > 0;
        }

        @Override
        public void updateTask() {
            --this.lookForFriends;
            if (this.lookForFriends <= 0) {
                World lvt_1_1_ = this.silverfish.world;
                Random lvt_2_1_ = this.silverfish.getRNG();
                BlockPos lvt_3_1_ = new BlockPos(this.silverfish);
                int lvt_4_1_ = 0;
                block0: while (lvt_4_1_ <= 5 && lvt_4_1_ >= -5) {
                    int lvt_5_1_ = 0;
                    while (lvt_5_1_ <= 10 && lvt_5_1_ >= -10) {
                        int lvt_6_1_ = 0;
                        while (lvt_6_1_ <= 10 && lvt_6_1_ >= -10) {
                            BlockPos lvt_7_1_ = lvt_3_1_.add(lvt_5_1_, lvt_4_1_, lvt_6_1_);
                            IBlockState lvt_8_1_ = lvt_1_1_.getBlockState(lvt_7_1_);
                            if (lvt_8_1_.getBlock() == Blocks.MONSTER_EGG) {
                                if (lvt_1_1_.getGameRules().getBoolean("mobGriefing")) {
                                    lvt_1_1_.destroyBlock(lvt_7_1_, true);
                                } else {
                                    lvt_1_1_.setBlockState(lvt_7_1_, lvt_8_1_.getValue(BlockSilverfish.VARIANT).getModelBlock(), 3);
                                }
                                if (lvt_2_1_.nextBoolean()) break block0;
                            }
                            lvt_6_1_ = (lvt_6_1_ <= 0 ? 1 : 0) - lvt_6_1_;
                        }
                        lvt_5_1_ = (lvt_5_1_ <= 0 ? 1 : 0) - lvt_5_1_;
                    }
                    lvt_4_1_ = (lvt_4_1_ <= 0 ? 1 : 0) - lvt_4_1_;
                }
            }
        }
    }
}

