/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntitySkeleton
extends AbstractSkeleton {
    public EntitySkeleton(World p_i1741_1_) {
        super(p_i1741_1_);
    }

    public static void registerFixesSkeleton(DataFixer p_registerFixesSkeleton_0_) {
        EntityLiving.registerFixesMob(p_registerFixesSkeleton_0_, EntitySkeleton.class);
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_SKELETON;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_SKELETON_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_SKELETON_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_SKELETON_DEATH;
    }

    @Override
    SoundEvent getStepSound() {
        return SoundEvents.ENTITY_SKELETON_STEP;
    }

    @Override
    public void onDeath(DamageSource p_onDeath_1_) {
        EntityCreeper lvt_2_1_;
        super.onDeath(p_onDeath_1_);
        if (p_onDeath_1_.getEntity() instanceof EntityCreeper && (lvt_2_1_ = (EntityCreeper)p_onDeath_1_.getEntity()).getPowered() && lvt_2_1_.isAIEnabled()) {
            lvt_2_1_.incrementDroppedSkulls();
            this.entityDropItem(new ItemStack(Items.SKULL, 1, 0), 0.0f);
        }
    }

    @Override
    protected EntityArrow getArrow(float p_getArrow_1_) {
        ItemStack lvt_2_1_ = this.getItemStackFromSlot(EntityEquipmentSlot.OFFHAND);
        if (lvt_2_1_.getItem() == Items.SPECTRAL_ARROW) {
            EntitySpectralArrow lvt_3_1_ = new EntitySpectralArrow(this.world, this);
            lvt_3_1_.setEnchantmentEffectsFromEntity(this, p_getArrow_1_);
            return lvt_3_1_;
        }
        EntityArrow lvt_3_2_ = super.getArrow(p_getArrow_1_);
        if (lvt_2_1_.getItem() == Items.TIPPED_ARROW && lvt_3_2_ instanceof EntityTippedArrow) {
            ((EntityTippedArrow)lvt_3_2_).setPotionEffect(lvt_2_1_);
        }
        return lvt_3_2_;
    }
}

