/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntitySnowman
extends EntityGolem
implements IRangedAttackMob {
    private static final DataParameter<Byte> PUMPKIN_EQUIPPED = EntityDataManager.createKey(EntitySnowman.class, DataSerializers.BYTE);

    public EntitySnowman(World p_i1692_1_) {
        super(p_i1692_1_);
        this.setSize(0.7f, 1.9f);
    }

    public static void registerFixesSnowman(DataFixer p_registerFixesSnowman_0_) {
        EntityLiving.registerFixesMob(p_registerFixesSnowman_0_, EntitySnowman.class);
    }

    @Override
    protected void initEntityAI() {
        this.tasks.addTask(1, new EntityAIAttackRanged(this, 1.25, 20, 10.0f));
        this.tasks.addTask(2, new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 1.0000001E-5f));
        this.tasks.addTask(3, new EntityAIWatchClosest(this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(4, new EntityAILookIdle(this));
        this.targetTasks.addTask(1, new EntityAINearestAttackableTarget<Entity>(this, EntityLiving.class, 10, true, false, IMob.MOB_SELECTOR));
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(4.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.2f);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(PUMPKIN_EQUIPPED, (byte)16);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setBoolean("Pumpkin", this.isPumpkinEquipped());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        if (p_readEntityFromNBT_1_.hasKey("Pumpkin")) {
            this.setPumpkinEquipped(p_readEntityFromNBT_1_.getBoolean("Pumpkin"));
        }
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (!this.world.isRemote) {
            int lvt_1_1_ = MathHelper.floor(this.posX);
            int lvt_2_1_ = MathHelper.floor(this.posY);
            int lvt_3_1_ = MathHelper.floor(this.posZ);
            if (this.isWet()) {
                this.attackEntityFrom(DamageSource.DROWN, 1.0f);
            }
            BlockPos blockPos = new BlockPos(lvt_1_1_, 0, lvt_3_1_);
            BlockPos blockPos2 = new BlockPos(lvt_1_1_, lvt_2_1_, lvt_3_1_);
            if (this.world.getBiome(blockPos).getFloatTemperature(blockPos2) > 1.0f) {
                this.attackEntityFrom(DamageSource.ON_FIRE, 1.0f);
            }
            if (!this.world.getGameRules().getBoolean("mobGriefing")) {
                return;
            }
            for (int lvt_4_1_ = 0; lvt_4_1_ < 4; ++lvt_4_1_) {
                lvt_1_1_ = MathHelper.floor(this.posX + (double)((float)(lvt_4_1_ % 2 * 2 - 1) * 0.25f));
                BlockPos lvt_5_1_ = new BlockPos(lvt_1_1_, lvt_2_1_ = MathHelper.floor(this.posY), lvt_3_1_ = MathHelper.floor(this.posZ + (double)((float)(lvt_4_1_ / 2 % 2 * 2 - 1) * 0.25f)));
                if (this.world.getBlockState(lvt_5_1_).getMaterial() != Material.AIR || !(this.world.getBiome(lvt_5_1_).getFloatTemperature(lvt_5_1_) < 0.8f) || !Blocks.SNOW_LAYER.canPlaceBlockAt(this.world, lvt_5_1_)) continue;
                this.world.setBlockState(lvt_5_1_, Blocks.SNOW_LAYER.getDefaultState());
            }
        }
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_SNOWMAN;
    }

    @Override
    public void attackEntityWithRangedAttack(EntityLivingBase p_attackEntityWithRangedAttack_1_, float p_attackEntityWithRangedAttack_2_) {
        EntitySnowball lvt_3_1_ = new EntitySnowball(this.world, this);
        double lvt_4_1_ = p_attackEntityWithRangedAttack_1_.posY + (double)p_attackEntityWithRangedAttack_1_.getEyeHeight() - (double)1.1f;
        double lvt_6_1_ = p_attackEntityWithRangedAttack_1_.posX - this.posX;
        double lvt_8_1_ = lvt_4_1_ - lvt_3_1_.posY;
        double lvt_10_1_ = p_attackEntityWithRangedAttack_1_.posZ - this.posZ;
        float lvt_12_1_ = MathHelper.sqrt(lvt_6_1_ * lvt_6_1_ + lvt_10_1_ * lvt_10_1_) * 0.2f;
        lvt_3_1_.setThrowableHeading(lvt_6_1_, lvt_8_1_ + (double)lvt_12_1_, lvt_10_1_, 1.6f, 12.0f);
        this.playSound(SoundEvents.ENTITY_SNOWMAN_SHOOT, 1.0f, 1.0f / (this.getRNG().nextFloat() * 0.4f + 0.8f));
        this.world.spawnEntity(lvt_3_1_);
    }

    @Override
    public float getEyeHeight() {
        return 1.7f;
    }

    @Override
    protected boolean processInteract(EntityPlayer p_processInteract_1_, EnumHand p_processInteract_2_) {
        ItemStack lvt_3_1_ = p_processInteract_1_.getHeldItem(p_processInteract_2_);
        if (lvt_3_1_.getItem() == Items.SHEARS && this.isPumpkinEquipped() && !this.world.isRemote) {
            this.setPumpkinEquipped(false);
            lvt_3_1_.damageItem(1, p_processInteract_1_);
        }
        return super.processInteract(p_processInteract_1_, p_processInteract_2_);
    }

    public boolean isPumpkinEquipped() {
        return (this.dataManager.get(PUMPKIN_EQUIPPED) & 0x10) != 0;
    }

    public void setPumpkinEquipped(boolean p_setPumpkinEquipped_1_) {
        byte lvt_2_1_ = this.dataManager.get(PUMPKIN_EQUIPPED);
        if (p_setPumpkinEquipped_1_) {
            this.dataManager.set(PUMPKIN_EQUIPPED, (byte)(lvt_2_1_ | 0x10));
        } else {
            this.dataManager.set(PUMPKIN_EQUIPPED, (byte)(lvt_2_1_ & 0xFFFFFFEF));
        }
    }

    @Override
    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_SNOWMAN_AMBIENT;
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_SNOWMAN_HURT;
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_SNOWMAN_DEATH;
    }
}

