/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntitySpider
extends EntityMob {
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.createKey(EntitySpider.class, DataSerializers.BYTE);

    public EntitySpider(World p_i1743_1_) {
        super(p_i1743_1_);
        this.setSize(1.4f, 0.9f);
    }

    public static void registerFixesSpider(DataFixer p_registerFixesSpider_0_) {
        EntityLiving.registerFixesMob(p_registerFixesSpider_0_, EntitySpider.class);
    }

    @Override
    protected void initEntityAI() {
        this.tasks.addTask(1, new EntityAISwimming(this));
        this.tasks.addTask(3, new EntityAILeapAtTarget(this, 0.4f));
        this.tasks.addTask(4, new AISpiderAttack(this));
        this.tasks.addTask(5, new EntityAIWanderAvoidWater(this, 0.8));
        this.tasks.addTask(6, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(6, new EntityAILookIdle(this));
        this.targetTasks.addTask(1, new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.targetTasks.addTask(2, new AISpiderTarget<EntityPlayer>(this, EntityPlayer.class));
        this.targetTasks.addTask(3, new AISpiderTarget<EntityIronGolem>(this, EntityIronGolem.class));
    }

    @Override
    public double getMountedYOffset() {
        return this.height * 0.5f;
    }

    @Override
    protected PathNavigate createNavigator(World p_createNavigator_1_) {
        return new PathNavigateClimber(this, p_createNavigator_1_);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(CLIMBING, (byte)0);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.world.isRemote) {
            this.setBesideClimbableBlock(this.isCollidedHorizontally);
        }
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(16.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.3f);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_SPIDER_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_SPIDER_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_SPIDER_DEATH;
    }

    @Override
    protected void playStepSound(BlockPos p_playStepSound_1_, Block p_playStepSound_2_) {
        this.playSound(SoundEvents.ENTITY_SPIDER_STEP, 0.15f, 1.0f);
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_SPIDER;
    }

    @Override
    public boolean isOnLadder() {
        return this.isBesideClimbableBlock();
    }

    @Override
    public void setInWeb() {
    }

    @Override
    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public boolean isPotionApplicable(PotionEffect p_isPotionApplicable_1_) {
        if (p_isPotionApplicable_1_.getPotion() == MobEffects.POISON) {
            return false;
        }
        return super.isPotionApplicable(p_isPotionApplicable_1_);
    }

    public boolean isBesideClimbableBlock() {
        return (this.dataManager.get(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean p_setBesideClimbableBlock_1_) {
        byte lvt_2_1_ = this.dataManager.get(CLIMBING);
        lvt_2_1_ = p_setBesideClimbableBlock_1_ ? (byte)(lvt_2_1_ | 1) : (byte)(lvt_2_1_ & 0xFFFFFFFE);
        this.dataManager.set(CLIMBING, lvt_2_1_);
    }

    @Override
    @Nullable
    public IEntityLivingData onInitialSpawn(DifficultyInstance p_onInitialSpawn_1_, IEntityLivingData p_onInitialSpawn_2_) {
        Potion lvt_3_2_;
        p_onInitialSpawn_2_ = super.onInitialSpawn(p_onInitialSpawn_1_, p_onInitialSpawn_2_);
        if (this.world.rand.nextInt(100) == 0) {
            EntitySkeleton lvt_3_1_ = new EntitySkeleton(this.world);
            lvt_3_1_.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, 0.0f);
            lvt_3_1_.onInitialSpawn(p_onInitialSpawn_1_, null);
            this.world.spawnEntity(lvt_3_1_);
            lvt_3_1_.startRiding(this);
        }
        if (p_onInitialSpawn_2_ == null) {
            p_onInitialSpawn_2_ = new GroupData();
            if (this.world.getDifficulty() == EnumDifficulty.HARD && this.world.rand.nextFloat() < 0.1f * p_onInitialSpawn_1_.getClampedAdditionalDifficulty()) {
                ((GroupData)p_onInitialSpawn_2_).setRandomEffect(this.world.rand);
            }
        }
        if (p_onInitialSpawn_2_ instanceof GroupData && (lvt_3_2_ = ((GroupData)p_onInitialSpawn_2_).effect) != null) {
            this.addPotionEffect(new PotionEffect(lvt_3_2_, Integer.MAX_VALUE));
        }
        return p_onInitialSpawn_2_;
    }

    @Override
    public float getEyeHeight() {
        return 0.65f;
    }

    static class AISpiderTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AISpiderTarget(EntitySpider p_i45818_1_, Class<T> p_i45818_2_) {
            super((EntityCreature)p_i45818_1_, p_i45818_2_, true);
        }

        @Override
        public boolean shouldExecute() {
            float lvt_1_1_ = this.taskOwner.getBrightness(1.0f);
            if (lvt_1_1_ >= 0.5f) {
                return false;
            }
            return super.shouldExecute();
        }
    }

    static class AISpiderAttack
    extends EntityAIAttackMelee {
        public AISpiderAttack(EntitySpider p_i46676_1_) {
            super(p_i46676_1_, 1.0, true);
        }

        @Override
        public boolean continueExecuting() {
            float lvt_1_1_ = this.attacker.getBrightness(1.0f);
            if (lvt_1_1_ >= 0.5f && this.attacker.getRNG().nextInt(100) == 0) {
                this.attacker.setAttackTarget(null);
                return false;
            }
            return super.continueExecuting();
        }

        @Override
        protected double getAttackReachSqr(EntityLivingBase p_getAttackReachSqr_1_) {
            return 4.0f + p_getAttackReachSqr_1_.width;
        }
    }

    public static class GroupData
    implements IEntityLivingData {
        public Potion effect;

        public void setRandomEffect(Random p_setRandomEffect_1_) {
            int lvt_2_1_ = p_setRandomEffect_1_.nextInt(5);
            if (lvt_2_1_ <= 1) {
                this.effect = MobEffects.SPEED;
            } else if (lvt_2_1_ <= 2) {
                this.effect = MobEffects.STRENGTH;
            } else if (lvt_2_1_ <= 3) {
                this.effect = MobEffects.REGENERATION;
            } else if (lvt_2_1_ <= 4) {
                this.effect = MobEffects.INVISIBILITY;
            }
        }
    }
}

