/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityStray
extends AbstractSkeleton {
    public EntityStray(World p_i47281_1_) {
        super(p_i47281_1_);
    }

    public static void registerFixesStray(DataFixer p_registerFixesStray_0_) {
        EntityLiving.registerFixesMob(p_registerFixesStray_0_, EntityStray.class);
    }

    @Override
    public boolean getCanSpawnHere() {
        return super.getCanSpawnHere() && this.world.canSeeSky(new BlockPos(this));
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_STRAY;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_STRAY_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_STRAY_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_STRAY_DEATH;
    }

    @Override
    SoundEvent getStepSound() {
        return SoundEvents.ENTITY_STRAY_STEP;
    }

    @Override
    protected EntityArrow getArrow(float p_getArrow_1_) {
        EntityArrow lvt_2_1_ = super.getArrow(p_getArrow_1_);
        if (lvt_2_1_ instanceof EntityTippedArrow) {
            ((EntityTippedArrow)lvt_2_1_).addEffect(new PotionEffect(MobEffects.SLOWNESS, 600));
        }
        return lvt_2_1_;
    }
}

