/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityVex
extends EntityMob {
    protected static final DataParameter<Byte> VEX_FLAGS = EntityDataManager.createKey(EntityVex.class, DataSerializers.BYTE);
    private EntityLiving owner;
    @Nullable
    private BlockPos boundOrigin;
    private boolean limitedLifespan;
    private int limitedLifeTicks;

    public EntityVex(World p_i47280_1_) {
        super(p_i47280_1_);
        this.isImmuneToFire = true;
        this.moveHelper = new AIMoveControl(this);
        this.setSize(0.4f, 0.8f);
        this.experienceValue = 3;
    }

    @Override
    public void move(MoverType p_move_1_, double p_move_2_, double p_move_4_, double p_move_6_) {
        super.move(p_move_1_, p_move_2_, p_move_4_, p_move_6_);
        this.doBlockCollisions();
    }

    @Override
    public void onUpdate() {
        this.noClip = true;
        super.onUpdate();
        this.noClip = false;
        this.setNoGravity(true);
        if (this.limitedLifespan && --this.limitedLifeTicks <= 0) {
            this.limitedLifeTicks = 20;
            this.attackEntityFrom(DamageSource.STARVE, 1.0f);
        }
    }

    @Override
    protected void initEntityAI() {
        super.initEntityAI();
        this.tasks.addTask(0, new EntityAISwimming(this));
        this.tasks.addTask(4, new AIChargeAttack());
        this.tasks.addTask(8, new AIMoveRandom());
        this.tasks.addTask(9, new EntityAIWatchClosest(this, EntityPlayer.class, 3.0f, 1.0f));
        this.tasks.addTask(10, new EntityAIWatchClosest(this, EntityLiving.class, 8.0f));
        this.targetTasks.addTask(1, new EntityAIHurtByTarget((EntityCreature)this, true, EntityVex.class));
        this.targetTasks.addTask(2, new AICopyOwnerTarget(this));
        this.targetTasks.addTask(3, new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(14.0);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(4.0);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(VEX_FLAGS, (byte)0);
    }

    public static void registerFixesVex(DataFixer p_registerFixesVex_0_) {
        EntityLiving.registerFixesMob(p_registerFixesVex_0_, EntityVex.class);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        if (p_readEntityFromNBT_1_.hasKey("BoundX")) {
            this.boundOrigin = new BlockPos(p_readEntityFromNBT_1_.getInteger("BoundX"), p_readEntityFromNBT_1_.getInteger("BoundY"), p_readEntityFromNBT_1_.getInteger("BoundZ"));
        }
        if (p_readEntityFromNBT_1_.hasKey("LifeTicks")) {
            this.setLimitedLife(p_readEntityFromNBT_1_.getInteger("LifeTicks"));
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        if (this.boundOrigin != null) {
            p_writeEntityToNBT_1_.setInteger("BoundX", this.boundOrigin.getX());
            p_writeEntityToNBT_1_.setInteger("BoundY", this.boundOrigin.getY());
            p_writeEntityToNBT_1_.setInteger("BoundZ", this.boundOrigin.getZ());
        }
        if (this.limitedLifespan) {
            p_writeEntityToNBT_1_.setInteger("LifeTicks", this.limitedLifeTicks);
        }
    }

    public EntityLiving getOwner() {
        return this.owner;
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(BlockPos p_setBoundOrigin_1_) {
        this.boundOrigin = p_setBoundOrigin_1_;
    }

    private boolean getVexFlag(int p_getVexFlag_1_) {
        byte lvt_2_1_ = this.dataManager.get(VEX_FLAGS);
        return (lvt_2_1_ & p_getVexFlag_1_) != 0;
    }

    private void setVexFlag(int p_setVexFlag_1_, boolean p_setVexFlag_2_) {
        int lvt_3_1_ = this.dataManager.get(VEX_FLAGS).byteValue();
        lvt_3_1_ = p_setVexFlag_2_ ? (lvt_3_1_ |= p_setVexFlag_1_) : (lvt_3_1_ &= ~p_setVexFlag_1_);
        this.dataManager.set(VEX_FLAGS, (byte)(lvt_3_1_ & 0xFF));
    }

    public boolean isCharging() {
        return this.getVexFlag(1);
    }

    public void setIsCharging(boolean p_setIsCharging_1_) {
        this.setVexFlag(1, p_setIsCharging_1_);
    }

    public void setOwner(EntityLiving p_setOwner_1_) {
        this.owner = p_setOwner_1_;
    }

    public void setLimitedLife(int p_setLimitedLife_1_) {
        this.limitedLifespan = true;
        this.limitedLifeTicks = p_setLimitedLife_1_;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_VEX_AMBIENT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_VEX_DEATH;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_VEX_HURT;
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_VEX;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float p_getBrightnessForRender_1_) {
        return 0xF000F0;
    }

    @Override
    public float getBrightness(float p_getBrightness_1_) {
        return 1.0f;
    }

    @Override
    @Nullable
    public IEntityLivingData onInitialSpawn(DifficultyInstance p_onInitialSpawn_1_, IEntityLivingData p_onInitialSpawn_2_) {
        this.setEquipmentBasedOnDifficulty(p_onInitialSpawn_1_);
        this.setEnchantmentBasedOnDifficulty(p_onInitialSpawn_1_);
        return super.onInitialSpawn(p_onInitialSpawn_1_, p_onInitialSpawn_2_);
    }

    @Override
    protected void setEquipmentBasedOnDifficulty(DifficultyInstance p_setEquipmentBasedOnDifficulty_1_) {
        this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.IRON_SWORD));
        this.setDropChance(EntityEquipmentSlot.MAINHAND, 0.0f);
    }

    class AICopyOwnerTarget
    extends EntityAITarget {
        public AICopyOwnerTarget(EntityCreature p_i47231_2_) {
            super(p_i47231_2_, false);
        }

        @Override
        public boolean shouldExecute() {
            return EntityVex.this.owner != null && EntityVex.this.owner.getAttackTarget() != null && this.isSuitableTarget(EntityVex.this.owner.getAttackTarget(), false);
        }

        @Override
        public void startExecuting() {
            EntityVex.this.setAttackTarget(EntityVex.this.owner.getAttackTarget());
            super.startExecuting();
        }
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.setMutexBits(1);
        }

        @Override
        public boolean shouldExecute() {
            return !EntityVex.this.getMoveHelper().isUpdating() && EntityVex.this.rand.nextInt(7) == 0;
        }

        @Override
        public boolean continueExecuting() {
            return false;
        }

        @Override
        public void updateTask() {
            BlockPos lvt_1_1_ = EntityVex.this.getBoundOrigin();
            if (lvt_1_1_ == null) {
                lvt_1_1_ = new BlockPos(EntityVex.this);
            }
            for (int lvt_2_1_ = 0; lvt_2_1_ < 3; ++lvt_2_1_) {
                BlockPos lvt_3_1_ = lvt_1_1_.add(EntityVex.this.rand.nextInt(15) - 7, EntityVex.this.rand.nextInt(11) - 5, EntityVex.this.rand.nextInt(15) - 7);
                if (!EntityVex.this.world.isAirBlock(lvt_3_1_)) continue;
                EntityVex.this.moveHelper.setMoveTo((double)lvt_3_1_.getX() + 0.5, (double)lvt_3_1_.getY() + 0.5, (double)lvt_3_1_.getZ() + 0.5, 0.25);
                if (EntityVex.this.getAttackTarget() != null) break;
                EntityVex.this.getLookHelper().setLookPosition((double)lvt_3_1_.getX() + 0.5, (double)lvt_3_1_.getY() + 0.5, (double)lvt_3_1_.getZ() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIChargeAttack
    extends EntityAIBase {
        public AIChargeAttack() {
            this.setMutexBits(1);
        }

        @Override
        public boolean shouldExecute() {
            if (EntityVex.this.getAttackTarget() != null && !EntityVex.this.getMoveHelper().isUpdating() && EntityVex.this.rand.nextInt(7) == 0) {
                return EntityVex.this.getDistanceSqToEntity(EntityVex.this.getAttackTarget()) > 4.0;
            }
            return false;
        }

        @Override
        public boolean continueExecuting() {
            return EntityVex.this.getMoveHelper().isUpdating() && EntityVex.this.isCharging() && EntityVex.this.getAttackTarget() != null && EntityVex.this.getAttackTarget().isEntityAlive();
        }

        @Override
        public void startExecuting() {
            EntityLivingBase lvt_1_1_ = EntityVex.this.getAttackTarget();
            Vec3d lvt_2_1_ = lvt_1_1_.getPositionEyes(1.0f);
            EntityVex.this.moveHelper.setMoveTo(lvt_2_1_.xCoord, lvt_2_1_.yCoord, lvt_2_1_.zCoord, 1.0);
            EntityVex.this.setIsCharging(true);
            EntityVex.this.playSound(SoundEvents.ENTITY_VEX_CHARGE, 1.0f, 1.0f);
        }

        @Override
        public void resetTask() {
            EntityVex.this.setIsCharging(false);
        }

        @Override
        public void updateTask() {
            EntityLivingBase lvt_1_1_ = EntityVex.this.getAttackTarget();
            if (EntityVex.this.getEntityBoundingBox().intersectsWith(lvt_1_1_.getEntityBoundingBox())) {
                EntityVex.this.attackEntityAsMob(lvt_1_1_);
                EntityVex.this.setIsCharging(false);
            } else {
                double lvt_2_1_ = EntityVex.this.getDistanceSqToEntity(lvt_1_1_);
                if (lvt_2_1_ < 9.0) {
                    Vec3d lvt_4_1_ = lvt_1_1_.getPositionEyes(1.0f);
                    EntityVex.this.moveHelper.setMoveTo(lvt_4_1_.xCoord, lvt_4_1_.yCoord, lvt_4_1_.zCoord, 1.0);
                }
            }
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityVex p_i47230_2_) {
            super(p_i47230_2_);
        }

        @Override
        public void onUpdateMoveHelper() {
            if (this.action != EntityMoveHelper.Action.MOVE_TO) {
                return;
            }
            double lvt_1_1_ = this.posX - EntityVex.this.posX;
            double lvt_3_1_ = this.posY - EntityVex.this.posY;
            double lvt_5_1_ = this.posZ - EntityVex.this.posZ;
            double lvt_7_1_ = lvt_1_1_ * lvt_1_1_ + lvt_3_1_ * lvt_3_1_ + lvt_5_1_ * lvt_5_1_;
            if ((lvt_7_1_ = (double)MathHelper.sqrt(lvt_7_1_)) < EntityVex.this.getEntityBoundingBox().getAverageEdgeLength()) {
                this.action = EntityMoveHelper.Action.WAIT;
                EntityVex.this.motionX *= 0.5;
                EntityVex.this.motionY *= 0.5;
                EntityVex.this.motionZ *= 0.5;
            } else {
                EntityVex.this.motionX += lvt_1_1_ / lvt_7_1_ * 0.05 * this.speed;
                EntityVex.this.motionY += lvt_3_1_ / lvt_7_1_ * 0.05 * this.speed;
                EntityVex.this.motionZ += lvt_5_1_ / lvt_7_1_ * 0.05 * this.speed;
                if (EntityVex.this.getAttackTarget() == null) {
                    EntityVex.this.renderYawOffset = EntityVex.this.rotationYaw = -((float)MathHelper.atan2(EntityVex.this.motionX, EntityVex.this.motionZ)) * 57.295776f;
                } else {
                    double lvt_9_1_ = EntityVex.this.getAttackTarget().posX - EntityVex.this.posX;
                    double lvt_11_1_ = EntityVex.this.getAttackTarget().posZ - EntityVex.this.posZ;
                    EntityVex.this.renderYawOffset = EntityVex.this.rotationYaw = -((float)MathHelper.atan2(lvt_9_1_, lvt_11_1_)) * 57.295776f;
                }
            }
        }
    }
}

