/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityVindicator
extends EntityMob {
    protected static final DataParameter<Byte> DATA_FLAGS_ID = EntityDataManager.createKey(EntityVindicator.class, DataSerializers.BYTE);
    private boolean johnny;
    private static final Predicate<Entity> JOHNNY_SELECTOR = new Predicate<Entity>(){

        public boolean apply(Entity p_apply_1_) {
            return p_apply_1_ instanceof EntityLivingBase && ((EntityLivingBase)p_apply_1_).attackable();
        }

        public /* synthetic */ boolean apply(Object p_apply_1_) {
            return this.apply((Entity)p_apply_1_);
        }
    };

    public EntityVindicator(World p_i47279_1_) {
        super(p_i47279_1_);
        this.setSize(0.6f, 1.95f);
    }

    public static void registerFixesVindicator(DataFixer p_registerFixesVindicator_0_) {
        EntityLiving.registerFixesMob(p_registerFixesVindicator_0_, EntityVindicator.class);
    }

    @Override
    protected void initEntityAI() {
        super.initEntityAI();
        this.tasks.addTask(0, new EntityAISwimming(this));
        this.tasks.addTask(4, new EntityAIAttackMelee(this, 1.0, false));
        this.tasks.addTask(8, new EntityAIWander(this, 0.6));
        this.tasks.addTask(9, new EntityAIWatchClosest(this, EntityPlayer.class, 3.0f, 1.0f));
        this.tasks.addTask(10, new EntityAIWatchClosest(this, EntityLiving.class, 8.0f));
        this.targetTasks.addTask(1, new EntityAIHurtByTarget((EntityCreature)this, true, EntityVindicator.class));
        this.targetTasks.addTask(2, new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true));
        this.targetTasks.addTask(3, new EntityAINearestAttackableTarget<EntityVillager>((EntityCreature)this, EntityVillager.class, true));
        this.targetTasks.addTask(3, new EntityAINearestAttackableTarget<EntityIronGolem>((EntityCreature)this, EntityIronGolem.class, true));
        this.targetTasks.addTask(4, new AIJohnnyAttack(this));
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.35f);
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(12.0);
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(24.0);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(5.0);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(DATA_FLAGS_ID, (byte)0);
    }

    @Override
    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.ILLAGER;
    }

    @Override
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_VINDICATION_ILLAGER;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean getVindicatorFlag(int p_getVindicatorFlag_1_) {
        byte lvt_2_1_ = this.dataManager.get(DATA_FLAGS_ID);
        return (lvt_2_1_ & p_getVindicatorFlag_1_) != 0;
    }

    private void setVindicatorFlag(int p_setVindicatorFlag_1_, boolean p_setVindicatorFlag_2_) {
        int lvt_3_1_ = this.dataManager.get(DATA_FLAGS_ID).byteValue();
        lvt_3_1_ = p_setVindicatorFlag_2_ ? (lvt_3_1_ |= p_setVindicatorFlag_1_) : (lvt_3_1_ &= ~p_setVindicatorFlag_1_);
        this.dataManager.set(DATA_FLAGS_ID, (byte)(lvt_3_1_ & 0xFF));
    }

    public void setAggressive(boolean p_setAggressive_1_) {
        this.setVindicatorFlag(1, p_setAggressive_1_);
        if (this.getItemStackFromSlot(EntityEquipmentSlot.MAINHAND) == ItemStack.EMPTY) {
            this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.IRON_AXE));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAggressive() {
        return this.getVindicatorFlag(1);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        if (this.johnny) {
            p_writeEntityToNBT_1_.setBoolean("Johnny", true);
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        if (p_readEntityFromNBT_1_.hasKey("Johnny", 99)) {
            this.johnny = p_readEntityFromNBT_1_.getBoolean("Johnny");
        }
    }

    @Override
    @Nullable
    public IEntityLivingData onInitialSpawn(DifficultyInstance p_onInitialSpawn_1_, IEntityLivingData p_onInitialSpawn_2_) {
        IEntityLivingData lvt_3_1_ = super.onInitialSpawn(p_onInitialSpawn_1_, p_onInitialSpawn_2_);
        this.setEquipmentBasedOnDifficulty(p_onInitialSpawn_1_);
        this.setEnchantmentBasedOnDifficulty(p_onInitialSpawn_1_);
        return lvt_3_1_;
    }

    @Override
    protected void setEquipmentBasedOnDifficulty(DifficultyInstance p_setEquipmentBasedOnDifficulty_1_) {
        this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.IRON_AXE));
    }

    @Override
    protected void updateAITasks() {
        super.updateAITasks();
        this.setAggressive(this.getAttackTarget() != null);
    }

    @Override
    public boolean isOnSameTeam(Entity p_isOnSameTeam_1_) {
        if (super.isOnSameTeam(p_isOnSameTeam_1_)) {
            return true;
        }
        if (p_isOnSameTeam_1_ instanceof EntityLivingBase && ((EntityLivingBase)p_isOnSameTeam_1_).getCreatureAttribute() == EnumCreatureAttribute.ILLAGER) {
            return this.getTeam() == null && p_isOnSameTeam_1_.getTeam() == null;
        }
        return false;
    }

    @Override
    public void setCustomNameTag(String p_setCustomNameTag_1_) {
        super.setCustomNameTag(p_setCustomNameTag_1_);
        if (!this.johnny && "Johnny".equals(p_setCustomNameTag_1_)) {
            this.johnny = true;
        }
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.VINDICATION_ILLAGER_AMBIENT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.VINDICATION_ILLAGER_DEATH;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_VINDICATION_ILLAGER_HURT;
    }

    static class AIJohnnyAttack
    extends EntityAINearestAttackableTarget<EntityLivingBase> {
        public AIJohnnyAttack(EntityVindicator p_i47345_1_) {
            super(p_i47345_1_, EntityLivingBase.class, 0, true, true, JOHNNY_SELECTOR);
        }

        @Override
        public boolean shouldExecute() {
            return ((EntityVindicator)this.taskOwner).johnny && super.shouldExecute();
        }
    }
}

