/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityWitch
extends EntityMob
implements IRangedAttackMob {
    private static final UUID MODIFIER_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier MODIFIER = new AttributeModifier(MODIFIER_UUID, "Drinking speed penalty", -0.25, 0).setSaved(false);
    private static final DataParameter<Boolean> IS_AGGRESSIVE = EntityDataManager.createKey(EntityWitch.class, DataSerializers.BOOLEAN);
    private int witchAttackTimer;

    public EntityWitch(World p_i1744_1_) {
        super(p_i1744_1_);
        this.setSize(0.6f, 1.95f);
    }

    public static void registerFixesWitch(DataFixer p_registerFixesWitch_0_) {
        EntityLiving.registerFixesMob(p_registerFixesWitch_0_, EntityWitch.class);
    }

    @Override
    protected void initEntityAI() {
        this.tasks.addTask(1, new EntityAISwimming(this));
        this.tasks.addTask(2, new EntityAIAttackRanged(this, 1.0, 60, 10.0f));
        this.tasks.addTask(2, new EntityAIWanderAvoidWater(this, 1.0));
        this.tasks.addTask(3, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(3, new EntityAILookIdle(this));
        this.targetTasks.addTask(1, new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.targetTasks.addTask(2, new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.getDataManager().register(IS_AGGRESSIVE, false);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_WITCH_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_WITCH_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_WITCH_DEATH;
    }

    public void setAggressive(boolean p_setAggressive_1_) {
        this.getDataManager().set(IS_AGGRESSIVE, p_setAggressive_1_);
    }

    public boolean isDrinkingPotion() {
        return this.getDataManager().get(IS_AGGRESSIVE);
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(26.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.25);
    }

    @Override
    public void onLivingUpdate() {
        if (!this.world.isRemote) {
            if (this.isDrinkingPotion()) {
                if (this.witchAttackTimer-- <= 0) {
                    List<PotionEffect> lvt_2_1_;
                    this.setAggressive(false);
                    ItemStack lvt_1_1_ = this.getHeldItemMainhand();
                    this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, ItemStack.EMPTY);
                    if (lvt_1_1_.getItem() == Items.POTIONITEM && (lvt_2_1_ = PotionUtils.getEffectsFromStack(lvt_1_1_)) != null) {
                        for (PotionEffect lvt_4_1_ : lvt_2_1_) {
                            this.addPotionEffect(new PotionEffect(lvt_4_1_));
                        }
                    }
                    this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).removeModifier(MODIFIER);
                }
            } else {
                PotionType lvt_1_2_ = null;
                if (this.rand.nextFloat() < 0.15f && this.isInsideOfMaterial(Material.WATER) && !this.isPotionActive(MobEffects.WATER_BREATHING)) {
                    lvt_1_2_ = PotionTypes.WATER_BREATHING;
                } else if (this.rand.nextFloat() < 0.15f && (this.isBurning() || this.getLastDamageSource() != null && this.getLastDamageSource().isFireDamage()) && !this.isPotionActive(MobEffects.FIRE_RESISTANCE)) {
                    lvt_1_2_ = PotionTypes.FIRE_RESISTANCE;
                } else if (this.rand.nextFloat() < 0.05f && this.getHealth() < this.getMaxHealth()) {
                    lvt_1_2_ = PotionTypes.HEALING;
                } else if (this.rand.nextFloat() < 0.5f && this.getAttackTarget() != null && !this.isPotionActive(MobEffects.SPEED) && this.getAttackTarget().getDistanceSqToEntity(this) > 121.0) {
                    lvt_1_2_ = PotionTypes.SWIFTNESS;
                }
                if (lvt_1_2_ != null) {
                    this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, PotionUtils.addPotionToItemStack(new ItemStack(Items.POTIONITEM), lvt_1_2_));
                    this.witchAttackTimer = this.getHeldItemMainhand().getMaxItemUseDuration();
                    this.setAggressive(true);
                    this.world.playSound(null, this.posX, this.posY, this.posZ, SoundEvents.ENTITY_WITCH_DRINK, this.getSoundCategory(), 1.0f, 0.8f + this.rand.nextFloat() * 0.4f);
                    IAttributeInstance lvt_2_2_ = this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED);
                    lvt_2_2_.removeModifier(MODIFIER);
                    lvt_2_2_.applyModifier(MODIFIER);
                }
            }
            if (this.rand.nextFloat() < 7.5E-4f) {
                this.world.setEntityState(this, (byte)15);
            }
        }
        super.onLivingUpdate();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte p_handleStatusUpdate_1_) {
        if (p_handleStatusUpdate_1_ == 15) {
            for (int lvt_2_1_ = 0; lvt_2_1_ < this.rand.nextInt(35) + 10; ++lvt_2_1_) {
                this.world.spawnParticle(EnumParticleTypes.SPELL_WITCH, this.posX + this.rand.nextGaussian() * (double)0.13f, this.getEntityBoundingBox().maxY + 0.5 + this.rand.nextGaussian() * (double)0.13f, this.posZ + this.rand.nextGaussian() * (double)0.13f, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.handleStatusUpdate(p_handleStatusUpdate_1_);
        }
    }

    @Override
    protected float applyPotionDamageCalculations(DamageSource p_applyPotionDamageCalculations_1_, float p_applyPotionDamageCalculations_2_) {
        p_applyPotionDamageCalculations_2_ = super.applyPotionDamageCalculations(p_applyPotionDamageCalculations_1_, p_applyPotionDamageCalculations_2_);
        if (p_applyPotionDamageCalculations_1_.getEntity() == this) {
            p_applyPotionDamageCalculations_2_ = 0.0f;
        }
        if (p_applyPotionDamageCalculations_1_.isMagicDamage()) {
            p_applyPotionDamageCalculations_2_ = (float)((double)p_applyPotionDamageCalculations_2_ * 0.15);
        }
        return p_applyPotionDamageCalculations_2_;
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_WITCH;
    }

    @Override
    public void attackEntityWithRangedAttack(EntityLivingBase p_attackEntityWithRangedAttack_1_, float p_attackEntityWithRangedAttack_2_) {
        if (this.isDrinkingPotion()) {
            return;
        }
        double lvt_3_1_ = p_attackEntityWithRangedAttack_1_.posY + (double)p_attackEntityWithRangedAttack_1_.getEyeHeight() - (double)1.1f;
        double lvt_5_1_ = p_attackEntityWithRangedAttack_1_.posX + p_attackEntityWithRangedAttack_1_.motionX - this.posX;
        double lvt_7_1_ = lvt_3_1_ - this.posY;
        double lvt_9_1_ = p_attackEntityWithRangedAttack_1_.posZ + p_attackEntityWithRangedAttack_1_.motionZ - this.posZ;
        float lvt_11_1_ = MathHelper.sqrt(lvt_5_1_ * lvt_5_1_ + lvt_9_1_ * lvt_9_1_);
        PotionType lvt_12_1_ = PotionTypes.HARMING;
        if (lvt_11_1_ >= 8.0f && !p_attackEntityWithRangedAttack_1_.isPotionActive(MobEffects.SLOWNESS)) {
            lvt_12_1_ = PotionTypes.SLOWNESS;
        } else if (p_attackEntityWithRangedAttack_1_.getHealth() >= 8.0f && !p_attackEntityWithRangedAttack_1_.isPotionActive(MobEffects.POISON)) {
            lvt_12_1_ = PotionTypes.POISON;
        } else if (lvt_11_1_ <= 3.0f && !p_attackEntityWithRangedAttack_1_.isPotionActive(MobEffects.WEAKNESS) && this.rand.nextFloat() < 0.25f) {
            lvt_12_1_ = PotionTypes.WEAKNESS;
        }
        EntityPotion lvt_13_1_ = new EntityPotion(this.world, this, PotionUtils.addPotionToItemStack(new ItemStack(Items.SPLASH_POTION), lvt_12_1_));
        lvt_13_1_.rotationPitch -= -20.0f;
        lvt_13_1_.setThrowableHeading(lvt_5_1_, lvt_7_1_ + (double)(lvt_11_1_ * 0.2f), lvt_9_1_, 0.75f, 8.0f);
        this.world.playSound(null, this.posX, this.posY, this.posZ, SoundEvents.ENTITY_WITCH_THROW, this.getSoundCategory(), 1.0f, 0.8f + this.rand.nextFloat() * 0.4f);
        this.world.spawnEntity(lvt_13_1_);
    }

    @Override
    public float getEyeHeight() {
        return 1.62f;
    }
}

