/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityWitherSkeleton
extends AbstractSkeleton {
    public EntityWitherSkeleton(World p_i47278_1_) {
        super(p_i47278_1_);
        this.setSize(0.7f, 2.4f);
        this.isImmuneToFire = true;
    }

    public static void registerFixesWitherSkeleton(DataFixer p_registerFixesWitherSkeleton_0_) {
        EntityLiving.registerFixesMob(p_registerFixesWitherSkeleton_0_, EntityWitherSkeleton.class);
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_WITHER_SKELETON;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_WITHER_SKELETON_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_WITHER_SKELETON_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_WITHER_SKELETON_DEATH;
    }

    @Override
    SoundEvent getStepSound() {
        return SoundEvents.ENTITY_WITHER_SKELETON_STEP;
    }

    @Override
    public void onDeath(DamageSource p_onDeath_1_) {
        EntityCreeper lvt_2_1_;
        super.onDeath(p_onDeath_1_);
        if (p_onDeath_1_.getEntity() instanceof EntityCreeper && (lvt_2_1_ = (EntityCreeper)p_onDeath_1_.getEntity()).getPowered() && lvt_2_1_.isAIEnabled()) {
            lvt_2_1_.incrementDroppedSkulls();
            this.entityDropItem(new ItemStack(Items.SKULL, 1, 1), 0.0f);
        }
    }

    @Override
    protected void setEquipmentBasedOnDifficulty(DifficultyInstance p_setEquipmentBasedOnDifficulty_1_) {
        this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.STONE_SWORD));
    }

    @Override
    protected void setEnchantmentBasedOnDifficulty(DifficultyInstance p_setEnchantmentBasedOnDifficulty_1_) {
    }

    @Override
    @Nullable
    public IEntityLivingData onInitialSpawn(DifficultyInstance p_onInitialSpawn_1_, IEntityLivingData p_onInitialSpawn_2_) {
        IEntityLivingData lvt_3_1_ = super.onInitialSpawn(p_onInitialSpawn_1_, p_onInitialSpawn_2_);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(4.0);
        this.setCombatTask();
        return lvt_3_1_;
    }

    @Override
    public float getEyeHeight() {
        return 2.1f;
    }

    @Override
    public boolean attackEntityAsMob(Entity p_attackEntityAsMob_1_) {
        if (!super.attackEntityAsMob(p_attackEntityAsMob_1_)) {
            return false;
        }
        if (p_attackEntityAsMob_1_ instanceof EntityLivingBase) {
            ((EntityLivingBase)p_attackEntityAsMob_1_).addPotionEffect(new PotionEffect(MobEffects.WITHER, 200));
        }
        return true;
    }

    @Override
    protected EntityArrow getArrow(float p_getArrow_1_) {
        EntityArrow lvt_2_1_ = super.getArrow(p_getArrow_1_);
        lvt_2_1_.setFire(100);
        return lvt_2_1_;
    }
}

