/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.world.World;

public abstract class AbstractChestHorse
extends AbstractHorse {
    private static final DataParameter<Boolean> DATA_ID_CHEST = EntityDataManager.createKey(AbstractChestHorse.class, DataSerializers.BOOLEAN);

    public AbstractChestHorse(World p_i47300_1_) {
        super(p_i47300_1_);
        this.canGallop = false;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(DATA_ID_CHEST, false);
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(this.getModifiedMaxHealth());
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.175f);
        this.getEntityAttribute(JUMP_STRENGTH).setBaseValue(0.5);
    }

    public boolean hasChest() {
        return this.dataManager.get(DATA_ID_CHEST);
    }

    public void setChested(boolean p_setChested_1_) {
        this.dataManager.set(DATA_ID_CHEST, p_setChested_1_);
    }

    @Override
    protected int getInventorySize() {
        if (this.hasChest()) {
            return 17;
        }
        return super.getInventorySize();
    }

    @Override
    public double getMountedYOffset() {
        return super.getMountedYOffset() - 0.25;
    }

    @Override
    protected SoundEvent getAngrySound() {
        super.getAngrySound();
        return SoundEvents.ENTITY_DONKEY_ANGRY;
    }

    @Override
    public void onDeath(DamageSource p_onDeath_1_) {
        super.onDeath(p_onDeath_1_);
        if (this.hasChest()) {
            if (!this.world.isRemote) {
                this.dropItem(Item.getItemFromBlock(Blocks.CHEST), 1);
            }
            this.setChested(false);
        }
    }

    public static void registerFixesAbstractChestHorse(DataFixer p_registerFixesAbstractChestHorse_0_, Class<?> p_registerFixesAbstractChestHorse_1_) {
        AbstractHorse.registerFixesAbstractHorse(p_registerFixesAbstractChestHorse_0_, p_registerFixesAbstractChestHorse_1_);
        p_registerFixesAbstractChestHorse_0_.registerWalker(FixTypes.ENTITY, new ItemStackDataLists(p_registerFixesAbstractChestHorse_1_, "Items"));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setBoolean("ChestedHorse", this.hasChest());
        if (this.hasChest()) {
            NBTTagList lvt_2_1_ = new NBTTagList();
            for (int lvt_3_1_ = 2; lvt_3_1_ < this.horseChest.getSizeInventory(); ++lvt_3_1_) {
                ItemStack lvt_4_1_ = this.horseChest.getStackInSlot(lvt_3_1_);
                if (lvt_4_1_.isEmpty()) continue;
                NBTTagCompound lvt_5_1_ = new NBTTagCompound();
                lvt_5_1_.setByte("Slot", (byte)lvt_3_1_);
                lvt_4_1_.writeToNBT(lvt_5_1_);
                lvt_2_1_.appendTag(lvt_5_1_);
            }
            p_writeEntityToNBT_1_.setTag("Items", lvt_2_1_);
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.setChested(p_readEntityFromNBT_1_.getBoolean("ChestedHorse"));
        if (this.hasChest()) {
            NBTTagList lvt_2_1_ = p_readEntityFromNBT_1_.getTagList("Items", 10);
            this.initHorseChest();
            for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_1_.tagCount(); ++lvt_3_1_) {
                NBTTagCompound lvt_4_1_ = lvt_2_1_.getCompoundTagAt(lvt_3_1_);
                int lvt_5_1_ = lvt_4_1_.getByte("Slot") & 0xFF;
                if (lvt_5_1_ < 2 || lvt_5_1_ >= this.horseChest.getSizeInventory()) continue;
                this.horseChest.setInventorySlotContents(lvt_5_1_, new ItemStack(lvt_4_1_));
            }
        }
        this.updateHorseSlots();
    }

    @Override
    public boolean replaceItemInInventory(int p_replaceItemInInventory_1_, ItemStack p_replaceItemInInventory_2_) {
        if (p_replaceItemInInventory_1_ == 499) {
            if (this.hasChest() && p_replaceItemInInventory_2_.isEmpty()) {
                this.setChested(false);
                this.initHorseChest();
                return true;
            }
            if (!this.hasChest() && p_replaceItemInInventory_2_.getItem() == Item.getItemFromBlock(Blocks.CHEST)) {
                this.setChested(true);
                this.initHorseChest();
                return true;
            }
        }
        return super.replaceItemInInventory(p_replaceItemInInventory_1_, p_replaceItemInInventory_2_);
    }

    @Override
    public boolean processInteract(EntityPlayer p_processInteract_1_, EnumHand p_processInteract_2_) {
        ItemStack lvt_3_1_ = p_processInteract_1_.getHeldItem(p_processInteract_2_);
        if (lvt_3_1_.getItem() == Items.SPAWN_EGG) {
            return super.processInteract(p_processInteract_1_, p_processInteract_2_);
        }
        if (!this.isChild()) {
            if (this.isTame() && p_processInteract_1_.isSneaking()) {
                this.openGUI(p_processInteract_1_);
                return true;
            }
            if (this.isBeingRidden()) {
                return super.processInteract(p_processInteract_1_, p_processInteract_2_);
            }
        }
        if (!lvt_3_1_.isEmpty()) {
            boolean lvt_4_1_ = this.handleEating(p_processInteract_1_, lvt_3_1_);
            if (!lvt_4_1_ && !this.isTame()) {
                if (lvt_3_1_.interactWithEntity(p_processInteract_1_, this, p_processInteract_2_)) {
                    return true;
                }
                this.makeMad();
                return true;
            }
            if (!lvt_4_1_ && !this.hasChest() && lvt_3_1_.getItem() == Item.getItemFromBlock(Blocks.CHEST)) {
                this.setChested(true);
                this.playChestEquipSound();
                lvt_4_1_ = true;
                this.initHorseChest();
            }
            if (!(lvt_4_1_ || this.isChild() || this.isHorseSaddled() || lvt_3_1_.getItem() != Items.SADDLE)) {
                this.openGUI(p_processInteract_1_);
                return true;
            }
            if (lvt_4_1_) {
                if (!p_processInteract_1_.capabilities.isCreativeMode) {
                    lvt_3_1_.shrink(1);
                }
                return true;
            }
        }
        if (this.isChild()) {
            return super.processInteract(p_processInteract_1_, p_processInteract_2_);
        }
        if (lvt_3_1_.interactWithEntity(p_processInteract_1_, this, p_processInteract_2_)) {
            return true;
        }
        this.mountTo(p_processInteract_1_);
        return true;
    }

    protected void playChestEquipSound() {
        this.playSound(SoundEvents.ENTITY_DONKEY_CHEST, 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
    }

    public int getInventoryColumns() {
        return 5;
    }
}

