/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIRunAroundLikeCrazy;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerHorseChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.ItemStackData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class AbstractHorse
extends EntityAnimal
implements IInventoryChangedListener,
IJumpingMount {
    private static final Predicate<Entity> IS_HORSE_BREEDING = new Predicate<Entity>(){

        public boolean apply(Entity p_apply_1_) {
            return p_apply_1_ instanceof AbstractHorse && ((AbstractHorse)p_apply_1_).isBreeding();
        }
    };
    protected static final IAttribute JUMP_STRENGTH = new RangedAttribute(null, "horse.jumpStrength", 0.7, 0.0, 2.0).setDescription("Jump Strength").setShouldWatch(true);
    private static final DataParameter<Byte> STATUS = EntityDataManager.createKey(AbstractHorse.class, DataSerializers.BYTE);
    private static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.createKey(AbstractHorse.class, DataSerializers.OPTIONAL_UNIQUE_ID);
    private int eatingCounter;
    private int openMouthCounter;
    private int jumpRearingCounter;
    public int tailCounter;
    public int sprintCounter;
    protected boolean horseJumping;
    protected ContainerHorseChest horseChest;
    protected int temper;
    protected float jumpPower;
    private boolean allowStandSliding;
    private float headLean;
    private float prevHeadLean;
    private float rearingAmount;
    private float prevRearingAmount;
    private float mouthOpenness;
    private float prevMouthOpenness;
    protected boolean canGallop = true;
    protected int gallopTime;
    private IItemHandler itemHandler = null;

    public AbstractHorse(World p_i47299_1_) {
        super(p_i47299_1_);
        this.setSize(1.3964844f, 1.6f);
        this.stepHeight = 1.0f;
        this.initHorseChest();
    }

    @Override
    protected void initEntityAI() {
        this.tasks.addTask(0, new EntityAISwimming(this));
        this.tasks.addTask(1, new EntityAIPanic(this, 1.2));
        this.tasks.addTask(1, new EntityAIRunAroundLikeCrazy(this, 1.2));
        this.tasks.addTask(2, new EntityAIMate(this, 1.0, AbstractHorse.class));
        this.tasks.addTask(4, new EntityAIFollowParent(this, 1.0));
        this.tasks.addTask(6, new EntityAIWanderAvoidWater(this, 0.7));
        this.tasks.addTask(7, new EntityAIWatchClosest(this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(8, new EntityAILookIdle(this));
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(STATUS, (byte)0);
        this.dataManager.register(OWNER_UNIQUE_ID, Optional.absent());
    }

    protected boolean getHorseWatchableBoolean(int p_getHorseWatchableBoolean_1_) {
        return (this.dataManager.get(STATUS) & p_getHorseWatchableBoolean_1_) != 0;
    }

    protected void setHorseWatchableBoolean(int p_setHorseWatchableBoolean_1_, boolean p_setHorseWatchableBoolean_2_) {
        byte b0 = this.dataManager.get(STATUS);
        if (p_setHorseWatchableBoolean_2_) {
            this.dataManager.set(STATUS, (byte)(b0 | p_setHorseWatchableBoolean_1_));
        } else {
            this.dataManager.set(STATUS, (byte)(b0 & ~p_setHorseWatchableBoolean_1_));
        }
    }

    public boolean isTame() {
        return this.getHorseWatchableBoolean(2);
    }

    @Nullable
    public UUID getOwnerUniqueId() {
        return (UUID)this.dataManager.get(OWNER_UNIQUE_ID).orNull();
    }

    public void setOwnerUniqueId(UUID p_setOwnerUniqueId_1_) {
        this.dataManager.set(OWNER_UNIQUE_ID, Optional.fromNullable((Object)p_setOwnerUniqueId_1_));
    }

    public float getHorseSize() {
        return 0.5f;
    }

    @Override
    public void setScaleForAge(boolean p_setScaleForAge_1_) {
        this.setScale(p_setScaleForAge_1_ ? this.getHorseSize() : 1.0f);
    }

    public boolean isHorseJumping() {
        return this.horseJumping;
    }

    public void setHorseTamed(boolean p_setHorseTamed_1_) {
        this.setHorseWatchableBoolean(2, p_setHorseTamed_1_);
    }

    public void setHorseJumping(boolean p_setHorseJumping_1_) {
        this.horseJumping = p_setHorseJumping_1_;
    }

    @Override
    public boolean canBeLeashedTo(EntityPlayer p_canBeLeashedTo_1_) {
        return super.canBeLeashedTo(p_canBeLeashedTo_1_) && this.getCreatureAttribute() != EnumCreatureAttribute.UNDEAD;
    }

    @Override
    protected void onLeashDistance(float p_onLeashDistance_1_) {
        if (p_onLeashDistance_1_ > 6.0f && this.isEatingHaystack()) {
            this.setEatingHaystack(false);
        }
    }

    public boolean isEatingHaystack() {
        return this.getHorseWatchableBoolean(16);
    }

    public boolean isRearing() {
        return this.getHorseWatchableBoolean(32);
    }

    public boolean isBreeding() {
        return this.getHorseWatchableBoolean(8);
    }

    public void setBreeding(boolean p_setBreeding_1_) {
        this.setHorseWatchableBoolean(8, p_setBreeding_1_);
    }

    public void setHorseSaddled(boolean p_setHorseSaddled_1_) {
        this.setHorseWatchableBoolean(4, p_setHorseSaddled_1_);
    }

    public int getTemper() {
        return this.temper;
    }

    public void setTemper(int p_setTemper_1_) {
        this.temper = p_setTemper_1_;
    }

    public int increaseTemper(int p_increaseTemper_1_) {
        int i = MathHelper.clamp(this.getTemper() + p_increaseTemper_1_, 0, this.getMaxTemper());
        this.setTemper(i);
        return i;
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        Entity entity = p_attackEntityFrom_1_.getEntity();
        return this.isBeingRidden() && entity != null && this.isRidingOrBeingRiddenBy(entity) ? false : super.attackEntityFrom(p_attackEntityFrom_1_, p_attackEntityFrom_2_);
    }

    @Override
    public boolean canBePushed() {
        return !this.isBeingRidden();
    }

    private void eatingHorse() {
        this.openHorseMouth();
        if (!this.isSilent()) {
            this.world.playSound(null, this.posX, this.posY, this.posZ, SoundEvents.ENTITY_HORSE_EAT, this.getSoundCategory(), 1.0f, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f);
        }
    }

    @Override
    public void fall(float p_fall_1_, float p_fall_2_) {
        int i;
        if (p_fall_1_ > 1.0f) {
            this.playSound(SoundEvents.ENTITY_HORSE_LAND, 0.4f, 1.0f);
        }
        if ((i = MathHelper.ceil((p_fall_1_ * 0.5f - 3.0f) * p_fall_2_)) > 0) {
            this.attackEntityFrom(DamageSource.FALL, i);
            if (this.isBeingRidden()) {
                for (Entity entity : this.getRecursivePassengers()) {
                    entity.attackEntityFrom(DamageSource.FALL, i);
                }
            }
            IBlockState iblockstate = this.world.getBlockState(new BlockPos(this.posX, this.posY - 0.2 - (double)this.prevRotationYaw, this.posZ));
            Block block = iblockstate.getBlock();
            if (iblockstate.getMaterial() != Material.AIR && !this.isSilent()) {
                SoundType soundtype = block.getSoundType();
                this.world.playSound(null, this.posX, this.posY, this.posZ, soundtype.getStepSound(), this.getSoundCategory(), soundtype.getVolume() * 0.5f, soundtype.getPitch() * 0.75f);
            }
        }
    }

    protected int getInventorySize() {
        return 2;
    }

    protected void initHorseChest() {
        ContainerHorseChest containerhorsechest = this.horseChest;
        this.horseChest = new ContainerHorseChest("HorseChest", this.getInventorySize());
        this.horseChest.setCustomName(this.getName());
        if (containerhorsechest != null) {
            containerhorsechest.removeInventoryChangeListener(this);
            int i = Math.min(containerhorsechest.getSizeInventory(), this.horseChest.getSizeInventory());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = containerhorsechest.getStackInSlot(j);
                if (itemstack.isEmpty()) continue;
                this.horseChest.setInventorySlotContents(j, itemstack.copy());
            }
        }
        this.horseChest.addInventoryChangeListener(this);
        this.updateHorseSlots();
        this.itemHandler = new InvWrapper(this.horseChest);
    }

    protected void updateHorseSlots() {
        if (!this.world.isRemote) {
            this.setHorseSaddled(!this.horseChest.getStackInSlot(0).isEmpty() && this.canBeSaddled());
        }
    }

    @Override
    public void onInventoryChanged(IInventory p_onInventoryChanged_1_) {
        boolean flag = this.isHorseSaddled();
        this.updateHorseSlots();
        if (this.ticksExisted > 20 && !flag && this.isHorseSaddled()) {
            this.playSound(SoundEvents.ENTITY_HORSE_SADDLE, 0.5f, 1.0f);
        }
    }

    @Nullable
    protected AbstractHorse getClosestHorse(Entity p_getClosestHorse_1_, double p_getClosestHorse_2_) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        for (Entity entity1 : this.world.getEntitiesInAABBexcluding(p_getClosestHorse_1_, p_getClosestHorse_1_.getEntityBoundingBox().addCoord(p_getClosestHorse_2_, p_getClosestHorse_2_, p_getClosestHorse_2_), IS_HORSE_BREEDING)) {
            double d1 = entity1.getDistanceSq(p_getClosestHorse_1_.posX, p_getClosestHorse_1_.posY, p_getClosestHorse_1_.posZ);
            if (!(d1 < d0)) continue;
            entity = entity1;
            d0 = d1;
        }
        return (AbstractHorse)entity;
    }

    public double getHorseJumpStrength() {
        return this.getEntityAttribute(JUMP_STRENGTH).getAttributeValue();
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        this.openHorseMouth();
        return null;
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound() {
        this.openHorseMouth();
        if (this.rand.nextInt(3) == 0) {
            this.makeHorseRear();
        }
        return null;
    }

    @Override
    @Nullable
    protected SoundEvent getAmbientSound() {
        this.openHorseMouth();
        if (this.rand.nextInt(10) == 0 && !this.isMovementBlocked()) {
            this.makeHorseRear();
        }
        return null;
    }

    public boolean canBeSaddled() {
        return true;
    }

    public boolean isHorseSaddled() {
        return this.getHorseWatchableBoolean(4);
    }

    @Nullable
    protected SoundEvent getAngrySound() {
        this.openHorseMouth();
        this.makeHorseRear();
        return null;
    }

    @Override
    protected void playStepSound(BlockPos p_playStepSound_1_, Block p_playStepSound_2_) {
        if (!p_playStepSound_2_.getDefaultState().getMaterial().isLiquid()) {
            SoundType soundtype = p_playStepSound_2_.getSoundType();
            if (this.world.getBlockState(p_playStepSound_1_.up()).getBlock() == Blocks.SNOW_LAYER) {
                soundtype = Blocks.SNOW_LAYER.getSoundType();
            }
            if (this.isBeingRidden() && this.canGallop) {
                ++this.gallopTime;
                if (this.gallopTime > 5 && this.gallopTime % 3 == 0) {
                    this.playGallopSound(soundtype);
                } else if (this.gallopTime <= 5) {
                    this.playSound(SoundEvents.ENTITY_HORSE_STEP_WOOD, soundtype.getVolume() * 0.15f, soundtype.getPitch());
                }
            } else if (soundtype == SoundType.WOOD) {
                this.playSound(SoundEvents.ENTITY_HORSE_STEP_WOOD, soundtype.getVolume() * 0.15f, soundtype.getPitch());
            } else {
                this.playSound(SoundEvents.ENTITY_HORSE_STEP, soundtype.getVolume() * 0.15f, soundtype.getPitch());
            }
        }
    }

    protected void playGallopSound(SoundType p_playGallopSound_1_) {
        this.playSound(SoundEvents.ENTITY_HORSE_GALLOP, p_playGallopSound_1_.getVolume() * 0.15f, p_playGallopSound_1_.getPitch());
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getAttributeMap().registerAttribute(JUMP_STRENGTH);
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(53.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.225f);
    }

    @Override
    public int getMaxSpawnedInChunk() {
        return 6;
    }

    public int getMaxTemper() {
        return 100;
    }

    @Override
    protected float getSoundVolume() {
        return 0.8f;
    }

    @Override
    public int getTalkInterval() {
        return 400;
    }

    public void openGUI(EntityPlayer p_openGUI_1_) {
        if (!this.world.isRemote && (!this.isBeingRidden() || this.isPassenger(p_openGUI_1_)) && this.isTame()) {
            this.horseChest.setCustomName(this.getName());
            p_openGUI_1_.openGuiHorseInventory(this, this.horseChest);
        }
    }

    protected boolean handleEating(EntityPlayer p_handleEating_1_, ItemStack p_handleEating_2_) {
        boolean flag = false;
        float f = 0.0f;
        int i = 0;
        int j = 0;
        Item item = p_handleEating_2_.getItem();
        if (item == Items.WHEAT) {
            f = 2.0f;
            i = 20;
            j = 3;
        } else if (item == Items.SUGAR) {
            f = 1.0f;
            i = 30;
            j = 3;
        } else if (item == Item.getItemFromBlock(Blocks.HAY_BLOCK)) {
            f = 20.0f;
            i = 180;
        } else if (item == Items.APPLE) {
            f = 3.0f;
            i = 60;
            j = 3;
        } else if (item == Items.GOLDEN_CARROT) {
            f = 4.0f;
            i = 60;
            j = 5;
            if (this.isTame() && this.getGrowingAge() == 0 && !this.isInLove()) {
                flag = true;
                this.setInLove(p_handleEating_1_);
            }
        } else if (item == Items.GOLDEN_APPLE) {
            f = 10.0f;
            i = 240;
            j = 10;
            if (this.isTame() && this.getGrowingAge() == 0 && !this.isInLove()) {
                flag = true;
                this.setInLove(p_handleEating_1_);
            }
        }
        if (this.getHealth() < this.getMaxHealth() && f > 0.0f) {
            this.heal(f);
            flag = true;
        }
        if (this.isChild() && i > 0) {
            this.world.spawnParticle(EnumParticleTypes.VILLAGER_HAPPY, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + 0.5 + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, 0.0, 0.0, 0.0, new int[0]);
            if (!this.world.isRemote) {
                this.addGrowth(i);
            }
            flag = true;
        }
        if (j > 0 && (flag || !this.isTame()) && this.getTemper() < this.getMaxTemper()) {
            flag = true;
            if (!this.world.isRemote) {
                this.increaseTemper(j);
            }
        }
        if (flag) {
            this.eatingHorse();
        }
        return flag;
    }

    protected void mountTo(EntityPlayer p_mountTo_1_) {
        p_mountTo_1_.rotationYaw = this.rotationYaw;
        p_mountTo_1_.rotationPitch = this.rotationPitch;
        this.setEatingHaystack(false);
        this.setRearing(false);
        if (!this.world.isRemote) {
            p_mountTo_1_.startRiding(this);
        }
    }

    @Override
    protected boolean isMovementBlocked() {
        return super.isMovementBlocked() && this.isBeingRidden() && this.isHorseSaddled() || this.isEatingHaystack() || this.isRearing();
    }

    @Override
    public boolean isBreedingItem(ItemStack p_isBreedingItem_1_) {
        return false;
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    @Override
    public void onDeath(DamageSource p_onDeath_1_) {
        super.onDeath(p_onDeath_1_);
        if (!this.world.isRemote && this.horseChest != null) {
            for (int i = 0; i < this.horseChest.getSizeInventory(); ++i) {
                ItemStack itemstack = this.horseChest.getStackInSlot(i);
                if (itemstack.isEmpty()) continue;
                this.entityDropItem(itemstack, 0.0f);
            }
        }
    }

    @Override
    public void onLivingUpdate() {
        if (this.rand.nextInt(200) == 0) {
            this.moveTail();
        }
        super.onLivingUpdate();
        if (!this.world.isRemote) {
            if (this.rand.nextInt(900) == 0 && this.deathTime == 0) {
                this.heal(1.0f);
            }
            if (this.canEatGrass()) {
                if (!this.isEatingHaystack() && !this.isBeingRidden() && this.rand.nextInt(300) == 0 && this.world.getBlockState(new BlockPos(MathHelper.floor(this.posX), MathHelper.floor(this.posY) - 1, MathHelper.floor(this.posZ))).getBlock() == Blocks.GRASS) {
                    this.setEatingHaystack(true);
                }
                if (this.isEatingHaystack() && ++this.eatingCounter > 50) {
                    this.eatingCounter = 0;
                    this.setEatingHaystack(false);
                }
            }
            this.followMother();
        }
    }

    protected void followMother() {
        AbstractHorse abstracthorse;
        if (this.isBreeding() && this.isChild() && !this.isEatingHaystack() && (abstracthorse = this.getClosestHorse(this, 16.0)) != null && this.getDistanceSqToEntity(abstracthorse) > 4.0) {
            this.navigator.getPathToEntityLiving(abstracthorse);
        }
    }

    public boolean canEatGrass() {
        return true;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.openMouthCounter > 0 && ++this.openMouthCounter > 30) {
            this.openMouthCounter = 0;
            this.setHorseWatchableBoolean(64, false);
        }
        if (this.canPassengerSteer() && this.jumpRearingCounter > 0 && ++this.jumpRearingCounter > 20) {
            this.jumpRearingCounter = 0;
            this.setRearing(false);
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        if (this.sprintCounter > 0) {
            ++this.sprintCounter;
            if (this.sprintCounter > 300) {
                this.sprintCounter = 0;
            }
        }
        this.prevHeadLean = this.headLean;
        if (this.isEatingHaystack()) {
            this.headLean += (1.0f - this.headLean) * 0.4f + 0.05f;
            if (this.headLean > 1.0f) {
                this.headLean = 1.0f;
            }
        } else {
            this.headLean += (0.0f - this.headLean) * 0.4f - 0.05f;
            if (this.headLean < 0.0f) {
                this.headLean = 0.0f;
            }
        }
        this.prevRearingAmount = this.rearingAmount;
        if (this.isRearing()) {
            this.prevHeadLean = this.headLean = 0.0f;
            this.rearingAmount += (1.0f - this.rearingAmount) * 0.4f + 0.05f;
            if (this.rearingAmount > 1.0f) {
                this.rearingAmount = 1.0f;
            }
        } else {
            this.allowStandSliding = false;
            this.rearingAmount += (0.8f * this.rearingAmount * this.rearingAmount * this.rearingAmount - this.rearingAmount) * 0.6f - 0.05f;
            if (this.rearingAmount < 0.0f) {
                this.rearingAmount = 0.0f;
            }
        }
        this.prevMouthOpenness = this.mouthOpenness;
        if (this.getHorseWatchableBoolean(64)) {
            this.mouthOpenness += (1.0f - this.mouthOpenness) * 0.7f + 0.05f;
            if (this.mouthOpenness > 1.0f) {
                this.mouthOpenness = 1.0f;
            }
        } else {
            this.mouthOpenness += (0.0f - this.mouthOpenness) * 0.7f - 0.05f;
            if (this.mouthOpenness < 0.0f) {
                this.mouthOpenness = 0.0f;
            }
        }
    }

    private void openHorseMouth() {
        if (!this.world.isRemote) {
            this.openMouthCounter = 1;
            this.setHorseWatchableBoolean(64, true);
        }
    }

    public void setEatingHaystack(boolean p_setEatingHaystack_1_) {
        this.setHorseWatchableBoolean(16, p_setEatingHaystack_1_);
    }

    public void setRearing(boolean p_setRearing_1_) {
        if (p_setRearing_1_) {
            this.setEatingHaystack(false);
        }
        this.setHorseWatchableBoolean(32, p_setRearing_1_);
    }

    private void makeHorseRear() {
        if (this.canPassengerSteer()) {
            this.jumpRearingCounter = 1;
            this.setRearing(true);
        }
    }

    public void makeMad() {
        this.makeHorseRear();
        SoundEvent soundevent = this.getAngrySound();
        if (soundevent != null) {
            this.playSound(soundevent, this.getSoundVolume(), this.getSoundPitch());
        }
    }

    public boolean setTamedBy(EntityPlayer p_setTamedBy_1_) {
        this.setOwnerUniqueId(p_setTamedBy_1_.getUniqueID());
        this.setHorseTamed(true);
        this.world.setEntityState(this, (byte)7);
        return true;
    }

    @Override
    public void moveEntityWithHeading(float p_moveEntityWithHeading_1_, float p_moveEntityWithHeading_2_) {
        if (this.isBeingRidden() && this.canBeSteered() && this.isHorseSaddled()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.getControllingPassenger();
            this.prevRotationYaw = this.rotationYaw = entitylivingbase.rotationYaw;
            this.rotationPitch = entitylivingbase.rotationPitch * 0.5f;
            this.setRotation(this.rotationYaw, this.rotationPitch);
            this.rotationYawHead = this.renderYawOffset = this.rotationYaw;
            p_moveEntityWithHeading_1_ = entitylivingbase.moveStrafing * 0.5f;
            p_moveEntityWithHeading_2_ = entitylivingbase.moveForward;
            if (p_moveEntityWithHeading_2_ <= 0.0f) {
                p_moveEntityWithHeading_2_ *= 0.25f;
                this.gallopTime = 0;
            }
            if (this.onGround && this.jumpPower == 0.0f && this.isRearing() && !this.allowStandSliding) {
                p_moveEntityWithHeading_1_ = 0.0f;
                p_moveEntityWithHeading_2_ = 0.0f;
            }
            if (this.jumpPower > 0.0f && !this.isHorseJumping() && this.onGround) {
                this.motionY = this.getHorseJumpStrength() * (double)this.jumpPower;
                if (this.isPotionActive(MobEffects.JUMP_BOOST)) {
                    this.motionY += (double)((float)(this.getActivePotionEffect(MobEffects.JUMP_BOOST).getAmplifier() + 1) * 0.1f);
                }
                this.setHorseJumping(true);
                this.isAirBorne = true;
                if (p_moveEntityWithHeading_2_ > 0.0f) {
                    float f = MathHelper.sin(this.rotationYaw * ((float)Math.PI / 180));
                    float f1 = MathHelper.cos(this.rotationYaw * ((float)Math.PI / 180));
                    this.motionX += (double)(-0.4f * f * this.jumpPower);
                    this.motionZ += (double)(0.4f * f1 * this.jumpPower);
                    this.playSound(SoundEvents.ENTITY_HORSE_JUMP, 0.4f, 1.0f);
                }
                this.jumpPower = 0.0f;
            }
            this.jumpMovementFactor = this.getAIMoveSpeed() * 0.1f;
            if (this.canPassengerSteer()) {
                this.setAIMoveSpeed((float)this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).getAttributeValue());
                super.moveEntityWithHeading(p_moveEntityWithHeading_1_, p_moveEntityWithHeading_2_);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.motionX = 0.0;
                this.motionY = 0.0;
                this.motionZ = 0.0;
            }
            if (this.onGround) {
                this.jumpPower = 0.0f;
                this.setHorseJumping(false);
            }
            this.prevLimbSwingAmount = this.limbSwingAmount;
            double d1 = this.posX - this.prevPosX;
            double d0 = this.posZ - this.prevPosZ;
            float f2 = MathHelper.sqrt(d1 * d1 + d0 * d0) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.limbSwingAmount += (f2 - this.limbSwingAmount) * 0.4f;
            this.limbSwing += this.limbSwingAmount;
        } else {
            this.jumpMovementFactor = 0.02f;
            super.moveEntityWithHeading(p_moveEntityWithHeading_1_, p_moveEntityWithHeading_2_);
        }
    }

    public static void registerFixesAbstractHorse(DataFixer p_registerFixesAbstractHorse_0_, Class<?> p_registerFixesAbstractHorse_1_) {
        EntityLiving.registerFixesMob(p_registerFixesAbstractHorse_0_, p_registerFixesAbstractHorse_1_);
        p_registerFixesAbstractHorse_0_.registerWalker(FixTypes.ENTITY, new ItemStackData(p_registerFixesAbstractHorse_1_, "SaddleItem"));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setBoolean("EatingHaystack", this.isEatingHaystack());
        p_writeEntityToNBT_1_.setBoolean("Bred", this.isBreeding());
        p_writeEntityToNBT_1_.setInteger("Temper", this.getTemper());
        p_writeEntityToNBT_1_.setBoolean("Tame", this.isTame());
        if (this.getOwnerUniqueId() != null) {
            p_writeEntityToNBT_1_.setString("OwnerUUID", this.getOwnerUniqueId().toString());
        }
        if (!this.horseChest.getStackInSlot(0).isEmpty()) {
            p_writeEntityToNBT_1_.setTag("SaddleItem", this.horseChest.getStackInSlot(0).writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        ItemStack itemstack;
        IAttributeInstance iattributeinstance;
        String s;
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.setEatingHaystack(p_readEntityFromNBT_1_.getBoolean("EatingHaystack"));
        this.setBreeding(p_readEntityFromNBT_1_.getBoolean("Bred"));
        this.setTemper(p_readEntityFromNBT_1_.getInteger("Temper"));
        this.setHorseTamed(p_readEntityFromNBT_1_.getBoolean("Tame"));
        if (p_readEntityFromNBT_1_.hasKey("OwnerUUID", 8)) {
            s = p_readEntityFromNBT_1_.getString("OwnerUUID");
        } else {
            String s1 = p_readEntityFromNBT_1_.getString("Owner");
            s = PreYggdrasilConverter.convertMobOwnerIfNeeded(this.getServer(), s1);
        }
        if (!s.isEmpty()) {
            this.setOwnerUniqueId(UUID.fromString(s));
        }
        if ((iattributeinstance = this.getAttributeMap().getAttributeInstanceByName("Speed")) != null) {
            this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(iattributeinstance.getBaseValue() * 0.25);
        }
        if (p_readEntityFromNBT_1_.hasKey("SaddleItem", 10) && (itemstack = new ItemStack(p_readEntityFromNBT_1_.getCompoundTag("SaddleItem"))).getItem() == Items.SADDLE) {
            this.horseChest.setInventorySlotContents(0, itemstack);
        }
        this.updateHorseSlots();
    }

    @Override
    public boolean canMateWith(EntityAnimal p_canMateWith_1_) {
        return false;
    }

    protected boolean canMate() {
        return !this.isBeingRidden() && !this.isRiding() && this.isTame() && !this.isChild() && this.getHealth() >= this.getMaxHealth() && this.isInLove();
    }

    @Override
    @Nullable
    public EntityAgeable createChild(EntityAgeable p_createChild_1_) {
        return null;
    }

    protected void setOffspringAttributes(EntityAgeable p_setOffspringAttributes_1_, AbstractHorse p_setOffspringAttributes_2_) {
        double d0 = this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).getBaseValue() + p_setOffspringAttributes_1_.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).getBaseValue() + (double)this.getModifiedMaxHealth();
        p_setOffspringAttributes_2_.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(d0 / 3.0);
        double d1 = this.getEntityAttribute(JUMP_STRENGTH).getBaseValue() + p_setOffspringAttributes_1_.getEntityAttribute(JUMP_STRENGTH).getBaseValue() + this.getModifiedJumpStrength();
        p_setOffspringAttributes_2_.getEntityAttribute(JUMP_STRENGTH).setBaseValue(d1 / 3.0);
        double d2 = this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).getBaseValue() + p_setOffspringAttributes_1_.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).getBaseValue() + this.getModifiedMovementSpeed();
        p_setOffspringAttributes_2_.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(d2 / 3.0);
    }

    @Override
    public boolean canBeSteered() {
        return this.getControllingPassenger() instanceof EntityLivingBase;
    }

    @SideOnly(value=Side.CLIENT)
    public float getGrassEatingAmount(float p_getGrassEatingAmount_1_) {
        return this.prevHeadLean + (this.headLean - this.prevHeadLean) * p_getGrassEatingAmount_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public float getRearingAmount(float p_getRearingAmount_1_) {
        return this.prevRearingAmount + (this.rearingAmount - this.prevRearingAmount) * p_getRearingAmount_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public float getMouthOpennessAngle(float p_getMouthOpennessAngle_1_) {
        return this.prevMouthOpenness + (this.mouthOpenness - this.prevMouthOpenness) * p_getMouthOpennessAngle_1_;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setJumpPower(int p_setJumpPower_1_) {
        if (this.isHorseSaddled()) {
            if (p_setJumpPower_1_ < 0) {
                p_setJumpPower_1_ = 0;
            } else {
                this.allowStandSliding = true;
                this.makeHorseRear();
            }
            this.jumpPower = p_setJumpPower_1_ >= 90 ? 1.0f : 0.4f + 0.4f * (float)p_setJumpPower_1_ / 90.0f;
        }
    }

    @Override
    public boolean canJump() {
        return this.isHorseSaddled();
    }

    @Override
    public void handleStartJump(int p_handleStartJump_1_) {
        this.allowStandSliding = true;
        this.makeHorseRear();
    }

    @Override
    public void handleStopJump() {
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnHorseParticles(boolean p_spawnHorseParticles_1_) {
        EnumParticleTypes enumparticletypes = p_spawnHorseParticles_1_ ? EnumParticleTypes.HEART : EnumParticleTypes.SMOKE_NORMAL;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.rand.nextGaussian() * 0.02;
            double d1 = this.rand.nextGaussian() * 0.02;
            double d2 = this.rand.nextGaussian() * 0.02;
            this.world.spawnParticle(enumparticletypes, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + 0.5 + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d0, d1, d2, new int[0]);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte p_handleStatusUpdate_1_) {
        if (p_handleStatusUpdate_1_ == 7) {
            this.spawnHorseParticles(true);
        } else if (p_handleStatusUpdate_1_ == 6) {
            this.spawnHorseParticles(false);
        } else {
            super.handleStatusUpdate(p_handleStatusUpdate_1_);
        }
    }

    @Override
    public void updatePassenger(Entity p_updatePassenger_1_) {
        super.updatePassenger(p_updatePassenger_1_);
        if (p_updatePassenger_1_ instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)p_updatePassenger_1_;
            this.renderYawOffset = entityliving.renderYawOffset;
        }
        if (this.prevRearingAmount > 0.0f) {
            float f3 = MathHelper.sin(this.renderYawOffset * ((float)Math.PI / 180));
            float f = MathHelper.cos(this.renderYawOffset * ((float)Math.PI / 180));
            float f1 = 0.7f * this.prevRearingAmount;
            float f2 = 0.15f * this.prevRearingAmount;
            p_updatePassenger_1_.setPosition(this.posX + (double)(f1 * f3), this.posY + this.getMountedYOffset() + p_updatePassenger_1_.getYOffset() + (double)f2, this.posZ - (double)(f1 * f));
            if (p_updatePassenger_1_ instanceof EntityLivingBase) {
                ((EntityLivingBase)p_updatePassenger_1_).renderYawOffset = this.renderYawOffset;
            }
        }
    }

    protected float getModifiedMaxHealth() {
        return 15.0f + (float)this.rand.nextInt(8) + (float)this.rand.nextInt(9);
    }

    protected double getModifiedJumpStrength() {
        return (double)0.4f + this.rand.nextDouble() * 0.2 + this.rand.nextDouble() * 0.2 + this.rand.nextDouble() * 0.2;
    }

    protected double getModifiedMovementSpeed() {
        return ((double)0.45f + this.rand.nextDouble() * 0.3 + this.rand.nextDouble() * 0.3 + this.rand.nextDouble() * 0.3) * 0.25;
    }

    @Override
    public boolean isOnLadder() {
        return false;
    }

    @Override
    public float getEyeHeight() {
        return this.height;
    }

    public boolean wearsArmor() {
        return false;
    }

    public boolean isArmor(ItemStack p_isArmor_1_) {
        return false;
    }

    @Override
    public boolean replaceItemInInventory(int p_replaceItemInInventory_1_, ItemStack p_replaceItemInInventory_2_) {
        int i = p_replaceItemInInventory_1_ - 400;
        if (i >= 0 && i < 2 && i < this.horseChest.getSizeInventory()) {
            if (i == 0 && p_replaceItemInInventory_2_.getItem() != Items.SADDLE) {
                return false;
            }
            if (i != 1 || this.wearsArmor() && this.isArmor(p_replaceItemInInventory_2_)) {
                this.horseChest.setInventorySlotContents(i, p_replaceItemInInventory_2_);
                this.updateHorseSlots();
                return true;
            }
            return false;
        }
        int j = p_replaceItemInInventory_1_ - 500 + 2;
        if (j >= 2 && j < this.horseChest.getSizeInventory()) {
            this.horseChest.setInventorySlotContents(j, p_replaceItemInInventory_2_);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Entity getControllingPassenger() {
        return this.getPassengers().isEmpty() ? null : this.getPassengers().get(0);
    }

    @Override
    @Nullable
    public IEntityLivingData onInitialSpawn(DifficultyInstance p_onInitialSpawn_1_, IEntityLivingData p_onInitialSpawn_2_) {
        p_onInitialSpawn_2_ = super.onInitialSpawn(p_onInitialSpawn_1_, p_onInitialSpawn_2_);
        if (this.rand.nextInt(5) == 0) {
            this.setGrowingAge(-24000);
        }
        return p_onInitialSpawn_2_;
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> p_getCapability_1_, EnumFacing p_getCapability_2_) {
        if (p_getCapability_1_ == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return super.getCapability(p_getCapability_1_, p_getCapability_2_);
    }

    @Override
    public boolean hasCapability(Capability<?> p_hasCapability_1_, EnumFacing p_hasCapability_2_) {
        return p_hasCapability_1_ == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(p_hasCapability_1_, p_hasCapability_2_);
    }
}

