/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityAnimal
extends EntityAgeable
implements IAnimals {
    protected Block spawnableBlock = Blocks.GRASS;
    private int inLove;
    private EntityPlayer playerInLove;

    public EntityAnimal(World p_i1681_1_) {
        super(p_i1681_1_);
    }

    @Override
    protected void updateAITasks() {
        if (this.getGrowingAge() != 0) {
            this.inLove = 0;
        }
        super.updateAITasks();
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.getGrowingAge() != 0) {
            this.inLove = 0;
        }
        if (this.inLove > 0) {
            --this.inLove;
            if (this.inLove % 10 == 0) {
                double lvt_1_1_ = this.rand.nextGaussian() * 0.02;
                double lvt_3_1_ = this.rand.nextGaussian() * 0.02;
                double lvt_5_1_ = this.rand.nextGaussian() * 0.02;
                this.world.spawnParticle(EnumParticleTypes.HEART, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + 0.5 + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, lvt_1_1_, lvt_3_1_, lvt_5_1_, new int[0]);
            }
        }
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        if (this.isEntityInvulnerable(p_attackEntityFrom_1_)) {
            return false;
        }
        this.inLove = 0;
        return super.attackEntityFrom(p_attackEntityFrom_1_, p_attackEntityFrom_2_);
    }

    @Override
    public float getBlockPathWeight(BlockPos p_getBlockPathWeight_1_) {
        if (this.world.getBlockState(p_getBlockPathWeight_1_.down()).getBlock() == this.spawnableBlock) {
            return 10.0f;
        }
        return this.world.getLightBrightness(p_getBlockPathWeight_1_) - 0.5f;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setInteger("InLove", this.inLove);
    }

    @Override
    public double getYOffset() {
        return 0.14;
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.inLove = p_readEntityFromNBT_1_.getInteger("InLove");
    }

    @Override
    public boolean getCanSpawnHere() {
        int lvt_3_1_;
        int lvt_2_1_;
        int lvt_1_1_ = MathHelper.floor(this.posX);
        BlockPos lvt_4_1_ = new BlockPos(lvt_1_1_, lvt_2_1_ = MathHelper.floor(this.getEntityBoundingBox().minY), lvt_3_1_ = MathHelper.floor(this.posZ));
        return this.world.getBlockState(lvt_4_1_.down()).getBlock() == this.spawnableBlock && this.world.getLight(lvt_4_1_) > 8 && super.getCanSpawnHere();
    }

    @Override
    public int getTalkInterval() {
        return 120;
    }

    @Override
    protected boolean canDespawn() {
        return false;
    }

    @Override
    protected int getExperiencePoints(EntityPlayer p_getExperiencePoints_1_) {
        return 1 + this.world.rand.nextInt(3);
    }

    public boolean isBreedingItem(ItemStack p_isBreedingItem_1_) {
        return p_isBreedingItem_1_.getItem() == Items.WHEAT;
    }

    @Override
    public boolean processInteract(EntityPlayer p_processInteract_1_, EnumHand p_processInteract_2_) {
        ItemStack lvt_3_1_ = p_processInteract_1_.getHeldItem(p_processInteract_2_);
        if (!lvt_3_1_.isEmpty()) {
            if (this.isBreedingItem(lvt_3_1_) && this.getGrowingAge() == 0 && this.inLove <= 0) {
                this.consumeItemFromStack(p_processInteract_1_, lvt_3_1_);
                this.setInLove(p_processInteract_1_);
                return true;
            }
            if (this.isChild() && this.isBreedingItem(lvt_3_1_)) {
                this.consumeItemFromStack(p_processInteract_1_, lvt_3_1_);
                this.ageUp((int)((float)(-this.getGrowingAge() / 20) * 0.1f), true);
                return true;
            }
        }
        return super.processInteract(p_processInteract_1_, p_processInteract_2_);
    }

    protected void consumeItemFromStack(EntityPlayer p_consumeItemFromStack_1_, ItemStack p_consumeItemFromStack_2_) {
        if (!p_consumeItemFromStack_1_.capabilities.isCreativeMode) {
            p_consumeItemFromStack_2_.shrink(1);
        }
    }

    public void setInLove(EntityPlayer p_setInLove_1_) {
        this.inLove = 600;
        this.playerInLove = p_setInLove_1_;
        this.world.setEntityState(this, (byte)18);
    }

    public EntityPlayer getPlayerInLove() {
        return this.playerInLove;
    }

    public boolean isInLove() {
        return this.inLove > 0;
    }

    public void resetInLove() {
        this.inLove = 0;
    }

    public boolean canMateWith(EntityAnimal p_canMateWith_1_) {
        if (p_canMateWith_1_ == this) {
            return false;
        }
        if (p_canMateWith_1_.getClass() != this.getClass()) {
            return false;
        }
        return this.isInLove() && p_canMateWith_1_.isInLove();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte p_handleStatusUpdate_1_) {
        if (p_handleStatusUpdate_1_ == 18) {
            for (int lvt_2_1_ = 0; lvt_2_1_ < 7; ++lvt_2_1_) {
                double lvt_3_1_ = this.rand.nextGaussian() * 0.02;
                double lvt_5_1_ = this.rand.nextGaussian() * 0.02;
                double lvt_7_1_ = this.rand.nextGaussian() * 0.02;
                this.world.spawnParticle(EnumParticleTypes.HEART, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + 0.5 + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, lvt_3_1_, lvt_5_1_, lvt_7_1_, new int[0]);
            }
        } else {
            super.handleStatusUpdate(p_handleStatusUpdate_1_);
        }
    }
}

