/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.Calendar;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityBat
extends EntityAmbientCreature {
    private static final DataParameter<Byte> HANGING = EntityDataManager.createKey(EntityBat.class, DataSerializers.BYTE);
    private BlockPos spawnPosition;

    public EntityBat(World p_i1680_1_) {
        super(p_i1680_1_);
        this.setSize(0.5f, 0.9f);
        this.setIsBatHanging(true);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(HANGING, (byte)0);
    }

    @Override
    protected float getSoundVolume() {
        return 0.1f;
    }

    @Override
    protected float getSoundPitch() {
        return super.getSoundPitch() * 0.95f;
    }

    @Override
    @Nullable
    protected SoundEvent getAmbientSound() {
        if (this.getIsBatHanging() && this.rand.nextInt(4) != 0) {
            return null;
        }
        return SoundEvents.ENTITY_BAT_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_BAT_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_BAT_DEATH;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }

    @Override
    protected void collideWithEntity(Entity p_collideWithEntity_1_) {
    }

    @Override
    protected void collideWithNearbyEntities() {
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(6.0);
    }

    public boolean getIsBatHanging() {
        return (this.dataManager.get(HANGING) & 1) != 0;
    }

    public void setIsBatHanging(boolean p_setIsBatHanging_1_) {
        byte lvt_2_1_ = this.dataManager.get(HANGING);
        if (p_setIsBatHanging_1_) {
            this.dataManager.set(HANGING, (byte)(lvt_2_1_ | 1));
        } else {
            this.dataManager.set(HANGING, (byte)(lvt_2_1_ & 0xFFFFFFFE));
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.getIsBatHanging()) {
            this.motionX = 0.0;
            this.motionY = 0.0;
            this.motionZ = 0.0;
            this.posY = (double)MathHelper.floor(this.posY) + 1.0 - (double)this.height;
        } else {
            this.motionY *= (double)0.6f;
        }
    }

    @Override
    protected void updateAITasks() {
        super.updateAITasks();
        BlockPos lvt_1_1_ = new BlockPos(this);
        BlockPos lvt_2_1_ = lvt_1_1_.up();
        if (this.getIsBatHanging()) {
            if (this.world.getBlockState(lvt_2_1_).isNormalCube()) {
                if (this.rand.nextInt(200) == 0) {
                    this.rotationYawHead = this.rand.nextInt(360);
                }
                if (this.world.getNearestPlayerNotCreative(this, 4.0) != null) {
                    this.setIsBatHanging(false);
                    this.world.playEvent(null, 1025, lvt_1_1_, 0);
                }
            } else {
                this.setIsBatHanging(false);
                this.world.playEvent(null, 1025, lvt_1_1_, 0);
            }
        } else {
            if (!(this.spawnPosition == null || this.world.isAirBlock(this.spawnPosition) && this.spawnPosition.getY() >= 1)) {
                this.spawnPosition = null;
            }
            if (this.spawnPosition == null || this.rand.nextInt(30) == 0 || this.spawnPosition.distanceSq((int)this.posX, (int)this.posY, (int)this.posZ) < 4.0) {
                this.spawnPosition = new BlockPos((int)this.posX + this.rand.nextInt(7) - this.rand.nextInt(7), (int)this.posY + this.rand.nextInt(6) - 2, (int)this.posZ + this.rand.nextInt(7) - this.rand.nextInt(7));
            }
            double lvt_3_1_ = (double)this.spawnPosition.getX() + 0.5 - this.posX;
            double lvt_5_1_ = (double)this.spawnPosition.getY() + 0.1 - this.posY;
            double lvt_7_1_ = (double)this.spawnPosition.getZ() + 0.5 - this.posZ;
            this.motionX += (Math.signum(lvt_3_1_) * 0.5 - this.motionX) * (double)0.1f;
            this.motionY += (Math.signum(lvt_5_1_) * (double)0.7f - this.motionY) * (double)0.1f;
            this.motionZ += (Math.signum(lvt_7_1_) * 0.5 - this.motionZ) * (double)0.1f;
            float lvt_9_1_ = (float)(MathHelper.atan2(this.motionZ, this.motionX) * 57.2957763671875) - 90.0f;
            float lvt_10_1_ = MathHelper.wrapDegrees(lvt_9_1_ - this.rotationYaw);
            this.moveForward = 0.5f;
            this.rotationYaw += lvt_10_1_;
            if (this.rand.nextInt(100) == 0 && this.world.getBlockState(lvt_2_1_).isNormalCube()) {
                this.setIsBatHanging(true);
            }
        }
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    public void fall(float p_fall_1_, float p_fall_2_) {
    }

    @Override
    protected void updateFallState(double p_updateFallState_1_, boolean p_updateFallState_3_, IBlockState p_updateFallState_4_, BlockPos p_updateFallState_5_) {
    }

    @Override
    public boolean doesEntityNotTriggerPressurePlate() {
        return true;
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        if (this.isEntityInvulnerable(p_attackEntityFrom_1_)) {
            return false;
        }
        if (!this.world.isRemote && this.getIsBatHanging()) {
            this.setIsBatHanging(false);
        }
        return super.attackEntityFrom(p_attackEntityFrom_1_, p_attackEntityFrom_2_);
    }

    public static void registerFixesBat(DataFixer p_registerFixesBat_0_) {
        EntityLiving.registerFixesMob(p_registerFixesBat_0_, EntityBat.class);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.dataManager.set(HANGING, p_readEntityFromNBT_1_.getByte("BatFlags"));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setByte("BatFlags", this.dataManager.get(HANGING));
    }

    @Override
    public boolean getCanSpawnHere() {
        BlockPos lvt_1_1_ = new BlockPos(this.posX, this.getEntityBoundingBox().minY, this.posZ);
        if (lvt_1_1_.getY() >= this.world.getSeaLevel()) {
            return false;
        }
        int lvt_2_1_ = this.world.getLightFromNeighbors(lvt_1_1_);
        int lvt_3_1_ = 4;
        if (this.isDateAroundHalloween(this.world.getCurrentDate())) {
            lvt_3_1_ = 7;
        } else if (this.rand.nextBoolean()) {
            return false;
        }
        if (lvt_2_1_ > this.rand.nextInt(lvt_3_1_)) {
            return false;
        }
        return super.getCanSpawnHere();
    }

    private boolean isDateAroundHalloween(Calendar p_isDateAroundHalloween_1_) {
        return p_isDateAroundHalloween_1_.get(2) + 1 == 10 && p_isDateAroundHalloween_1_.get(5) >= 20 || p_isDateAroundHalloween_1_.get(2) + 1 == 11 && p_isDateAroundHalloween_1_.get(5) <= 3;
    }

    @Override
    public float getEyeHeight() {
        return this.height / 2.0f;
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_BAT;
    }
}

