/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityCow
extends EntityAnimal {
    public EntityCow(World p_i1683_1_) {
        super(p_i1683_1_);
        this.setSize(0.9f, 1.4f);
    }

    public static void registerFixesCow(DataFixer p_registerFixesCow_0_) {
        EntityLiving.registerFixesMob(p_registerFixesCow_0_, EntityCow.class);
    }

    @Override
    protected void initEntityAI() {
        this.tasks.addTask(0, new EntityAISwimming(this));
        this.tasks.addTask(1, new EntityAIPanic(this, 2.0));
        this.tasks.addTask(2, new EntityAIMate(this, 1.0));
        this.tasks.addTask(3, new EntityAITempt((EntityCreature)this, 1.25, Items.WHEAT, false));
        this.tasks.addTask(4, new EntityAIFollowParent(this, 1.25));
        this.tasks.addTask(5, new EntityAIWanderAvoidWater(this, 1.0));
        this.tasks.addTask(6, new EntityAIWatchClosest(this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(7, new EntityAILookIdle(this));
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(10.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.2f);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_COW_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_COW_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_COW_DEATH;
    }

    @Override
    protected void playStepSound(BlockPos p_playStepSound_1_, Block p_playStepSound_2_) {
        this.playSound(SoundEvents.ENTITY_COW_STEP, 0.15f, 1.0f);
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_COW;
    }

    @Override
    public boolean processInteract(EntityPlayer p_processInteract_1_, EnumHand p_processInteract_2_) {
        ItemStack lvt_3_1_ = p_processInteract_1_.getHeldItem(p_processInteract_2_);
        if (lvt_3_1_.getItem() == Items.BUCKET && !p_processInteract_1_.capabilities.isCreativeMode && !this.isChild()) {
            p_processInteract_1_.playSound(SoundEvents.ENTITY_COW_MILK, 1.0f, 1.0f);
            lvt_3_1_.shrink(1);
            if (lvt_3_1_.isEmpty()) {
                p_processInteract_1_.setHeldItem(p_processInteract_2_, new ItemStack(Items.MILK_BUCKET));
            } else if (!p_processInteract_1_.inventory.addItemStackToInventory(new ItemStack(Items.MILK_BUCKET))) {
                p_processInteract_1_.dropItem(new ItemStack(Items.MILK_BUCKET), false);
            }
            return true;
        }
        return super.processInteract(p_processInteract_1_, p_processInteract_2_);
    }

    @Override
    public EntityCow createChild(EntityAgeable p_createChild_1_) {
        return new EntityCow(this.world);
    }

    @Override
    public float getEyeHeight() {
        if (this.isChild()) {
            return this.height;
        }
        return 1.3f;
    }

    @Override
    public /* synthetic */ EntityAgeable createChild(EntityAgeable p_createChild_1_) {
        return this.createChild(p_createChild_1_);
    }
}

