/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.passive.HorseArmorType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.ItemStackData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHorse
extends AbstractHorse {
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final DataParameter<Integer> HORSE_VARIANT = EntityDataManager.createKey(EntityHorse.class, DataSerializers.VARINT);
    private static final DataParameter<Integer> HORSE_ARMOR = EntityDataManager.createKey(EntityHorse.class, DataSerializers.VARINT);
    private static final String[] HORSE_TEXTURES = new String[]{"textures/entity/horse/horse_white.png", "textures/entity/horse/horse_creamy.png", "textures/entity/horse/horse_chestnut.png", "textures/entity/horse/horse_brown.png", "textures/entity/horse/horse_black.png", "textures/entity/horse/horse_gray.png", "textures/entity/horse/horse_darkbrown.png"};
    private static final String[] HORSE_TEXTURES_ABBR = new String[]{"hwh", "hcr", "hch", "hbr", "hbl", "hgr", "hdb"};
    private static final String[] HORSE_MARKING_TEXTURES = new String[]{null, "textures/entity/horse/horse_markings_white.png", "textures/entity/horse/horse_markings_whitefield.png", "textures/entity/horse/horse_markings_whitedots.png", "textures/entity/horse/horse_markings_blackdots.png"};
    private static final String[] HORSE_MARKING_TEXTURES_ABBR = new String[]{"", "wo_", "wmo", "wdo", "bdo"};
    private String texturePrefix;
    private final String[] horseTexturesArray = new String[3];

    public EntityHorse(World p_i1685_1_) {
        super(p_i1685_1_);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(HORSE_VARIANT, 0);
        this.dataManager.register(HORSE_ARMOR, HorseArmorType.NONE.getOrdinal());
    }

    public static void registerFixesHorse(DataFixer p_registerFixesHorse_0_) {
        AbstractHorse.registerFixesAbstractHorse(p_registerFixesHorse_0_, EntityHorse.class);
        p_registerFixesHorse_0_.registerWalker(FixTypes.ENTITY, new ItemStackData(EntityHorse.class, "ArmorItem"));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setInteger("Variant", this.getHorseVariant());
        if (!this.horseChest.getStackInSlot(1).isEmpty()) {
            p_writeEntityToNBT_1_.setTag("ArmorItem", this.horseChest.getStackInSlot(1).writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        ItemStack lvt_2_1_;
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.setHorseVariant(p_readEntityFromNBT_1_.getInteger("Variant"));
        if (p_readEntityFromNBT_1_.hasKey("ArmorItem", 10) && !(lvt_2_1_ = new ItemStack(p_readEntityFromNBT_1_.getCompoundTag("ArmorItem"))).isEmpty() && HorseArmorType.isHorseArmor(lvt_2_1_.getItem())) {
            this.horseChest.setInventorySlotContents(1, lvt_2_1_);
        }
        this.updateHorseSlots();
    }

    public void setHorseVariant(int p_setHorseVariant_1_) {
        this.dataManager.set(HORSE_VARIANT, p_setHorseVariant_1_);
        this.resetTexturePrefix();
    }

    public int getHorseVariant() {
        return this.dataManager.get(HORSE_VARIANT);
    }

    private void resetTexturePrefix() {
        this.texturePrefix = null;
    }

    @SideOnly(value=Side.CLIENT)
    private void setHorseTexturePaths() {
        int lvt_1_1_ = this.getHorseVariant();
        int lvt_2_1_ = (lvt_1_1_ & 0xFF) % 7;
        int lvt_3_1_ = ((lvt_1_1_ & 0xFF00) >> 8) % 5;
        HorseArmorType lvt_4_1_ = this.getHorseArmorType();
        this.horseTexturesArray[0] = HORSE_TEXTURES[lvt_2_1_];
        this.horseTexturesArray[1] = HORSE_MARKING_TEXTURES[lvt_3_1_];
        this.horseTexturesArray[2] = lvt_4_1_.getTextureName();
        this.texturePrefix = "horse/" + HORSE_TEXTURES_ABBR[lvt_2_1_] + HORSE_MARKING_TEXTURES_ABBR[lvt_3_1_] + lvt_4_1_.getHash();
    }

    @SideOnly(value=Side.CLIENT)
    public String getHorseTexture() {
        if (this.texturePrefix == null) {
            this.setHorseTexturePaths();
        }
        return this.texturePrefix;
    }

    @SideOnly(value=Side.CLIENT)
    public String[] getVariantTexturePaths() {
        if (this.texturePrefix == null) {
            this.setHorseTexturePaths();
        }
        return this.horseTexturesArray;
    }

    @Override
    protected void updateHorseSlots() {
        super.updateHorseSlots();
        this.setHorseArmorStack(this.horseChest.getStackInSlot(1));
    }

    public void setHorseArmorStack(ItemStack p_setHorseArmorStack_1_) {
        HorseArmorType lvt_2_1_ = HorseArmorType.getByItemStack(p_setHorseArmorStack_1_);
        this.dataManager.set(HORSE_ARMOR, lvt_2_1_.getOrdinal());
        this.resetTexturePrefix();
        if (!this.world.isRemote) {
            this.getEntityAttribute(SharedMonsterAttributes.ARMOR).removeModifier(ARMOR_MODIFIER_UUID);
            int lvt_3_1_ = lvt_2_1_.getProtection();
            if (lvt_3_1_ != 0) {
                this.getEntityAttribute(SharedMonsterAttributes.ARMOR).applyModifier(new AttributeModifier(ARMOR_MODIFIER_UUID, "Horse armor bonus", lvt_3_1_, 0).setSaved(false));
            }
        }
    }

    public HorseArmorType getHorseArmorType() {
        return HorseArmorType.getByOrdinal(this.dataManager.get(HORSE_ARMOR));
    }

    @Override
    public void onInventoryChanged(IInventory p_onInventoryChanged_1_) {
        HorseArmorType lvt_2_1_ = this.getHorseArmorType();
        super.onInventoryChanged(p_onInventoryChanged_1_);
        HorseArmorType lvt_3_1_ = this.getHorseArmorType();
        if (this.ticksExisted > 20 && lvt_2_1_ != lvt_3_1_ && lvt_3_1_ != HorseArmorType.NONE) {
            this.playSound(SoundEvents.ENTITY_HORSE_ARMOR, 0.5f, 1.0f);
        }
    }

    @Override
    protected void playGallopSound(SoundType p_playGallopSound_1_) {
        super.playGallopSound(p_playGallopSound_1_);
        if (this.rand.nextInt(10) == 0) {
            this.playSound(SoundEvents.ENTITY_HORSE_BREATHE, p_playGallopSound_1_.getVolume() * 0.6f, p_playGallopSound_1_.getPitch());
        }
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(this.getModifiedMaxHealth());
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(this.getModifiedMovementSpeed());
        this.getEntityAttribute(JUMP_STRENGTH).setBaseValue(this.getModifiedJumpStrength());
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.world.isRemote && this.dataManager.isDirty()) {
            this.dataManager.setClean();
            this.resetTexturePrefix();
        }
    }

    @Override
    protected SoundEvent getAmbientSound() {
        super.getAmbientSound();
        return SoundEvents.ENTITY_HORSE_AMBIENT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        super.getDeathSound();
        return SoundEvents.ENTITY_HORSE_DEATH;
    }

    @Override
    protected SoundEvent getHurtSound() {
        super.getHurtSound();
        return SoundEvents.ENTITY_HORSE_HURT;
    }

    @Override
    protected SoundEvent getAngrySound() {
        super.getAngrySound();
        return SoundEvents.ENTITY_HORSE_ANGRY;
    }

    @Override
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_HORSE;
    }

    @Override
    public boolean processInteract(EntityPlayer p_processInteract_1_, EnumHand p_processInteract_2_) {
        boolean lvt_4_1_;
        ItemStack lvt_3_1_ = p_processInteract_1_.getHeldItem(p_processInteract_2_);
        boolean bl = lvt_4_1_ = !lvt_3_1_.isEmpty();
        if (lvt_4_1_ && lvt_3_1_.getItem() == Items.SPAWN_EGG) {
            return super.processInteract(p_processInteract_1_, p_processInteract_2_);
        }
        if (!this.isChild()) {
            if (this.isTame() && p_processInteract_1_.isSneaking()) {
                this.openGUI(p_processInteract_1_);
                return true;
            }
            if (this.isBeingRidden()) {
                return super.processInteract(p_processInteract_1_, p_processInteract_2_);
            }
        }
        if (lvt_4_1_) {
            boolean lvt_6_1_;
            if (this.handleEating(p_processInteract_1_, lvt_3_1_)) {
                if (!p_processInteract_1_.capabilities.isCreativeMode) {
                    lvt_3_1_.shrink(1);
                }
                return true;
            }
            if (lvt_3_1_.interactWithEntity(p_processInteract_1_, this, p_processInteract_2_)) {
                return true;
            }
            if (!this.isTame()) {
                this.makeMad();
                return true;
            }
            boolean lvt_5_1_ = HorseArmorType.getByItemStack(lvt_3_1_) != HorseArmorType.NONE;
            boolean bl2 = lvt_6_1_ = !this.isChild() && !this.isHorseSaddled() && lvt_3_1_.getItem() == Items.SADDLE;
            if (lvt_5_1_ || lvt_6_1_) {
                this.openGUI(p_processInteract_1_);
                return true;
            }
        }
        if (this.isChild()) {
            return super.processInteract(p_processInteract_1_, p_processInteract_2_);
        }
        this.mountTo(p_processInteract_1_);
        return true;
    }

    @Override
    public boolean canMateWith(EntityAnimal p_canMateWith_1_) {
        if (p_canMateWith_1_ == this) {
            return false;
        }
        if (p_canMateWith_1_ instanceof EntityDonkey || p_canMateWith_1_ instanceof EntityHorse) {
            return this.canMate() && ((AbstractHorse)p_canMateWith_1_).canMate();
        }
        return false;
    }

    @Override
    public EntityAgeable createChild(EntityAgeable p_createChild_1_) {
        EntityHorse lvt_2_2_;
        if (p_createChild_1_ instanceof EntityDonkey) {
            EntityMule lvt_2_1_ = new EntityMule(this.world);
        } else {
            int lvt_4_3_;
            EntityHorse lvt_3_1_ = (EntityHorse)p_createChild_1_;
            lvt_2_2_ = new EntityHorse(this.world);
            int lvt_5_1_ = this.rand.nextInt(9);
            if (lvt_5_1_ < 4) {
                int lvt_4_1_ = this.getHorseVariant() & 0xFF;
            } else if (lvt_5_1_ < 8) {
                int lvt_4_2_ = lvt_3_1_.getHorseVariant() & 0xFF;
            } else {
                lvt_4_3_ = this.rand.nextInt(7);
            }
            int lvt_6_1_ = this.rand.nextInt(5);
            lvt_4_3_ = lvt_6_1_ < 2 ? (lvt_4_3_ |= this.getHorseVariant() & 0xFF00) : (lvt_6_1_ < 4 ? (lvt_4_3_ |= lvt_3_1_.getHorseVariant() & 0xFF00) : (lvt_4_3_ |= this.rand.nextInt(5) << 8 & 0xFF00));
            lvt_2_2_.setHorseVariant(lvt_4_3_);
        }
        this.setOffspringAttributes(p_createChild_1_, lvt_2_2_);
        return lvt_2_2_;
    }

    @Override
    public boolean wearsArmor() {
        return true;
    }

    @Override
    public boolean isArmor(ItemStack p_isArmor_1_) {
        return HorseArmorType.isHorseArmor(p_isArmor_1_.getItem());
    }

    @Override
    @Nullable
    public IEntityLivingData onInitialSpawn(DifficultyInstance p_onInitialSpawn_1_, IEntityLivingData p_onInitialSpawn_2_) {
        int lvt_3_2_;
        if ((p_onInitialSpawn_2_ = super.onInitialSpawn(p_onInitialSpawn_1_, p_onInitialSpawn_2_)) instanceof GroupData) {
            int lvt_3_1_ = ((GroupData)p_onInitialSpawn_2_).variant;
        } else {
            lvt_3_2_ = this.rand.nextInt(7);
            p_onInitialSpawn_2_ = new GroupData(lvt_3_2_);
        }
        this.setHorseVariant(lvt_3_2_ | this.rand.nextInt(5) << 8);
        return p_onInitialSpawn_2_;
    }

    public static class GroupData
    implements IEntityLivingData {
        public int variant;

        public GroupData(int p_i47337_1_) {
            this.variant = p_i47337_1_;
        }
    }
}

