/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILlamaFollowCaravan;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIRunAroundLikeCrazy;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.AbstractChestHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLlamaSpit;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLlama
extends AbstractChestHorse
implements IRangedAttackMob {
    private static final DataParameter<Integer> DATA_STRENGTH_ID = EntityDataManager.createKey(EntityLlama.class, DataSerializers.VARINT);
    private static final DataParameter<Integer> DATA_COLOR_ID = EntityDataManager.createKey(EntityLlama.class, DataSerializers.VARINT);
    private static final DataParameter<Integer> DATA_VARIANT_ID = EntityDataManager.createKey(EntityLlama.class, DataSerializers.VARINT);
    private boolean didSpit;
    @Nullable
    private EntityLlama caravanHead;
    @Nullable
    private EntityLlama caravanTail;

    public EntityLlama(World p_i47297_1_) {
        super(p_i47297_1_);
        this.setSize(0.9f, 1.87f);
    }

    private void setStrength(int p_setStrength_1_) {
        this.dataManager.set(DATA_STRENGTH_ID, Math.max(1, Math.min(5, p_setStrength_1_)));
    }

    private void setRandomStrength() {
        int lvt_1_1_ = this.rand.nextFloat() < 0.04f ? 5 : 3;
        this.setStrength(1 + this.rand.nextInt(lvt_1_1_));
    }

    public int getStrength() {
        return this.dataManager.get(DATA_STRENGTH_ID);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setInteger("Variant", this.getVariant());
        p_writeEntityToNBT_1_.setInteger("Strength", this.getStrength());
        if (!this.horseChest.getStackInSlot(1).isEmpty()) {
            p_writeEntityToNBT_1_.setTag("DecorItem", this.horseChest.getStackInSlot(1).writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        this.setStrength(p_readEntityFromNBT_1_.getInteger("Strength"));
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.setVariant(p_readEntityFromNBT_1_.getInteger("Variant"));
        if (p_readEntityFromNBT_1_.hasKey("DecorItem", 10)) {
            this.horseChest.setInventorySlotContents(1, new ItemStack(p_readEntityFromNBT_1_.getCompoundTag("DecorItem")));
        }
        this.updateHorseSlots();
    }

    @Override
    protected void initEntityAI() {
        this.tasks.addTask(0, new EntityAISwimming(this));
        this.tasks.addTask(1, new EntityAIRunAroundLikeCrazy(this, 1.2));
        this.tasks.addTask(2, new EntityAILlamaFollowCaravan(this, 2.1f));
        this.tasks.addTask(3, new EntityAIAttackRanged(this, 1.25, 40, 20.0f));
        this.tasks.addTask(3, new EntityAIPanic(this, 1.2));
        this.tasks.addTask(4, new EntityAIMate(this, 1.0));
        this.tasks.addTask(5, new EntityAIFollowParent(this, 1.0));
        this.tasks.addTask(6, new EntityAIWanderAvoidWater(this, 0.7));
        this.tasks.addTask(7, new EntityAIWatchClosest(this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(8, new EntityAILookIdle(this));
        this.targetTasks.addTask(1, new AIHurtByTarget(this));
        this.targetTasks.addTask(2, new AIDefendTarget(this));
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(40.0);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(DATA_STRENGTH_ID, 0);
        this.dataManager.register(DATA_COLOR_ID, -1);
        this.dataManager.register(DATA_VARIANT_ID, 0);
    }

    public int getVariant() {
        return MathHelper.clamp(this.dataManager.get(DATA_VARIANT_ID), 0, 3);
    }

    public void setVariant(int p_setVariant_1_) {
        this.dataManager.set(DATA_VARIANT_ID, p_setVariant_1_);
    }

    @Override
    protected int getInventorySize() {
        if (this.hasChest()) {
            return 2 + 3 * this.getInventoryColumns();
        }
        return super.getInventorySize();
    }

    @Override
    public void updatePassenger(Entity p_updatePassenger_1_) {
        if (!this.isPassenger(p_updatePassenger_1_)) {
            return;
        }
        float lvt_2_1_ = MathHelper.cos(this.renderYawOffset * ((float)Math.PI / 180));
        float lvt_3_1_ = MathHelper.sin(this.renderYawOffset * ((float)Math.PI / 180));
        float lvt_4_1_ = 0.3f;
        p_updatePassenger_1_.setPosition(this.posX + (double)(0.3f * lvt_3_1_), this.posY + this.getMountedYOffset() + p_updatePassenger_1_.getYOffset(), this.posZ - (double)(0.3f * lvt_2_1_));
    }

    @Override
    public double getMountedYOffset() {
        return (double)this.height * 0.67;
    }

    @Override
    public boolean canBeSteered() {
        return false;
    }

    @Override
    protected boolean handleEating(EntityPlayer p_handleEating_1_, ItemStack p_handleEating_2_) {
        int lvt_3_1_ = 0;
        int lvt_4_1_ = 0;
        float lvt_5_1_ = 0.0f;
        boolean lvt_6_1_ = false;
        Item lvt_7_1_ = p_handleEating_2_.getItem();
        if (lvt_7_1_ == Items.WHEAT) {
            lvt_3_1_ = 10;
            lvt_4_1_ = 3;
            lvt_5_1_ = 2.0f;
        } else if (lvt_7_1_ == Item.getItemFromBlock(Blocks.HAY_BLOCK)) {
            lvt_3_1_ = 90;
            lvt_4_1_ = 6;
            lvt_5_1_ = 10.0f;
            if (this.isTame() && this.getGrowingAge() == 0) {
                lvt_6_1_ = true;
                this.setInLove(p_handleEating_1_);
            }
        }
        if (this.getHealth() < this.getMaxHealth() && lvt_5_1_ > 0.0f) {
            this.heal(lvt_5_1_);
            lvt_6_1_ = true;
        }
        if (this.isChild() && lvt_3_1_ > 0) {
            this.world.spawnParticle(EnumParticleTypes.VILLAGER_HAPPY, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + 0.5 + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, 0.0, 0.0, 0.0, new int[0]);
            if (!this.world.isRemote) {
                this.addGrowth(lvt_3_1_);
            }
            lvt_6_1_ = true;
        }
        if (lvt_4_1_ > 0 && (lvt_6_1_ || !this.isTame()) && this.getTemper() < this.getMaxTemper()) {
            lvt_6_1_ = true;
            if (!this.world.isRemote) {
                this.increaseTemper(lvt_4_1_);
            }
        }
        if (lvt_6_1_ && !this.isSilent()) {
            this.world.playSound(null, this.posX, this.posY, this.posZ, SoundEvents.ENTITY_LLAMA_EAT, this.getSoundCategory(), 1.0f, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f);
        }
        return lvt_6_1_;
    }

    @Override
    protected boolean isMovementBlocked() {
        return this.getHealth() <= 0.0f || this.isEatingHaystack();
    }

    @Override
    @Nullable
    public IEntityLivingData onInitialSpawn(DifficultyInstance p_onInitialSpawn_1_, IEntityLivingData p_onInitialSpawn_2_) {
        int lvt_3_2_;
        p_onInitialSpawn_2_ = super.onInitialSpawn(p_onInitialSpawn_1_, p_onInitialSpawn_2_);
        this.setRandomStrength();
        if (p_onInitialSpawn_2_ instanceof GroupData) {
            int lvt_3_1_ = ((GroupData)p_onInitialSpawn_2_).variant;
        } else {
            lvt_3_2_ = this.rand.nextInt(4);
            p_onInitialSpawn_2_ = new GroupData(lvt_3_2_);
        }
        this.setVariant(lvt_3_2_);
        return p_onInitialSpawn_2_;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasColor() {
        return this.getColor() != null;
    }

    @Override
    protected SoundEvent getAngrySound() {
        return SoundEvents.ENTITY_LLAMA_ANGRY;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_LLAMA_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_LLAMA_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_LLAMA_DEATH;
    }

    @Override
    protected void playStepSound(BlockPos p_playStepSound_1_, Block p_playStepSound_2_) {
        this.playSound(SoundEvents.ENTITY_LLAMA_STEP, 0.15f, 1.0f);
    }

    @Override
    protected void playChestEquipSound() {
        this.playSound(SoundEvents.ENTITY_LLAMA_CHEST, 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
    }

    @Override
    public void makeMad() {
        SoundEvent lvt_1_1_ = this.getAngrySound();
        if (lvt_1_1_ != null) {
            this.playSound(lvt_1_1_, this.getSoundVolume(), this.getSoundPitch());
        }
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_LLAMA;
    }

    @Override
    public int getInventoryColumns() {
        return this.getStrength();
    }

    @Override
    public boolean wearsArmor() {
        return true;
    }

    @Override
    public boolean isArmor(ItemStack p_isArmor_1_) {
        return p_isArmor_1_.getItem() == Item.getItemFromBlock(Blocks.CARPET);
    }

    @Override
    public boolean canBeSaddled() {
        return false;
    }

    @Override
    public void onInventoryChanged(IInventory p_onInventoryChanged_1_) {
        EnumDyeColor lvt_2_1_ = this.getColor();
        super.onInventoryChanged(p_onInventoryChanged_1_);
        EnumDyeColor lvt_3_1_ = this.getColor();
        if (this.ticksExisted > 20 && lvt_3_1_ != null && lvt_3_1_ != lvt_2_1_) {
            this.playSound(SoundEvents.ENTITY_LLAMA_SWAG, 0.5f, 1.0f);
        }
    }

    @Override
    protected void updateHorseSlots() {
        if (this.world.isRemote) {
            return;
        }
        super.updateHorseSlots();
        this.setColorByItem(this.horseChest.getStackInSlot(1));
    }

    private void setColor(EnumDyeColor p_setColor_1_) {
        this.dataManager.set(DATA_COLOR_ID, p_setColor_1_ == null ? -1 : p_setColor_1_.getMetadata());
    }

    private void setColorByItem(ItemStack p_setColorByItem_1_) {
        if (this.isArmor(p_setColorByItem_1_)) {
            this.setColor(EnumDyeColor.byMetadata(p_setColorByItem_1_.getMetadata()));
        } else {
            this.setColor(null);
        }
    }

    @Nullable
    public EnumDyeColor getColor() {
        int lvt_1_1_ = this.dataManager.get(DATA_COLOR_ID);
        return lvt_1_1_ == -1 ? null : EnumDyeColor.byMetadata(lvt_1_1_);
    }

    @Override
    public int getMaxTemper() {
        return 30;
    }

    @Override
    public boolean canMateWith(EntityAnimal p_canMateWith_1_) {
        return p_canMateWith_1_ != this && p_canMateWith_1_ instanceof EntityLlama && this.canMate() && ((EntityLlama)p_canMateWith_1_).canMate();
    }

    @Override
    public EntityLlama createChild(EntityAgeable p_createChild_1_) {
        EntityLlama lvt_2_1_ = new EntityLlama(this.world);
        this.setOffspringAttributes(p_createChild_1_, lvt_2_1_);
        EntityLlama lvt_3_1_ = (EntityLlama)p_createChild_1_;
        int lvt_4_1_ = this.rand.nextInt(Math.max(this.getStrength(), lvt_3_1_.getStrength())) + 1;
        if (this.rand.nextFloat() < 0.03f) {
            ++lvt_4_1_;
        }
        lvt_2_1_.setStrength(lvt_4_1_);
        lvt_2_1_.setVariant(this.rand.nextBoolean() ? this.getVariant() : lvt_3_1_.getVariant());
        return lvt_2_1_;
    }

    private void spit(EntityLivingBase p_spit_1_) {
        EntityLlamaSpit lvt_2_1_ = new EntityLlamaSpit(this.world, this);
        double lvt_3_1_ = p_spit_1_.posX - this.posX;
        double lvt_5_1_ = p_spit_1_.getEntityBoundingBox().minY + (double)(p_spit_1_.height / 3.0f) - lvt_2_1_.posY;
        double lvt_7_1_ = p_spit_1_.posZ - this.posZ;
        float lvt_9_1_ = MathHelper.sqrt(lvt_3_1_ * lvt_3_1_ + lvt_7_1_ * lvt_7_1_) * 0.2f;
        lvt_2_1_.setThrowableHeading(lvt_3_1_, lvt_5_1_ + (double)lvt_9_1_, lvt_7_1_, 1.5f, 10.0f);
        this.world.playSound(null, this.posX, this.posY, this.posZ, SoundEvents.ENTITY_LLAMA_SPIT, this.getSoundCategory(), 1.0f, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f);
        this.world.spawnEntity(lvt_2_1_);
        this.didSpit = true;
    }

    private void setDidSpit(boolean p_setDidSpit_1_) {
        this.didSpit = p_setDidSpit_1_;
    }

    @Override
    public void fall(float p_fall_1_, float p_fall_2_) {
        int lvt_3_1_ = MathHelper.ceil((p_fall_1_ * 0.5f - 3.0f) * p_fall_2_);
        if (lvt_3_1_ <= 0) {
            return;
        }
        if (p_fall_1_ >= 6.0f) {
            this.attackEntityFrom(DamageSource.FALL, lvt_3_1_);
            if (this.isBeingRidden()) {
                for (Entity lvt_5_1_ : this.getRecursivePassengers()) {
                    lvt_5_1_.attackEntityFrom(DamageSource.FALL, lvt_3_1_);
                }
            }
        }
        IBlockState lvt_4_1_ = this.world.getBlockState(new BlockPos(this.posX, this.posY - 0.2 - (double)this.prevRotationYaw, this.posZ));
        Block lvt_5_2_ = lvt_4_1_.getBlock();
        if (lvt_4_1_.getMaterial() != Material.AIR && !this.isSilent()) {
            SoundType lvt_6_1_ = lvt_5_2_.getSoundType();
            this.world.playSound(null, this.posX, this.posY, this.posZ, lvt_6_1_.getStepSound(), this.getSoundCategory(), lvt_6_1_.getVolume() * 0.5f, lvt_6_1_.getPitch() * 0.75f);
        }
    }

    public void leaveCaravan() {
        if (this.caravanHead != null) {
            this.caravanHead.caravanTail = null;
        }
        this.caravanHead = null;
    }

    public void joinCaravan(EntityLlama p_joinCaravan_1_) {
        this.caravanHead = p_joinCaravan_1_;
        this.caravanHead.caravanTail = this;
    }

    public boolean hasCaravanTrail() {
        return this.caravanTail != null;
    }

    public boolean inCaravan() {
        return this.caravanHead != null;
    }

    @Nullable
    public EntityLlama getCaravanHead() {
        return this.caravanHead;
    }

    @Override
    protected double followLeashSpeed() {
        return 2.0;
    }

    @Override
    protected void followMother() {
        if (!this.inCaravan() && this.isChild()) {
            super.followMother();
        }
    }

    @Override
    public boolean canEatGrass() {
        return false;
    }

    @Override
    public void attackEntityWithRangedAttack(EntityLivingBase p_attackEntityWithRangedAttack_1_, float p_attackEntityWithRangedAttack_2_) {
        this.spit(p_attackEntityWithRangedAttack_1_);
    }

    @Override
    public /* synthetic */ EntityAgeable createChild(EntityAgeable p_createChild_1_) {
        return this.createChild(p_createChild_1_);
    }

    static class AIDefendTarget
    extends EntityAINearestAttackableTarget<EntityWolf> {
        public AIDefendTarget(EntityLlama p_i47285_1_) {
            super(p_i47285_1_, EntityWolf.class, 16, false, true, null);
        }

        @Override
        public boolean shouldExecute() {
            if (super.shouldExecute() && this.targetEntity != null && !((EntityWolf)this.targetEntity).isTamed()) {
                return true;
            }
            this.taskOwner.setAttackTarget(null);
            return false;
        }

        @Override
        protected double getTargetDistance() {
            return super.getTargetDistance() * 0.25;
        }
    }

    static class AIHurtByTarget
    extends EntityAIHurtByTarget {
        public AIHurtByTarget(EntityLlama p_i47282_1_) {
            super((EntityCreature)p_i47282_1_, false, new Class[0]);
        }

        @Override
        public boolean continueExecuting() {
            EntityLlama lvt_1_1_;
            if (this.taskOwner instanceof EntityLlama && (lvt_1_1_ = (EntityLlama)this.taskOwner).didSpit) {
                lvt_1_1_.setDidSpit(false);
                return false;
            }
            return super.continueExecuting();
        }
    }

    static class GroupData
    implements IEntityLivingData {
        public int variant;

        private GroupData(int p_i47283_1_) {
            this.variant = p_i47283_1_;
        }
    }
}

