/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.IShearable;

public class EntityMooshroom
extends EntityCow
implements IShearable {
    public EntityMooshroom(World p_i1687_1_) {
        super(p_i1687_1_);
        this.setSize(0.9f, 1.4f);
        this.spawnableBlock = Blocks.MYCELIUM;
    }

    public static void registerFixesMooshroom(DataFixer p_registerFixesMooshroom_0_) {
        EntityLiving.registerFixesMob(p_registerFixesMooshroom_0_, EntityMooshroom.class);
    }

    @Override
    public boolean processInteract(EntityPlayer p_processInteract_1_, EnumHand p_processInteract_2_) {
        ItemStack itemstack = p_processInteract_1_.getHeldItem(p_processInteract_2_);
        if (itemstack.getItem() == Items.BOWL && this.getGrowingAge() >= 0 && !p_processInteract_1_.capabilities.isCreativeMode) {
            itemstack.shrink(1);
            if (itemstack.isEmpty()) {
                p_processInteract_1_.setHeldItem(p_processInteract_2_, new ItemStack(Items.MUSHROOM_STEW));
            } else if (!p_processInteract_1_.inventory.addItemStackToInventory(new ItemStack(Items.MUSHROOM_STEW))) {
                p_processInteract_1_.dropItem(new ItemStack(Items.MUSHROOM_STEW), false);
            }
            return true;
        }
        return super.processInteract(p_processInteract_1_, p_processInteract_2_);
    }

    @Override
    public EntityMooshroom createChild(EntityAgeable p_createChild_1_) {
        return new EntityMooshroom(this.world);
    }

    @Override
    public boolean isShearable(ItemStack p_isShearable_1_, IBlockAccess p_isShearable_2_, BlockPos p_isShearable_3_) {
        return this.getGrowingAge() >= 0;
    }

    @Override
    public List<ItemStack> onSheared(ItemStack p_onSheared_1_, IBlockAccess p_onSheared_2_, BlockPos p_onSheared_3_, int p_onSheared_4_) {
        this.setDead();
        this.world.spawnParticle(EnumParticleTypes.EXPLOSION_LARGE, this.posX, this.posY + (double)(this.height / 2.0f), this.posZ, 0.0, 0.0, 0.0, new int[0]);
        EntityCow entitycow = new EntityCow(this.world);
        entitycow.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
        entitycow.setHealth(this.getHealth());
        entitycow.renderYawOffset = this.renderYawOffset;
        if (this.hasCustomName()) {
            entitycow.setCustomNameTag(this.getCustomNameTag());
        }
        this.world.spawnEntity(entitycow);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = 0; i < 5; ++i) {
            ret.add(new ItemStack(Blocks.RED_MUSHROOM));
        }
        this.playSound(SoundEvents.ENTITY_MOOSHROOM_SHEAR, 1.0f, 1.0f);
        return ret;
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_MUSHROOM_COW;
    }
}

