/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.stats.AchievementList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityPig
extends EntityAnimal {
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.createKey(EntityPig.class, DataSerializers.BOOLEAN);
    private static final DataParameter<Integer> field_191520_bx = EntityDataManager.createKey(EntityPig.class, DataSerializers.VARINT);
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.CARROT, Items.POTATO, Items.BEETROOT});
    private boolean boosting;
    private int boostTime;
    private int totalBoostTime;

    public EntityPig(World p_i1689_1_) {
        super(p_i1689_1_);
        this.setSize(0.9f, 0.9f);
    }

    @Override
    protected void initEntityAI() {
        this.tasks.addTask(0, new EntityAISwimming(this));
        this.tasks.addTask(1, new EntityAIPanic(this, 1.25));
        this.tasks.addTask(3, new EntityAIMate(this, 1.0));
        this.tasks.addTask(4, new EntityAITempt((EntityCreature)this, 1.2, Items.CARROT_ON_A_STICK, false));
        this.tasks.addTask(4, new EntityAITempt((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS));
        this.tasks.addTask(5, new EntityAIFollowParent(this, 1.1));
        this.tasks.addTask(6, new EntityAIWanderAvoidWater(this, 1.0));
        this.tasks.addTask(7, new EntityAIWatchClosest(this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(8, new EntityAILookIdle(this));
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(10.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.25);
    }

    @Override
    @Nullable
    public Entity getControllingPassenger() {
        if (this.getPassengers().isEmpty()) {
            return null;
        }
        return this.getPassengers().get(0);
    }

    @Override
    public boolean canBeSteered() {
        Entity lvt_1_1_ = this.getControllingPassenger();
        if (!(lvt_1_1_ instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer lvt_2_1_ = (EntityPlayer)lvt_1_1_;
        return lvt_2_1_.getHeldItemMainhand().getItem() == Items.CARROT_ON_A_STICK || lvt_2_1_.getHeldItemOffhand().getItem() == Items.CARROT_ON_A_STICK;
    }

    @Override
    public void notifyDataManagerChange(DataParameter<?> p_notifyDataManagerChange_1_) {
        if (field_191520_bx.equals(p_notifyDataManagerChange_1_) && this.world.isRemote) {
            this.boosting = true;
            this.boostTime = 0;
            this.totalBoostTime = this.dataManager.get(field_191520_bx);
        }
        super.notifyDataManagerChange(p_notifyDataManagerChange_1_);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(SADDLED, false);
        this.dataManager.register(field_191520_bx, 0);
    }

    public static void registerFixesPig(DataFixer p_registerFixesPig_0_) {
        EntityLiving.registerFixesMob(p_registerFixesPig_0_, EntityPig.class);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setBoolean("Saddle", this.getSaddled());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.setSaddled(p_readEntityFromNBT_1_.getBoolean("Saddle"));
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_PIG_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_PIG_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_PIG_DEATH;
    }

    @Override
    protected void playStepSound(BlockPos p_playStepSound_1_, Block p_playStepSound_2_) {
        this.playSound(SoundEvents.ENTITY_PIG_STEP, 0.15f, 1.0f);
    }

    @Override
    public boolean processInteract(EntityPlayer p_processInteract_1_, EnumHand p_processInteract_2_) {
        if (!super.processInteract(p_processInteract_1_, p_processInteract_2_)) {
            ItemStack lvt_3_1_ = p_processInteract_1_.getHeldItem(p_processInteract_2_);
            if (lvt_3_1_.getItem() == Items.NAME_TAG) {
                lvt_3_1_.interactWithEntity(p_processInteract_1_, this, p_processInteract_2_);
                return true;
            }
            if (this.getSaddled() && !this.isBeingRidden()) {
                if (!this.world.isRemote) {
                    p_processInteract_1_.startRiding(this);
                }
                return true;
            }
            if (lvt_3_1_.getItem() == Items.SADDLE) {
                lvt_3_1_.interactWithEntity(p_processInteract_1_, this, p_processInteract_2_);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void onDeath(DamageSource p_onDeath_1_) {
        super.onDeath(p_onDeath_1_);
        if (this.world.isRemote) {
            return;
        }
        if (this.getSaddled()) {
            this.dropItem(Items.SADDLE, 1);
        }
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_PIG;
    }

    public boolean getSaddled() {
        return this.dataManager.get(SADDLED);
    }

    public void setSaddled(boolean p_setSaddled_1_) {
        if (p_setSaddled_1_) {
            this.dataManager.set(SADDLED, true);
        } else {
            this.dataManager.set(SADDLED, false);
        }
    }

    @Override
    public void onStruckByLightning(EntityLightningBolt p_onStruckByLightning_1_) {
        if (this.world.isRemote || this.isDead) {
            return;
        }
        EntityPigZombie lvt_2_1_ = new EntityPigZombie(this.world);
        lvt_2_1_.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.GOLDEN_SWORD));
        lvt_2_1_.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
        lvt_2_1_.setNoAI(this.isAIDisabled());
        if (this.hasCustomName()) {
            lvt_2_1_.setCustomNameTag(this.getCustomNameTag());
            lvt_2_1_.setAlwaysRenderNameTag(this.getAlwaysRenderNameTag());
        }
        this.world.spawnEntity(lvt_2_1_);
        this.setDead();
    }

    @Override
    public void fall(float p_fall_1_, float p_fall_2_) {
        super.fall(p_fall_1_, p_fall_2_);
        if (p_fall_1_ > 5.0f) {
            for (EntityPlayer lvt_4_1_ : this.getRecursivePassengersByType(EntityPlayer.class)) {
                lvt_4_1_.addStat(AchievementList.FLY_PIG);
            }
        }
    }

    @Override
    public void moveEntityWithHeading(float p_moveEntityWithHeading_1_, float p_moveEntityWithHeading_2_) {
        Entity lvt_3_1_;
        Entity entity = lvt_3_1_ = this.getPassengers().isEmpty() ? null : this.getPassengers().get(0);
        if (!this.isBeingRidden() || !this.canBeSteered()) {
            this.stepHeight = 0.5f;
            this.jumpMovementFactor = 0.02f;
            super.moveEntityWithHeading(p_moveEntityWithHeading_1_, p_moveEntityWithHeading_2_);
            return;
        }
        this.prevRotationYaw = this.rotationYaw = lvt_3_1_.rotationYaw;
        this.rotationPitch = lvt_3_1_.rotationPitch * 0.5f;
        this.setRotation(this.rotationYaw, this.rotationPitch);
        this.renderYawOffset = this.rotationYaw;
        this.rotationYawHead = this.rotationYaw;
        this.stepHeight = 1.0f;
        this.jumpMovementFactor = this.getAIMoveSpeed() * 0.1f;
        if (this.boosting && this.boostTime++ > this.totalBoostTime) {
            this.boosting = false;
        }
        if (this.canPassengerSteer()) {
            float lvt_4_1_ = (float)this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).getAttributeValue() * 0.225f;
            if (this.boosting) {
                lvt_4_1_ += lvt_4_1_ * 1.15f * MathHelper.sin((float)this.boostTime / (float)this.totalBoostTime * (float)Math.PI);
            }
            this.setAIMoveSpeed(lvt_4_1_);
            super.moveEntityWithHeading(0.0f, 1.0f);
        } else {
            this.motionX = 0.0;
            this.motionY = 0.0;
            this.motionZ = 0.0;
        }
        this.prevLimbSwingAmount = this.limbSwingAmount;
        double lvt_4_2_ = this.posX - this.prevPosX;
        double lvt_6_1_ = this.posZ - this.prevPosZ;
        float lvt_8_1_ = MathHelper.sqrt(lvt_4_2_ * lvt_4_2_ + lvt_6_1_ * lvt_6_1_) * 4.0f;
        if (lvt_8_1_ > 1.0f) {
            lvt_8_1_ = 1.0f;
        }
        this.limbSwingAmount += (lvt_8_1_ - this.limbSwingAmount) * 0.4f;
        this.limbSwing += this.limbSwingAmount;
    }

    public boolean boost() {
        if (this.boosting) {
            return false;
        }
        this.boosting = true;
        this.boostTime = 0;
        this.totalBoostTime = this.getRNG().nextInt(841) + 140;
        this.getDataManager().set(field_191520_bx, this.totalBoostTime);
        return true;
    }

    @Override
    public EntityPig createChild(EntityAgeable p_createChild_1_) {
        return new EntityPig(this.world);
    }

    @Override
    public boolean isBreedingItem(ItemStack p_isBreedingItem_1_) {
        return TEMPTATION_ITEMS.contains(p_isBreedingItem_1_.getItem());
    }

    @Override
    public /* synthetic */ EntityAgeable createChild(EntityAgeable p_createChild_1_) {
        return this.createChild(p_createChild_1_);
    }
}

