/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarrot;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityJumpHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDesert;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityRabbit
extends EntityAnimal {
    private static final DataParameter<Integer> RABBIT_TYPE = EntityDataManager.createKey(EntityRabbit.class, DataSerializers.VARINT);
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int currentMoveTypeDuration;
    private int carrotTicks;

    public EntityRabbit(World p_i45869_1_) {
        super(p_i45869_1_);
        this.setSize(0.4f, 0.5f);
        this.jumpHelper = new RabbitJumpHelper(this);
        this.moveHelper = new RabbitMoveHelper(this);
        this.setMovementSpeed(0.0);
    }

    @Override
    protected void initEntityAI() {
        this.tasks.addTask(1, new EntityAISwimming(this));
        this.tasks.addTask(1, new AIPanic(this, 2.2));
        this.tasks.addTask(2, new EntityAIMate(this, 0.8));
        this.tasks.addTask(3, new EntityAITempt((EntityCreature)this, 1.0, Items.CARROT, false));
        this.tasks.addTask(3, new EntityAITempt((EntityCreature)this, 1.0, Items.GOLDEN_CARROT, false));
        this.tasks.addTask(3, new EntityAITempt((EntityCreature)this, 1.0, Item.getItemFromBlock(Blocks.YELLOW_FLOWER), false));
        this.tasks.addTask(4, new AIAvoidEntity<EntityPlayer>(this, EntityPlayer.class, 8.0f, 2.2, 2.2));
        this.tasks.addTask(4, new AIAvoidEntity<EntityWolf>(this, EntityWolf.class, 10.0f, 2.2, 2.2));
        this.tasks.addTask(4, new AIAvoidEntity<EntityMob>(this, EntityMob.class, 4.0f, 2.2, 2.2));
        this.tasks.addTask(5, new AIRaidFarm(this));
        this.tasks.addTask(6, new EntityAIWanderAvoidWater(this, 0.6));
        this.tasks.addTask(11, new EntityAIWatchClosest(this, EntityPlayer.class, 10.0f));
    }

    @Override
    protected float getJumpUpwardsMotion() {
        if (this.isCollidedHorizontally || this.moveHelper.isUpdating() && this.moveHelper.getY() > this.posY + 0.5) {
            return 0.5f;
        }
        Path lvt_1_1_ = this.navigator.getPath();
        if (lvt_1_1_ != null && lvt_1_1_.getCurrentPathIndex() < lvt_1_1_.getCurrentPathLength()) {
            Vec3d lvt_2_1_ = lvt_1_1_.getPosition(this);
            if (lvt_2_1_.yCoord > this.posY + 0.5) {
                return 0.5f;
            }
        }
        if (this.moveHelper.getSpeed() <= 0.6) {
            return 0.2f;
        }
        return 0.3f;
    }

    @Override
    protected void jump() {
        double lvt_3_1_;
        super.jump();
        double lvt_1_1_ = this.moveHelper.getSpeed();
        if (lvt_1_1_ > 0.0 && (lvt_3_1_ = this.motionX * this.motionX + this.motionZ * this.motionZ) < 0.010000000000000002) {
            this.moveRelative(0.0f, 1.0f, 0.1f);
        }
        if (!this.world.isRemote) {
            this.world.setEntityState(this, (byte)1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float setJumpCompletion(float p_setJumpCompletion_1_) {
        if (this.jumpDuration == 0) {
            return 0.0f;
        }
        return ((float)this.jumpTicks + p_setJumpCompletion_1_) / (float)this.jumpDuration;
    }

    public void setMovementSpeed(double p_setMovementSpeed_1_) {
        this.getNavigator().setSpeed(p_setMovementSpeed_1_);
        this.moveHelper.setMoveTo(this.moveHelper.getX(), this.moveHelper.getY(), this.moveHelper.getZ(), p_setMovementSpeed_1_);
    }

    @Override
    public void setJumping(boolean p_setJumping_1_) {
        super.setJumping(p_setJumping_1_);
        if (p_setJumping_1_) {
            this.playSound(this.getJumpSound(), this.getSoundVolume(), ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void startJumping() {
        this.setJumping(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(RABBIT_TYPE, 0);
    }

    @Override
    public void updateAITasks() {
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        if (this.carrotTicks > 0) {
            this.carrotTicks -= this.rand.nextInt(3);
            if (this.carrotTicks < 0) {
                this.carrotTicks = 0;
            }
        }
        if (this.onGround) {
            RabbitJumpHelper lvt_1_2_;
            EntityLivingBase lvt_1_1_;
            if (!this.wasOnGround) {
                this.setJumping(false);
                this.checkLandingDelay();
            }
            if (this.getRabbitType() == 99 && this.currentMoveTypeDuration == 0 && (lvt_1_1_ = this.getAttackTarget()) != null && this.getDistanceSqToEntity(lvt_1_1_) < 16.0) {
                this.calculateRotationYaw(lvt_1_1_.posX, lvt_1_1_.posZ);
                this.moveHelper.setMoveTo(lvt_1_1_.posX, lvt_1_1_.posY, lvt_1_1_.posZ, this.moveHelper.getSpeed());
                this.startJumping();
                this.wasOnGround = true;
            }
            if (!(lvt_1_2_ = (RabbitJumpHelper)this.jumpHelper).getIsJumping()) {
                if (this.moveHelper.isUpdating() && this.currentMoveTypeDuration == 0) {
                    Path lvt_2_1_ = this.navigator.getPath();
                    Vec3d lvt_3_1_ = new Vec3d(this.moveHelper.getX(), this.moveHelper.getY(), this.moveHelper.getZ());
                    if (lvt_2_1_ != null && lvt_2_1_.getCurrentPathIndex() < lvt_2_1_.getCurrentPathLength()) {
                        lvt_3_1_ = lvt_2_1_.getPosition(this);
                    }
                    this.calculateRotationYaw(lvt_3_1_.xCoord, lvt_3_1_.zCoord);
                    this.startJumping();
                }
            } else if (!lvt_1_2_.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.onGround;
    }

    @Override
    public void spawnRunningParticles() {
    }

    private void calculateRotationYaw(double p_calculateRotationYaw_1_, double p_calculateRotationYaw_3_) {
        this.rotationYaw = (float)(MathHelper.atan2(p_calculateRotationYaw_3_ - this.posZ, p_calculateRotationYaw_1_ - this.posX) * 57.2957763671875) - 90.0f;
    }

    private void enableJumpControl() {
        ((RabbitJumpHelper)this.jumpHelper).setCanJump(true);
    }

    private void disableJumpControl() {
        ((RabbitJumpHelper)this.jumpHelper).setCanJump(false);
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.moveHelper.getSpeed() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.setJumping(false);
        }
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(3.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.3f);
    }

    public static void registerFixesRabbit(DataFixer p_registerFixesRabbit_0_) {
        EntityLiving.registerFixesMob(p_registerFixesRabbit_0_, EntityRabbit.class);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setInteger("RabbitType", this.getRabbitType());
        p_writeEntityToNBT_1_.setInteger("MoreCarrotTicks", this.carrotTicks);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.setRabbitType(p_readEntityFromNBT_1_.getInteger("RabbitType"));
        this.carrotTicks = p_readEntityFromNBT_1_.getInteger("MoreCarrotTicks");
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.ENTITY_RABBIT_JUMP;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_RABBIT_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_RABBIT_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_RABBIT_DEATH;
    }

    @Override
    public boolean attackEntityAsMob(Entity p_attackEntityAsMob_1_) {
        if (this.getRabbitType() == 99) {
            this.playSound(SoundEvents.ENTITY_RABBIT_ATTACK, 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            return p_attackEntityAsMob_1_.attackEntityFrom(DamageSource.causeMobDamage(this), 8.0f);
        }
        return p_attackEntityAsMob_1_.attackEntityFrom(DamageSource.causeMobDamage(this), 3.0f);
    }

    @Override
    public SoundCategory getSoundCategory() {
        return this.getRabbitType() == 99 ? SoundCategory.HOSTILE : SoundCategory.NEUTRAL;
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        if (this.isEntityInvulnerable(p_attackEntityFrom_1_)) {
            return false;
        }
        return super.attackEntityFrom(p_attackEntityFrom_1_, p_attackEntityFrom_2_);
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_RABBIT;
    }

    private boolean isRabbitBreedingItem(Item p_isRabbitBreedingItem_1_) {
        return p_isRabbitBreedingItem_1_ == Items.CARROT || p_isRabbitBreedingItem_1_ == Items.GOLDEN_CARROT || p_isRabbitBreedingItem_1_ == Item.getItemFromBlock(Blocks.YELLOW_FLOWER);
    }

    @Override
    public EntityRabbit createChild(EntityAgeable p_createChild_1_) {
        EntityRabbit lvt_2_1_ = new EntityRabbit(this.world);
        int lvt_3_1_ = this.getRandomRabbitType();
        if (this.rand.nextInt(20) != 0) {
            lvt_3_1_ = p_createChild_1_ instanceof EntityRabbit && this.rand.nextBoolean() ? ((EntityRabbit)p_createChild_1_).getRabbitType() : this.getRabbitType();
        }
        lvt_2_1_.setRabbitType(lvt_3_1_);
        return lvt_2_1_;
    }

    @Override
    public boolean isBreedingItem(ItemStack p_isBreedingItem_1_) {
        return this.isRabbitBreedingItem(p_isBreedingItem_1_.getItem());
    }

    public int getRabbitType() {
        return this.dataManager.get(RABBIT_TYPE);
    }

    public void setRabbitType(int p_setRabbitType_1_) {
        if (p_setRabbitType_1_ == 99) {
            this.getEntityAttribute(SharedMonsterAttributes.ARMOR).setBaseValue(8.0);
            this.tasks.addTask(4, new AIEvilAttack(this));
            this.targetTasks.addTask(1, new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
            this.targetTasks.addTask(2, new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true));
            this.targetTasks.addTask(2, new EntityAINearestAttackableTarget<EntityWolf>((EntityCreature)this, EntityWolf.class, true));
            if (!this.hasCustomName()) {
                this.setCustomNameTag(I18n.translateToLocal("entity.KillerBunny.name"));
            }
        }
        this.dataManager.set(RABBIT_TYPE, p_setRabbitType_1_);
    }

    @Override
    @Nullable
    public IEntityLivingData onInitialSpawn(DifficultyInstance p_onInitialSpawn_1_, IEntityLivingData p_onInitialSpawn_2_) {
        p_onInitialSpawn_2_ = super.onInitialSpawn(p_onInitialSpawn_1_, p_onInitialSpawn_2_);
        int lvt_3_1_ = this.getRandomRabbitType();
        boolean lvt_4_1_ = false;
        if (p_onInitialSpawn_2_ instanceof RabbitTypeData) {
            lvt_3_1_ = ((RabbitTypeData)p_onInitialSpawn_2_).typeData;
            lvt_4_1_ = true;
        } else {
            p_onInitialSpawn_2_ = new RabbitTypeData(lvt_3_1_);
        }
        this.setRabbitType(lvt_3_1_);
        if (lvt_4_1_) {
            this.setGrowingAge(-24000);
        }
        return p_onInitialSpawn_2_;
    }

    private int getRandomRabbitType() {
        Biome lvt_1_1_ = this.world.getBiome(new BlockPos(this));
        int lvt_2_1_ = this.rand.nextInt(100);
        if (lvt_1_1_.isSnowyBiome()) {
            return lvt_2_1_ < 80 ? 1 : 3;
        }
        if (lvt_1_1_ instanceof BiomeDesert) {
            return 4;
        }
        return lvt_2_1_ < 50 ? 0 : (lvt_2_1_ < 90 ? 5 : 2);
    }

    private boolean isCarrotEaten() {
        return this.carrotTicks == 0;
    }

    protected void createEatingParticles() {
        BlockCarrot lvt_1_1_ = (BlockCarrot)Blocks.CARROTS;
        IBlockState lvt_2_1_ = lvt_1_1_.withAge(lvt_1_1_.getMaxAge());
        this.world.spawnParticle(EnumParticleTypes.BLOCK_DUST, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + 0.5 + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, 0.0, 0.0, 0.0, Block.getStateId(lvt_2_1_));
        this.carrotTicks = 40;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte p_handleStatusUpdate_1_) {
        if (p_handleStatusUpdate_1_ == 1) {
            this.createRunningParticles();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.handleStatusUpdate(p_handleStatusUpdate_1_);
        }
    }

    @Override
    public /* synthetic */ EntityAgeable createChild(EntityAgeable p_createChild_1_) {
        return this.createChild(p_createChild_1_);
    }

    static class AIEvilAttack
    extends EntityAIAttackMelee {
        public AIEvilAttack(EntityRabbit p_i45867_1_) {
            super(p_i45867_1_, 1.4, true);
        }

        @Override
        protected double getAttackReachSqr(EntityLivingBase p_getAttackReachSqr_1_) {
            return 4.0f + p_getAttackReachSqr_1_.width;
        }
    }

    static class AIPanic
    extends EntityAIPanic {
        private final EntityRabbit theEntity;

        public AIPanic(EntityRabbit p_i45861_1_, double p_i45861_2_) {
            super(p_i45861_1_, p_i45861_2_);
            this.theEntity = p_i45861_1_;
        }

        @Override
        public void updateTask() {
            super.updateTask();
            this.theEntity.setMovementSpeed(this.speed);
        }
    }

    static class AIRaidFarm
    extends EntityAIMoveToBlock {
        private final EntityRabbit rabbit;
        private boolean wantsToRaid;
        private boolean canRaid;

        public AIRaidFarm(EntityRabbit p_i45860_1_) {
            super(p_i45860_1_, 0.7f, 16);
            this.rabbit = p_i45860_1_;
        }

        @Override
        public boolean shouldExecute() {
            if (this.runDelay <= 0) {
                if (!this.rabbit.world.getGameRules().getBoolean("mobGriefing")) {
                    return false;
                }
                this.canRaid = false;
                this.wantsToRaid = this.rabbit.isCarrotEaten();
                this.wantsToRaid = true;
            }
            return super.shouldExecute();
        }

        @Override
        public boolean continueExecuting() {
            return this.canRaid && super.continueExecuting();
        }

        @Override
        public void updateTask() {
            super.updateTask();
            this.rabbit.getLookHelper().setLookPosition((double)this.destinationBlock.getX() + 0.5, this.destinationBlock.getY() + 1, (double)this.destinationBlock.getZ() + 0.5, 10.0f, this.rabbit.getVerticalFaceSpeed());
            if (this.getIsAboveDestination()) {
                World lvt_1_1_ = this.rabbit.world;
                BlockPos lvt_2_1_ = this.destinationBlock.up();
                IBlockState lvt_3_1_ = lvt_1_1_.getBlockState(lvt_2_1_);
                Block lvt_4_1_ = lvt_3_1_.getBlock();
                if (this.canRaid && lvt_4_1_ instanceof BlockCarrot) {
                    Integer lvt_5_1_ = lvt_3_1_.getValue(BlockCarrot.AGE);
                    if (lvt_5_1_ == 0) {
                        lvt_1_1_.setBlockState(lvt_2_1_, Blocks.AIR.getDefaultState(), 2);
                        lvt_1_1_.destroyBlock(lvt_2_1_, true);
                    } else {
                        lvt_1_1_.setBlockState(lvt_2_1_, lvt_3_1_.withProperty(BlockCarrot.AGE, lvt_5_1_ - 1), 2);
                        lvt_1_1_.playEvent(2001, lvt_2_1_, Block.getStateId(lvt_3_1_));
                    }
                    this.rabbit.createEatingParticles();
                }
                this.canRaid = false;
                this.runDelay = 10;
            }
        }

        @Override
        protected boolean shouldMoveTo(World p_shouldMoveTo_1_, BlockPos p_shouldMoveTo_2_) {
            IBlockState lvt_4_1_;
            Block lvt_3_1_ = p_shouldMoveTo_1_.getBlockState(p_shouldMoveTo_2_).getBlock();
            if (lvt_3_1_ == Blocks.FARMLAND && this.wantsToRaid && !this.canRaid && (lvt_3_1_ = (lvt_4_1_ = p_shouldMoveTo_1_.getBlockState(p_shouldMoveTo_2_ = p_shouldMoveTo_2_.up())).getBlock()) instanceof BlockCarrot && ((BlockCarrot)lvt_3_1_).isMaxAge(lvt_4_1_)) {
                this.canRaid = true;
                return true;
            }
            return false;
        }
    }

    static class AIAvoidEntity<T extends Entity>
    extends EntityAIAvoidEntity<T> {
        private final EntityRabbit entityInstance;

        public AIAvoidEntity(EntityRabbit p_i46403_1_, Class<T> p_i46403_2_, float p_i46403_3_, double p_i46403_4_, double p_i46403_6_) {
            super(p_i46403_1_, p_i46403_2_, p_i46403_3_, p_i46403_4_, p_i46403_6_);
            this.entityInstance = p_i46403_1_;
        }

        @Override
        public boolean shouldExecute() {
            return this.entityInstance.getRabbitType() != 99 && super.shouldExecute();
        }
    }

    static class RabbitMoveHelper
    extends EntityMoveHelper {
        private final EntityRabbit theEntity;
        private double nextJumpSpeed;

        public RabbitMoveHelper(EntityRabbit p_i45862_1_) {
            super(p_i45862_1_);
            this.theEntity = p_i45862_1_;
        }

        @Override
        public void onUpdateMoveHelper() {
            if (this.theEntity.onGround && !this.theEntity.isJumping && !((RabbitJumpHelper)this.theEntity.jumpHelper).getIsJumping()) {
                this.theEntity.setMovementSpeed(0.0);
            } else if (this.isUpdating()) {
                this.theEntity.setMovementSpeed(this.nextJumpSpeed);
            }
            super.onUpdateMoveHelper();
        }

        @Override
        public void setMoveTo(double p_setMoveTo_1_, double p_setMoveTo_3_, double p_setMoveTo_5_, double p_setMoveTo_7_) {
            if (this.theEntity.isInWater()) {
                p_setMoveTo_7_ = 1.5;
            }
            super.setMoveTo(p_setMoveTo_1_, p_setMoveTo_3_, p_setMoveTo_5_, p_setMoveTo_7_);
            if (p_setMoveTo_7_ > 0.0) {
                this.nextJumpSpeed = p_setMoveTo_7_;
            }
        }
    }

    public class RabbitJumpHelper
    extends EntityJumpHelper {
        private final EntityRabbit theEntity;
        private boolean canJump;

        public RabbitJumpHelper(EntityRabbit p_i45863_2_) {
            super(p_i45863_2_);
            this.theEntity = p_i45863_2_;
        }

        public boolean getIsJumping() {
            return this.isJumping;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean p_setCanJump_1_) {
            this.canJump = p_setCanJump_1_;
        }

        @Override
        public void doJump() {
            if (this.isJumping) {
                this.theEntity.startJumping();
                this.isJumping = false;
            }
        }
    }

    public static class RabbitTypeData
    implements IEntityLivingData {
        public int typeData;

        public RabbitTypeData(int p_i45864_1_) {
            this.typeData = p_i45864_1_;
        }
    }
}

