/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import javax.annotation.Nullable;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAISkeletonRiders;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntitySkeletonHorse
extends AbstractHorse {
    private final EntityAISkeletonRiders skeletonTrapAI = new EntityAISkeletonRiders(this);
    private boolean skeletonTrap;
    private int skeletonTrapTime;

    public EntitySkeletonHorse(World p_i47295_1_) {
        super(p_i47295_1_);
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(15.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.2f);
        this.getEntityAttribute(JUMP_STRENGTH).setBaseValue(this.getModifiedJumpStrength());
    }

    @Override
    protected SoundEvent getAmbientSound() {
        super.getAmbientSound();
        return SoundEvents.ENTITY_SKELETON_HORSE_AMBIENT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        super.getDeathSound();
        return SoundEvents.ENTITY_SKELETON_HORSE_DEATH;
    }

    @Override
    protected SoundEvent getHurtSound() {
        super.getHurtSound();
        return SoundEvents.ENTITY_SKELETON_HORSE_HURT;
    }

    @Override
    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Override
    public double getMountedYOffset() {
        return super.getMountedYOffset() - 0.1875;
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_SKELETON_HORSE;
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.isTrap() && this.skeletonTrapTime++ >= 18000) {
            this.setDead();
        }
    }

    public static void registerFixesSkeletonHorse(DataFixer p_registerFixesSkeletonHorse_0_) {
        AbstractHorse.registerFixesAbstractHorse(p_registerFixesSkeletonHorse_0_, EntitySkeletonHorse.class);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setBoolean("SkeletonTrap", this.isTrap());
        p_writeEntityToNBT_1_.setInteger("SkeletonTrapTime", this.skeletonTrapTime);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.setTrap(p_readEntityFromNBT_1_.getBoolean("SkeletonTrap"));
        this.skeletonTrapTime = p_readEntityFromNBT_1_.getInteger("SkeletonTrapTime");
    }

    public boolean isTrap() {
        return this.skeletonTrap;
    }

    public void setTrap(boolean p_setTrap_1_) {
        if (p_setTrap_1_ == this.skeletonTrap) {
            return;
        }
        this.skeletonTrap = p_setTrap_1_;
        if (p_setTrap_1_) {
            this.tasks.addTask(1, this.skeletonTrapAI);
        } else {
            this.tasks.removeTask(this.skeletonTrapAI);
        }
    }

    @Override
    public boolean processInteract(EntityPlayer p_processInteract_1_, EnumHand p_processInteract_2_) {
        boolean lvt_4_1_;
        ItemStack lvt_3_1_ = p_processInteract_1_.getHeldItem(p_processInteract_2_);
        boolean bl = lvt_4_1_ = !lvt_3_1_.isEmpty();
        if (lvt_4_1_ && lvt_3_1_.getItem() == Items.SPAWN_EGG) {
            return super.processInteract(p_processInteract_1_, p_processInteract_2_);
        }
        if (!this.isTame()) {
            return false;
        }
        if (this.isChild()) {
            return super.processInteract(p_processInteract_1_, p_processInteract_2_);
        }
        if (p_processInteract_1_.isSneaking()) {
            this.openGUI(p_processInteract_1_);
            return true;
        }
        if (this.isBeingRidden()) {
            return super.processInteract(p_processInteract_1_, p_processInteract_2_);
        }
        if (lvt_4_1_) {
            if (lvt_3_1_.getItem() == Items.SADDLE && !this.isHorseSaddled()) {
                this.openGUI(p_processInteract_1_);
                return true;
            }
            if (lvt_3_1_.interactWithEntity(p_processInteract_1_, this, p_processInteract_2_)) {
                return true;
            }
        }
        this.mountTo(p_processInteract_1_);
        return true;
    }
}

