/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityTameable
extends EntityAnimal
implements IEntityOwnable {
    protected static final DataParameter<Byte> TAMED = EntityDataManager.createKey(EntityTameable.class, DataSerializers.BYTE);
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.createKey(EntityTameable.class, DataSerializers.OPTIONAL_UNIQUE_ID);
    protected EntityAISit aiSit;

    public EntityTameable(World p_i1604_1_) {
        super(p_i1604_1_);
        this.setupTamedAI();
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(TAMED, (byte)0);
        this.dataManager.register(OWNER_UNIQUE_ID, Optional.absent());
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        if (this.getOwnerId() == null) {
            p_writeEntityToNBT_1_.setString("OwnerUUID", "");
        } else {
            p_writeEntityToNBT_1_.setString("OwnerUUID", this.getOwnerId().toString());
        }
        p_writeEntityToNBT_1_.setBoolean("Sitting", this.isSitting());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        String lvt_2_2_;
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        if (p_readEntityFromNBT_1_.hasKey("OwnerUUID", 8)) {
            String lvt_2_1_ = p_readEntityFromNBT_1_.getString("OwnerUUID");
        } else {
            String lvt_3_1_ = p_readEntityFromNBT_1_.getString("Owner");
            lvt_2_2_ = PreYggdrasilConverter.convertMobOwnerIfNeeded(this.getServer(), lvt_3_1_);
        }
        if (!lvt_2_2_.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(lvt_2_2_));
                this.setTamed(true);
            }
            catch (Throwable lvt_3_2_) {
                this.setTamed(false);
            }
        }
        if (this.aiSit != null) {
            this.aiSit.setSitting(p_readEntityFromNBT_1_.getBoolean("Sitting"));
        }
        this.setSitting(p_readEntityFromNBT_1_.getBoolean("Sitting"));
    }

    @Override
    public boolean canBeLeashedTo(EntityPlayer p_canBeLeashedTo_1_) {
        return !this.getLeashed();
    }

    protected void playTameEffect(boolean p_playTameEffect_1_) {
        EnumParticleTypes lvt_2_1_ = EnumParticleTypes.HEART;
        if (!p_playTameEffect_1_) {
            lvt_2_1_ = EnumParticleTypes.SMOKE_NORMAL;
        }
        for (int lvt_3_1_ = 0; lvt_3_1_ < 7; ++lvt_3_1_) {
            double lvt_4_1_ = this.rand.nextGaussian() * 0.02;
            double lvt_6_1_ = this.rand.nextGaussian() * 0.02;
            double lvt_8_1_ = this.rand.nextGaussian() * 0.02;
            this.world.spawnParticle(lvt_2_1_, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + 0.5 + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, lvt_4_1_, lvt_6_1_, lvt_8_1_, new int[0]);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte p_handleStatusUpdate_1_) {
        if (p_handleStatusUpdate_1_ == 7) {
            this.playTameEffect(true);
        } else if (p_handleStatusUpdate_1_ == 6) {
            this.playTameEffect(false);
        } else {
            super.handleStatusUpdate(p_handleStatusUpdate_1_);
        }
    }

    public boolean isTamed() {
        return (this.dataManager.get(TAMED) & 4) != 0;
    }

    public void setTamed(boolean p_setTamed_1_) {
        byte lvt_2_1_ = this.dataManager.get(TAMED);
        if (p_setTamed_1_) {
            this.dataManager.set(TAMED, (byte)(lvt_2_1_ | 4));
        } else {
            this.dataManager.set(TAMED, (byte)(lvt_2_1_ & 0xFFFFFFFB));
        }
        this.setupTamedAI();
    }

    protected void setupTamedAI() {
    }

    public boolean isSitting() {
        return (this.dataManager.get(TAMED) & 1) != 0;
    }

    public void setSitting(boolean p_setSitting_1_) {
        byte lvt_2_1_ = this.dataManager.get(TAMED);
        if (p_setSitting_1_) {
            this.dataManager.set(TAMED, (byte)(lvt_2_1_ | 1));
        } else {
            this.dataManager.set(TAMED, (byte)(lvt_2_1_ & 0xFFFFFFFE));
        }
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return (UUID)this.dataManager.get(OWNER_UNIQUE_ID).orNull();
    }

    public void setOwnerId(UUID p_setOwnerId_1_) {
        this.dataManager.set(OWNER_UNIQUE_ID, Optional.fromNullable((Object)p_setOwnerId_1_));
    }

    @Override
    @Nullable
    public EntityLivingBase getOwner() {
        try {
            UUID lvt_1_1_ = this.getOwnerId();
            if (lvt_1_1_ == null) {
                return null;
            }
            return this.world.getPlayerEntityByUUID(lvt_1_1_);
        }
        catch (IllegalArgumentException lvt_1_2_) {
            return null;
        }
    }

    public boolean isOwner(EntityLivingBase p_isOwner_1_) {
        return p_isOwner_1_ == this.getOwner();
    }

    public EntityAISit getAISit() {
        return this.aiSit;
    }

    public boolean shouldAttackEntity(EntityLivingBase p_shouldAttackEntity_1_, EntityLivingBase p_shouldAttackEntity_2_) {
        return true;
    }

    @Override
    public Team getTeam() {
        EntityLivingBase lvt_1_1_;
        if (this.isTamed() && (lvt_1_1_ = this.getOwner()) != null) {
            return lvt_1_1_.getTeam();
        }
        return super.getTeam();
    }

    @Override
    public boolean isOnSameTeam(Entity p_isOnSameTeam_1_) {
        if (this.isTamed()) {
            EntityLivingBase lvt_2_1_ = this.getOwner();
            if (p_isOnSameTeam_1_ == lvt_2_1_) {
                return true;
            }
            if (lvt_2_1_ != null) {
                return lvt_2_1_.isOnSameTeam(p_isOnSameTeam_1_);
            }
        }
        return super.isOnSameTeam(p_isOnSameTeam_1_);
    }

    @Override
    public void onDeath(DamageSource p_onDeath_1_) {
        if (!this.world.isRemote && this.world.getGameRules().getBoolean("showDeathMessages") && this.getOwner() instanceof EntityPlayerMP) {
            this.getOwner().sendMessage(this.getCombatTracker().getDeathMessage());
        }
        super.onDeath(p_onDeath_1_);
    }

    @Override
    @Nullable
    public /* synthetic */ Entity getOwner() {
        return this.getOwner();
    }
}

