/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.base.Predicate;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBeg;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityWolf
extends EntityTameable {
    private static final DataParameter<Float> DATA_HEALTH_ID = EntityDataManager.createKey(EntityWolf.class, DataSerializers.FLOAT);
    private static final DataParameter<Boolean> BEGGING = EntityDataManager.createKey(EntityWolf.class, DataSerializers.BOOLEAN);
    private static final DataParameter<Integer> COLLAR_COLOR = EntityDataManager.createKey(EntityWolf.class, DataSerializers.VARINT);
    private float headRotationCourse;
    private float headRotationCourseOld;
    private boolean isWet;
    private boolean isShaking;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;

    public EntityWolf(World p_i1696_1_) {
        super(p_i1696_1_);
        this.setSize(0.6f, 0.85f);
        this.setTamed(false);
    }

    @Override
    protected void initEntityAI() {
        this.aiSit = new EntityAISit(this);
        this.tasks.addTask(1, new EntityAISwimming(this));
        this.tasks.addTask(2, this.aiSit);
        this.tasks.addTask(3, new AIAvoidEntity<EntityLlama>(this, EntityLlama.class, 24.0f, 1.5, 1.5));
        this.tasks.addTask(4, new EntityAILeapAtTarget(this, 0.4f));
        this.tasks.addTask(5, new EntityAIAttackMelee(this, 1.0, true));
        this.tasks.addTask(6, new EntityAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.tasks.addTask(7, new EntityAIMate(this, 1.0));
        this.tasks.addTask(8, new EntityAIWanderAvoidWater(this, 1.0));
        this.tasks.addTask(9, new EntityAIBeg(this, 8.0f));
        this.tasks.addTask(10, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(10, new EntityAILookIdle(this));
        this.targetTasks.addTask(1, new EntityAIOwnerHurtByTarget(this));
        this.targetTasks.addTask(2, new EntityAIOwnerHurtTarget(this));
        this.targetTasks.addTask(3, new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.targetTasks.addTask(4, new EntityAITargetNonTamed<Entity>(this, EntityAnimal.class, false, new Predicate<Entity>(){

            public boolean apply(Entity p_apply_1_) {
                return p_apply_1_ instanceof EntitySheep || p_apply_1_ instanceof EntityRabbit;
            }

            public /* synthetic */ boolean apply(Object p_apply_1_) {
                return this.apply((Entity)p_apply_1_);
            }
        }));
        this.targetTasks.addTask(5, new EntityAINearestAttackableTarget<AbstractSkeleton>((EntityCreature)this, AbstractSkeleton.class, false));
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.3f);
        if (this.isTamed()) {
            this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(20.0);
        } else {
            this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(8.0);
        }
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(2.0);
    }

    @Override
    public void setAttackTarget(EntityLivingBase p_setAttackTarget_1_) {
        super.setAttackTarget(p_setAttackTarget_1_);
        if (p_setAttackTarget_1_ == null) {
            this.setAngry(false);
        } else if (!this.isTamed()) {
            this.setAngry(true);
        }
    }

    @Override
    protected void updateAITasks() {
        this.dataManager.set(DATA_HEALTH_ID, Float.valueOf(this.getHealth()));
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(DATA_HEALTH_ID, Float.valueOf(this.getHealth()));
        this.dataManager.register(BEGGING, false);
        this.dataManager.register(COLLAR_COLOR, EnumDyeColor.RED.getDyeDamage());
    }

    @Override
    protected void playStepSound(BlockPos p_playStepSound_1_, Block p_playStepSound_2_) {
        this.playSound(SoundEvents.ENTITY_WOLF_STEP, 0.15f, 1.0f);
    }

    public static void registerFixesWolf(DataFixer p_registerFixesWolf_0_) {
        EntityLiving.registerFixesMob(p_registerFixesWolf_0_, EntityWolf.class);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setBoolean("Angry", this.isAngry());
        p_writeEntityToNBT_1_.setByte("CollarColor", (byte)this.getCollarColor().getDyeDamage());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.setAngry(p_readEntityFromNBT_1_.getBoolean("Angry"));
        if (p_readEntityFromNBT_1_.hasKey("CollarColor", 99)) {
            this.setCollarColor(EnumDyeColor.byDyeDamage(p_readEntityFromNBT_1_.getByte("CollarColor")));
        }
    }

    @Override
    protected SoundEvent getAmbientSound() {
        if (this.isAngry()) {
            return SoundEvents.ENTITY_WOLF_GROWL;
        }
        if (this.rand.nextInt(3) == 0) {
            if (this.isTamed() && this.dataManager.get(DATA_HEALTH_ID).floatValue() < 10.0f) {
                return SoundEvents.ENTITY_WOLF_WHINE;
            }
            return SoundEvents.ENTITY_WOLF_PANT;
        }
        return SoundEvents.ENTITY_WOLF_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_WOLF_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_WOLF_DEATH;
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_WOLF;
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (!this.world.isRemote && this.isWet && !this.isShaking && !this.hasPath() && this.onGround) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
            this.world.setEntityState(this, (byte)8);
        }
        if (!this.world.isRemote && this.getAttackTarget() == null && this.isAngry()) {
            this.setAngry(false);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.headRotationCourseOld = this.headRotationCourse;
        this.headRotationCourse = this.isBegging() ? (this.headRotationCourse += (1.0f - this.headRotationCourse) * 0.4f) : (this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f);
        if (this.isWet()) {
            this.isWet = true;
            this.isShaking = false;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else if ((this.isWet || this.isShaking) && this.isShaking) {
            if (this.timeWolfIsShaking == 0.0f) {
                this.playSound(SoundEvents.ENTITY_WOLF_SHAKE, this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
            this.timeWolfIsShaking += 0.05f;
            if (this.prevTimeWolfIsShaking >= 2.0f) {
                this.isWet = false;
                this.isShaking = false;
                this.prevTimeWolfIsShaking = 0.0f;
                this.timeWolfIsShaking = 0.0f;
            }
            if (this.timeWolfIsShaking > 0.4f) {
                float lvt_1_1_ = (float)this.getEntityBoundingBox().minY;
                int lvt_2_1_ = (int)(MathHelper.sin((this.timeWolfIsShaking - 0.4f) * (float)Math.PI) * 7.0f);
                for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_1_; ++lvt_3_1_) {
                    float lvt_4_1_ = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width * 0.5f;
                    float lvt_5_1_ = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width * 0.5f;
                    this.world.spawnParticle(EnumParticleTypes.WATER_SPLASH, this.posX + (double)lvt_4_1_, (double)(lvt_1_1_ + 0.8f), this.posZ + (double)lvt_5_1_, this.motionX, this.motionY, this.motionZ, new int[0]);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isWolfWet() {
        return this.isWet;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadingWhileWet(float p_getShadingWhileWet_1_) {
        return 0.75f + (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * p_getShadingWhileWet_1_) / 2.0f * 0.25f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShakeAngle(float p_getShakeAngle_1_, float p_getShakeAngle_2_) {
        float lvt_3_1_ = (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * p_getShakeAngle_1_ + p_getShakeAngle_2_) / 1.8f;
        if (lvt_3_1_ < 0.0f) {
            lvt_3_1_ = 0.0f;
        } else if (lvt_3_1_ > 1.0f) {
            lvt_3_1_ = 1.0f;
        }
        return MathHelper.sin(lvt_3_1_ * (float)Math.PI) * MathHelper.sin(lvt_3_1_ * (float)Math.PI * 11.0f) * 0.15f * (float)Math.PI;
    }

    @SideOnly(value=Side.CLIENT)
    public float getInterestedAngle(float p_getInterestedAngle_1_) {
        return (this.headRotationCourseOld + (this.headRotationCourse - this.headRotationCourseOld) * p_getInterestedAngle_1_) * 0.15f * (float)Math.PI;
    }

    @Override
    public float getEyeHeight() {
        return this.height * 0.8f;
    }

    @Override
    public int getVerticalFaceSpeed() {
        if (this.isSitting()) {
            return 20;
        }
        return super.getVerticalFaceSpeed();
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        if (this.isEntityInvulnerable(p_attackEntityFrom_1_)) {
            return false;
        }
        Entity lvt_3_1_ = p_attackEntityFrom_1_.getEntity();
        if (this.aiSit != null) {
            this.aiSit.setSitting(false);
        }
        if (lvt_3_1_ != null && !(lvt_3_1_ instanceof EntityPlayer) && !(lvt_3_1_ instanceof EntityArrow)) {
            p_attackEntityFrom_2_ = (p_attackEntityFrom_2_ + 1.0f) / 2.0f;
        }
        return super.attackEntityFrom(p_attackEntityFrom_1_, p_attackEntityFrom_2_);
    }

    @Override
    public boolean attackEntityAsMob(Entity p_attackEntityAsMob_1_) {
        boolean lvt_2_1_ = p_attackEntityAsMob_1_.attackEntityFrom(DamageSource.causeMobDamage(this), (int)this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).getAttributeValue());
        if (lvt_2_1_) {
            this.applyEnchantments(this, p_attackEntityAsMob_1_);
        }
        return lvt_2_1_;
    }

    @Override
    public void setTamed(boolean p_setTamed_1_) {
        super.setTamed(p_setTamed_1_);
        if (p_setTamed_1_) {
            this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(20.0);
        } else {
            this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(8.0);
        }
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(4.0);
    }

    @Override
    public boolean processInteract(EntityPlayer p_processInteract_1_, EnumHand p_processInteract_2_) {
        ItemStack lvt_3_1_ = p_processInteract_1_.getHeldItem(p_processInteract_2_);
        if (this.isTamed()) {
            if (!lvt_3_1_.isEmpty()) {
                EnumDyeColor lvt_4_2_;
                if (lvt_3_1_.getItem() instanceof ItemFood) {
                    ItemFood lvt_4_1_ = (ItemFood)lvt_3_1_.getItem();
                    if (lvt_4_1_.isWolfsFavoriteMeat() && this.dataManager.get(DATA_HEALTH_ID).floatValue() < 20.0f) {
                        if (!p_processInteract_1_.capabilities.isCreativeMode) {
                            lvt_3_1_.shrink(1);
                        }
                        this.heal(lvt_4_1_.getHealAmount(lvt_3_1_));
                        return true;
                    }
                } else if (lvt_3_1_.getItem() == Items.DYE && (lvt_4_2_ = EnumDyeColor.byDyeDamage(lvt_3_1_.getMetadata())) != this.getCollarColor()) {
                    this.setCollarColor(lvt_4_2_);
                    if (!p_processInteract_1_.capabilities.isCreativeMode) {
                        lvt_3_1_.shrink(1);
                    }
                    return true;
                }
            }
            if (this.isOwner(p_processInteract_1_) && !this.world.isRemote && !this.isBreedingItem(lvt_3_1_)) {
                this.aiSit.setSitting(!this.isSitting());
                this.isJumping = false;
                this.navigator.clearPathEntity();
                this.setAttackTarget(null);
            }
        } else if (lvt_3_1_.getItem() == Items.BONE && !this.isAngry()) {
            if (!p_processInteract_1_.capabilities.isCreativeMode) {
                lvt_3_1_.shrink(1);
            }
            if (!this.world.isRemote) {
                if (this.rand.nextInt(3) == 0) {
                    this.setTamed(true);
                    this.navigator.clearPathEntity();
                    this.setAttackTarget(null);
                    this.aiSit.setSitting(true);
                    this.setHealth(20.0f);
                    this.setOwnerId(p_processInteract_1_.getUniqueID());
                    this.playTameEffect(true);
                    this.world.setEntityState(this, (byte)7);
                } else {
                    this.playTameEffect(false);
                    this.world.setEntityState(this, (byte)6);
                }
            }
            return true;
        }
        return super.processInteract(p_processInteract_1_, p_processInteract_2_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte p_handleStatusUpdate_1_) {
        if (p_handleStatusUpdate_1_ == 8) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else {
            super.handleStatusUpdate(p_handleStatusUpdate_1_);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailRotation() {
        if (this.isAngry()) {
            return 1.5393804f;
        }
        if (this.isTamed()) {
            return (0.55f - (this.getMaxHealth() - this.dataManager.get(DATA_HEALTH_ID).floatValue()) * 0.02f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public boolean isBreedingItem(ItemStack p_isBreedingItem_1_) {
        return p_isBreedingItem_1_.getItem() instanceof ItemFood && ((ItemFood)p_isBreedingItem_1_.getItem()).isWolfsFavoriteMeat();
    }

    @Override
    public int getMaxSpawnedInChunk() {
        return 8;
    }

    public boolean isAngry() {
        return ((Byte)this.dataManager.get(TAMED) & 2) != 0;
    }

    public void setAngry(boolean p_setAngry_1_) {
        byte lvt_2_1_ = (Byte)this.dataManager.get(TAMED);
        if (p_setAngry_1_) {
            this.dataManager.set(TAMED, (byte)(lvt_2_1_ | 2));
        } else {
            this.dataManager.set(TAMED, (byte)(lvt_2_1_ & 0xFFFFFFFD));
        }
    }

    public EnumDyeColor getCollarColor() {
        return EnumDyeColor.byDyeDamage(this.dataManager.get(COLLAR_COLOR) & 0xF);
    }

    public void setCollarColor(EnumDyeColor p_setCollarColor_1_) {
        this.dataManager.set(COLLAR_COLOR, p_setCollarColor_1_.getDyeDamage());
    }

    @Override
    public EntityWolf createChild(EntityAgeable p_createChild_1_) {
        EntityWolf lvt_2_1_ = new EntityWolf(this.world);
        UUID lvt_3_1_ = this.getOwnerId();
        if (lvt_3_1_ != null) {
            lvt_2_1_.setOwnerId(lvt_3_1_);
            lvt_2_1_.setTamed(true);
        }
        return lvt_2_1_;
    }

    public void setBegging(boolean p_setBegging_1_) {
        this.dataManager.set(BEGGING, p_setBegging_1_);
    }

    @Override
    public boolean canMateWith(EntityAnimal p_canMateWith_1_) {
        if (p_canMateWith_1_ == this) {
            return false;
        }
        if (!this.isTamed()) {
            return false;
        }
        if (!(p_canMateWith_1_ instanceof EntityWolf)) {
            return false;
        }
        EntityWolf lvt_2_1_ = (EntityWolf)p_canMateWith_1_;
        if (!lvt_2_1_.isTamed()) {
            return false;
        }
        if (lvt_2_1_.isSitting()) {
            return false;
        }
        return this.isInLove() && lvt_2_1_.isInLove();
    }

    public boolean isBegging() {
        return this.dataManager.get(BEGGING);
    }

    @Override
    public boolean shouldAttackEntity(EntityLivingBase p_shouldAttackEntity_1_, EntityLivingBase p_shouldAttackEntity_2_) {
        EntityWolf lvt_3_1_;
        if (p_shouldAttackEntity_1_ instanceof EntityCreeper || p_shouldAttackEntity_1_ instanceof EntityGhast) {
            return false;
        }
        if (p_shouldAttackEntity_1_ instanceof EntityWolf && (lvt_3_1_ = (EntityWolf)p_shouldAttackEntity_1_).isTamed() && lvt_3_1_.getOwner() == p_shouldAttackEntity_2_) {
            return false;
        }
        if (p_shouldAttackEntity_1_ instanceof EntityPlayer && p_shouldAttackEntity_2_ instanceof EntityPlayer && !((EntityPlayer)p_shouldAttackEntity_2_).canAttackPlayer((EntityPlayer)p_shouldAttackEntity_1_)) {
            return false;
        }
        return !(p_shouldAttackEntity_1_ instanceof AbstractHorse) || !((AbstractHorse)p_shouldAttackEntity_1_).isTame();
    }

    @Override
    public boolean canBeLeashedTo(EntityPlayer p_canBeLeashedTo_1_) {
        return !this.isAngry() && super.canBeLeashedTo(p_canBeLeashedTo_1_);
    }

    @Override
    public /* synthetic */ EntityAgeable createChild(EntityAgeable p_createChild_1_) {
        return this.createChild(p_createChild_1_);
    }

    class AIAvoidEntity<T extends Entity>
    extends EntityAIAvoidEntity<T> {
        private final EntityWolf wolf;

        public AIAvoidEntity(EntityWolf p_i47251_2_, Class<T> p_i47251_3_, float p_i47251_4_, double p_i47251_5_, double p_i47251_7_) {
            super(p_i47251_2_, p_i47251_3_, p_i47251_4_, p_i47251_5_, p_i47251_7_);
            this.wolf = p_i47251_2_;
        }

        @Override
        public boolean shouldExecute() {
            if (super.shouldExecute() && this.closestLivingEntity instanceof EntityLlama) {
                return !this.wolf.isTamed() && this.avoidLlama((EntityLlama)this.closestLivingEntity);
            }
            return false;
        }

        private boolean avoidLlama(EntityLlama p_avoidLlama_1_) {
            return p_avoidLlama_1_.getStrength() >= EntityWolf.this.rand.nextInt(5);
        }

        @Override
        public void startExecuting() {
            EntityWolf.this.setAttackTarget(null);
            super.startExecuting();
        }

        @Override
        public void updateTask() {
            EntityWolf.this.setAttackTarget(null);
            super.updateTask();
        }
    }
}

