/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import javax.annotation.Nullable;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityZombieHorse
extends AbstractHorse {
    public EntityZombieHorse(World p_i47293_1_) {
        super(p_i47293_1_);
    }

    public static void registerFixesZombieHorse(DataFixer p_registerFixesZombieHorse_0_) {
        AbstractHorse.registerFixesAbstractHorse(p_registerFixesZombieHorse_0_, EntityZombieHorse.class);
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(15.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.2f);
        this.getEntityAttribute(JUMP_STRENGTH).setBaseValue(this.getModifiedJumpStrength());
    }

    @Override
    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        super.getAmbientSound();
        return SoundEvents.ENTITY_ZOMBIE_HORSE_AMBIENT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        super.getDeathSound();
        return SoundEvents.ENTITY_ZOMBIE_HORSE_DEATH;
    }

    @Override
    protected SoundEvent getHurtSound() {
        super.getHurtSound();
        return SoundEvents.ENTITY_ZOMBIE_HORSE_HURT;
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_ZOMBIE_HORSE;
    }

    @Override
    public boolean processInteract(EntityPlayer p_processInteract_1_, EnumHand p_processInteract_2_) {
        boolean lvt_4_1_;
        ItemStack lvt_3_1_ = p_processInteract_1_.getHeldItem(p_processInteract_2_);
        boolean bl = lvt_4_1_ = !lvt_3_1_.isEmpty();
        if (lvt_4_1_ && lvt_3_1_.getItem() == Items.SPAWN_EGG) {
            return super.processInteract(p_processInteract_1_, p_processInteract_2_);
        }
        if (!this.isTame()) {
            return false;
        }
        if (this.isChild()) {
            return super.processInteract(p_processInteract_1_, p_processInteract_2_);
        }
        if (p_processInteract_1_.isSneaking()) {
            this.openGUI(p_processInteract_1_);
            return true;
        }
        if (this.isBeingRidden()) {
            return super.processInteract(p_processInteract_1_, p_processInteract_2_);
        }
        if (lvt_4_1_) {
            if (!this.isHorseSaddled() && lvt_3_1_.getItem() == Items.SADDLE) {
                this.openGUI(p_processInteract_1_);
                return true;
            }
            if (lvt_3_1_.interactWithEntity(p_processInteract_1_, this, p_processInteract_2_)) {
                return true;
            }
        }
        this.mountTo(p_processInteract_1_);
        return true;
    }
}

