/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum HorseArmorType {
    NONE(0),
    IRON(5, "iron", "meo"),
    GOLD(7, "gold", "goo"),
    DIAMOND(11, "diamond", "dio");

    private final String textureName;
    private final String hash;
    private final int protection;

    private HorseArmorType(int p_i46799_3_) {
        this.protection = p_i46799_3_;
        this.textureName = null;
        this.hash = "";
    }

    private HorseArmorType(int p_i46800_3_, String p_i46800_4_, String p_i46800_5_) {
        this.protection = p_i46800_3_;
        this.textureName = "textures/entity/horse/armor/horse_armor_" + p_i46800_4_ + ".png";
        this.hash = p_i46800_5_;
    }

    public int getOrdinal() {
        return this.ordinal();
    }

    @SideOnly(value=Side.CLIENT)
    public String getHash() {
        return this.hash;
    }

    public int getProtection() {
        return this.protection;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public String getTextureName() {
        return this.textureName;
    }

    public static HorseArmorType getByOrdinal(int p_getByOrdinal_0_) {
        return HorseArmorType.values()[p_getByOrdinal_0_];
    }

    public static HorseArmorType getByItemStack(ItemStack p_getByItemStack_0_) {
        return p_getByItemStack_0_.isEmpty() ? NONE : HorseArmorType.getByItem(p_getByItemStack_0_.getItem());
    }

    public static HorseArmorType getByItem(Item p_getByItem_0_) {
        if (p_getByItem_0_ == Items.IRON_HORSE_ARMOR) {
            return IRON;
        }
        if (p_getByItem_0_ == Items.GOLDEN_HORSE_ARMOR) {
            return GOLD;
        }
        if (p_getByItem_0_ == Items.DIAMOND_HORSE_ARMOR) {
            return DIAMOND;
        }
        return NONE;
    }

    public static boolean isHorseArmor(Item p_isHorseArmor_0_) {
        return HorseArmorType.getByItem(p_isHorseArmor_0_) != NONE;
    }
}

