/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.player;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.FoodStats;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataFixer;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.LockCode;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.PlayerArmorInvWrapper;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.items.wrapper.PlayerOffhandInvWrapper;

public abstract class EntityPlayer
extends EntityLivingBase {
    public static final String PERSISTED_NBT_TAG = "PlayerPersisted";
    private HashMap<Integer, BlockPos> spawnChunkMap = new HashMap();
    private HashMap<Integer, Boolean> spawnForcedMap = new HashMap();
    public float eyeHeight = this.getDefaultEyeHeight();
    private static final DataParameter<Float> ABSORPTION = EntityDataManager.createKey(EntityPlayer.class, DataSerializers.FLOAT);
    private static final DataParameter<Integer> PLAYER_SCORE = EntityDataManager.createKey(EntityPlayer.class, DataSerializers.VARINT);
    protected static final DataParameter<Byte> PLAYER_MODEL_FLAG = EntityDataManager.createKey(EntityPlayer.class, DataSerializers.BYTE);
    protected static final DataParameter<Byte> MAIN_HAND = EntityDataManager.createKey(EntityPlayer.class, DataSerializers.BYTE);
    public InventoryPlayer inventory = new InventoryPlayer(this);
    private InventoryEnderChest theInventoryEnderChest = new InventoryEnderChest();
    public Container inventoryContainer;
    public Container openContainer;
    protected FoodStats foodStats = new FoodStats();
    protected int flyToggleTimer;
    public float prevCameraYaw;
    public float cameraYaw;
    public int xpCooldown;
    public double prevChasingPosX;
    public double prevChasingPosY;
    public double prevChasingPosZ;
    public double chasingPosX;
    public double chasingPosY;
    public double chasingPosZ;
    protected boolean sleeping;
    public BlockPos bedLocation;
    private int sleepTimer;
    public float renderOffsetX;
    @SideOnly(value=Side.CLIENT)
    public float renderOffsetY;
    public float renderOffsetZ;
    private BlockPos spawnChunk;
    private boolean spawnForced;
    private BlockPos startMinecartRidingCoordinate;
    public PlayerCapabilities capabilities = new PlayerCapabilities();
    public int experienceLevel;
    public int experienceTotal;
    public float experience;
    private int xpSeed;
    protected float speedOnGround = 0.1f;
    protected float speedInAir = 0.02f;
    private int lastXPSound;
    private final GameProfile gameProfile;
    @SideOnly(value=Side.CLIENT)
    private boolean hasReducedDebug;
    private ItemStack itemStackMainHand = ItemStack.EMPTY;
    private final CooldownTracker cooldownTracker = this.createCooldownTracker();
    @Nullable
    public EntityFishHook fishEntity;
    private String displayname;
    private final Collection<ITextComponent> prefixes = new LinkedList<ITextComponent>();
    private final Collection<ITextComponent> suffixes = new LinkedList<ITextComponent>();
    private final IItemHandler playerMainHandler = new PlayerMainInvWrapper(this.inventory);
    private final IItemHandler playerEquipmentHandler = new CombinedInvWrapper(new PlayerArmorInvWrapper(this.inventory), new PlayerOffhandInvWrapper(this.inventory));
    private final IItemHandler playerJoinedHandler = new PlayerInvWrapper(this.inventory);

    protected CooldownTracker createCooldownTracker() {
        return new CooldownTracker();
    }

    public EntityPlayer(World p_i45324_1_, GameProfile p_i45324_2_) {
        super(p_i45324_1_);
        this.setUniqueId(EntityPlayer.getUUID(p_i45324_2_));
        this.gameProfile = p_i45324_2_;
        this.openContainer = this.inventoryContainer = new ContainerPlayer(this.inventory, !p_i45324_1_.isRemote, this);
        BlockPos blockpos = p_i45324_1_.getSpawnPoint();
        this.setLocationAndAngles((double)blockpos.getX() + 0.5, blockpos.getY() + 1, (double)blockpos.getZ() + 0.5, 0.0f, 0.0f);
        this.unused180 = 180.0f;
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(1.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.1f);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.ATTACK_SPEED);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.LUCK);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(ABSORPTION, Float.valueOf(0.0f));
        this.dataManager.register(PLAYER_SCORE, 0);
        this.dataManager.register(PLAYER_MODEL_FLAG, (byte)0);
        this.dataManager.register(MAIN_HAND, (byte)1);
    }

    @Override
    public void onUpdate() {
        FMLCommonHandler.instance().onPlayerPreTick(this);
        this.noClip = this.isSpectator();
        if (this.isSpectator()) {
            this.onGround = false;
        }
        if (this.xpCooldown > 0) {
            --this.xpCooldown;
        }
        if (this.isPlayerSleeping()) {
            ++this.sleepTimer;
            if (this.sleepTimer > 100) {
                this.sleepTimer = 100;
            }
            if (!this.world.isRemote) {
                if (!this.isInBed()) {
                    this.wakeUpPlayer(true, true, false);
                } else if (this.world.isDaytime()) {
                    this.wakeUpPlayer(false, true, true);
                }
            }
        } else if (this.sleepTimer > 0) {
            ++this.sleepTimer;
            if (this.sleepTimer >= 110) {
                this.sleepTimer = 0;
            }
        }
        super.onUpdate();
        if (!this.world.isRemote && this.openContainer != null && !this.openContainer.canInteractWith(this)) {
            this.closeScreen();
            this.openContainer = this.inventoryContainer;
        }
        if (this.isBurning() && this.capabilities.disableDamage) {
            this.extinguish();
        }
        this.updateCape();
        if (!this.isRiding()) {
            this.startMinecartRidingCoordinate = null;
        }
        if (!this.world.isRemote) {
            this.foodStats.onUpdate(this);
            this.addStat(StatList.PLAY_ONE_MINUTE);
            if (this.isEntityAlive()) {
                this.addStat(StatList.TIME_SINCE_DEATH);
            }
            if (this.isSneaking()) {
                this.addStat(StatList.SNEAK_TIME);
            }
        }
        int i = 29999999;
        double d0 = MathHelper.clamp(this.posX, -2.9999999E7, 2.9999999E7);
        double d1 = MathHelper.clamp(this.posZ, -2.9999999E7, 2.9999999E7);
        if (d0 != this.posX || d1 != this.posZ) {
            this.setPosition(d0, this.posY, d1);
        }
        ++this.ticksSinceLastSwing;
        ItemStack itemstack = this.getHeldItemMainhand();
        if (!ItemStack.areItemStacksEqual(this.itemStackMainHand, itemstack)) {
            if (!ItemStack.areItemsEqualIgnoreDurability(this.itemStackMainHand, itemstack)) {
                this.resetCooldown();
            }
            this.itemStackMainHand = itemstack.isEmpty() ? ItemStack.EMPTY : itemstack.copy();
        }
        this.cooldownTracker.tick();
        this.updateSize();
    }

    private void updateCape() {
        this.prevChasingPosX = this.chasingPosX;
        this.prevChasingPosY = this.chasingPosY;
        this.prevChasingPosZ = this.chasingPosZ;
        double d0 = this.posX - this.chasingPosX;
        double d1 = this.posY - this.chasingPosY;
        double d2 = this.posZ - this.chasingPosZ;
        double d3 = 10.0;
        if (d0 > 10.0) {
            this.prevChasingPosX = this.chasingPosX = this.posX;
        }
        if (d2 > 10.0) {
            this.prevChasingPosZ = this.chasingPosZ = this.posZ;
        }
        if (d1 > 10.0) {
            this.prevChasingPosY = this.chasingPosY = this.posY;
        }
        if (d0 < -10.0) {
            this.prevChasingPosX = this.chasingPosX = this.posX;
        }
        if (d2 < -10.0) {
            this.prevChasingPosZ = this.chasingPosZ = this.posZ;
        }
        if (d1 < -10.0) {
            this.prevChasingPosY = this.chasingPosY = this.posY;
        }
        this.chasingPosX += d0 * 0.25;
        this.chasingPosZ += d2 * 0.25;
        this.chasingPosY += d1 * 0.25;
    }

    protected void updateSize() {
        float f1;
        float f;
        if (this.isElytraFlying()) {
            f = 0.6f;
            f1 = 0.6f;
        } else if (this.isPlayerSleeping()) {
            f = 0.2f;
            f1 = 0.2f;
        } else if (this.isSneaking()) {
            f = 0.6f;
            f1 = 1.65f;
        } else {
            f = 0.6f;
            f1 = 1.8f;
        }
        if (f != this.width || f1 != this.height) {
            AxisAlignedBB axisalignedbb = this.getEntityBoundingBox();
            axisalignedbb = new AxisAlignedBB(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ, axisalignedbb.minX + (double)f, axisalignedbb.minY + (double)f1, axisalignedbb.minZ + (double)f);
            if (!this.world.collidesWithAnyBlock(axisalignedbb)) {
                this.setSize(f, f1);
            }
        }
        FMLCommonHandler.instance().onPlayerPostTick(this);
    }

    @Override
    public int getMaxInPortalTime() {
        return this.capabilities.disableDamage ? 1 : 80;
    }

    @Override
    protected SoundEvent getSwimSound() {
        return SoundEvents.ENTITY_PLAYER_SWIM;
    }

    @Override
    protected SoundEvent getSplashSound() {
        return SoundEvents.ENTITY_PLAYER_SPLASH;
    }

    @Override
    public int getPortalCooldown() {
        return 10;
    }

    @Override
    public void playSound(SoundEvent p_playSound_1_, float p_playSound_2_, float p_playSound_3_) {
        this.world.playSound(this, this.posX, this.posY, this.posZ, p_playSound_1_, this.getSoundCategory(), p_playSound_2_, p_playSound_3_);
    }

    @Override
    public SoundCategory getSoundCategory() {
        return SoundCategory.PLAYERS;
    }

    @Override
    protected int getFireImmuneTicks() {
        return 20;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte p_handleStatusUpdate_1_) {
        if (p_handleStatusUpdate_1_ == 9) {
            this.onItemUseFinish();
        } else if (p_handleStatusUpdate_1_ == 23) {
            this.hasReducedDebug = false;
        } else if (p_handleStatusUpdate_1_ == 22) {
            this.hasReducedDebug = true;
        } else {
            super.handleStatusUpdate(p_handleStatusUpdate_1_);
        }
    }

    @Override
    protected boolean isMovementBlocked() {
        return this.getHealth() <= 0.0f || this.isPlayerSleeping();
    }

    public void closeScreen() {
        this.openContainer = this.inventoryContainer;
    }

    @Override
    public void updateRidden() {
        if (!this.world.isRemote && this.isSneaking() && this.isRiding()) {
            this.dismountRidingEntity();
            this.setSneaking(false);
        } else {
            double d0 = this.posX;
            double d1 = this.posY;
            double d2 = this.posZ;
            float f = this.rotationYaw;
            float f1 = this.rotationPitch;
            super.updateRidden();
            this.prevCameraYaw = this.cameraYaw;
            this.cameraYaw = 0.0f;
            this.addMountedMovementStat(this.posX - d0, this.posY - d1, this.posZ - d2);
            if (this.getRidingEntity() instanceof EntityLivingBase && ((EntityLivingBase)this.getRidingEntity()).shouldRiderFaceForward(this)) {
                this.rotationPitch = f1;
                this.rotationYaw = f;
                this.renderYawOffset = ((EntityLivingBase)this.getRidingEntity()).renderYawOffset;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preparePlayerToSpawn() {
        this.setSize(0.6f, 1.8f);
        super.preparePlayerToSpawn();
        this.setHealth(this.getMaxHealth());
        this.deathTime = 0;
    }

    @Override
    protected void updateEntityActionState() {
        super.updateEntityActionState();
        this.updateArmSwingProgress();
        this.rotationYawHead = this.rotationYaw;
    }

    @Override
    public void onLivingUpdate() {
        if (this.flyToggleTimer > 0) {
            --this.flyToggleTimer;
        }
        if (this.world.getDifficulty() == EnumDifficulty.PEACEFUL && this.world.getGameRules().getBoolean("naturalRegeneration")) {
            if (this.getHealth() < this.getMaxHealth() && this.ticksExisted % 20 == 0) {
                this.heal(1.0f);
            }
            if (this.foodStats.needFood() && this.ticksExisted % 10 == 0) {
                this.foodStats.setFoodLevel(this.foodStats.getFoodLevel() + 1);
            }
        }
        this.inventory.decrementAnimations();
        this.prevCameraYaw = this.cameraYaw;
        super.onLivingUpdate();
        IAttributeInstance iattributeinstance = this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED);
        if (!this.world.isRemote) {
            iattributeinstance.setBaseValue(this.capabilities.getWalkSpeed());
        }
        this.jumpMovementFactor = this.speedInAir;
        if (this.isSprinting()) {
            this.jumpMovementFactor = (float)((double)this.jumpMovementFactor + (double)this.speedInAir * 0.3);
        }
        this.setAIMoveSpeed((float)iattributeinstance.getAttributeValue());
        float f = MathHelper.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
        float f1 = (float)(Math.atan(-this.motionY * (double)0.2f) * 15.0);
        if (f > 0.1f) {
            f = 0.1f;
        }
        if (!this.onGround || this.getHealth() <= 0.0f) {
            f = 0.0f;
        }
        if (this.onGround || this.getHealth() <= 0.0f) {
            f1 = 0.0f;
        }
        this.cameraYaw += (f - this.cameraYaw) * 0.4f;
        this.cameraPitch += (f1 - this.cameraPitch) * 0.8f;
        if (this.getHealth() > 0.0f && !this.isSpectator()) {
            AxisAlignedBB axisalignedbb = this.isRiding() && !this.getRidingEntity().isDead ? this.getEntityBoundingBox().union(this.getRidingEntity().getEntityBoundingBox()).expand(1.0, 0.0, 1.0) : this.getEntityBoundingBox().expand(1.0, 0.5, 1.0);
            List<Entity> list = this.world.getEntitiesWithinAABBExcludingEntity(this, axisalignedbb);
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = list.get(i);
                if (entity.isDead) continue;
                this.collideWithPlayer(entity);
            }
        }
    }

    private void collideWithPlayer(Entity p_collideWithPlayer_1_) {
        p_collideWithPlayer_1_.onCollideWithPlayer(this);
    }

    public int getScore() {
        return this.dataManager.get(PLAYER_SCORE);
    }

    public void setScore(int p_setScore_1_) {
        this.dataManager.set(PLAYER_SCORE, p_setScore_1_);
    }

    public void addScore(int p_addScore_1_) {
        int i = this.getScore();
        this.dataManager.set(PLAYER_SCORE, i + p_addScore_1_);
    }

    @Override
    public void onDeath(DamageSource p_onDeath_1_) {
        if (ForgeHooks.onLivingDeath(this, p_onDeath_1_)) {
            return;
        }
        super.onDeath(p_onDeath_1_);
        this.setSize(0.2f, 0.2f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.motionY = 0.1f;
        this.captureDrops = true;
        this.capturedDrops.clear();
        if ("Notch".equals(this.getName())) {
            this.dropItem(new ItemStack(Items.APPLE, 1), true, false);
        }
        if (!this.world.getGameRules().getBoolean("keepInventory") && !this.isSpectator()) {
            this.destroyVanishingCursedItems();
            this.inventory.dropAllItems();
        }
        this.captureDrops = false;
        if (!this.world.isRemote) {
            ForgeEventFactory.onPlayerDrops(this, p_onDeath_1_, this.capturedDrops, this.recentlyHit > 0);
        }
        if (p_onDeath_1_ != null) {
            this.motionX = -MathHelper.cos((this.attackedAtYaw + this.rotationYaw) * ((float)Math.PI / 180)) * 0.1f;
            this.motionZ = -MathHelper.sin((this.attackedAtYaw + this.rotationYaw) * ((float)Math.PI / 180)) * 0.1f;
        } else {
            this.motionX = 0.0;
            this.motionZ = 0.0;
        }
        this.addStat(StatList.DEATHS);
        this.takeStat(StatList.TIME_SINCE_DEATH);
        this.extinguish();
        this.setFlag(0, false);
    }

    protected void destroyVanishingCursedItems() {
        for (int i = 0; i < this.inventory.getSizeInventory(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.isEmpty() || !EnchantmentHelper.hasVanishingCurse(itemstack)) continue;
            this.inventory.removeStackFromSlot(i);
        }
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_PLAYER_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_PLAYER_DEATH;
    }

    @Override
    public void addToPlayerScore(Entity p_addToPlayerScore_1_, int p_addToPlayerScore_2_) {
        if (p_addToPlayerScore_1_ != this) {
            this.addScore(p_addToPlayerScore_2_);
            Collection<ScoreObjective> collection = this.getWorldScoreboard().getObjectivesFromCriteria(IScoreCriteria.TOTAL_KILL_COUNT);
            if (p_addToPlayerScore_1_ instanceof EntityPlayer) {
                this.addStat(StatList.PLAYER_KILLS);
                collection.addAll(this.getWorldScoreboard().getObjectivesFromCriteria(IScoreCriteria.PLAYER_KILL_COUNT));
            } else {
                this.addStat(StatList.MOB_KILLS);
            }
            collection.addAll(this.giveTeamKillScores(p_addToPlayerScore_1_));
            for (ScoreObjective scoreobjective : collection) {
                this.getWorldScoreboard().getOrCreateScore(this.getName(), scoreobjective).incrementScore();
            }
        }
    }

    private Collection<ScoreObjective> giveTeamKillScores(Entity p_giveTeamKillScores_1_) {
        int j;
        ScorePlayerTeam scoreplayerteam1;
        int i;
        String s = p_giveTeamKillScores_1_ instanceof EntityPlayer ? p_giveTeamKillScores_1_.getName() : p_giveTeamKillScores_1_.getCachedUniqueIdString();
        ScorePlayerTeam scoreplayerteam = this.getWorldScoreboard().getPlayersTeam(this.getName());
        if (scoreplayerteam != null && (i = scoreplayerteam.getChatFormat().getColorIndex()) >= 0 && i < IScoreCriteria.KILLED_BY_TEAM.length) {
            for (ScoreObjective scoreobjective : this.getWorldScoreboard().getObjectivesFromCriteria(IScoreCriteria.KILLED_BY_TEAM[i])) {
                Score score = this.getWorldScoreboard().getOrCreateScore(s, scoreobjective);
                score.incrementScore();
            }
        }
        if ((scoreplayerteam1 = this.getWorldScoreboard().getPlayersTeam(s)) != null && (j = scoreplayerteam1.getChatFormat().getColorIndex()) >= 0 && j < IScoreCriteria.TEAM_KILL.length) {
            return this.getWorldScoreboard().getObjectivesFromCriteria(IScoreCriteria.TEAM_KILL[j]);
        }
        return Lists.newArrayList();
    }

    @Nullable
    public EntityItem dropItem(boolean p_dropItem_1_) {
        ItemStack stack = this.inventory.getCurrentItem();
        if (stack.isEmpty()) {
            return null;
        }
        if (stack.getItem().onDroppedByPlayer(stack, this)) {
            int count = p_dropItem_1_ ? this.inventory.getCurrentItem().getCount() : 1;
            return ForgeHooks.onPlayerTossEvent(this, this.inventory.decrStackSize(this.inventory.currentItem, count), true);
        }
        return null;
    }

    @Nullable
    public EntityItem dropItem(ItemStack p_dropItem_1_, boolean p_dropItem_2_) {
        return ForgeHooks.onPlayerTossEvent(this, p_dropItem_1_, false);
    }

    @Nullable
    public EntityItem dropItem(ItemStack p_dropItem_1_, boolean p_dropItem_2_, boolean p_dropItem_3_) {
        if (p_dropItem_1_.isEmpty()) {
            return null;
        }
        double d0 = this.posY - (double)0.3f + (double)this.getEyeHeight();
        EntityItem entityitem = new EntityItem(this.world, this.posX, d0, this.posZ, p_dropItem_1_);
        entityitem.setPickupDelay(40);
        if (p_dropItem_3_) {
            entityitem.setThrower(this.getName());
        }
        if (p_dropItem_2_) {
            float f = this.rand.nextFloat() * 0.5f;
            float f1 = this.rand.nextFloat() * ((float)Math.PI * 2);
            entityitem.motionX = -MathHelper.sin(f1) * f;
            entityitem.motionZ = MathHelper.cos(f1) * f;
            entityitem.motionY = 0.2f;
        } else {
            float f2 = 0.3f;
            entityitem.motionX = -MathHelper.sin(this.rotationYaw * ((float)Math.PI / 180)) * MathHelper.cos(this.rotationPitch * ((float)Math.PI / 180)) * f2;
            entityitem.motionZ = MathHelper.cos(this.rotationYaw * ((float)Math.PI / 180)) * MathHelper.cos(this.rotationPitch * ((float)Math.PI / 180)) * f2;
            entityitem.motionY = -MathHelper.sin(this.rotationPitch * ((float)Math.PI / 180)) * f2 + 0.1f;
            float f3 = this.rand.nextFloat() * ((float)Math.PI * 2);
            f2 = 0.02f * this.rand.nextFloat();
            entityitem.motionX += Math.cos(f3) * (double)f2;
            entityitem.motionY += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
            entityitem.motionZ += Math.sin(f3) * (double)f2;
        }
        ItemStack itemstack = this.dropItemAndGetStack(entityitem);
        if (p_dropItem_3_) {
            if (!itemstack.isEmpty()) {
                this.addStat(StatList.getDroppedObjectStats(itemstack.getItem()), p_dropItem_1_.getCount());
            }
            this.addStat(StatList.DROP);
        }
        return entityitem;
    }

    public ItemStack dropItemAndGetStack(EntityItem p_dropItemAndGetStack_1_) {
        if (this.captureDrops) {
            this.capturedDrops.add(p_dropItemAndGetStack_1_);
        } else {
            this.world.spawnEntity(p_dropItemAndGetStack_1_);
        }
        return p_dropItemAndGetStack_1_.getEntityItem();
    }

    @Deprecated
    public float getDigSpeed(IBlockState p_getDigSpeed_1_) {
        return this.getDigSpeed(p_getDigSpeed_1_, null);
    }

    public float getDigSpeed(IBlockState p_getDigSpeed_1_, BlockPos p_getDigSpeed_2_) {
        float f = this.inventory.getStrVsBlock(p_getDigSpeed_1_);
        if (f > 1.0f) {
            int i = EnchantmentHelper.getEfficiencyModifier(this);
            ItemStack itemstack = this.getHeldItemMainhand();
            if (i > 0 && !itemstack.isEmpty()) {
                f += (float)(i * i + 1);
            }
        }
        if (this.isPotionActive(MobEffects.HASTE)) {
            f *= 1.0f + (float)(this.getActivePotionEffect(MobEffects.HASTE).getAmplifier() + 1) * 0.2f;
        }
        if (this.isPotionActive(MobEffects.MINING_FATIGUE)) {
            float f1;
            switch (this.getActivePotionEffect(MobEffects.MINING_FATIGUE).getAmplifier()) {
                case 0: {
                    f1 = 0.3f;
                    break;
                }
                case 1: {
                    f1 = 0.09f;
                    break;
                }
                case 2: {
                    f1 = 0.0027f;
                    break;
                }
                default: {
                    f1 = 8.1E-4f;
                }
            }
            f *= f1;
        }
        if (this.isInsideOfMaterial(Material.WATER) && !EnchantmentHelper.getAquaAffinityModifier(this)) {
            f /= 5.0f;
        }
        if (!this.onGround) {
            f /= 5.0f;
        }
        return (f = ForgeEventFactory.getBreakSpeed(this, p_getDigSpeed_1_, f, p_getDigSpeed_2_)) < 0.0f ? 0.0f : f;
    }

    public boolean canHarvestBlock(IBlockState p_canHarvestBlock_1_) {
        return ForgeEventFactory.doPlayerHarvestCheck(this, p_canHarvestBlock_1_, this.inventory.canHarvestBlock(p_canHarvestBlock_1_));
    }

    public static void registerFixesPlayer(DataFixer p_registerFixesPlayer_0_) {
        p_registerFixesPlayer_0_.registerWalker(FixTypes.PLAYER, new IDataWalker(){

            @Override
            public NBTTagCompound process(IDataFixer p_process_1_, NBTTagCompound p_process_2_, int p_process_3_) {
                DataFixesManager.processInventory(p_process_1_, p_process_2_, p_process_3_, "Inventory");
                DataFixesManager.processInventory(p_process_1_, p_process_2_, p_process_3_, "EnderItems");
                return p_process_2_;
            }
        });
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.setUniqueId(EntityPlayer.getUUID(this.gameProfile));
        NBTTagList nbttaglist = p_readEntityFromNBT_1_.getTagList("Inventory", 10);
        this.inventory.readFromNBT(nbttaglist);
        this.inventory.currentItem = p_readEntityFromNBT_1_.getInteger("SelectedItemSlot");
        this.sleeping = p_readEntityFromNBT_1_.getBoolean("Sleeping");
        this.sleepTimer = p_readEntityFromNBT_1_.getShort("SleepTimer");
        this.experience = p_readEntityFromNBT_1_.getFloat("XpP");
        this.experienceLevel = p_readEntityFromNBT_1_.getInteger("XpLevel");
        this.experienceTotal = p_readEntityFromNBT_1_.getInteger("XpTotal");
        this.xpSeed = p_readEntityFromNBT_1_.getInteger("XpSeed");
        if (this.xpSeed == 0) {
            this.xpSeed = this.rand.nextInt();
        }
        this.setScore(p_readEntityFromNBT_1_.getInteger("Score"));
        if (this.sleeping) {
            this.bedLocation = new BlockPos(this);
            this.wakeUpPlayer(true, true, false);
        }
        if (p_readEntityFromNBT_1_.hasKey("SpawnX", 99) && p_readEntityFromNBT_1_.hasKey("SpawnY", 99) && p_readEntityFromNBT_1_.hasKey("SpawnZ", 99)) {
            this.spawnChunk = new BlockPos(p_readEntityFromNBT_1_.getInteger("SpawnX"), p_readEntityFromNBT_1_.getInteger("SpawnY"), p_readEntityFromNBT_1_.getInteger("SpawnZ"));
            this.spawnForced = p_readEntityFromNBT_1_.getBoolean("SpawnForced");
        }
        NBTTagList spawnlist = null;
        spawnlist = p_readEntityFromNBT_1_.getTagList("Spawns", 10);
        for (int i = 0; i < spawnlist.tagCount(); ++i) {
            NBTTagCompound spawndata = spawnlist.getCompoundTagAt(i);
            int spawndim = spawndata.getInteger("Dim");
            this.spawnChunkMap.put(spawndim, new BlockPos(spawndata.getInteger("SpawnX"), spawndata.getInteger("SpawnY"), spawndata.getInteger("SpawnZ")));
            this.spawnForcedMap.put(spawndim, spawndata.getBoolean("SpawnForced"));
        }
        this.foodStats.readNBT(p_readEntityFromNBT_1_);
        this.capabilities.readCapabilitiesFromNBT(p_readEntityFromNBT_1_);
        if (p_readEntityFromNBT_1_.hasKey("EnderItems", 9)) {
            NBTTagList nbttaglist1 = p_readEntityFromNBT_1_.getTagList("EnderItems", 10);
            this.theInventoryEnderChest.loadInventoryFromNBT(nbttaglist1);
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setInteger("DataVersion", 922);
        FMLCommonHandler.instance().getDataFixer().writeVersionData(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setTag("Inventory", this.inventory.writeToNBT(new NBTTagList()));
        p_writeEntityToNBT_1_.setInteger("SelectedItemSlot", this.inventory.currentItem);
        p_writeEntityToNBT_1_.setBoolean("Sleeping", this.sleeping);
        p_writeEntityToNBT_1_.setShort("SleepTimer", (short)this.sleepTimer);
        p_writeEntityToNBT_1_.setFloat("XpP", this.experience);
        p_writeEntityToNBT_1_.setInteger("XpLevel", this.experienceLevel);
        p_writeEntityToNBT_1_.setInteger("XpTotal", this.experienceTotal);
        p_writeEntityToNBT_1_.setInteger("XpSeed", this.xpSeed);
        p_writeEntityToNBT_1_.setInteger("Score", this.getScore());
        if (this.spawnChunk != null) {
            p_writeEntityToNBT_1_.setInteger("SpawnX", this.spawnChunk.getX());
            p_writeEntityToNBT_1_.setInteger("SpawnY", this.spawnChunk.getY());
            p_writeEntityToNBT_1_.setInteger("SpawnZ", this.spawnChunk.getZ());
            p_writeEntityToNBT_1_.setBoolean("SpawnForced", this.spawnForced);
        }
        NBTTagList spawnlist = new NBTTagList();
        for (Map.Entry<Integer, BlockPos> entry : this.spawnChunkMap.entrySet()) {
            BlockPos spawn = entry.getValue();
            if (spawn == null) continue;
            Boolean forced = this.spawnForcedMap.get(entry.getKey());
            if (forced == null) {
                forced = false;
            }
            NBTTagCompound spawndata = new NBTTagCompound();
            spawndata.setInteger("Dim", entry.getKey());
            spawndata.setInteger("SpawnX", spawn.getX());
            spawndata.setInteger("SpawnY", spawn.getY());
            spawndata.setInteger("SpawnZ", spawn.getZ());
            spawndata.setBoolean("SpawnForced", forced);
            spawnlist.appendTag(spawndata);
        }
        p_writeEntityToNBT_1_.setTag("Spawns", spawnlist);
        this.foodStats.writeNBT(p_writeEntityToNBT_1_);
        this.capabilities.writeCapabilitiesToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setTag("EnderItems", this.theInventoryEnderChest.saveInventoryToNBT());
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        if (!ForgeHooks.onLivingAttack(this, p_attackEntityFrom_1_, p_attackEntityFrom_2_)) {
            return false;
        }
        if (this.isEntityInvulnerable(p_attackEntityFrom_1_)) {
            return false;
        }
        if (this.capabilities.disableDamage && !p_attackEntityFrom_1_.canHarmInCreative()) {
            return false;
        }
        this.entityAge = 0;
        if (this.getHealth() <= 0.0f) {
            return false;
        }
        if (this.isPlayerSleeping() && !this.world.isRemote) {
            this.wakeUpPlayer(true, true, false);
        }
        if (p_attackEntityFrom_1_.isDifficultyScaled()) {
            if (this.world.getDifficulty() == EnumDifficulty.PEACEFUL) {
                p_attackEntityFrom_2_ = 0.0f;
            }
            if (this.world.getDifficulty() == EnumDifficulty.EASY) {
                p_attackEntityFrom_2_ = Math.min(p_attackEntityFrom_2_ / 2.0f + 1.0f, p_attackEntityFrom_2_);
            }
            if (this.world.getDifficulty() == EnumDifficulty.HARD) {
                p_attackEntityFrom_2_ = p_attackEntityFrom_2_ * 3.0f / 2.0f;
            }
        }
        return p_attackEntityFrom_2_ == 0.0f ? false : super.attackEntityFrom(p_attackEntityFrom_1_, p_attackEntityFrom_2_);
    }

    @Override
    protected void blockUsingShield(EntityLivingBase p_blockUsingShield_1_) {
        super.blockUsingShield(p_blockUsingShield_1_);
        if (p_blockUsingShield_1_.getHeldItemMainhand().getItem() instanceof ItemAxe) {
            this.disableShield(true);
        }
    }

    public boolean canAttackPlayer(EntityPlayer p_canAttackPlayer_1_) {
        Team team = this.getTeam();
        Team team1 = p_canAttackPlayer_1_.getTeam();
        return team == null ? true : (!team.isSameTeam(team1) ? true : team.getAllowFriendlyFire());
    }

    @Override
    protected void damageArmor(float p_damageArmor_1_) {
        this.inventory.damageArmor(p_damageArmor_1_);
    }

    @Override
    protected void damageShield(float p_damageShield_1_) {
        if (p_damageShield_1_ >= 3.0f && this.activeItemStack.getItem() == Items.SHIELD) {
            int i = 1 + MathHelper.floor(p_damageShield_1_);
            this.activeItemStack.damageItem(i, this);
            if (this.activeItemStack.isEmpty()) {
                EnumHand enumhand = this.getActiveHand();
                ForgeEventFactory.onPlayerDestroyItem(this, this.activeItemStack, enumhand);
                if (enumhand == EnumHand.MAIN_HAND) {
                    this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, ItemStack.EMPTY);
                } else {
                    this.setItemStackToSlot(EntityEquipmentSlot.OFFHAND, ItemStack.EMPTY);
                }
                this.activeItemStack = ItemStack.EMPTY;
                this.playSound(SoundEvents.ITEM_SHIELD_BREAK, 0.8f, 0.8f + this.world.rand.nextFloat() * 0.4f);
            }
        }
    }

    public float getArmorVisibility() {
        int i = 0;
        for (ItemStack itemstack : this.inventory.armorInventory) {
            if (itemstack.isEmpty()) continue;
            ++i;
        }
        return (float)i / (float)this.inventory.armorInventory.size();
    }

    @Override
    protected void damageEntity(DamageSource p_damageEntity_1_, float p_damageEntity_2_) {
        if (!this.isEntityInvulnerable(p_damageEntity_1_)) {
            if ((p_damageEntity_2_ = ForgeHooks.onLivingHurt(this, p_damageEntity_1_, p_damageEntity_2_)) <= 0.0f) {
                return;
            }
            if ((p_damageEntity_2_ = ISpecialArmor.ArmorProperties.applyArmor(this, this.inventory.armorInventory, p_damageEntity_1_, p_damageEntity_2_)) <= 0.0f) {
                return;
            }
            float f = p_damageEntity_2_ = this.applyPotionDamageCalculations(p_damageEntity_1_, p_damageEntity_2_);
            p_damageEntity_2_ = Math.max(p_damageEntity_2_ - this.getAbsorptionAmount(), 0.0f);
            this.setAbsorptionAmount(this.getAbsorptionAmount() - (f - p_damageEntity_2_));
            if (p_damageEntity_2_ != 0.0f) {
                this.addExhaustion(p_damageEntity_1_.getHungerDamage());
                float f1 = this.getHealth();
                this.setHealth(this.getHealth() - p_damageEntity_2_);
                this.getCombatTracker().trackDamage(p_damageEntity_1_, f1, p_damageEntity_2_);
                if (p_damageEntity_2_ < 3.4028235E37f) {
                    this.addStat(StatList.DAMAGE_TAKEN, Math.round(p_damageEntity_2_ * 10.0f));
                }
            }
        }
    }

    public void openEditSign(TileEntitySign p_openEditSign_1_) {
    }

    public void displayGuiEditCommandCart(CommandBlockBaseLogic p_displayGuiEditCommandCart_1_) {
    }

    public void displayGuiCommandBlock(TileEntityCommandBlock p_displayGuiCommandBlock_1_) {
    }

    public void openEditStructure(TileEntityStructure p_openEditStructure_1_) {
    }

    public void displayVillagerTradeGui(IMerchant p_displayVillagerTradeGui_1_) {
    }

    public void displayGUIChest(IInventory p_displayGUIChest_1_) {
    }

    public void openGuiHorseInventory(AbstractHorse p_openGuiHorseInventory_1_, IInventory p_openGuiHorseInventory_2_) {
    }

    public void displayGui(IInteractionObject p_displayGui_1_) {
    }

    public void openBook(ItemStack p_openBook_1_, EnumHand p_openBook_2_) {
    }

    public EnumActionResult interactOn(Entity p_interactOn_1_, EnumHand p_interactOn_2_) {
        ItemStack itemstack1;
        if (this.isSpectator()) {
            if (p_interactOn_1_ instanceof IInventory) {
                this.displayGUIChest((IInventory)((Object)p_interactOn_1_));
            }
            return EnumActionResult.PASS;
        }
        if (ForgeHooks.onInteractEntity(this, p_interactOn_1_, p_interactOn_2_)) {
            return EnumActionResult.PASS;
        }
        ItemStack itemstack = this.getHeldItem(p_interactOn_2_);
        ItemStack itemStack = itemstack1 = itemstack.isEmpty() ? ItemStack.EMPTY : itemstack.copy();
        if (p_interactOn_1_.processInitialInteract(this, p_interactOn_2_)) {
            if (this.capabilities.isCreativeMode && itemstack == this.getHeldItem(p_interactOn_2_) && itemstack.getCount() < itemstack1.getCount()) {
                itemstack.setCount(itemstack1.getCount());
            }
            if (!this.capabilities.isCreativeMode && itemstack.isEmpty()) {
                ForgeEventFactory.onPlayerDestroyItem(this, itemstack1, p_interactOn_2_);
            }
            return EnumActionResult.SUCCESS;
        }
        if (!itemstack.isEmpty() && p_interactOn_1_ instanceof EntityLivingBase) {
            if (this.capabilities.isCreativeMode) {
                itemstack = itemstack1;
            }
            if (itemstack.interactWithEntity(this, (EntityLivingBase)p_interactOn_1_, p_interactOn_2_)) {
                if (itemstack.isEmpty() && !this.capabilities.isCreativeMode) {
                    ForgeEventFactory.onPlayerDestroyItem(this, itemstack1, p_interactOn_2_);
                    this.setHeldItem(p_interactOn_2_, ItemStack.EMPTY);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    @Override
    public double getYOffset() {
        return -0.35;
    }

    @Override
    public void dismountRidingEntity() {
        super.dismountRidingEntity();
        this.rideCooldown = 0;
    }

    public void attackTargetEntityWithCurrentItem(Entity p_attackTargetEntityWithCurrentItem_1_) {
        if (!ForgeHooks.onPlayerAttackTarget(this, p_attackTargetEntityWithCurrentItem_1_)) {
            return;
        }
        if (p_attackTargetEntityWithCurrentItem_1_.canBeAttackedWithItem() && !p_attackTargetEntityWithCurrentItem_1_.hitByEntity(this)) {
            float f = (float)this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).getAttributeValue();
            float f1 = p_attackTargetEntityWithCurrentItem_1_ instanceof EntityLivingBase ? EnchantmentHelper.getModifierForCreature(this.getHeldItemMainhand(), ((EntityLivingBase)p_attackTargetEntityWithCurrentItem_1_).getCreatureAttribute()) : EnchantmentHelper.getModifierForCreature(this.getHeldItemMainhand(), EnumCreatureAttribute.UNDEFINED);
            float f2 = this.getCooledAttackStrength(0.5f);
            f1 *= f2;
            this.resetCooldown();
            if ((f *= 0.2f + f2 * f2 * 0.8f) > 0.0f || f1 > 0.0f) {
                ItemStack itemstack;
                boolean flag = f2 > 0.9f;
                boolean flag1 = false;
                int i = 0;
                i += EnchantmentHelper.getKnockbackModifier(this);
                if (this.isSprinting() && flag) {
                    this.world.playSound(null, this.posX, this.posY, this.posZ, SoundEvents.ENTITY_PLAYER_ATTACK_KNOCKBACK, this.getSoundCategory(), 1.0f, 1.0f);
                    ++i;
                    flag1 = true;
                }
                boolean flag2 = flag && this.fallDistance > 0.0f && !this.onGround && !this.isOnLadder() && !this.isInWater() && !this.isPotionActive(MobEffects.BLINDNESS) && !this.isRiding() && p_attackTargetEntityWithCurrentItem_1_ instanceof EntityLivingBase;
                boolean bl = flag2 = flag2 && !this.isSprinting();
                if (flag2) {
                    f *= 1.5f;
                }
                f += f1;
                boolean flag3 = false;
                double d0 = this.distanceWalkedModified - this.prevDistanceWalkedModified;
                if (flag && !flag2 && !flag1 && this.onGround && d0 < (double)this.getAIMoveSpeed() && (itemstack = this.getHeldItem(EnumHand.MAIN_HAND)).getItem() instanceof ItemSword) {
                    flag3 = true;
                }
                float f4 = 0.0f;
                boolean flag4 = false;
                int j = EnchantmentHelper.getFireAspectModifier(this);
                if (p_attackTargetEntityWithCurrentItem_1_ instanceof EntityLivingBase) {
                    f4 = ((EntityLivingBase)p_attackTargetEntityWithCurrentItem_1_).getHealth();
                    if (j > 0 && !p_attackTargetEntityWithCurrentItem_1_.isBurning()) {
                        flag4 = true;
                        p_attackTargetEntityWithCurrentItem_1_.setFire(1);
                    }
                }
                double d1 = p_attackTargetEntityWithCurrentItem_1_.motionX;
                double d2 = p_attackTargetEntityWithCurrentItem_1_.motionY;
                double d3 = p_attackTargetEntityWithCurrentItem_1_.motionZ;
                boolean flag5 = p_attackTargetEntityWithCurrentItem_1_.attackEntityFrom(DamageSource.causePlayerDamage(this), f);
                if (flag5) {
                    IEntityMultiPart ientitymultipart;
                    if (i > 0) {
                        if (p_attackTargetEntityWithCurrentItem_1_ instanceof EntityLivingBase) {
                            ((EntityLivingBase)p_attackTargetEntityWithCurrentItem_1_).knockBack(this, (float)i * 0.5f, MathHelper.sin(this.rotationYaw * ((float)Math.PI / 180)), -MathHelper.cos(this.rotationYaw * ((float)Math.PI / 180)));
                        } else {
                            p_attackTargetEntityWithCurrentItem_1_.addVelocity(-MathHelper.sin(this.rotationYaw * ((float)Math.PI / 180)) * (float)i * 0.5f, 0.1, MathHelper.cos(this.rotationYaw * ((float)Math.PI / 180)) * (float)i * 0.5f);
                        }
                        this.motionX *= 0.6;
                        this.motionZ *= 0.6;
                        this.setSprinting(false);
                    }
                    if (flag3) {
                        float f3 = 1.0f + EnchantmentHelper.func_191527_a(this) * f;
                        for (EntityLivingBase entitylivingbase : this.world.getEntitiesWithinAABB(EntityLivingBase.class, p_attackTargetEntityWithCurrentItem_1_.getEntityBoundingBox().expand(1.0, 0.25, 1.0))) {
                            if (entitylivingbase == this || entitylivingbase == p_attackTargetEntityWithCurrentItem_1_ || this.isOnSameTeam(entitylivingbase) || !(this.getDistanceSqToEntity(entitylivingbase) < 9.0)) continue;
                            entitylivingbase.knockBack(this, 0.4f, MathHelper.sin(this.rotationYaw * ((float)Math.PI / 180)), -MathHelper.cos(this.rotationYaw * ((float)Math.PI / 180)));
                            entitylivingbase.attackEntityFrom(DamageSource.causePlayerDamage(this), f3);
                        }
                        this.world.playSound(null, this.posX, this.posY, this.posZ, SoundEvents.ENTITY_PLAYER_ATTACK_SWEEP, this.getSoundCategory(), 1.0f, 1.0f);
                        this.spawnSweepParticles();
                    }
                    if (p_attackTargetEntityWithCurrentItem_1_ instanceof EntityPlayerMP && p_attackTargetEntityWithCurrentItem_1_.velocityChanged) {
                        ((EntityPlayerMP)p_attackTargetEntityWithCurrentItem_1_).connection.sendPacket(new SPacketEntityVelocity(p_attackTargetEntityWithCurrentItem_1_));
                        p_attackTargetEntityWithCurrentItem_1_.velocityChanged = false;
                        p_attackTargetEntityWithCurrentItem_1_.motionX = d1;
                        p_attackTargetEntityWithCurrentItem_1_.motionY = d2;
                        p_attackTargetEntityWithCurrentItem_1_.motionZ = d3;
                    }
                    if (flag2) {
                        this.world.playSound(null, this.posX, this.posY, this.posZ, SoundEvents.ENTITY_PLAYER_ATTACK_CRIT, this.getSoundCategory(), 1.0f, 1.0f);
                        this.onCriticalHit(p_attackTargetEntityWithCurrentItem_1_);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            this.world.playSound(null, this.posX, this.posY, this.posZ, SoundEvents.ENTITY_PLAYER_ATTACK_STRONG, this.getSoundCategory(), 1.0f, 1.0f);
                        } else {
                            this.world.playSound(null, this.posX, this.posY, this.posZ, SoundEvents.ENTITY_PLAYER_ATTACK_WEAK, this.getSoundCategory(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.onEnchantmentCritical(p_attackTargetEntityWithCurrentItem_1_);
                    }
                    if (f >= 18.0f) {
                        this.addStat(AchievementList.OVERKILL);
                    }
                    this.setLastAttacker(p_attackTargetEntityWithCurrentItem_1_);
                    if (p_attackTargetEntityWithCurrentItem_1_ instanceof EntityLivingBase) {
                        EnchantmentHelper.applyThornEnchantments((EntityLivingBase)p_attackTargetEntityWithCurrentItem_1_, this);
                    }
                    EnchantmentHelper.applyArthropodEnchantments(this, p_attackTargetEntityWithCurrentItem_1_);
                    ItemStack itemstack1 = this.getHeldItemMainhand();
                    Entity entity = p_attackTargetEntityWithCurrentItem_1_;
                    if (p_attackTargetEntityWithCurrentItem_1_ instanceof EntityDragonPart && (ientitymultipart = ((EntityDragonPart)p_attackTargetEntityWithCurrentItem_1_).entityDragonObj) instanceof EntityLivingBase) {
                        entity = (EntityLivingBase)((Object)ientitymultipart);
                    }
                    if (!itemstack1.isEmpty() && entity instanceof EntityLivingBase) {
                        ItemStack beforeHitCopy = itemstack1.copy();
                        itemstack1.hitEntity((EntityLivingBase)entity, this);
                        if (itemstack1.isEmpty()) {
                            this.setHeldItem(EnumHand.MAIN_HAND, ItemStack.EMPTY);
                            ForgeEventFactory.onPlayerDestroyItem(this, beforeHitCopy, EnumHand.MAIN_HAND);
                        }
                    }
                    if (p_attackTargetEntityWithCurrentItem_1_ instanceof EntityLivingBase) {
                        float f5 = f4 - ((EntityLivingBase)p_attackTargetEntityWithCurrentItem_1_).getHealth();
                        this.addStat(StatList.DAMAGE_DEALT, Math.round(f5 * 10.0f));
                        if (j > 0) {
                            p_attackTargetEntityWithCurrentItem_1_.setFire(j * 4);
                        }
                        if (this.world instanceof WorldServer && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((WorldServer)this.world).spawnParticle(EnumParticleTypes.DAMAGE_INDICATOR, p_attackTargetEntityWithCurrentItem_1_.posX, p_attackTargetEntityWithCurrentItem_1_.posY + (double)(p_attackTargetEntityWithCurrentItem_1_.height * 0.5f), p_attackTargetEntityWithCurrentItem_1_.posZ, k, 0.1, 0.0, 0.1, 0.2, new int[0]);
                        }
                    }
                    this.addExhaustion(0.1f);
                } else {
                    this.world.playSound(null, this.posX, this.posY, this.posZ, SoundEvents.ENTITY_PLAYER_ATTACK_NODAMAGE, this.getSoundCategory(), 1.0f, 1.0f);
                    if (flag4) {
                        p_attackTargetEntityWithCurrentItem_1_.extinguish();
                    }
                }
            }
        }
    }

    public void disableShield(boolean p_disableShield_1_) {
        float f = 0.25f + (float)EnchantmentHelper.getEfficiencyModifier(this) * 0.05f;
        if (p_disableShield_1_) {
            f += 0.75f;
        }
        if (this.rand.nextFloat() < f) {
            this.getCooldownTracker().setCooldown(Items.SHIELD, 100);
            this.resetActiveHand();
            this.world.setEntityState(this, (byte)30);
        }
    }

    public void onCriticalHit(Entity p_onCriticalHit_1_) {
    }

    public void onEnchantmentCritical(Entity p_onEnchantmentCritical_1_) {
    }

    public void spawnSweepParticles() {
        double d0 = -MathHelper.sin(this.rotationYaw * ((float)Math.PI / 180));
        double d1 = MathHelper.cos(this.rotationYaw * ((float)Math.PI / 180));
        if (this.world instanceof WorldServer) {
            ((WorldServer)this.world).spawnParticle(EnumParticleTypes.SWEEP_ATTACK, this.posX + d0, this.posY + (double)this.height * 0.5, this.posZ + d1, 0, d0, 0.0, d1, 0.0, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void respawnPlayer() {
    }

    @Override
    public void setDead() {
        super.setDead();
        this.inventoryContainer.onContainerClosed(this);
        if (this.openContainer != null) {
            this.openContainer.onContainerClosed(this);
        }
    }

    @Override
    public boolean isEntityInsideOpaqueBlock() {
        return !this.sleeping && super.isEntityInsideOpaqueBlock();
    }

    public boolean isUser() {
        return false;
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    public SleepResult trySleep(BlockPos p_trySleep_1_) {
        SleepResult ret = ForgeEventFactory.onPlayerSleepInBed(this, p_trySleep_1_);
        if (ret != null) {
            return ret;
        }
        EnumFacing enumfacing = this.world.getBlockState(p_trySleep_1_).getValue(BlockHorizontal.FACING);
        if (!this.world.isRemote) {
            if (this.isPlayerSleeping() || !this.isEntityAlive()) {
                return SleepResult.OTHER_PROBLEM;
            }
            if (!this.world.provider.isSurfaceWorld()) {
                return SleepResult.NOT_POSSIBLE_HERE;
            }
            if (this.world.isDaytime()) {
                return SleepResult.NOT_POSSIBLE_NOW;
            }
            if (!this.bedInRange(p_trySleep_1_, enumfacing)) {
                return SleepResult.TOO_FAR_AWAY;
            }
            double d0 = 8.0;
            double d1 = 5.0;
            List<EntityMob> list = this.world.getEntitiesWithinAABB(EntityMob.class, new AxisAlignedBB((double)p_trySleep_1_.getX() - 8.0, (double)p_trySleep_1_.getY() - 5.0, (double)p_trySleep_1_.getZ() - 8.0, (double)p_trySleep_1_.getX() + 8.0, (double)p_trySleep_1_.getY() + 5.0, (double)p_trySleep_1_.getZ() + 8.0));
            if (!list.isEmpty()) {
                return SleepResult.NOT_SAFE;
            }
        }
        if (this.isRiding()) {
            this.dismountRidingEntity();
        }
        this.setSize(0.2f, 0.2f);
        IBlockState state = null;
        if (this.world.isBlockLoaded(p_trySleep_1_)) {
            state = this.world.getBlockState(p_trySleep_1_);
        }
        if (state != null && state.getBlock().isBed(state, this.world, p_trySleep_1_, this)) {
            float f1 = 0.5f + (float)enumfacing.getFrontOffsetX() * 0.4f;
            float f = 0.5f + (float)enumfacing.getFrontOffsetZ() * 0.4f;
            this.setRenderOffsetForSleep(enumfacing);
            this.setPosition((float)p_trySleep_1_.getX() + f1, (float)p_trySleep_1_.getY() + 0.6875f, (float)p_trySleep_1_.getZ() + f);
        } else {
            this.setPosition((float)p_trySleep_1_.getX() + 0.5f, (float)p_trySleep_1_.getY() + 0.6875f, (float)p_trySleep_1_.getZ() + 0.5f);
        }
        this.sleeping = true;
        this.sleepTimer = 0;
        this.bedLocation = p_trySleep_1_;
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        if (!this.world.isRemote) {
            this.world.updateAllPlayersSleepingFlag();
        }
        return SleepResult.OK;
    }

    private boolean bedInRange(BlockPos p_bedInRange_1_, EnumFacing p_bedInRange_2_) {
        if (Math.abs(this.posX - (double)p_bedInRange_1_.getX()) <= 3.0 && Math.abs(this.posY - (double)p_bedInRange_1_.getY()) <= 2.0 && Math.abs(this.posZ - (double)p_bedInRange_1_.getZ()) <= 3.0) {
            return true;
        }
        BlockPos blockpos = p_bedInRange_1_.offset(p_bedInRange_2_.getOpposite());
        return Math.abs(this.posX - (double)blockpos.getX()) <= 3.0 && Math.abs(this.posY - (double)blockpos.getY()) <= 2.0 && Math.abs(this.posZ - (double)blockpos.getZ()) <= 3.0;
    }

    private void setRenderOffsetForSleep(EnumFacing p_setRenderOffsetForSleep_1_) {
        this.renderOffsetX = -1.8f * (float)p_setRenderOffsetForSleep_1_.getFrontOffsetX();
        this.renderOffsetZ = -1.8f * (float)p_setRenderOffsetForSleep_1_.getFrontOffsetZ();
    }

    public void wakeUpPlayer(boolean p_wakeUpPlayer_1_, boolean p_wakeUpPlayer_2_, boolean p_wakeUpPlayer_3_) {
        ForgeEventFactory.onPlayerWakeup(this, p_wakeUpPlayer_1_, p_wakeUpPlayer_2_, p_wakeUpPlayer_3_);
        this.setSize(0.6f, 1.8f);
        IBlockState iblockstate = this.world.getBlockState(this.bedLocation);
        if (this.bedLocation != null && iblockstate.getBlock().isBed(iblockstate, this.world, this.bedLocation, this)) {
            iblockstate.getBlock().setBedOccupied(this.world, this.bedLocation, this, false);
            BlockPos blockpos = iblockstate.getBlock().getBedSpawnPosition(iblockstate, this.world, this.bedLocation, this);
            if (blockpos == null) {
                blockpos = this.bedLocation.up();
            }
            this.setPosition((float)blockpos.getX() + 0.5f, (float)blockpos.getY() + 0.1f, (float)blockpos.getZ() + 0.5f);
        } else {
            p_wakeUpPlayer_3_ = false;
        }
        this.sleeping = false;
        if (!this.world.isRemote && p_wakeUpPlayer_2_) {
            this.world.updateAllPlayersSleepingFlag();
        }
        int n = this.sleepTimer = p_wakeUpPlayer_1_ ? 0 : 100;
        if (p_wakeUpPlayer_3_) {
            this.setSpawnPoint(this.bedLocation, false);
        }
    }

    private boolean isInBed() {
        return ForgeEventFactory.fireSleepingLocationCheck(this, this.bedLocation);
    }

    @Nullable
    public static BlockPos getBedSpawnLocation(World p_getBedSpawnLocation_0_, BlockPos p_getBedSpawnLocation_1_, boolean p_getBedSpawnLocation_2_) {
        IBlockState state = p_getBedSpawnLocation_0_.getBlockState(p_getBedSpawnLocation_1_);
        Block block = state.getBlock();
        if (!block.isBed(state, p_getBedSpawnLocation_0_, p_getBedSpawnLocation_1_, null)) {
            if (!p_getBedSpawnLocation_2_) {
                return null;
            }
            boolean flag = block.canSpawnInBlock();
            boolean flag1 = p_getBedSpawnLocation_0_.getBlockState(p_getBedSpawnLocation_1_.up()).getBlock().canSpawnInBlock();
            return flag && flag1 ? p_getBedSpawnLocation_1_ : null;
        }
        return block.getBedSpawnPosition(state, p_getBedSpawnLocation_0_, p_getBedSpawnLocation_1_, null);
    }

    @SideOnly(value=Side.CLIENT)
    public float getBedOrientationInDegrees() {
        IBlockState state;
        IBlockState iBlockState = state = this.bedLocation == null ? null : this.world.getBlockState(this.bedLocation);
        if (state != null && state.getBlock().isBed(state, this.world, this.bedLocation, this)) {
            EnumFacing enumfacing = state.getBlock().getBedDirection(state, this.world, this.bedLocation);
            switch (enumfacing) {
                case SOUTH: {
                    return 90.0f;
                }
                case WEST: {
                    return 0.0f;
                }
                case NORTH: {
                    return 270.0f;
                }
                case EAST: {
                    return 180.0f;
                }
            }
        }
        return 0.0f;
    }

    @Override
    public boolean isPlayerSleeping() {
        return this.sleeping;
    }

    public boolean isPlayerFullyAsleep() {
        return this.sleeping && this.sleepTimer >= 100;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSleepTimer() {
        return this.sleepTimer;
    }

    public void sendStatusMessage(ITextComponent p_sendStatusMessage_1_, boolean p_sendStatusMessage_2_) {
    }

    public BlockPos getBedLocation() {
        return this.getBedLocation(this.dimension);
    }

    @Deprecated
    public boolean isSpawnForced() {
        return this.isSpawnForced(this.dimension);
    }

    public void setSpawnPoint(BlockPos p_setSpawnPoint_1_, boolean p_setSpawnPoint_2_) {
        if (ForgeEventFactory.onPlayerSpawnSet(this, p_setSpawnPoint_1_, p_setSpawnPoint_2_)) {
            return;
        }
        if (this.dimension != 0) {
            this.setSpawnChunk(p_setSpawnPoint_1_, p_setSpawnPoint_2_, this.dimension);
            return;
        }
        if (p_setSpawnPoint_1_ != null) {
            this.spawnChunk = p_setSpawnPoint_1_;
            this.spawnForced = p_setSpawnPoint_2_;
        } else {
            this.spawnChunk = null;
            this.spawnForced = false;
        }
    }

    public boolean hasAchievement(Achievement p_hasAchievement_1_) {
        return false;
    }

    public void addStat(StatBase p_addStat_1_) {
        this.addStat(p_addStat_1_, 1);
    }

    public void addStat(StatBase p_addStat_1_, int p_addStat_2_) {
    }

    public void takeStat(StatBase p_takeStat_1_) {
    }

    @Override
    public void jump() {
        super.jump();
        this.addStat(StatList.JUMP);
        if (this.isSprinting()) {
            this.addExhaustion(0.2f);
        } else {
            this.addExhaustion(0.05f);
        }
    }

    @Override
    public void moveEntityWithHeading(float p_moveEntityWithHeading_1_, float p_moveEntityWithHeading_2_) {
        double d0 = this.posX;
        double d1 = this.posY;
        double d2 = this.posZ;
        if (this.capabilities.isFlying && !this.isRiding()) {
            double d3 = this.motionY;
            float f = this.jumpMovementFactor;
            this.jumpMovementFactor = this.capabilities.getFlySpeed() * (float)(this.isSprinting() ? 2 : 1);
            super.moveEntityWithHeading(p_moveEntityWithHeading_1_, p_moveEntityWithHeading_2_);
            this.motionY = d3 * 0.6;
            this.jumpMovementFactor = f;
            this.fallDistance = 0.0f;
            this.setFlag(7, false);
        } else {
            super.moveEntityWithHeading(p_moveEntityWithHeading_1_, p_moveEntityWithHeading_2_);
        }
        this.addMovementStat(this.posX - d0, this.posY - d1, this.posZ - d2);
    }

    @Override
    public float getAIMoveSpeed() {
        return (float)this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).getAttributeValue();
    }

    public void addMovementStat(double p_addMovementStat_1_, double p_addMovementStat_3_, double p_addMovementStat_5_) {
        if (!this.isRiding()) {
            if (this.isInsideOfMaterial(Material.WATER)) {
                int i = Math.round(MathHelper.sqrt(p_addMovementStat_1_ * p_addMovementStat_1_ + p_addMovementStat_3_ * p_addMovementStat_3_ + p_addMovementStat_5_ * p_addMovementStat_5_) * 100.0f);
                if (i > 0) {
                    this.addStat(StatList.DIVE_ONE_CM, i);
                    this.addExhaustion(0.01f * (float)i * 0.01f);
                }
            } else if (this.isInWater()) {
                int j = Math.round(MathHelper.sqrt(p_addMovementStat_1_ * p_addMovementStat_1_ + p_addMovementStat_5_ * p_addMovementStat_5_) * 100.0f);
                if (j > 0) {
                    this.addStat(StatList.SWIM_ONE_CM, j);
                    this.addExhaustion(0.01f * (float)j * 0.01f);
                }
            } else if (this.isOnLadder()) {
                if (p_addMovementStat_3_ > 0.0) {
                    this.addStat(StatList.CLIMB_ONE_CM, (int)Math.round(p_addMovementStat_3_ * 100.0));
                }
            } else if (this.onGround) {
                int k = Math.round(MathHelper.sqrt(p_addMovementStat_1_ * p_addMovementStat_1_ + p_addMovementStat_5_ * p_addMovementStat_5_) * 100.0f);
                if (k > 0) {
                    if (this.isSprinting()) {
                        this.addStat(StatList.SPRINT_ONE_CM, k);
                        this.addExhaustion(0.1f * (float)k * 0.01f);
                    } else if (this.isSneaking()) {
                        this.addStat(StatList.CROUCH_ONE_CM, k);
                        this.addExhaustion(0.0f * (float)k * 0.01f);
                    } else {
                        this.addStat(StatList.WALK_ONE_CM, k);
                        this.addExhaustion(0.0f * (float)k * 0.01f);
                    }
                }
            } else if (this.isElytraFlying()) {
                int l = Math.round(MathHelper.sqrt(p_addMovementStat_1_ * p_addMovementStat_1_ + p_addMovementStat_3_ * p_addMovementStat_3_ + p_addMovementStat_5_ * p_addMovementStat_5_) * 100.0f);
                this.addStat(StatList.AVIATE_ONE_CM, l);
            } else {
                int i1 = Math.round(MathHelper.sqrt(p_addMovementStat_1_ * p_addMovementStat_1_ + p_addMovementStat_5_ * p_addMovementStat_5_) * 100.0f);
                if (i1 > 25) {
                    this.addStat(StatList.FLY_ONE_CM, i1);
                }
            }
        }
    }

    private void addMountedMovementStat(double p_addMountedMovementStat_1_, double p_addMountedMovementStat_3_, double p_addMountedMovementStat_5_) {
        int i;
        if (this.isRiding() && (i = Math.round(MathHelper.sqrt(p_addMountedMovementStat_1_ * p_addMountedMovementStat_1_ + p_addMountedMovementStat_3_ * p_addMountedMovementStat_3_ + p_addMountedMovementStat_5_ * p_addMountedMovementStat_5_) * 100.0f)) > 0) {
            if (this.getRidingEntity() instanceof EntityMinecart) {
                this.addStat(StatList.MINECART_ONE_CM, i);
                if (this.startMinecartRidingCoordinate == null) {
                    this.startMinecartRidingCoordinate = new BlockPos(this);
                } else if (this.startMinecartRidingCoordinate.distanceSq(MathHelper.floor(this.posX), MathHelper.floor(this.posY), MathHelper.floor(this.posZ)) >= 1000000.0) {
                    this.addStat(AchievementList.ON_A_RAIL);
                }
            } else if (this.getRidingEntity() instanceof EntityBoat) {
                this.addStat(StatList.BOAT_ONE_CM, i);
            } else if (this.getRidingEntity() instanceof EntityPig) {
                this.addStat(StatList.PIG_ONE_CM, i);
            } else if (this.getRidingEntity() instanceof AbstractHorse) {
                this.addStat(StatList.HORSE_ONE_CM, i);
            }
        }
    }

    @Override
    public void fall(float p_fall_1_, float p_fall_2_) {
        if (!this.capabilities.allowFlying) {
            if (p_fall_1_ >= 2.0f) {
                this.addStat(StatList.FALL_ONE_CM, (int)Math.round((double)p_fall_1_ * 100.0));
            }
            super.fall(p_fall_1_, p_fall_2_);
        } else {
            ForgeEventFactory.onPlayerFall(this, p_fall_1_, p_fall_2_);
        }
    }

    @Override
    protected void resetHeight() {
        if (!this.isSpectator()) {
            super.resetHeight();
        }
    }

    @Override
    protected SoundEvent getFallSound(int p_getFallSound_1_) {
        return p_getFallSound_1_ > 4 ? SoundEvents.ENTITY_PLAYER_BIG_FALL : SoundEvents.ENTITY_PLAYER_SMALL_FALL;
    }

    @Override
    public void onKillEntity(EntityLivingBase p_onKillEntity_1_) {
        EntityList.EntityEggInfo entitylist$entityegginfo;
        if (p_onKillEntity_1_ instanceof IMob) {
            this.addStat(AchievementList.KILL_ENEMY);
        }
        if ((entitylist$entityegginfo = EntityList.ENTITY_EGGS.get(EntityList.getKey(p_onKillEntity_1_))) != null) {
            this.addStat(entitylist$entityegginfo.killEntityStat);
        }
    }

    @Override
    public void setInWeb() {
        if (!this.capabilities.isFlying) {
            super.setInWeb();
        }
    }

    public void addExperience(int p_addExperience_1_) {
        this.addScore(p_addExperience_1_);
        int i = Integer.MAX_VALUE - this.experienceTotal;
        if (p_addExperience_1_ > i) {
            p_addExperience_1_ = i;
        }
        this.experience += (float)p_addExperience_1_ / (float)this.xpBarCap();
        this.experienceTotal += p_addExperience_1_;
        while (this.experience >= 1.0f) {
            this.experience = (this.experience - 1.0f) * (float)this.xpBarCap();
            this.addExperienceLevel(1);
            this.experience /= (float)this.xpBarCap();
        }
    }

    public int getXPSeed() {
        return this.xpSeed;
    }

    public void removeExperienceLevel(int p_removeExperienceLevel_1_) {
        this.experienceLevel -= p_removeExperienceLevel_1_;
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
            this.experience = 0.0f;
            this.experienceTotal = 0;
        }
        this.xpSeed = this.rand.nextInt();
    }

    public void addExperienceLevel(int p_addExperienceLevel_1_) {
        this.experienceLevel += p_addExperienceLevel_1_;
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
            this.experience = 0.0f;
            this.experienceTotal = 0;
        }
        if (p_addExperienceLevel_1_ > 0 && this.experienceLevel % 5 == 0 && (float)this.lastXPSound < (float)this.ticksExisted - 100.0f) {
            float f = this.experienceLevel > 30 ? 1.0f : (float)this.experienceLevel / 30.0f;
            this.world.playSound(null, this.posX, this.posY, this.posZ, SoundEvents.ENTITY_PLAYER_LEVELUP, this.getSoundCategory(), f * 0.75f, 1.0f);
            this.lastXPSound = this.ticksExisted;
        }
    }

    public int xpBarCap() {
        return this.experienceLevel >= 30 ? 112 + (this.experienceLevel - 30) * 9 : (this.experienceLevel >= 15 ? 37 + (this.experienceLevel - 15) * 5 : 7 + this.experienceLevel * 2);
    }

    public void addExhaustion(float p_addExhaustion_1_) {
        if (!this.capabilities.disableDamage && !this.world.isRemote) {
            this.foodStats.addExhaustion(p_addExhaustion_1_);
        }
    }

    public FoodStats getFoodStats() {
        return this.foodStats;
    }

    public boolean canEat(boolean p_canEat_1_) {
        return (p_canEat_1_ || this.foodStats.needFood()) && !this.capabilities.disableDamage;
    }

    public boolean shouldHeal() {
        return this.getHealth() > 0.0f && this.getHealth() < this.getMaxHealth();
    }

    public boolean isAllowEdit() {
        return this.capabilities.allowEdit;
    }

    public boolean canPlayerEdit(BlockPos p_canPlayerEdit_1_, EnumFacing p_canPlayerEdit_2_, ItemStack p_canPlayerEdit_3_) {
        if (this.capabilities.allowEdit) {
            return true;
        }
        if (p_canPlayerEdit_3_.isEmpty()) {
            return false;
        }
        BlockPos blockpos = p_canPlayerEdit_1_.offset(p_canPlayerEdit_2_.getOpposite());
        Block block = this.world.getBlockState(blockpos).getBlock();
        return p_canPlayerEdit_3_.canPlaceOn(block) || p_canPlayerEdit_3_.canEditBlocks();
    }

    @Override
    protected int getExperiencePoints(EntityPlayer p_getExperiencePoints_1_) {
        if (!this.world.getGameRules().getBoolean("keepInventory") && !this.isSpectator()) {
            int i = this.experienceLevel * 7;
            return i > 100 ? 100 : i;
        }
        return 0;
    }

    @Override
    protected boolean isPlayer() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean getAlwaysRenderNameTagForRender() {
        return true;
    }

    public void clonePlayer(EntityPlayer p_clonePlayer_1_, boolean p_clonePlayer_2_) {
        if (p_clonePlayer_2_) {
            this.inventory.copyInventory(p_clonePlayer_1_.inventory);
            this.setHealth(p_clonePlayer_1_.getHealth());
            this.foodStats = p_clonePlayer_1_.foodStats;
            this.experienceLevel = p_clonePlayer_1_.experienceLevel;
            this.experienceTotal = p_clonePlayer_1_.experienceTotal;
            this.experience = p_clonePlayer_1_.experience;
            this.setScore(p_clonePlayer_1_.getScore());
            this.lastPortalPos = p_clonePlayer_1_.lastPortalPos;
            this.lastPortalVec = p_clonePlayer_1_.lastPortalVec;
            this.teleportDirection = p_clonePlayer_1_.teleportDirection;
        } else if (this.world.getGameRules().getBoolean("keepInventory") || p_clonePlayer_1_.isSpectator()) {
            this.inventory.copyInventory(p_clonePlayer_1_.inventory);
            this.experienceLevel = p_clonePlayer_1_.experienceLevel;
            this.experienceTotal = p_clonePlayer_1_.experienceTotal;
            this.experience = p_clonePlayer_1_.experience;
            this.setScore(p_clonePlayer_1_.getScore());
        }
        this.xpSeed = p_clonePlayer_1_.xpSeed;
        this.theInventoryEnderChest = p_clonePlayer_1_.theInventoryEnderChest;
        this.getDataManager().set(PLAYER_MODEL_FLAG, p_clonePlayer_1_.getDataManager().get(PLAYER_MODEL_FLAG));
        this.spawnChunkMap = p_clonePlayer_1_.spawnChunkMap;
        this.spawnForcedMap = p_clonePlayer_1_.spawnForcedMap;
        NBTTagCompound old = p_clonePlayer_1_.getEntityData();
        if (old.hasKey(PERSISTED_NBT_TAG)) {
            this.getEntityData().setTag(PERSISTED_NBT_TAG, old.getCompoundTag(PERSISTED_NBT_TAG));
        }
        ForgeEventFactory.onPlayerClone(this, p_clonePlayer_1_, !p_clonePlayer_2_);
    }

    @Override
    protected boolean canTriggerWalking() {
        return !this.capabilities.isFlying;
    }

    public void sendPlayerAbilities() {
    }

    public void setGameType(GameType p_setGameType_1_) {
    }

    @Override
    public String getName() {
        return this.gameProfile.getName();
    }

    public InventoryEnderChest getInventoryEnderChest() {
        return this.theInventoryEnderChest;
    }

    @Override
    public ItemStack getItemStackFromSlot(EntityEquipmentSlot p_getItemStackFromSlot_1_) {
        return p_getItemStackFromSlot_1_ == EntityEquipmentSlot.MAINHAND ? this.inventory.getCurrentItem() : (p_getItemStackFromSlot_1_ == EntityEquipmentSlot.OFFHAND ? this.inventory.offHandInventory.get(0) : (p_getItemStackFromSlot_1_.getSlotType() == EntityEquipmentSlot.Type.ARMOR ? this.inventory.armorInventory.get(p_getItemStackFromSlot_1_.getIndex()) : ItemStack.EMPTY));
    }

    @Override
    public void setItemStackToSlot(EntityEquipmentSlot p_setItemStackToSlot_1_, ItemStack p_setItemStackToSlot_2_) {
        if (p_setItemStackToSlot_1_ == EntityEquipmentSlot.MAINHAND) {
            this.playEquipSound(p_setItemStackToSlot_2_);
            this.inventory.mainInventory.set(this.inventory.currentItem, p_setItemStackToSlot_2_);
        } else if (p_setItemStackToSlot_1_ == EntityEquipmentSlot.OFFHAND) {
            this.playEquipSound(p_setItemStackToSlot_2_);
            this.inventory.offHandInventory.set(0, p_setItemStackToSlot_2_);
        } else if (p_setItemStackToSlot_1_.getSlotType() == EntityEquipmentSlot.Type.ARMOR) {
            this.playEquipSound(p_setItemStackToSlot_2_);
            this.inventory.armorInventory.set(p_setItemStackToSlot_1_.getIndex(), p_setItemStackToSlot_2_);
        }
    }

    public boolean func_191521_c(ItemStack p_191521_1_) {
        this.playEquipSound(p_191521_1_);
        return this.inventory.addItemStackToInventory(p_191521_1_);
    }

    @Override
    public Iterable<ItemStack> getHeldEquipment() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.getHeldItemMainhand(), this.getHeldItemOffhand()});
    }

    @Override
    public Iterable<ItemStack> getArmorInventoryList() {
        return this.inventory.armorInventory;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isInvisibleToPlayer(EntityPlayer p_isInvisibleToPlayer_1_) {
        if (!this.isInvisible()) {
            return false;
        }
        if (p_isInvisibleToPlayer_1_.isSpectator()) {
            return false;
        }
        Team team = this.getTeam();
        return team == null || p_isInvisibleToPlayer_1_ == null || p_isInvisibleToPlayer_1_.getTeam() != team || !team.getSeeFriendlyInvisiblesEnabled();
    }

    public abstract boolean isSpectator();

    public abstract boolean isCreative();

    @Override
    public boolean isPushedByWater() {
        return !this.capabilities.isFlying;
    }

    public Scoreboard getWorldScoreboard() {
        return this.world.getScoreboard();
    }

    @Override
    public Team getTeam() {
        return this.getWorldScoreboard().getPlayersTeam(this.getName());
    }

    @Override
    public ITextComponent getDisplayName() {
        TextComponentString itextcomponent = new TextComponentString("");
        if (!this.prefixes.isEmpty()) {
            for (ITextComponent prefix : this.prefixes) {
                itextcomponent.appendSibling(prefix);
            }
        }
        itextcomponent.appendSibling(new TextComponentString(ScorePlayerTeam.formatPlayerName(this.getTeam(), this.getDisplayNameString())));
        if (!this.suffixes.isEmpty()) {
            for (ITextComponent suffix : this.suffixes) {
                itextcomponent.appendSibling(suffix);
            }
        }
        itextcomponent.getStyle().setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/msg " + this.getName() + " "));
        itextcomponent.getStyle().setHoverEvent(this.getHoverEvent());
        itextcomponent.getStyle().setInsertion(this.getName());
        return itextcomponent;
    }

    @Override
    public float getEyeHeight() {
        float f = this.eyeHeight;
        if (this.isPlayerSleeping()) {
            f = 0.2f;
        } else if (!this.isSneaking() && this.height != 1.65f) {
            if (this.isElytraFlying() || this.height == 0.6f) {
                f = 0.4f;
            }
        } else {
            f -= 0.08f;
        }
        return f;
    }

    @Override
    public void setAbsorptionAmount(float p_setAbsorptionAmount_1_) {
        if (p_setAbsorptionAmount_1_ < 0.0f) {
            p_setAbsorptionAmount_1_ = 0.0f;
        }
        this.getDataManager().set(ABSORPTION, Float.valueOf(p_setAbsorptionAmount_1_));
    }

    @Override
    public float getAbsorptionAmount() {
        return this.getDataManager().get(ABSORPTION).floatValue();
    }

    public static UUID getUUID(GameProfile p_getUUID_0_) {
        UUID uuid = p_getUUID_0_.getId();
        if (uuid == null) {
            uuid = EntityPlayer.getOfflineUUID(p_getUUID_0_.getName());
        }
        return uuid;
    }

    public static UUID getOfflineUUID(String p_getOfflineUUID_0_) {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + p_getOfflineUUID_0_).getBytes(Charsets.UTF_8));
    }

    public boolean canOpen(LockCode p_canOpen_1_) {
        if (p_canOpen_1_.isEmpty()) {
            return true;
        }
        ItemStack itemstack = this.getHeldItemMainhand();
        return !itemstack.isEmpty() && itemstack.hasDisplayName() ? itemstack.getDisplayName().equals(p_canOpen_1_.getLock()) : false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isWearing(EnumPlayerModelParts p_isWearing_1_) {
        return (this.getDataManager().get(PLAYER_MODEL_FLAG) & p_isWearing_1_.getPartMask()) == p_isWearing_1_.getPartMask();
    }

    @Override
    public boolean sendCommandFeedback() {
        return this.getServer().worlds[0].getGameRules().getBoolean("sendCommandFeedback");
    }

    @Override
    public boolean replaceItemInInventory(int p_replaceItemInInventory_1_, ItemStack p_replaceItemInInventory_2_) {
        if (p_replaceItemInInventory_1_ >= 0 && p_replaceItemInInventory_1_ < this.inventory.mainInventory.size()) {
            this.inventory.setInventorySlotContents(p_replaceItemInInventory_1_, p_replaceItemInInventory_2_);
            return true;
        }
        EntityEquipmentSlot entityequipmentslot = p_replaceItemInInventory_1_ == 100 + EntityEquipmentSlot.HEAD.getIndex() ? EntityEquipmentSlot.HEAD : (p_replaceItemInInventory_1_ == 100 + EntityEquipmentSlot.CHEST.getIndex() ? EntityEquipmentSlot.CHEST : (p_replaceItemInInventory_1_ == 100 + EntityEquipmentSlot.LEGS.getIndex() ? EntityEquipmentSlot.LEGS : (p_replaceItemInInventory_1_ == 100 + EntityEquipmentSlot.FEET.getIndex() ? EntityEquipmentSlot.FEET : null)));
        if (p_replaceItemInInventory_1_ == 98) {
            this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, p_replaceItemInInventory_2_);
            return true;
        }
        if (p_replaceItemInInventory_1_ == 99) {
            this.setItemStackToSlot(EntityEquipmentSlot.OFFHAND, p_replaceItemInInventory_2_);
            return true;
        }
        if (entityequipmentslot == null) {
            int i = p_replaceItemInInventory_1_ - 200;
            if (i >= 0 && i < this.theInventoryEnderChest.getSizeInventory()) {
                this.theInventoryEnderChest.setInventorySlotContents(i, p_replaceItemInInventory_2_);
                return true;
            }
            return false;
        }
        if (!p_replaceItemInInventory_2_.isEmpty() && (!(p_replaceItemInInventory_2_.getItem() instanceof ItemArmor) && !(p_replaceItemInInventory_2_.getItem() instanceof ItemElytra) ? entityequipmentslot != EntityEquipmentSlot.HEAD : EntityLiving.getSlotForItemStack(p_replaceItemInInventory_2_) != entityequipmentslot)) {
            return false;
        }
        this.inventory.setInventorySlotContents(entityequipmentslot.getIndex() + this.inventory.mainInventory.size(), p_replaceItemInInventory_2_);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasReducedDebug() {
        return this.hasReducedDebug;
    }

    @SideOnly(value=Side.CLIENT)
    public void setReducedDebug(boolean p_setReducedDebug_1_) {
        this.hasReducedDebug = p_setReducedDebug_1_;
    }

    @Override
    public EnumHandSide getPrimaryHand() {
        return this.dataManager.get(MAIN_HAND) == 0 ? EnumHandSide.LEFT : EnumHandSide.RIGHT;
    }

    public void setPrimaryHand(EnumHandSide p_setPrimaryHand_1_) {
        this.dataManager.set(MAIN_HAND, (byte)(p_setPrimaryHand_1_ != EnumHandSide.LEFT ? 1 : 0));
    }

    public float getCooldownPeriod() {
        return (float)(1.0 / this.getEntityAttribute(SharedMonsterAttributes.ATTACK_SPEED).getAttributeValue() * 20.0);
    }

    public float getCooledAttackStrength(float p_getCooledAttackStrength_1_) {
        return MathHelper.clamp(((float)this.ticksSinceLastSwing + p_getCooledAttackStrength_1_) / this.getCooldownPeriod(), 0.0f, 1.0f);
    }

    public void resetCooldown() {
        this.ticksSinceLastSwing = 0;
    }

    public CooldownTracker getCooldownTracker() {
        return this.cooldownTracker;
    }

    @Override
    public void applyEntityCollision(Entity p_applyEntityCollision_1_) {
        if (!this.isPlayerSleeping()) {
            super.applyEntityCollision(p_applyEntityCollision_1_);
        }
    }

    public float getLuck() {
        return (float)this.getEntityAttribute(SharedMonsterAttributes.LUCK).getAttributeValue();
    }

    public boolean canUseCommandBlock() {
        return this.capabilities.isCreativeMode && this.canUseCommand(2, "");
    }

    public void openGui(Object p_openGui_1_, int p_openGui_2_, World p_openGui_3_, int p_openGui_4_, int p_openGui_5_, int p_openGui_6_) {
        FMLNetworkHandler.openGui(this, p_openGui_1_, p_openGui_2_, p_openGui_3_, p_openGui_4_, p_openGui_5_, p_openGui_6_);
    }

    public BlockPos getBedLocation(int p_getBedLocation_1_) {
        return p_getBedLocation_1_ == 0 ? this.spawnChunk : this.spawnChunkMap.get(p_getBedLocation_1_);
    }

    public boolean isSpawnForced(int p_isSpawnForced_1_) {
        if (p_isSpawnForced_1_ == 0) {
            return this.spawnForced;
        }
        Boolean forced = this.spawnForcedMap.get(p_isSpawnForced_1_);
        return forced == null ? false : forced;
    }

    public void setSpawnChunk(BlockPos p_setSpawnChunk_1_, boolean p_setSpawnChunk_2_, int p_setSpawnChunk_3_) {
        if (p_setSpawnChunk_3_ == 0) {
            if (p_setSpawnChunk_1_ != null) {
                this.spawnChunk = p_setSpawnChunk_1_;
                this.spawnForced = p_setSpawnChunk_2_;
            } else {
                this.spawnChunk = null;
                this.spawnForced = false;
            }
            return;
        }
        if (p_setSpawnChunk_1_ != null) {
            this.spawnChunkMap.put(p_setSpawnChunk_3_, p_setSpawnChunk_1_);
            this.spawnForcedMap.put(p_setSpawnChunk_3_, p_setSpawnChunk_2_);
        } else {
            this.spawnChunkMap.remove(p_setSpawnChunk_3_);
            this.spawnForcedMap.remove(p_setSpawnChunk_3_);
        }
    }

    public float getDefaultEyeHeight() {
        return 1.62f;
    }

    public String getDisplayNameString() {
        if (this.displayname == null) {
            this.displayname = ForgeEventFactory.getPlayerDisplayName(this, this.getName());
        }
        return this.displayname;
    }

    public void refreshDisplayName() {
        this.displayname = ForgeEventFactory.getPlayerDisplayName(this, this.getName());
    }

    public void addPrefix(ITextComponent p_addPrefix_1_) {
        this.prefixes.add(p_addPrefix_1_);
    }

    public void addSuffix(ITextComponent p_addSuffix_1_) {
        this.suffixes.add(p_addSuffix_1_);
    }

    public Collection<ITextComponent> getPrefixes() {
        return this.prefixes;
    }

    public Collection<ITextComponent> getSuffixes() {
        return this.suffixes;
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> p_getCapability_1_, EnumFacing p_getCapability_2_) {
        if (p_getCapability_1_ == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (p_getCapability_2_ == null) {
                return (T)this.playerJoinedHandler;
            }
            if (p_getCapability_2_.getAxis().isVertical()) {
                return (T)this.playerMainHandler;
            }
            if (p_getCapability_2_.getAxis().isHorizontal()) {
                return (T)this.playerEquipmentHandler;
            }
        }
        return super.getCapability(p_getCapability_1_, p_getCapability_2_);
    }

    @Override
    public boolean hasCapability(Capability<?> p_hasCapability_1_, EnumFacing p_hasCapability_2_) {
        return p_hasCapability_1_ == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(p_hasCapability_1_, p_hasCapability_2_);
    }

    public static enum SleepResult {
        OK,
        NOT_POSSIBLE_HERE,
        NOT_POSSIBLE_NOW,
        TOO_FAR_AWAY,
        OTHER_PROBLEM,
        NOT_SAFE;

    }

    public static enum EnumChatVisibility {
        FULL(0, "options.chat.visibility.full"),
        SYSTEM(1, "options.chat.visibility.system"),
        HIDDEN(2, "options.chat.visibility.hidden");

        private static final EnumChatVisibility[] ID_LOOKUP;
        private final int chatVisibility;
        private final String resourceKey;

        private EnumChatVisibility(int p_i45323_3_, String p_i45323_4_) {
            this.chatVisibility = p_i45323_3_;
            this.resourceKey = p_i45323_4_;
        }

        @SideOnly(value=Side.CLIENT)
        public int getChatVisibility() {
            return this.chatVisibility;
        }

        @SideOnly(value=Side.CLIENT)
        public static EnumChatVisibility getEnumChatVisibility(int p_getEnumChatVisibility_0_) {
            return ID_LOOKUP[p_getEnumChatVisibility_0_ % ID_LOOKUP.length];
        }

        @SideOnly(value=Side.CLIENT)
        public String getResourceKey() {
            return this.resourceKey;
        }

        static {
            ID_LOOKUP = new EnumChatVisibility[EnumChatVisibility.values().length];
            EnumChatVisibility[] enumChatVisibilityArray = EnumChatVisibility.values();
            int n = enumChatVisibilityArray.length;
            for (int i = 0; i < n; ++i) {
                EnumChatVisibility entityplayer$enumchatvisibility;
                EnumChatVisibility.ID_LOOKUP[entityplayer$enumchatvisibility.chatVisibility] = entityplayer$enumchatvisibility = enumChatVisibilityArray[i];
            }
        }
    }
}

