/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.player;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.ContainerHorseInventory;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryMerchant;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMapBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketClientSettings;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.network.play.server.SPacketCamera;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.network.play.server.SPacketCloseWindow;
import net.minecraft.network.play.server.SPacketCombatEvent;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.network.play.server.SPacketDestroyEntities;
import net.minecraft.network.play.server.SPacketEffect;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.network.play.server.SPacketOpenWindow;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketRemoveEntityEffect;
import net.minecraft.network.play.server.SPacketResourcePackSend;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.network.play.server.SPacketSignEditorOpen;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.network.play.server.SPacketUpdateHealth;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.network.play.server.SPacketUseBed;
import net.minecraft.network.play.server.SPacketWindowItems;
import net.minecraft.network.play.server.SPacketWindowProperty;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.CooldownTrackerServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.JsonSerializableSet;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ReportedException;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataFixer;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.GameType;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.ILootContainer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AchievementEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityPlayerMP
extends EntityPlayer
implements IContainerListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private String language = "en_US";
    public NetHandlerPlayServer connection;
    public final MinecraftServer mcServer;
    public final PlayerInteractionManager interactionManager;
    public double managedPosX;
    public double managedPosZ;
    private final List<Integer> entityRemoveQueue = Lists.newLinkedList();
    private final StatisticsManagerServer statsFile;
    private float lastHealthScore = Float.MIN_VALUE;
    private int lastFoodScore = Integer.MIN_VALUE;
    private int lastAirScore = Integer.MIN_VALUE;
    private int lastArmorScore = Integer.MIN_VALUE;
    private int lastLevelScore = Integer.MIN_VALUE;
    private int lastExperienceScore = Integer.MIN_VALUE;
    private float lastHealth = -1.0E8f;
    private int lastFoodLevel = -99999999;
    private boolean wasHungry = true;
    private int lastExperience = -99999999;
    private int respawnInvulnerabilityTicks = 60;
    private EntityPlayer.EnumChatVisibility chatVisibility;
    private boolean chatColours = true;
    private long playerLastActiveTime = System.currentTimeMillis();
    private Entity spectatingEntity;
    private boolean invulnerableDimensionChange;
    public int currentWindowId;
    public boolean isChangingQuantityOnly;
    public int ping;
    public boolean playerConqueredTheEnd;

    public EntityPlayerMP(MinecraftServer p_i45285_1_, WorldServer p_i45285_2_, GameProfile p_i45285_3_, PlayerInteractionManager p_i45285_4_) {
        super(p_i45285_2_, p_i45285_3_);
        p_i45285_4_.player = this;
        this.interactionManager = p_i45285_4_;
        BlockPos blockpos = p_i45285_2_.provider.getRandomizedSpawnPoint();
        this.mcServer = p_i45285_1_;
        this.statsFile = p_i45285_1_.getPlayerList().getPlayerStatsFile(this);
        this.stepHeight = 0.0f;
        this.moveToBlockPosAndAngles(blockpos, 0.0f, 0.0f);
        while (!p_i45285_2_.getCollisionBoxes(this, this.getEntityBoundingBox()).isEmpty() && this.posY < 255.0) {
            this.setPosition(this.posX, this.posY + 1.0, this.posZ);
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        if (p_readEntityFromNBT_1_.hasKey("playerGameType", 99)) {
            if (this.getServer().getForceGamemode()) {
                this.interactionManager.setGameType(this.getServer().getGameType());
            } else {
                this.interactionManager.setGameType(GameType.getByID(p_readEntityFromNBT_1_.getInteger("playerGameType")));
            }
        }
    }

    public static void func_191522_a(DataFixer p_191522_0_) {
        p_191522_0_.registerWalker(FixTypes.PLAYER, new IDataWalker(){

            @Override
            public NBTTagCompound process(IDataFixer p_process_1_, NBTTagCompound p_process_2_, int p_process_3_) {
                NBTTagCompound nbttagcompound;
                if (p_process_2_.hasKey("RootVehicle", 10) && (nbttagcompound = p_process_2_.getCompoundTag("RootVehicle")).hasKey("Entity", 10)) {
                    nbttagcompound.setTag("Entity", p_process_1_.process(FixTypes.ENTITY, nbttagcompound.getCompoundTag("Entity"), p_process_3_));
                }
                return p_process_2_;
            }
        });
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setInteger("playerGameType", this.interactionManager.getGameType().getID());
        Entity entity = this.getLowestRidingEntity();
        Entity entity1 = this.getRidingEntity();
        if (entity1 != null && entity != this & entity.getRecursivePassengersByType(EntityPlayerMP.class).size() == 1) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            entity.writeToNBTOptional(nbttagcompound1);
            nbttagcompound.setUniqueId("Attach", entity1.getUniqueID());
            nbttagcompound.setTag("Entity", nbttagcompound1);
            p_writeEntityToNBT_1_.setTag("RootVehicle", nbttagcompound);
        }
    }

    @Override
    public void addExperienceLevel(int p_addExperienceLevel_1_) {
        super.addExperienceLevel(p_addExperienceLevel_1_);
        this.lastExperience = -1;
    }

    @Override
    public void removeExperienceLevel(int p_removeExperienceLevel_1_) {
        super.removeExperienceLevel(p_removeExperienceLevel_1_);
        this.lastExperience = -1;
    }

    public void addSelfToInternalCraftingInventory() {
        this.openContainer.addListener(this);
    }

    @Override
    public void sendEnterCombat() {
        super.sendEnterCombat();
        this.connection.sendPacket(new SPacketCombatEvent(this.getCombatTracker(), SPacketCombatEvent.Event.ENTER_COMBAT));
    }

    @Override
    public void sendEndCombat() {
        super.sendEndCombat();
        this.connection.sendPacket(new SPacketCombatEvent(this.getCombatTracker(), SPacketCombatEvent.Event.END_COMBAT));
    }

    @Override
    protected CooldownTracker createCooldownTracker() {
        return new CooldownTrackerServer(this);
    }

    @Override
    public void onUpdate() {
        this.interactionManager.updateBlockRemoving();
        --this.respawnInvulnerabilityTicks;
        if (this.hurtResistantTime > 0) {
            --this.hurtResistantTime;
        }
        this.openContainer.detectAndSendChanges();
        if (!this.world.isRemote && this.openContainer != null && !this.openContainer.canInteractWith(this)) {
            this.closeScreen();
            this.openContainer = this.inventoryContainer;
        }
        while (!this.entityRemoveQueue.isEmpty()) {
            int i = Math.min(this.entityRemoveQueue.size(), Integer.MAX_VALUE);
            int[] aint = new int[i];
            Iterator<Integer> iterator = this.entityRemoveQueue.iterator();
            int j = 0;
            while (iterator.hasNext() && j < i) {
                aint[j++] = iterator.next();
                iterator.remove();
            }
            this.connection.sendPacket(new SPacketDestroyEntities(aint));
        }
        Entity entity = this.getSpectatingEntity();
        if (entity != this) {
            if (entity.isEntityAlive()) {
                this.setPositionAndRotation(entity.posX, entity.posY, entity.posZ, entity.rotationYaw, entity.rotationPitch);
                this.mcServer.getPlayerList().serverUpdateMovingPlayer(this);
                if (this.isSneaking()) {
                    this.setSpectatingEntity(this);
                }
            } else {
                this.setSpectatingEntity(this);
            }
        }
    }

    public void onUpdateEntity() {
        try {
            super.onUpdate();
            for (int i = 0; i < this.inventory.getSizeInventory(); ++i) {
                Packet<?> packet;
                ItemStack itemstack = this.inventory.getStackInSlot(i);
                if (itemstack.isEmpty() || !itemstack.getItem().isMap() || (packet = ((ItemMapBase)itemstack.getItem()).createMapDataPacket(itemstack, this.world, this)) == null) continue;
                this.connection.sendPacket(packet);
            }
            if (this.getHealth() != this.lastHealth || this.lastFoodLevel != this.foodStats.getFoodLevel() || this.foodStats.getSaturationLevel() == 0.0f != this.wasHungry) {
                this.connection.sendPacket(new SPacketUpdateHealth(this.getHealth(), this.foodStats.getFoodLevel(), this.foodStats.getSaturationLevel()));
                this.lastHealth = this.getHealth();
                this.lastFoodLevel = this.foodStats.getFoodLevel();
                boolean bl = this.wasHungry = this.foodStats.getSaturationLevel() == 0.0f;
            }
            if (this.getHealth() + this.getAbsorptionAmount() != this.lastHealthScore) {
                this.lastHealthScore = this.getHealth() + this.getAbsorptionAmount();
                this.updateScorePoints(IScoreCriteria.HEALTH, MathHelper.ceil(this.lastHealthScore));
            }
            if (this.foodStats.getFoodLevel() != this.lastFoodScore) {
                this.lastFoodScore = this.foodStats.getFoodLevel();
                this.updateScorePoints(IScoreCriteria.FOOD, MathHelper.ceil(this.lastFoodScore));
            }
            if (this.getAir() != this.lastAirScore) {
                this.lastAirScore = this.getAir();
                this.updateScorePoints(IScoreCriteria.AIR, MathHelper.ceil(this.lastAirScore));
            }
            if (this.getTotalArmorValue() != this.lastArmorScore) {
                this.lastArmorScore = this.getTotalArmorValue();
                this.updateScorePoints(IScoreCriteria.ARMOR, MathHelper.ceil(this.lastArmorScore));
            }
            if (this.experienceTotal != this.lastExperienceScore) {
                this.lastExperienceScore = this.experienceTotal;
                this.updateScorePoints(IScoreCriteria.XP, MathHelper.ceil(this.lastExperienceScore));
            }
            if (this.experienceLevel != this.lastLevelScore) {
                this.lastLevelScore = this.experienceLevel;
                this.updateScorePoints(IScoreCriteria.LEVEL, MathHelper.ceil(this.lastLevelScore));
            }
            if (this.experienceTotal != this.lastExperience) {
                this.lastExperience = this.experienceTotal;
                this.connection.sendPacket(new SPacketSetExperience(this.experience, this.experienceTotal, this.experienceLevel));
            }
            if (this.ticksExisted % 100 == 0 && !this.getStatFile().hasAchievementUnlocked(AchievementList.EXPLORE_ALL_BIOMES)) {
                this.updateBiomesExplored();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Ticking player");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Player being ticked");
            this.addEntityCrashInfo(crashreportcategory);
            throw new ReportedException(crashreport);
        }
    }

    private void updateScorePoints(IScoreCriteria p_updateScorePoints_1_, int p_updateScorePoints_2_) {
        for (ScoreObjective scoreobjective : this.getWorldScoreboard().getObjectivesFromCriteria(p_updateScorePoints_1_)) {
            Score score = this.getWorldScoreboard().getOrCreateScore(this.getName(), scoreobjective);
            score.setScorePoints(p_updateScorePoints_2_);
        }
    }

    protected void updateBiomesExplored() {
        Biome biome = this.world.getBiome(new BlockPos(MathHelper.floor(this.posX), 0, MathHelper.floor(this.posZ)));
        String s = biome.getBiomeName();
        JsonSerializableSet jsonserializableset = (JsonSerializableSet)this.getStatFile().getProgress(AchievementList.EXPLORE_ALL_BIOMES);
        if (jsonserializableset == null) {
            jsonserializableset = this.getStatFile().setProgress(AchievementList.EXPLORE_ALL_BIOMES, new JsonSerializableSet());
        }
        jsonserializableset.add(s);
        if (this.getStatFile().canUnlockAchievement(AchievementList.EXPLORE_ALL_BIOMES) && jsonserializableset.size() >= Biome.EXPLORATION_BIOMES_LIST.size()) {
            HashSet set = Sets.newHashSet(Biome.EXPLORATION_BIOMES_LIST);
            Iterator iterator = jsonserializableset.iterator();
            while (iterator.hasNext()) {
                String s1 = (String)iterator.next();
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    Biome biome1 = (Biome)iterator2.next();
                    if (!biome1.getBiomeName().equals(s1)) continue;
                    iterator2.remove();
                }
                if (!set.isEmpty()) continue;
                break;
            }
            if (set.isEmpty()) {
                this.addStat(AchievementList.EXPLORE_ALL_BIOMES);
            }
        }
    }

    @Override
    public void onDeath(DamageSource p_onDeath_1_) {
        if (ForgeHooks.onLivingDeath(this, p_onDeath_1_)) {
            return;
        }
        boolean flag = this.world.getGameRules().getBoolean("showDeathMessages");
        this.connection.sendPacket(new SPacketCombatEvent(this.getCombatTracker(), SPacketCombatEvent.Event.ENTITY_DIED, flag));
        if (flag) {
            Team team = this.getTeam();
            if (team != null && team.getDeathMessageVisibility() != Team.EnumVisible.ALWAYS) {
                if (team.getDeathMessageVisibility() == Team.EnumVisible.HIDE_FOR_OTHER_TEAMS) {
                    this.mcServer.getPlayerList().sendMessageToAllTeamMembers(this, this.getCombatTracker().getDeathMessage());
                } else if (team.getDeathMessageVisibility() == Team.EnumVisible.HIDE_FOR_OWN_TEAM) {
                    this.mcServer.getPlayerList().sendMessageToTeamOrAllPlayers(this, this.getCombatTracker().getDeathMessage());
                }
            } else {
                this.mcServer.getPlayerList().sendMessage(this.getCombatTracker().getDeathMessage());
            }
        }
        if (!this.world.getGameRules().getBoolean("keepInventory") && !this.isSpectator()) {
            this.captureDrops = true;
            this.capturedDrops.clear();
            this.destroyVanishingCursedItems();
            this.inventory.dropAllItems();
            this.captureDrops = false;
            PlayerDropsEvent event = new PlayerDropsEvent(this, p_onDeath_1_, this.capturedDrops, this.recentlyHit > 0);
            if (!MinecraftForge.EVENT_BUS.post(event)) {
                for (EntityItem item : this.capturedDrops) {
                    this.world.spawnEntity(item);
                }
            }
        }
        for (ScoreObjective scoreobjective : this.world.getScoreboard().getObjectivesFromCriteria(IScoreCriteria.DEATH_COUNT)) {
            Score score = this.getWorldScoreboard().getOrCreateScore(this.getName(), scoreobjective);
            score.incrementScore();
        }
        EntityLivingBase entitylivingbase = this.getAttackingEntity();
        if (entitylivingbase != null) {
            EntityList.EntityEggInfo entitylist$entityegginfo = EntityList.ENTITY_EGGS.get(EntityList.getKey(entitylivingbase));
            if (entitylist$entityegginfo != null) {
                this.addStat(entitylist$entityegginfo.entityKilledByStat);
            }
            entitylivingbase.addToPlayerScore(this, this.scoreValue);
        }
        this.addStat(StatList.DEATHS);
        this.takeStat(StatList.TIME_SINCE_DEATH);
        this.extinguish();
        this.setFlag(0, false);
        this.getCombatTracker().reset();
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        boolean flag;
        if (this.isEntityInvulnerable(p_attackEntityFrom_1_)) {
            return false;
        }
        boolean bl = flag = this.mcServer.isDedicatedServer() && this.canPlayersAttack() && "fall".equals(p_attackEntityFrom_1_.damageType);
        if (!flag && this.respawnInvulnerabilityTicks > 0 && p_attackEntityFrom_1_ != DamageSource.OUT_OF_WORLD) {
            return false;
        }
        if (p_attackEntityFrom_1_ instanceof EntityDamageSource) {
            Entity entity = p_attackEntityFrom_1_.getEntity();
            if (entity instanceof EntityPlayer && !this.canAttackPlayer((EntityPlayer)entity)) {
                return false;
            }
            if (entity instanceof EntityArrow) {
                EntityArrow entityarrow = (EntityArrow)entity;
                if (entityarrow.shootingEntity instanceof EntityPlayer && !this.canAttackPlayer((EntityPlayer)entityarrow.shootingEntity)) {
                    return false;
                }
            }
        }
        return super.attackEntityFrom(p_attackEntityFrom_1_, p_attackEntityFrom_2_);
    }

    @Override
    public boolean canAttackPlayer(EntityPlayer p_canAttackPlayer_1_) {
        return !this.canPlayersAttack() ? false : super.canAttackPlayer(p_canAttackPlayer_1_);
    }

    private boolean canPlayersAttack() {
        return this.mcServer.isPVPEnabled();
    }

    @Override
    @Nullable
    public Entity changeDimension(int p_changeDimension_1_) {
        if (!ForgeHooks.onTravelToDimension(this, p_changeDimension_1_)) {
            return this;
        }
        this.invulnerableDimensionChange = true;
        if (this.dimension == 1 && p_changeDimension_1_ == 1) {
            this.world.removeEntity(this);
            if (!this.playerConqueredTheEnd) {
                this.playerConqueredTheEnd = true;
                if (this.hasAchievement(AchievementList.THE_END2)) {
                    this.connection.sendPacket(new SPacketChangeGameState(4, 0.0f));
                } else {
                    this.addStat(AchievementList.THE_END2);
                    this.connection.sendPacket(new SPacketChangeGameState(4, 1.0f));
                }
            }
            return this;
        }
        if (this.dimension == 0 && p_changeDimension_1_ == 1) {
            this.addStat(AchievementList.THE_END);
            p_changeDimension_1_ = 1;
        } else {
            this.addStat(AchievementList.PORTAL);
        }
        this.mcServer.getPlayerList().changePlayerDimension(this, p_changeDimension_1_);
        this.connection.sendPacket(new SPacketEffect(1032, BlockPos.ORIGIN, 0, false));
        this.lastExperience = -1;
        this.lastHealth = -1.0f;
        this.lastFoodLevel = -1;
        return this;
    }

    @Override
    public boolean isSpectatedByPlayer(EntityPlayerMP p_isSpectatedByPlayer_1_) {
        return p_isSpectatedByPlayer_1_.isSpectator() ? this.getSpectatingEntity() == this : (this.isSpectator() ? false : super.isSpectatedByPlayer(p_isSpectatedByPlayer_1_));
    }

    private void sendTileEntityUpdate(TileEntity p_sendTileEntityUpdate_1_) {
        SPacketUpdateTileEntity spacketupdatetileentity;
        if (p_sendTileEntityUpdate_1_ != null && (spacketupdatetileentity = p_sendTileEntityUpdate_1_.getUpdatePacket()) != null) {
            this.connection.sendPacket(spacketupdatetileentity);
        }
    }

    @Override
    public void onItemPickup(Entity p_onItemPickup_1_, int p_onItemPickup_2_) {
        super.onItemPickup(p_onItemPickup_1_, p_onItemPickup_2_);
        this.openContainer.detectAndSendChanges();
    }

    @Override
    public EntityPlayer.SleepResult trySleep(BlockPos p_trySleep_1_) {
        EntityPlayer.SleepResult entityplayer$sleepresult = super.trySleep(p_trySleep_1_);
        if (entityplayer$sleepresult == EntityPlayer.SleepResult.OK) {
            this.addStat(StatList.SLEEP_IN_BED);
            SPacketUseBed packet = new SPacketUseBed(this, p_trySleep_1_);
            this.getServerWorld().getEntityTracker().sendToTracking(this, packet);
            this.connection.setPlayerLocation(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
            this.connection.sendPacket(packet);
        }
        return entityplayer$sleepresult;
    }

    @Override
    public void wakeUpPlayer(boolean p_wakeUpPlayer_1_, boolean p_wakeUpPlayer_2_, boolean p_wakeUpPlayer_3_) {
        if (this.isPlayerSleeping()) {
            this.getServerWorld().getEntityTracker().sendToTrackingAndSelf(this, new SPacketAnimation(this, 2));
        }
        super.wakeUpPlayer(p_wakeUpPlayer_1_, p_wakeUpPlayer_2_, p_wakeUpPlayer_3_);
        if (this.connection != null) {
            this.connection.setPlayerLocation(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
        }
    }

    @Override
    public boolean startRiding(Entity p_startRiding_1_, boolean p_startRiding_2_) {
        Entity entity = this.getRidingEntity();
        if (!super.startRiding(p_startRiding_1_, p_startRiding_2_)) {
            return false;
        }
        Entity entity1 = this.getRidingEntity();
        if (entity1 != entity && this.connection != null) {
            this.connection.setPlayerLocation(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
        }
        return true;
    }

    @Override
    public void dismountRidingEntity() {
        Entity entity = this.getRidingEntity();
        super.dismountRidingEntity();
        Entity entity1 = this.getRidingEntity();
        if (entity1 != entity && this.connection != null) {
            this.connection.setPlayerLocation(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
        }
    }

    @Override
    public boolean isEntityInvulnerable(DamageSource p_isEntityInvulnerable_1_) {
        return super.isEntityInvulnerable(p_isEntityInvulnerable_1_) || this.isInvulnerableDimensionChange();
    }

    @Override
    protected void updateFallState(double p_updateFallState_1_, boolean p_updateFallState_3_, IBlockState p_updateFallState_4_, BlockPos p_updateFallState_5_) {
    }

    @Override
    protected void frostWalk(BlockPos p_frostWalk_1_) {
        if (!this.isSpectator()) {
            super.frostWalk(p_frostWalk_1_);
        }
    }

    public void handleFalling(double p_handleFalling_1_, boolean p_handleFalling_3_) {
        BlockPos blockpos1;
        IBlockState iblockstate1;
        Block block;
        int k;
        int j;
        int i = MathHelper.floor(this.posX);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.floor(this.posY - (double)0.2f), k = MathHelper.floor(this.posZ));
        IBlockState iblockstate = this.world.getBlockState(blockpos);
        if (iblockstate.getBlock().isAir(iblockstate, this.world, blockpos) && ((block = (iblockstate1 = this.world.getBlockState(blockpos1 = blockpos.down())).getBlock()) instanceof BlockFence || block instanceof BlockWall || block instanceof BlockFenceGate)) {
            blockpos = blockpos1;
            iblockstate = iblockstate1;
        }
        super.updateFallState(p_handleFalling_1_, p_handleFalling_3_, iblockstate, blockpos);
    }

    @Override
    public void openEditSign(TileEntitySign p_openEditSign_1_) {
        p_openEditSign_1_.setPlayer(this);
        this.connection.sendPacket(new SPacketSignEditorOpen(p_openEditSign_1_.getPos()));
    }

    public void getNextWindowId() {
        this.currentWindowId = this.currentWindowId % 100 + 1;
    }

    @Override
    public void displayGui(IInteractionObject p_displayGui_1_) {
        if (p_displayGui_1_ instanceof ILootContainer && ((ILootContainer)((Object)p_displayGui_1_)).getLootTable() != null && this.isSpectator()) {
            this.sendStatusMessage(new TextComponentTranslation("container.spectatorCantOpen", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)), true);
        } else {
            this.getNextWindowId();
            this.connection.sendPacket(new SPacketOpenWindow(this.currentWindowId, p_displayGui_1_.getGuiID(), p_displayGui_1_.getDisplayName()));
            this.openContainer = p_displayGui_1_.createContainer(this.inventory, this);
            this.openContainer.windowId = this.currentWindowId;
            this.openContainer.addListener(this);
            MinecraftForge.EVENT_BUS.post(new PlayerContainerEvent.Open(this, this.openContainer));
        }
    }

    @Override
    public void displayGUIChest(IInventory p_displayGUIChest_1_) {
        if (p_displayGUIChest_1_ instanceof ILootContainer && ((ILootContainer)((Object)p_displayGUIChest_1_)).getLootTable() != null && this.isSpectator()) {
            this.sendStatusMessage(new TextComponentTranslation("container.spectatorCantOpen", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)), true);
        } else {
            ILockableContainer ilockablecontainer;
            if (this.openContainer != this.inventoryContainer) {
                this.closeScreen();
            }
            if (p_displayGUIChest_1_ instanceof ILockableContainer && (ilockablecontainer = (ILockableContainer)p_displayGUIChest_1_).isLocked() && !this.canOpen(ilockablecontainer.getLockCode()) && !this.isSpectator()) {
                this.connection.sendPacket(new SPacketChat(new TextComponentTranslation("container.isLocked", p_displayGUIChest_1_.getDisplayName()), 2));
                this.connection.sendPacket(new SPacketSoundEffect(SoundEvents.BLOCK_CHEST_LOCKED, SoundCategory.BLOCKS, this.posX, this.posY, this.posZ, 1.0f, 1.0f));
                return;
            }
            this.getNextWindowId();
            if (p_displayGUIChest_1_ instanceof IInteractionObject) {
                this.connection.sendPacket(new SPacketOpenWindow(this.currentWindowId, ((IInteractionObject)((Object)p_displayGUIChest_1_)).getGuiID(), p_displayGUIChest_1_.getDisplayName(), p_displayGUIChest_1_.getSizeInventory()));
                this.openContainer = ((IInteractionObject)((Object)p_displayGUIChest_1_)).createContainer(this.inventory, this);
            } else {
                this.connection.sendPacket(new SPacketOpenWindow(this.currentWindowId, "minecraft:container", p_displayGUIChest_1_.getDisplayName(), p_displayGUIChest_1_.getSizeInventory()));
                this.openContainer = new ContainerChest(this.inventory, p_displayGUIChest_1_, this);
            }
            this.openContainer.windowId = this.currentWindowId;
            this.openContainer.addListener(this);
            MinecraftForge.EVENT_BUS.post(new PlayerContainerEvent.Open(this, this.openContainer));
        }
    }

    @Override
    public void displayVillagerTradeGui(IMerchant p_displayVillagerTradeGui_1_) {
        this.getNextWindowId();
        this.openContainer = new ContainerMerchant(this.inventory, p_displayVillagerTradeGui_1_, this.world);
        this.openContainer.windowId = this.currentWindowId;
        this.openContainer.addListener(this);
        MinecraftForge.EVENT_BUS.post(new PlayerContainerEvent.Open(this, this.openContainer));
        InventoryMerchant iinventory = ((ContainerMerchant)this.openContainer).getMerchantInventory();
        ITextComponent itextcomponent = p_displayVillagerTradeGui_1_.getDisplayName();
        this.connection.sendPacket(new SPacketOpenWindow(this.currentWindowId, "minecraft:villager", itextcomponent, iinventory.getSizeInventory()));
        MerchantRecipeList merchantrecipelist = p_displayVillagerTradeGui_1_.getRecipes(this);
        if (merchantrecipelist != null) {
            PacketBuffer packetbuffer = new PacketBuffer(Unpooled.buffer());
            packetbuffer.writeInt(this.currentWindowId);
            merchantrecipelist.writeToBuf(packetbuffer);
            this.connection.sendPacket(new SPacketCustomPayload("MC|TrList", packetbuffer));
        }
    }

    @Override
    public void openGuiHorseInventory(AbstractHorse p_openGuiHorseInventory_1_, IInventory p_openGuiHorseInventory_2_) {
        if (this.openContainer != this.inventoryContainer) {
            this.closeScreen();
        }
        this.getNextWindowId();
        this.connection.sendPacket(new SPacketOpenWindow(this.currentWindowId, "EntityHorse", p_openGuiHorseInventory_2_.getDisplayName(), p_openGuiHorseInventory_2_.getSizeInventory(), p_openGuiHorseInventory_1_.getEntityId()));
        this.openContainer = new ContainerHorseInventory(this.inventory, p_openGuiHorseInventory_2_, p_openGuiHorseInventory_1_, this);
        this.openContainer.windowId = this.currentWindowId;
        this.openContainer.addListener(this);
    }

    @Override
    public void openBook(ItemStack p_openBook_1_, EnumHand p_openBook_2_) {
        Item item = p_openBook_1_.getItem();
        if (item == Items.WRITTEN_BOOK) {
            PacketBuffer packetbuffer = new PacketBuffer(Unpooled.buffer());
            packetbuffer.writeEnumValue(p_openBook_2_);
            this.connection.sendPacket(new SPacketCustomPayload("MC|BOpen", packetbuffer));
        }
    }

    @Override
    public void displayGuiCommandBlock(TileEntityCommandBlock p_displayGuiCommandBlock_1_) {
        p_displayGuiCommandBlock_1_.setSendToClient(true);
        this.sendTileEntityUpdate(p_displayGuiCommandBlock_1_);
    }

    @Override
    public void sendSlotContents(Container p_sendSlotContents_1_, int p_sendSlotContents_2_, ItemStack p_sendSlotContents_3_) {
        if (!(p_sendSlotContents_1_.getSlot(p_sendSlotContents_2_) instanceof SlotCrafting) && !this.isChangingQuantityOnly) {
            this.connection.sendPacket(new SPacketSetSlot(p_sendSlotContents_1_.windowId, p_sendSlotContents_2_, p_sendSlotContents_3_));
        }
    }

    public void sendContainerToPlayer(Container p_sendContainerToPlayer_1_) {
        this.updateCraftingInventory(p_sendContainerToPlayer_1_, p_sendContainerToPlayer_1_.getInventory());
    }

    @Override
    public void updateCraftingInventory(Container p_updateCraftingInventory_1_, NonNullList<ItemStack> p_updateCraftingInventory_2_) {
        this.connection.sendPacket(new SPacketWindowItems(p_updateCraftingInventory_1_.windowId, p_updateCraftingInventory_2_));
        this.connection.sendPacket(new SPacketSetSlot(-1, -1, this.inventory.getItemStack()));
    }

    @Override
    public void sendProgressBarUpdate(Container p_sendProgressBarUpdate_1_, int p_sendProgressBarUpdate_2_, int p_sendProgressBarUpdate_3_) {
        this.connection.sendPacket(new SPacketWindowProperty(p_sendProgressBarUpdate_1_.windowId, p_sendProgressBarUpdate_2_, p_sendProgressBarUpdate_3_));
    }

    @Override
    public void sendAllWindowProperties(Container p_sendAllWindowProperties_1_, IInventory p_sendAllWindowProperties_2_) {
        for (int i = 0; i < p_sendAllWindowProperties_2_.getFieldCount(); ++i) {
            this.connection.sendPacket(new SPacketWindowProperty(p_sendAllWindowProperties_1_.windowId, i, p_sendAllWindowProperties_2_.getField(i)));
        }
    }

    @Override
    public void closeScreen() {
        this.connection.sendPacket(new SPacketCloseWindow(this.openContainer.windowId));
        this.closeContainer();
    }

    public void updateHeldItem() {
        if (!this.isChangingQuantityOnly) {
            this.connection.sendPacket(new SPacketSetSlot(-1, -1, this.inventory.getItemStack()));
        }
    }

    public void closeContainer() {
        this.openContainer.onContainerClosed(this);
        MinecraftForge.EVENT_BUS.post(new PlayerContainerEvent.Close(this, this.openContainer));
        this.openContainer = this.inventoryContainer;
    }

    public void setEntityActionState(float p_setEntityActionState_1_, float p_setEntityActionState_2_, boolean p_setEntityActionState_3_, boolean p_setEntityActionState_4_) {
        if (this.isRiding()) {
            if (p_setEntityActionState_1_ >= -1.0f && p_setEntityActionState_1_ <= 1.0f) {
                this.moveStrafing = p_setEntityActionState_1_;
            }
            if (p_setEntityActionState_2_ >= -1.0f && p_setEntityActionState_2_ <= 1.0f) {
                this.moveForward = p_setEntityActionState_2_;
            }
            this.isJumping = p_setEntityActionState_3_;
            this.setSneaking(p_setEntityActionState_4_);
        }
    }

    @Override
    public boolean hasAchievement(Achievement p_hasAchievement_1_) {
        return this.statsFile.hasAchievementUnlocked(p_hasAchievement_1_);
    }

    @Override
    public void addStat(StatBase p_addStat_1_, int p_addStat_2_) {
        if (p_addStat_1_ != null) {
            if (p_addStat_1_.isAchievement() && MinecraftForge.EVENT_BUS.post(new AchievementEvent(this, (Achievement)p_addStat_1_))) {
                return;
            }
            this.statsFile.increaseStat(this, p_addStat_1_, p_addStat_2_);
            for (ScoreObjective scoreobjective : this.getWorldScoreboard().getObjectivesFromCriteria(p_addStat_1_.getCriteria())) {
                this.getWorldScoreboard().getOrCreateScore(this.getName(), scoreobjective).increaseScore(p_addStat_2_);
            }
            if (this.statsFile.hasUnsentAchievement()) {
                this.statsFile.sendStats(this);
            }
        }
    }

    @Override
    public void takeStat(StatBase p_takeStat_1_) {
        if (p_takeStat_1_ != null) {
            this.statsFile.unlockAchievement(this, p_takeStat_1_, 0);
            for (ScoreObjective scoreobjective : this.getWorldScoreboard().getObjectivesFromCriteria(p_takeStat_1_.getCriteria())) {
                this.getWorldScoreboard().getOrCreateScore(this.getName(), scoreobjective).setScorePoints(0);
            }
            if (this.statsFile.hasUnsentAchievement()) {
                this.statsFile.sendStats(this);
            }
        }
    }

    public void mountEntityAndWakeUp() {
        this.removePassengers();
        if (this.sleeping) {
            this.wakeUpPlayer(true, false, false);
        }
    }

    public void setPlayerHealthUpdated() {
        this.lastHealth = -1.0E8f;
    }

    @Override
    public void sendStatusMessage(ITextComponent p_sendStatusMessage_1_, boolean p_sendStatusMessage_2_) {
        this.connection.sendPacket(new SPacketChat(p_sendStatusMessage_1_, (byte)(p_sendStatusMessage_2_ ? 2 : 0)));
    }

    @Override
    protected void onItemUseFinish() {
        if (!this.activeItemStack.isEmpty() && this.isHandActive()) {
            this.connection.sendPacket(new SPacketEntityStatus(this, 9));
            super.onItemUseFinish();
        }
    }

    @Override
    public void clonePlayer(EntityPlayer p_clonePlayer_1_, boolean p_clonePlayer_2_) {
        super.clonePlayer(p_clonePlayer_1_, p_clonePlayer_2_);
        this.lastExperience = -1;
        this.lastHealth = -1.0f;
        this.lastFoodLevel = -1;
        this.entityRemoveQueue.addAll(((EntityPlayerMP)p_clonePlayer_1_).entityRemoveQueue);
    }

    @Override
    protected void onNewPotionEffect(PotionEffect p_onNewPotionEffect_1_) {
        super.onNewPotionEffect(p_onNewPotionEffect_1_);
        this.connection.sendPacket(new SPacketEntityEffect(this.getEntityId(), p_onNewPotionEffect_1_));
    }

    @Override
    protected void onChangedPotionEffect(PotionEffect p_onChangedPotionEffect_1_, boolean p_onChangedPotionEffect_2_) {
        super.onChangedPotionEffect(p_onChangedPotionEffect_1_, p_onChangedPotionEffect_2_);
        this.connection.sendPacket(new SPacketEntityEffect(this.getEntityId(), p_onChangedPotionEffect_1_));
    }

    @Override
    protected void onFinishedPotionEffect(PotionEffect p_onFinishedPotionEffect_1_) {
        super.onFinishedPotionEffect(p_onFinishedPotionEffect_1_);
        this.connection.sendPacket(new SPacketRemoveEntityEffect(this.getEntityId(), p_onFinishedPotionEffect_1_.getPotion()));
    }

    @Override
    public void setPositionAndUpdate(double p_setPositionAndUpdate_1_, double p_setPositionAndUpdate_3_, double p_setPositionAndUpdate_5_) {
        this.connection.setPlayerLocation(p_setPositionAndUpdate_1_, p_setPositionAndUpdate_3_, p_setPositionAndUpdate_5_, this.rotationYaw, this.rotationPitch);
    }

    @Override
    public void onCriticalHit(Entity p_onCriticalHit_1_) {
        this.getServerWorld().getEntityTracker().sendToTrackingAndSelf(this, new SPacketAnimation(p_onCriticalHit_1_, 4));
    }

    @Override
    public void onEnchantmentCritical(Entity p_onEnchantmentCritical_1_) {
        this.getServerWorld().getEntityTracker().sendToTrackingAndSelf(this, new SPacketAnimation(p_onEnchantmentCritical_1_, 5));
    }

    @Override
    public void sendPlayerAbilities() {
        if (this.connection != null) {
            this.connection.sendPacket(new SPacketPlayerAbilities(this.capabilities));
            this.updatePotionMetadata();
        }
    }

    public WorldServer getServerWorld() {
        return (WorldServer)this.world;
    }

    @Override
    public void setGameType(GameType p_setGameType_1_) {
        this.interactionManager.setGameType(p_setGameType_1_);
        this.connection.sendPacket(new SPacketChangeGameState(3, p_setGameType_1_.getID()));
        if (p_setGameType_1_ == GameType.SPECTATOR) {
            this.dismountRidingEntity();
        } else {
            this.setSpectatingEntity(this);
        }
        this.sendPlayerAbilities();
        this.markPotionsDirty();
    }

    @Override
    public boolean isSpectator() {
        return this.interactionManager.getGameType() == GameType.SPECTATOR;
    }

    @Override
    public boolean isCreative() {
        return this.interactionManager.getGameType() == GameType.CREATIVE;
    }

    @Override
    public void sendMessage(ITextComponent p_sendMessage_1_) {
        this.connection.sendPacket(new SPacketChat(p_sendMessage_1_));
    }

    @Override
    public boolean canUseCommand(int p_canUseCommand_1_, String p_canUseCommand_2_) {
        if ("seed".equals(p_canUseCommand_2_) && !this.mcServer.isDedicatedServer()) {
            return true;
        }
        if (!("tell".equals(p_canUseCommand_2_) || "help".equals(p_canUseCommand_2_) || "me".equals(p_canUseCommand_2_) || "trigger".equals(p_canUseCommand_2_))) {
            if (this.mcServer.getPlayerList().canSendCommands(this.getGameProfile())) {
                UserListOpsEntry userlistopsentry = (UserListOpsEntry)this.mcServer.getPlayerList().getOppedPlayers().getEntry(this.getGameProfile());
                return userlistopsentry != null ? userlistopsentry.getPermissionLevel() >= p_canUseCommand_1_ : this.mcServer.getOpPermissionLevel() >= p_canUseCommand_1_;
            }
            return false;
        }
        return true;
    }

    public String getPlayerIP() {
        String s = this.connection.netManager.getRemoteAddress().toString();
        s = s.substring(s.indexOf("/") + 1);
        s = s.substring(0, s.indexOf(":"));
        return s;
    }

    public void handleClientSettings(CPacketClientSettings p_handleClientSettings_1_) {
        this.language = p_handleClientSettings_1_.getLang();
        this.chatVisibility = p_handleClientSettings_1_.getChatVisibility();
        this.chatColours = p_handleClientSettings_1_.isColorsEnabled();
        this.getDataManager().set(PLAYER_MODEL_FLAG, (byte)p_handleClientSettings_1_.getModelPartFlags());
        this.getDataManager().set(MAIN_HAND, (byte)(p_handleClientSettings_1_.getMainHand() != EnumHandSide.LEFT ? 1 : 0));
    }

    public EntityPlayer.EnumChatVisibility getChatVisibility() {
        return this.chatVisibility;
    }

    public void loadResourcePack(String p_loadResourcePack_1_, String p_loadResourcePack_2_) {
        this.connection.sendPacket(new SPacketResourcePackSend(p_loadResourcePack_1_, p_loadResourcePack_2_));
    }

    @Override
    public BlockPos getPosition() {
        return new BlockPos(this.posX, this.posY + 0.5, this.posZ);
    }

    public void markPlayerActive() {
        this.playerLastActiveTime = MinecraftServer.getCurrentTimeMillis();
    }

    public StatisticsManagerServer getStatFile() {
        return this.statsFile;
    }

    public void removeEntity(Entity p_removeEntity_1_) {
        if (p_removeEntity_1_ instanceof EntityPlayer) {
            this.connection.sendPacket(new SPacketDestroyEntities(p_removeEntity_1_.getEntityId()));
        } else {
            this.entityRemoveQueue.add(p_removeEntity_1_.getEntityId());
        }
    }

    public void addEntity(Entity p_addEntity_1_) {
        this.entityRemoveQueue.remove((Object)p_addEntity_1_.getEntityId());
    }

    @Override
    protected void updatePotionMetadata() {
        if (this.isSpectator()) {
            this.resetPotionEffectMetadata();
            this.setInvisible(true);
        } else {
            super.updatePotionMetadata();
        }
        this.getServerWorld().getEntityTracker().updateVisibility(this);
    }

    public Entity getSpectatingEntity() {
        return this.spectatingEntity == null ? this : this.spectatingEntity;
    }

    public void setSpectatingEntity(Entity p_setSpectatingEntity_1_) {
        Entity entity = this.getSpectatingEntity();
        Entity entity2 = this.spectatingEntity = p_setSpectatingEntity_1_ == null ? this : p_setSpectatingEntity_1_;
        if (entity != this.spectatingEntity) {
            this.connection.sendPacket(new SPacketCamera(this.spectatingEntity));
            this.setPositionAndUpdate(this.spectatingEntity.posX, this.spectatingEntity.posY, this.spectatingEntity.posZ);
        }
    }

    @Override
    protected void decrementTimeUntilPortal() {
        if (this.timeUntilPortal > 0 && !this.invulnerableDimensionChange) {
            --this.timeUntilPortal;
        }
    }

    @Override
    public void attackTargetEntityWithCurrentItem(Entity p_attackTargetEntityWithCurrentItem_1_) {
        if (this.interactionManager.getGameType() == GameType.SPECTATOR) {
            this.setSpectatingEntity(p_attackTargetEntityWithCurrentItem_1_);
        } else {
            super.attackTargetEntityWithCurrentItem(p_attackTargetEntityWithCurrentItem_1_);
        }
    }

    public long getLastActiveTime() {
        return this.playerLastActiveTime;
    }

    @Nullable
    public ITextComponent getTabListDisplayName() {
        return null;
    }

    @Override
    public void swingArm(EnumHand p_swingArm_1_) {
        super.swingArm(p_swingArm_1_);
        this.resetCooldown();
    }

    public boolean isInvulnerableDimensionChange() {
        return this.invulnerableDimensionChange;
    }

    public void clearInvulnerableDimensionChange() {
        this.invulnerableDimensionChange = false;
    }

    public void setElytraFlying() {
        this.setFlag(7, true);
    }

    public void clearElytraFlying() {
        this.setFlag(7, true);
        this.setFlag(7, false);
    }
}

