/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.player;

import java.util.Arrays;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ReportedException;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InventoryPlayer
implements IInventory {
    public final NonNullList<ItemStack> mainInventory = NonNullList.withSize(36, ItemStack.EMPTY);
    public final NonNullList<ItemStack> armorInventory = NonNullList.withSize(4, ItemStack.EMPTY);
    public final NonNullList<ItemStack> offHandInventory = NonNullList.withSize(1, ItemStack.EMPTY);
    private final List<NonNullList<ItemStack>> allInventories = Arrays.asList(this.mainInventory, this.armorInventory, this.offHandInventory);
    public int currentItem;
    public EntityPlayer player;
    private ItemStack itemStack = ItemStack.EMPTY;
    public boolean inventoryChanged;

    public InventoryPlayer(EntityPlayer p_i1750_1_) {
        this.player = p_i1750_1_;
    }

    public ItemStack getCurrentItem() {
        return InventoryPlayer.isHotbar(this.currentItem) ? this.mainInventory.get(this.currentItem) : ItemStack.EMPTY;
    }

    public static int getHotbarSize() {
        return 9;
    }

    private boolean canMergeStacks(ItemStack p_canMergeStacks_1_, ItemStack p_canMergeStacks_2_) {
        return !p_canMergeStacks_1_.isEmpty() && this.stackEqualExact(p_canMergeStacks_1_, p_canMergeStacks_2_) && p_canMergeStacks_1_.isStackable() && p_canMergeStacks_1_.getCount() < p_canMergeStacks_1_.getMaxStackSize() && p_canMergeStacks_1_.getCount() < this.getInventoryStackLimit();
    }

    private boolean stackEqualExact(ItemStack p_stackEqualExact_1_, ItemStack p_stackEqualExact_2_) {
        return p_stackEqualExact_1_.getItem() == p_stackEqualExact_2_.getItem() && (!p_stackEqualExact_1_.getHasSubtypes() || p_stackEqualExact_1_.getMetadata() == p_stackEqualExact_2_.getMetadata()) && ItemStack.areItemStackTagsEqual(p_stackEqualExact_1_, p_stackEqualExact_2_);
    }

    public int getFirstEmptyStack() {
        for (int i = 0; i < this.mainInventory.size(); ++i) {
            if (!this.mainInventory.get(i).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public void setPickedItemStack(ItemStack p_setPickedItemStack_1_) {
        int i = this.getSlotFor(p_setPickedItemStack_1_);
        if (InventoryPlayer.isHotbar(i)) {
            this.currentItem = i;
        } else if (i == -1) {
            int j;
            this.currentItem = this.getBestHotbarSlot();
            if (!this.mainInventory.get(this.currentItem).isEmpty() && (j = this.getFirstEmptyStack()) != -1) {
                this.mainInventory.set(j, this.mainInventory.get(this.currentItem));
            }
            this.mainInventory.set(this.currentItem, p_setPickedItemStack_1_);
        } else {
            this.pickItem(i);
        }
    }

    public void pickItem(int p_pickItem_1_) {
        this.currentItem = this.getBestHotbarSlot();
        ItemStack itemstack = this.mainInventory.get(this.currentItem);
        this.mainInventory.set(this.currentItem, this.mainInventory.get(p_pickItem_1_));
        this.mainInventory.set(p_pickItem_1_, itemstack);
    }

    public static boolean isHotbar(int p_isHotbar_0_) {
        return p_isHotbar_0_ >= 0 && p_isHotbar_0_ < 9;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSlotFor(ItemStack p_getSlotFor_1_) {
        for (int i = 0; i < this.mainInventory.size(); ++i) {
            if (this.mainInventory.get(i).isEmpty() || !this.stackEqualExact(p_getSlotFor_1_, this.mainInventory.get(i))) continue;
            return i;
        }
        return -1;
    }

    public int getBestHotbarSlot() {
        for (int i = 0; i < 9; ++i) {
            int j = (this.currentItem + i) % 9;
            if (!this.mainInventory.get(j).isEmpty()) continue;
            return j;
        }
        for (int k = 0; k < 9; ++k) {
            int l = (this.currentItem + k) % 9;
            if (this.mainInventory.get(l).isItemEnchanted()) continue;
            return l;
        }
        return this.currentItem;
    }

    @SideOnly(value=Side.CLIENT)
    public void changeCurrentItem(int p_changeCurrentItem_1_) {
        if (p_changeCurrentItem_1_ > 0) {
            p_changeCurrentItem_1_ = 1;
        }
        if (p_changeCurrentItem_1_ < 0) {
            p_changeCurrentItem_1_ = -1;
        }
        this.currentItem -= p_changeCurrentItem_1_;
        while (this.currentItem < 0) {
            this.currentItem += 9;
        }
        while (this.currentItem >= 9) {
            this.currentItem -= 9;
        }
    }

    public int clearMatchingItems(Item p_clearMatchingItems_1_, int p_clearMatchingItems_2_, int p_clearMatchingItems_3_, NBTTagCompound p_clearMatchingItems_4_) {
        int i = 0;
        for (int j = 0; j < this.getSizeInventory(); ++j) {
            ItemStack itemstack = this.getStackInSlot(j);
            if (itemstack.isEmpty() || p_clearMatchingItems_1_ != null && itemstack.getItem() != p_clearMatchingItems_1_ || p_clearMatchingItems_2_ > -1 && itemstack.getMetadata() != p_clearMatchingItems_2_ || p_clearMatchingItems_4_ != null && !NBTUtil.areNBTEquals(p_clearMatchingItems_4_, itemstack.getTagCompound(), true)) continue;
            int k = p_clearMatchingItems_3_ <= 0 ? itemstack.getCount() : Math.min(p_clearMatchingItems_3_ - i, itemstack.getCount());
            i += k;
            if (p_clearMatchingItems_3_ == 0) continue;
            itemstack.shrink(k);
            if (itemstack.isEmpty()) {
                this.setInventorySlotContents(j, ItemStack.EMPTY);
            }
            if (p_clearMatchingItems_3_ <= 0 || i < p_clearMatchingItems_3_) continue;
            return i;
        }
        if (!this.itemStack.isEmpty()) {
            if (p_clearMatchingItems_1_ != null && this.itemStack.getItem() != p_clearMatchingItems_1_) {
                return i;
            }
            if (p_clearMatchingItems_2_ > -1 && this.itemStack.getMetadata() != p_clearMatchingItems_2_) {
                return i;
            }
            if (p_clearMatchingItems_4_ != null && !NBTUtil.areNBTEquals(p_clearMatchingItems_4_, this.itemStack.getTagCompound(), true)) {
                return i;
            }
            int l = p_clearMatchingItems_3_ <= 0 ? this.itemStack.getCount() : Math.min(p_clearMatchingItems_3_ - i, this.itemStack.getCount());
            i += l;
            if (p_clearMatchingItems_3_ != 0) {
                this.itemStack.shrink(l);
                if (this.itemStack.isEmpty()) {
                    this.itemStack = ItemStack.EMPTY;
                }
                if (p_clearMatchingItems_3_ > 0 && i >= p_clearMatchingItems_3_) {
                    return i;
                }
            }
        }
        return i;
    }

    private int storePartialItemStack(ItemStack p_storePartialItemStack_1_) {
        Item item = p_storePartialItemStack_1_.getItem();
        int i = p_storePartialItemStack_1_.getCount();
        int j = this.storeItemStack(p_storePartialItemStack_1_);
        if (j == -1) {
            j = this.getFirstEmptyStack();
        }
        if (j == -1) {
            return i;
        }
        ItemStack itemstack = this.getStackInSlot(j);
        if (itemstack.isEmpty()) {
            itemstack = p_storePartialItemStack_1_.copy();
            itemstack.setCount(0);
            if (p_storePartialItemStack_1_.hasTagCompound()) {
                itemstack.setTagCompound(p_storePartialItemStack_1_.getTagCompound().copy());
            }
            this.setInventorySlotContents(j, itemstack);
        }
        int k = i;
        if (i > itemstack.getMaxStackSize() - itemstack.getCount()) {
            k = itemstack.getMaxStackSize() - itemstack.getCount();
        }
        if (k > this.getInventoryStackLimit() - itemstack.getCount()) {
            k = this.getInventoryStackLimit() - itemstack.getCount();
        }
        if (k == 0) {
            return i;
        }
        itemstack.grow(k);
        itemstack.setAnimationsToGo(5);
        return i -= k;
    }

    private int storeItemStack(ItemStack p_storeItemStack_1_) {
        if (this.canMergeStacks(this.getStackInSlot(this.currentItem), p_storeItemStack_1_)) {
            return this.currentItem;
        }
        if (this.canMergeStacks(this.getStackInSlot(40), p_storeItemStack_1_)) {
            return 40;
        }
        for (int i = 0; i < this.mainInventory.size(); ++i) {
            if (!this.canMergeStacks(this.mainInventory.get(i), p_storeItemStack_1_)) continue;
            return i;
        }
        return -1;
    }

    public void decrementAnimations() {
        for (NonNullList<ItemStack> nonnulllist : this.allInventories) {
            for (int i = 0; i < nonnulllist.size(); ++i) {
                if (nonnulllist.get(i).isEmpty()) continue;
                nonnulllist.get(i).updateAnimation(this.player.world, this.player, i, this.currentItem == i);
            }
        }
        for (ItemStack is : this.armorInventory) {
            if (is.isEmpty()) continue;
            is.getItem().onArmorTick(this.player.world, this.player, is);
        }
    }

    public boolean addItemStackToInventory(final ItemStack p_addItemStackToInventory_1_) {
        if (p_addItemStackToInventory_1_.isEmpty()) {
            return false;
        }
        try {
            int i;
            if (p_addItemStackToInventory_1_.isItemDamaged()) {
                int j = this.getFirstEmptyStack();
                if (j >= 0) {
                    this.mainInventory.set(j, p_addItemStackToInventory_1_.copy());
                    this.mainInventory.get(j).setAnimationsToGo(5);
                    p_addItemStackToInventory_1_.setCount(0);
                    return true;
                }
                if (this.player.capabilities.isCreativeMode) {
                    p_addItemStackToInventory_1_.setCount(0);
                    return true;
                }
                return false;
            }
            do {
                i = p_addItemStackToInventory_1_.getCount();
                p_addItemStackToInventory_1_.setCount(this.storePartialItemStack(p_addItemStackToInventory_1_));
            } while (!p_addItemStackToInventory_1_.isEmpty() && p_addItemStackToInventory_1_.getCount() < i);
            if (p_addItemStackToInventory_1_.getCount() == i && this.player.capabilities.isCreativeMode) {
                p_addItemStackToInventory_1_.setCount(0);
                return true;
            }
            return p_addItemStackToInventory_1_.getCount() < i;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Adding item to inventory");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Item being added");
            crashreportcategory.addCrashSection("Item ID", Item.getIdFromItem(p_addItemStackToInventory_1_.getItem()));
            crashreportcategory.addCrashSection("Item data", p_addItemStackToInventory_1_.getMetadata());
            crashreportcategory.setDetail("Item name", new ICrashReportDetail<String>(){

                @Override
                public String call() throws Exception {
                    return p_addItemStackToInventory_1_.getDisplayName();
                }
            });
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public ItemStack decrStackSize(int p_decrStackSize_1_, int p_decrStackSize_2_) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> nonnulllist : this.allInventories) {
            if (p_decrStackSize_1_ < nonnulllist.size()) {
                list = nonnulllist;
                break;
            }
            p_decrStackSize_1_ -= nonnulllist.size();
        }
        return list != null && !((ItemStack)list.get(p_decrStackSize_1_)).isEmpty() ? ItemStackHelper.getAndSplit(list, p_decrStackSize_1_, p_decrStackSize_2_) : ItemStack.EMPTY;
    }

    public void deleteStack(ItemStack p_deleteStack_1_) {
        block0: for (NonNullList<ItemStack> nonnulllist : this.allInventories) {
            for (int i = 0; i < nonnulllist.size(); ++i) {
                if (nonnulllist.get(i) != p_deleteStack_1_) continue;
                nonnulllist.set(i, ItemStack.EMPTY);
                continue block0;
            }
        }
    }

    @Override
    public ItemStack removeStackFromSlot(int p_removeStackFromSlot_1_) {
        NonNullList<ItemStack> nonnulllist = null;
        for (NonNullList<ItemStack> nonnulllist1 : this.allInventories) {
            if (p_removeStackFromSlot_1_ < nonnulllist1.size()) {
                nonnulllist = nonnulllist1;
                break;
            }
            p_removeStackFromSlot_1_ -= nonnulllist1.size();
        }
        if (nonnulllist != null && !((ItemStack)nonnulllist.get(p_removeStackFromSlot_1_)).isEmpty()) {
            ItemStack itemstack = nonnulllist.get(p_removeStackFromSlot_1_);
            nonnulllist.set(p_removeStackFromSlot_1_, ItemStack.EMPTY);
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setInventorySlotContents(int p_setInventorySlotContents_1_, ItemStack p_setInventorySlotContents_2_) {
        NonNullList<ItemStack> nonnulllist = null;
        for (NonNullList<ItemStack> nonnulllist1 : this.allInventories) {
            if (p_setInventorySlotContents_1_ < nonnulllist1.size()) {
                nonnulllist = nonnulllist1;
                break;
            }
            p_setInventorySlotContents_1_ -= nonnulllist1.size();
        }
        if (nonnulllist != null) {
            nonnulllist.set(p_setInventorySlotContents_1_, p_setInventorySlotContents_2_);
        }
    }

    public float getStrVsBlock(IBlockState p_getStrVsBlock_1_) {
        float f = 1.0f;
        if (!this.mainInventory.get(this.currentItem).isEmpty()) {
            f *= this.mainInventory.get(this.currentItem).getStrVsBlock(p_getStrVsBlock_1_);
        }
        return f;
    }

    public NBTTagList writeToNBT(NBTTagList p_writeToNBT_1_) {
        for (int i = 0; i < this.mainInventory.size(); ++i) {
            if (this.mainInventory.get(i).isEmpty()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.setByte("Slot", (byte)i);
            this.mainInventory.get(i).writeToNBT(nbttagcompound);
            p_writeToNBT_1_.appendTag(nbttagcompound);
        }
        for (int j = 0; j < this.armorInventory.size(); ++j) {
            if (this.armorInventory.get(j).isEmpty()) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)(j + 100));
            this.armorInventory.get(j).writeToNBT(nbttagcompound1);
            p_writeToNBT_1_.appendTag(nbttagcompound1);
        }
        for (int k = 0; k < this.offHandInventory.size(); ++k) {
            if (this.offHandInventory.get(k).isEmpty()) continue;
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttagcompound2.setByte("Slot", (byte)(k + 150));
            this.offHandInventory.get(k).writeToNBT(nbttagcompound2);
            p_writeToNBT_1_.appendTag(nbttagcompound2);
        }
        return p_writeToNBT_1_;
    }

    public void readFromNBT(NBTTagList p_readFromNBT_1_) {
        this.mainInventory.clear();
        this.armorInventory.clear();
        this.offHandInventory.clear();
        for (int i = 0; i < p_readFromNBT_1_.tagCount(); ++i) {
            NBTTagCompound nbttagcompound = p_readFromNBT_1_.getCompoundTagAt(i);
            int j = nbttagcompound.getByte("Slot") & 0xFF;
            ItemStack itemstack = new ItemStack(nbttagcompound);
            if (itemstack.isEmpty()) continue;
            if (j >= 0 && j < this.mainInventory.size()) {
                this.mainInventory.set(j, itemstack);
                continue;
            }
            if (j >= 100 && j < this.armorInventory.size() + 100) {
                this.armorInventory.set(j - 100, itemstack);
                continue;
            }
            if (j < 150 || j >= this.offHandInventory.size() + 150) continue;
            this.offHandInventory.set(j - 150, itemstack);
        }
    }

    @Override
    public int getSizeInventory() {
        return this.mainInventory.size() + this.armorInventory.size() + this.offHandInventory.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack itemstack : this.mainInventory) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        for (ItemStack itemstack1 : this.armorInventory) {
            if (itemstack1.isEmpty()) continue;
            return false;
        }
        for (ItemStack itemstack2 : this.offHandInventory) {
            if (itemstack2.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getStackInSlot(int p_getStackInSlot_1_) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> nonnulllist : this.allInventories) {
            if (p_getStackInSlot_1_ < nonnulllist.size()) {
                list = nonnulllist;
                break;
            }
            p_getStackInSlot_1_ -= nonnulllist.size();
        }
        return list == null ? ItemStack.EMPTY : (ItemStack)list.get(p_getStackInSlot_1_);
    }

    @Override
    public String getName() {
        return "container.inventory";
    }

    @Override
    public boolean hasCustomName() {
        return false;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.hasCustomName() ? new TextComponentString(this.getName()) : new TextComponentTranslation(this.getName(), new Object[0]);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean canHarvestBlock(IBlockState p_canHarvestBlock_1_) {
        if (p_canHarvestBlock_1_.getMaterial().isToolNotRequired()) {
            return true;
        }
        ItemStack itemstack = this.getStackInSlot(this.currentItem);
        return !itemstack.isEmpty() ? itemstack.canHarvestBlock(p_canHarvestBlock_1_) : false;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack armorItemInSlot(int p_armorItemInSlot_1_) {
        return this.armorInventory.get(p_armorItemInSlot_1_);
    }

    public void damageArmor(float p_damageArmor_1_) {
        if ((p_damageArmor_1_ /= 4.0f) < 1.0f) {
            p_damageArmor_1_ = 1.0f;
        }
        for (int i = 0; i < this.armorInventory.size(); ++i) {
            ItemStack itemstack = this.armorInventory.get(i);
            if (!(itemstack.getItem() instanceof ItemArmor)) continue;
            itemstack.damageItem((int)p_damageArmor_1_, this.player);
        }
    }

    public void dropAllItems() {
        for (List list : this.allInventories) {
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemstack = (ItemStack)list.get(i);
                if (itemstack.isEmpty()) continue;
                this.player.dropItem(itemstack, true, false);
                list.set(i, ItemStack.EMPTY);
            }
        }
    }

    @Override
    public void markDirty() {
        this.inventoryChanged = true;
    }

    public void setItemStack(ItemStack p_setItemStack_1_) {
        this.itemStack = p_setItemStack_1_;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer p_isUsableByPlayer_1_) {
        return this.player.isDead ? false : p_isUsableByPlayer_1_.getDistanceSqToEntity(this.player) <= 64.0;
    }

    public boolean hasItemStack(ItemStack p_hasItemStack_1_) {
        for (List list : this.allInventories) {
            for (ItemStack itemstack : list) {
                if (itemstack.isEmpty() || !itemstack.isItemEqual(p_hasItemStack_1_)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void openInventory(EntityPlayer p_openInventory_1_) {
    }

    @Override
    public void closeInventory(EntityPlayer p_closeInventory_1_) {
    }

    @Override
    public boolean isItemValidForSlot(int p_isItemValidForSlot_1_, ItemStack p_isItemValidForSlot_2_) {
        return true;
    }

    public void copyInventory(InventoryPlayer p_copyInventory_1_) {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            this.setInventorySlotContents(i, p_copyInventory_1_.getStackInSlot(i));
        }
        this.currentItem = p_copyInventory_1_.currentItem;
    }

    @Override
    public int getField(int p_getField_1_) {
        return 0;
    }

    @Override
    public void setField(int p_setField_1_, int p_setField_2_) {
    }

    @Override
    public int getFieldCount() {
        return 0;
    }

    @Override
    public void clear() {
        for (List list : this.allInventories) {
            list.clear();
        }
    }
}

