/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityArrow
extends Entity
implements IProjectile {
    private static final Predicate<Entity> ARROW_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.NOT_SPECTATING, EntitySelectors.IS_ALIVE, new Predicate<Entity>(){

        public boolean apply(Entity p_apply_1_) {
            return p_apply_1_.canBeCollidedWith();
        }

        public /* synthetic */ boolean apply(Object p_apply_1_) {
            return this.apply((Entity)p_apply_1_);
        }
    }});
    private static final DataParameter<Byte> CRITICAL = EntityDataManager.createKey(EntityArrow.class, DataSerializers.BYTE);
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    private int inData;
    protected boolean inGround;
    protected int timeInGround;
    public PickupStatus pickupStatus = PickupStatus.DISALLOWED;
    public int arrowShake;
    public Entity shootingEntity;
    private int ticksInGround;
    private int ticksInAir;
    private double damage = 2.0;
    private int knockbackStrength;

    public EntityArrow(World p_i1753_1_) {
        super(p_i1753_1_);
        this.setSize(0.5f, 0.5f);
    }

    public EntityArrow(World p_i1754_1_, double p_i1754_2_, double p_i1754_4_, double p_i1754_6_) {
        this(p_i1754_1_);
        this.setPosition(p_i1754_2_, p_i1754_4_, p_i1754_6_);
    }

    public EntityArrow(World p_i46777_1_, EntityLivingBase p_i46777_2_) {
        this(p_i46777_1_, p_i46777_2_.posX, p_i46777_2_.posY + (double)p_i46777_2_.getEyeHeight() - (double)0.1f, p_i46777_2_.posZ);
        this.shootingEntity = p_i46777_2_;
        if (p_i46777_2_ instanceof EntityPlayer) {
            this.pickupStatus = PickupStatus.ALLOWED;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double p_isInRangeToRenderDist_1_) {
        double lvt_3_1_ = this.getEntityBoundingBox().getAverageEdgeLength() * 10.0;
        if (Double.isNaN(lvt_3_1_)) {
            lvt_3_1_ = 1.0;
        }
        return p_isInRangeToRenderDist_1_ < (lvt_3_1_ *= 64.0 * EntityArrow.getRenderDistanceWeight()) * lvt_3_1_;
    }

    @Override
    protected void entityInit() {
        this.dataManager.register(CRITICAL, (byte)0);
    }

    public void setAim(Entity p_setAim_1_, float p_setAim_2_, float p_setAim_3_, float p_setAim_4_, float p_setAim_5_, float p_setAim_6_) {
        float lvt_7_1_ = -MathHelper.sin(p_setAim_3_ * ((float)Math.PI / 180)) * MathHelper.cos(p_setAim_2_ * ((float)Math.PI / 180));
        float lvt_8_1_ = -MathHelper.sin(p_setAim_2_ * ((float)Math.PI / 180));
        float lvt_9_1_ = MathHelper.cos(p_setAim_3_ * ((float)Math.PI / 180)) * MathHelper.cos(p_setAim_2_ * ((float)Math.PI / 180));
        this.setThrowableHeading(lvt_7_1_, lvt_8_1_, lvt_9_1_, p_setAim_5_, p_setAim_6_);
        this.motionX += p_setAim_1_.motionX;
        this.motionZ += p_setAim_1_.motionZ;
        if (!p_setAim_1_.onGround) {
            this.motionY += p_setAim_1_.motionY;
        }
    }

    @Override
    public void setThrowableHeading(double p_setThrowableHeading_1_, double p_setThrowableHeading_3_, double p_setThrowableHeading_5_, float p_setThrowableHeading_7_, float p_setThrowableHeading_8_) {
        float lvt_9_1_ = MathHelper.sqrt(p_setThrowableHeading_1_ * p_setThrowableHeading_1_ + p_setThrowableHeading_3_ * p_setThrowableHeading_3_ + p_setThrowableHeading_5_ * p_setThrowableHeading_5_);
        p_setThrowableHeading_1_ /= (double)lvt_9_1_;
        p_setThrowableHeading_3_ /= (double)lvt_9_1_;
        p_setThrowableHeading_5_ /= (double)lvt_9_1_;
        p_setThrowableHeading_1_ += this.rand.nextGaussian() * (double)0.0075f * (double)p_setThrowableHeading_8_;
        p_setThrowableHeading_3_ += this.rand.nextGaussian() * (double)0.0075f * (double)p_setThrowableHeading_8_;
        p_setThrowableHeading_5_ += this.rand.nextGaussian() * (double)0.0075f * (double)p_setThrowableHeading_8_;
        this.motionX = p_setThrowableHeading_1_ *= (double)p_setThrowableHeading_7_;
        this.motionY = p_setThrowableHeading_3_ *= (double)p_setThrowableHeading_7_;
        this.motionZ = p_setThrowableHeading_5_ *= (double)p_setThrowableHeading_7_;
        float lvt_10_1_ = MathHelper.sqrt(p_setThrowableHeading_1_ * p_setThrowableHeading_1_ + p_setThrowableHeading_5_ * p_setThrowableHeading_5_);
        this.rotationYaw = (float)(MathHelper.atan2(p_setThrowableHeading_1_, p_setThrowableHeading_5_) * 57.2957763671875);
        this.rotationPitch = (float)(MathHelper.atan2(p_setThrowableHeading_3_, lvt_10_1_) * 57.2957763671875);
        this.prevRotationYaw = this.rotationYaw;
        this.prevRotationPitch = this.rotationPitch;
        this.ticksInGround = 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotationDirect(double p_setPositionAndRotationDirect_1_, double p_setPositionAndRotationDirect_3_, double p_setPositionAndRotationDirect_5_, float p_setPositionAndRotationDirect_7_, float p_setPositionAndRotationDirect_8_, int p_setPositionAndRotationDirect_9_, boolean p_setPositionAndRotationDirect_10_) {
        this.setPosition(p_setPositionAndRotationDirect_1_, p_setPositionAndRotationDirect_3_, p_setPositionAndRotationDirect_5_);
        this.setRotation(p_setPositionAndRotationDirect_7_, p_setPositionAndRotationDirect_8_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setVelocity(double p_setVelocity_1_, double p_setVelocity_3_, double p_setVelocity_5_) {
        this.motionX = p_setVelocity_1_;
        this.motionY = p_setVelocity_3_;
        this.motionZ = p_setVelocity_5_;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float lvt_7_1_ = MathHelper.sqrt(p_setVelocity_1_ * p_setVelocity_1_ + p_setVelocity_5_ * p_setVelocity_5_);
            this.rotationPitch = (float)(MathHelper.atan2(p_setVelocity_3_, lvt_7_1_) * 57.2957763671875);
            this.rotationYaw = (float)(MathHelper.atan2(p_setVelocity_1_, p_setVelocity_5_) * 57.2957763671875);
            this.prevRotationPitch = this.rotationPitch;
            this.prevRotationYaw = this.rotationYaw;
            this.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
            this.ticksInGround = 0;
        }
    }

    @Override
    public void onUpdate() {
        Entity lvt_7_1_;
        AxisAlignedBB lvt_4_1_;
        super.onUpdate();
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float lvt_1_1_ = MathHelper.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            this.rotationYaw = (float)(MathHelper.atan2(this.motionX, this.motionZ) * 57.2957763671875);
            this.rotationPitch = (float)(MathHelper.atan2(this.motionY, lvt_1_1_) * 57.2957763671875);
            this.prevRotationYaw = this.rotationYaw;
            this.prevRotationPitch = this.rotationPitch;
        }
        BlockPos lvt_1_2_ = new BlockPos(this.xTile, this.yTile, this.zTile);
        IBlockState lvt_2_1_ = this.world.getBlockState(lvt_1_2_);
        Block lvt_3_1_ = lvt_2_1_.getBlock();
        if (lvt_2_1_.getMaterial() != Material.AIR && (lvt_4_1_ = lvt_2_1_.getCollisionBoundingBox(this.world, lvt_1_2_)) != Block.NULL_AABB && lvt_4_1_.offset(lvt_1_2_).isVecInside(new Vec3d(this.posX, this.posY, this.posZ))) {
            this.inGround = true;
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inGround) {
            int lvt_4_2_ = lvt_3_1_.getMetaFromState(lvt_2_1_);
            if (!(lvt_3_1_ == this.inTile && lvt_4_2_ == this.inData || this.world.collidesWithAnyBlock(this.getEntityBoundingBox().expandXyz(0.05)))) {
                this.inGround = false;
                this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            } else {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.setDead();
                }
            }
            ++this.timeInGround;
            return;
        }
        this.timeInGround = 0;
        ++this.ticksInAir;
        Vec3d lvt_4_3_ = new Vec3d(this.posX, this.posY, this.posZ);
        Vec3d lvt_5_1_ = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        RayTraceResult lvt_6_1_ = this.world.rayTraceBlocks(lvt_4_3_, lvt_5_1_, false, true, false);
        lvt_4_3_ = new Vec3d(this.posX, this.posY, this.posZ);
        lvt_5_1_ = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        if (lvt_6_1_ != null) {
            lvt_5_1_ = new Vec3d(lvt_6_1_.hitVec.xCoord, lvt_6_1_.hitVec.yCoord, lvt_6_1_.hitVec.zCoord);
        }
        if ((lvt_7_1_ = this.findEntityOnPath(lvt_4_3_, lvt_5_1_)) != null) {
            lvt_6_1_ = new RayTraceResult(lvt_7_1_);
        }
        if (lvt_6_1_ != null && lvt_6_1_.entityHit instanceof EntityPlayer) {
            EntityPlayer lvt_8_1_ = (EntityPlayer)lvt_6_1_.entityHit;
            if (this.shootingEntity instanceof EntityPlayer && !((EntityPlayer)this.shootingEntity).canAttackPlayer(lvt_8_1_)) {
                lvt_6_1_ = null;
            }
        }
        if (lvt_6_1_ != null) {
            this.onHit(lvt_6_1_);
        }
        if (this.getIsCritical()) {
            for (int lvt_8_2_ = 0; lvt_8_2_ < 4; ++lvt_8_2_) {
                this.world.spawnParticle(EnumParticleTypes.CRIT, this.posX + this.motionX * (double)lvt_8_2_ / 4.0, this.posY + this.motionY * (double)lvt_8_2_ / 4.0, this.posZ + this.motionZ * (double)lvt_8_2_ / 4.0, -this.motionX, -this.motionY + 0.2, -this.motionZ, new int[0]);
            }
        }
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float lvt_8_3_ = MathHelper.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
        this.rotationYaw = (float)(MathHelper.atan2(this.motionX, this.motionZ) * 57.2957763671875);
        this.rotationPitch = (float)(MathHelper.atan2(this.motionY, lvt_8_3_) * 57.2957763671875);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        float lvt_9_1_ = 0.99f;
        float lvt_10_1_ = 0.05f;
        if (this.isInWater()) {
            for (int lvt_11_1_ = 0; lvt_11_1_ < 4; ++lvt_11_1_) {
                float lvt_12_1_ = 0.25f;
                this.world.spawnParticle(EnumParticleTypes.WATER_BUBBLE, this.posX - this.motionX * 0.25, this.posY - this.motionY * 0.25, this.posZ - this.motionZ * 0.25, this.motionX, this.motionY, this.motionZ, new int[0]);
            }
            lvt_9_1_ = 0.6f;
        }
        if (this.isWet()) {
            this.extinguish();
        }
        this.motionX *= (double)lvt_9_1_;
        this.motionY *= (double)lvt_9_1_;
        this.motionZ *= (double)lvt_9_1_;
        if (!this.hasNoGravity()) {
            this.motionY -= (double)0.05f;
        }
        this.setPosition(this.posX, this.posY, this.posZ);
        this.doBlockCollisions();
    }

    protected void onHit(RayTraceResult p_onHit_1_) {
        Entity lvt_2_1_ = p_onHit_1_.entityHit;
        if (lvt_2_1_ != null) {
            DamageSource lvt_5_2_;
            float lvt_3_1_ = MathHelper.sqrt(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ);
            int lvt_4_1_ = MathHelper.ceil((double)lvt_3_1_ * this.damage);
            if (this.getIsCritical()) {
                lvt_4_1_ += this.rand.nextInt(lvt_4_1_ / 2 + 2);
            }
            if (this.shootingEntity == null) {
                DamageSource lvt_5_1_ = DamageSource.causeArrowDamage(this, this);
            } else {
                lvt_5_2_ = DamageSource.causeArrowDamage(this, this.shootingEntity);
            }
            if (this.isBurning() && !(lvt_2_1_ instanceof EntityEnderman)) {
                lvt_2_1_.setFire(5);
            }
            if (lvt_2_1_.attackEntityFrom(lvt_5_2_, lvt_4_1_)) {
                if (lvt_2_1_ instanceof EntityLivingBase) {
                    float lvt_7_1_;
                    EntityLivingBase lvt_6_1_ = (EntityLivingBase)lvt_2_1_;
                    if (!this.world.isRemote) {
                        lvt_6_1_.setArrowCountInEntity(lvt_6_1_.getArrowCountInEntity() + 1);
                    }
                    if (this.knockbackStrength > 0 && (lvt_7_1_ = MathHelper.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ)) > 0.0f) {
                        lvt_6_1_.addVelocity(this.motionX * (double)this.knockbackStrength * (double)0.6f / (double)lvt_7_1_, 0.1, this.motionZ * (double)this.knockbackStrength * (double)0.6f / (double)lvt_7_1_);
                    }
                    if (this.shootingEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.applyThornEnchantments(lvt_6_1_, this.shootingEntity);
                        EnchantmentHelper.applyArthropodEnchantments((EntityLivingBase)this.shootingEntity, lvt_6_1_);
                    }
                    this.arrowHit(lvt_6_1_);
                    if (this.shootingEntity != null && lvt_6_1_ != this.shootingEntity && lvt_6_1_ instanceof EntityPlayer && this.shootingEntity instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)this.shootingEntity).connection.sendPacket(new SPacketChangeGameState(6, 0.0f));
                    }
                }
                this.playSound(SoundEvents.ENTITY_ARROW_HIT, 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
                if (!(lvt_2_1_ instanceof EntityEnderman)) {
                    this.setDead();
                }
            } else {
                this.motionX *= (double)-0.1f;
                this.motionY *= (double)-0.1f;
                this.motionZ *= (double)-0.1f;
                this.rotationYaw += 180.0f;
                this.prevRotationYaw += 180.0f;
                this.ticksInAir = 0;
                if (!this.world.isRemote && this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ < (double)0.001f) {
                    if (this.pickupStatus == PickupStatus.ALLOWED) {
                        this.entityDropItem(this.getArrowStack(), 0.1f);
                    }
                    this.setDead();
                }
            }
        } else {
            BlockPos lvt_3_2_ = p_onHit_1_.getBlockPos();
            this.xTile = lvt_3_2_.getX();
            this.yTile = lvt_3_2_.getY();
            this.zTile = lvt_3_2_.getZ();
            IBlockState lvt_4_2_ = this.world.getBlockState(lvt_3_2_);
            this.inTile = lvt_4_2_.getBlock();
            this.inData = this.inTile.getMetaFromState(lvt_4_2_);
            this.motionX = (float)(p_onHit_1_.hitVec.xCoord - this.posX);
            this.motionY = (float)(p_onHit_1_.hitVec.yCoord - this.posY);
            this.motionZ = (float)(p_onHit_1_.hitVec.zCoord - this.posZ);
            float lvt_5_3_ = MathHelper.sqrt(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ);
            this.posX -= this.motionX / (double)lvt_5_3_ * (double)0.05f;
            this.posY -= this.motionY / (double)lvt_5_3_ * (double)0.05f;
            this.posZ -= this.motionZ / (double)lvt_5_3_ * (double)0.05f;
            this.playSound(SoundEvents.ENTITY_ARROW_HIT, 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
            this.inGround = true;
            this.arrowShake = 7;
            this.setIsCritical(false);
            if (lvt_4_2_.getMaterial() != Material.AIR) {
                this.inTile.onEntityCollidedWithBlock(this.world, lvt_3_2_, lvt_4_2_, this);
            }
        }
    }

    @Override
    public void move(MoverType p_move_1_, double p_move_2_, double p_move_4_, double p_move_6_) {
        super.move(p_move_1_, p_move_2_, p_move_4_, p_move_6_);
        if (this.inGround) {
            this.xTile = MathHelper.floor(this.posX);
            this.yTile = MathHelper.floor(this.posY);
            this.zTile = MathHelper.floor(this.posZ);
        }
    }

    protected void arrowHit(EntityLivingBase p_arrowHit_1_) {
    }

    @Nullable
    protected Entity findEntityOnPath(Vec3d p_findEntityOnPath_1_, Vec3d p_findEntityOnPath_2_) {
        Entity lvt_3_1_ = null;
        List<Entity> lvt_4_1_ = this.world.getEntitiesInAABBexcluding(this, this.getEntityBoundingBox().addCoord(this.motionX, this.motionY, this.motionZ).expandXyz(1.0), ARROW_TARGETS);
        double lvt_5_1_ = 0.0;
        for (int lvt_7_1_ = 0; lvt_7_1_ < lvt_4_1_.size(); ++lvt_7_1_) {
            double lvt_11_1_;
            AxisAlignedBB lvt_9_1_;
            RayTraceResult lvt_10_1_;
            Entity lvt_8_1_ = lvt_4_1_.get(lvt_7_1_);
            if (lvt_8_1_ == this.shootingEntity && this.ticksInAir < 5 || (lvt_10_1_ = (lvt_9_1_ = lvt_8_1_.getEntityBoundingBox().expandXyz(0.3f)).calculateIntercept(p_findEntityOnPath_1_, p_findEntityOnPath_2_)) == null || !((lvt_11_1_ = p_findEntityOnPath_1_.squareDistanceTo(lvt_10_1_.hitVec)) < lvt_5_1_) && lvt_5_1_ != 0.0) continue;
            lvt_3_1_ = lvt_8_1_;
            lvt_5_1_ = lvt_11_1_;
        }
        return lvt_3_1_;
    }

    public static void registerFixesArrow(DataFixer p_registerFixesArrow_0_, String p_registerFixesArrow_1_) {
    }

    public static void registerFixesArrow(DataFixer p_registerFixesArrow_0_) {
        EntityArrow.registerFixesArrow(p_registerFixesArrow_0_, "Arrow");
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        p_writeEntityToNBT_1_.setInteger("xTile", this.xTile);
        p_writeEntityToNBT_1_.setInteger("yTile", this.yTile);
        p_writeEntityToNBT_1_.setInteger("zTile", this.zTile);
        p_writeEntityToNBT_1_.setShort("life", (short)this.ticksInGround);
        ResourceLocation lvt_2_1_ = Block.REGISTRY.getNameForObject(this.inTile);
        p_writeEntityToNBT_1_.setString("inTile", lvt_2_1_ == null ? "" : lvt_2_1_.toString());
        p_writeEntityToNBT_1_.setByte("inData", (byte)this.inData);
        p_writeEntityToNBT_1_.setByte("shake", (byte)this.arrowShake);
        p_writeEntityToNBT_1_.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        p_writeEntityToNBT_1_.setByte("pickup", (byte)this.pickupStatus.ordinal());
        p_writeEntityToNBT_1_.setDouble("damage", this.damage);
        p_writeEntityToNBT_1_.setBoolean("crit", this.getIsCritical());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        this.xTile = p_readEntityFromNBT_1_.getInteger("xTile");
        this.yTile = p_readEntityFromNBT_1_.getInteger("yTile");
        this.zTile = p_readEntityFromNBT_1_.getInteger("zTile");
        this.ticksInGround = p_readEntityFromNBT_1_.getShort("life");
        this.inTile = p_readEntityFromNBT_1_.hasKey("inTile", 8) ? Block.getBlockFromName(p_readEntityFromNBT_1_.getString("inTile")) : Block.getBlockById(p_readEntityFromNBT_1_.getByte("inTile") & 0xFF);
        this.inData = p_readEntityFromNBT_1_.getByte("inData") & 0xFF;
        this.arrowShake = p_readEntityFromNBT_1_.getByte("shake") & 0xFF;
        boolean bl = this.inGround = p_readEntityFromNBT_1_.getByte("inGround") == 1;
        if (p_readEntityFromNBT_1_.hasKey("damage", 99)) {
            this.damage = p_readEntityFromNBT_1_.getDouble("damage");
        }
        if (p_readEntityFromNBT_1_.hasKey("pickup", 99)) {
            this.pickupStatus = PickupStatus.getByOrdinal(p_readEntityFromNBT_1_.getByte("pickup"));
        } else if (p_readEntityFromNBT_1_.hasKey("player", 99)) {
            this.pickupStatus = p_readEntityFromNBT_1_.getBoolean("player") ? PickupStatus.ALLOWED : PickupStatus.DISALLOWED;
        }
        this.setIsCritical(p_readEntityFromNBT_1_.getBoolean("crit"));
    }

    @Override
    public void onCollideWithPlayer(EntityPlayer p_onCollideWithPlayer_1_) {
        boolean lvt_2_1_;
        if (this.world.isRemote || !this.inGround || this.arrowShake > 0) {
            return;
        }
        boolean bl = lvt_2_1_ = this.pickupStatus == PickupStatus.ALLOWED || this.pickupStatus == PickupStatus.CREATIVE_ONLY && p_onCollideWithPlayer_1_.capabilities.isCreativeMode;
        if (this.pickupStatus == PickupStatus.ALLOWED && !p_onCollideWithPlayer_1_.inventory.addItemStackToInventory(this.getArrowStack())) {
            lvt_2_1_ = false;
        }
        if (lvt_2_1_) {
            p_onCollideWithPlayer_1_.onItemPickup(this, 1);
            this.setDead();
        }
    }

    protected abstract ItemStack getArrowStack();

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    public void setDamage(double p_setDamage_1_) {
        this.damage = p_setDamage_1_;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setKnockbackStrength(int p_setKnockbackStrength_1_) {
        this.knockbackStrength = p_setKnockbackStrength_1_;
    }

    @Override
    public boolean canBeAttackedWithItem() {
        return false;
    }

    @Override
    public float getEyeHeight() {
        return 0.0f;
    }

    public void setIsCritical(boolean p_setIsCritical_1_) {
        byte lvt_2_1_ = this.dataManager.get(CRITICAL);
        if (p_setIsCritical_1_) {
            this.dataManager.set(CRITICAL, (byte)(lvt_2_1_ | 1));
        } else {
            this.dataManager.set(CRITICAL, (byte)(lvt_2_1_ & 0xFFFFFFFE));
        }
    }

    public boolean getIsCritical() {
        byte lvt_1_1_ = this.dataManager.get(CRITICAL);
        return (lvt_1_1_ & 1) != 0;
    }

    public void setEnchantmentEffectsFromEntity(EntityLivingBase p_setEnchantmentEffectsFromEntity_1_, float p_setEnchantmentEffectsFromEntity_2_) {
        int lvt_3_1_ = EnchantmentHelper.getMaxEnchantmentLevel(Enchantments.POWER, p_setEnchantmentEffectsFromEntity_1_);
        int lvt_4_1_ = EnchantmentHelper.getMaxEnchantmentLevel(Enchantments.PUNCH, p_setEnchantmentEffectsFromEntity_1_);
        this.setDamage((double)(p_setEnchantmentEffectsFromEntity_2_ * 2.0f) + (this.rand.nextGaussian() * 0.25 + (double)((float)this.world.getDifficulty().getDifficultyId() * 0.11f)));
        if (lvt_3_1_ > 0) {
            this.setDamage(this.getDamage() + (double)lvt_3_1_ * 0.5 + 0.5);
        }
        if (lvt_4_1_ > 0) {
            this.setKnockbackStrength(lvt_4_1_);
        }
        if (EnchantmentHelper.getMaxEnchantmentLevel(Enchantments.FLAME, p_setEnchantmentEffectsFromEntity_1_) > 0) {
            this.setFire(100);
        }
    }

    public static enum PickupStatus {
        DISALLOWED,
        ALLOWED,
        CREATIVE_ONLY;


        public static PickupStatus getByOrdinal(int p_getByOrdinal_0_) {
            if (p_getByOrdinal_0_ < 0 || p_getByOrdinal_0_ > PickupStatus.values().length) {
                p_getByOrdinal_0_ = 0;
            }
            return PickupStatus.values()[p_getByOrdinal_0_];
        }
    }
}

