/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.List;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityDragonFireball
extends EntityFireball {
    public EntityDragonFireball(World p_i46774_1_) {
        super(p_i46774_1_);
        this.setSize(1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityDragonFireball(World p_i46775_1_, double p_i46775_2_, double p_i46775_4_, double p_i46775_6_, double p_i46775_8_, double p_i46775_10_, double p_i46775_12_) {
        super(p_i46775_1_, p_i46775_2_, p_i46775_4_, p_i46775_6_, p_i46775_8_, p_i46775_10_, p_i46775_12_);
        this.setSize(1.0f, 1.0f);
    }

    public EntityDragonFireball(World p_i46776_1_, EntityLivingBase p_i46776_2_, double p_i46776_3_, double p_i46776_5_, double p_i46776_7_) {
        super(p_i46776_1_, p_i46776_2_, p_i46776_3_, p_i46776_5_, p_i46776_7_);
        this.setSize(1.0f, 1.0f);
    }

    public static void registerFixesDragonFireball(DataFixer p_registerFixesDragonFireball_0_) {
        EntityFireball.registerFixesFireball(p_registerFixesDragonFireball_0_, "DragonFireball");
    }

    @Override
    protected void onImpact(RayTraceResult p_onImpact_1_) {
        if (p_onImpact_1_.entityHit != null && p_onImpact_1_.entityHit.isEntityEqual(this.shootingEntity)) {
            return;
        }
        if (!this.world.isRemote) {
            List<EntityLivingBase> lvt_2_1_ = this.world.getEntitiesWithinAABB(EntityLivingBase.class, this.getEntityBoundingBox().expand(4.0, 2.0, 4.0));
            EntityAreaEffectCloud lvt_3_1_ = new EntityAreaEffectCloud(this.world, this.posX, this.posY, this.posZ);
            lvt_3_1_.setOwner(this.shootingEntity);
            lvt_3_1_.setParticle(EnumParticleTypes.DRAGON_BREATH);
            lvt_3_1_.setRadius(3.0f);
            lvt_3_1_.setDuration(600);
            lvt_3_1_.setRadiusPerTick((7.0f - lvt_3_1_.getRadius()) / (float)lvt_3_1_.getDuration());
            lvt_3_1_.addEffect(new PotionEffect(MobEffects.INSTANT_DAMAGE, 1, 1));
            if (!lvt_2_1_.isEmpty()) {
                for (EntityLivingBase lvt_5_1_ : lvt_2_1_) {
                    double lvt_6_1_ = this.getDistanceSqToEntity(lvt_5_1_);
                    if (!(lvt_6_1_ < 16.0)) continue;
                    lvt_3_1_.setPosition(lvt_5_1_.posX, lvt_5_1_.posY, lvt_5_1_.posZ);
                    break;
                }
            }
            this.world.playEvent(2006, new BlockPos(this.posX, this.posY, this.posZ), 0);
            this.world.spawnEntity(lvt_3_1_);
            this.setDead();
        }
    }

    @Override
    public boolean canBeCollidedWith() {
        return false;
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        return false;
    }

    @Override
    protected EnumParticleTypes getParticleType() {
        return EnumParticleTypes.DRAGON_BREATH;
    }

    @Override
    protected boolean isFireballFiery() {
        return false;
    }
}

