/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityEgg
extends EntityThrowable {
    public EntityEgg(World p_i1779_1_) {
        super(p_i1779_1_);
    }

    public EntityEgg(World p_i1780_1_, EntityLivingBase p_i1780_2_) {
        super(p_i1780_1_, p_i1780_2_);
    }

    public EntityEgg(World p_i1781_1_, double p_i1781_2_, double p_i1781_4_, double p_i1781_6_) {
        super(p_i1781_1_, p_i1781_2_, p_i1781_4_, p_i1781_6_);
    }

    public static void registerFixesEgg(DataFixer p_registerFixesEgg_0_) {
        EntityThrowable.registerFixesThrowable(p_registerFixesEgg_0_, "ThrownEgg");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte p_handleStatusUpdate_1_) {
        if (p_handleStatusUpdate_1_ == 3) {
            double lvt_2_1_ = 0.08;
            for (int lvt_4_1_ = 0; lvt_4_1_ < 8; ++lvt_4_1_) {
                this.world.spawnParticle(EnumParticleTypes.ITEM_CRACK, this.posX, this.posY, this.posZ, ((double)this.rand.nextFloat() - 0.5) * 0.08, ((double)this.rand.nextFloat() - 0.5) * 0.08, ((double)this.rand.nextFloat() - 0.5) * 0.08, Item.getIdFromItem(Items.EGG));
            }
        }
    }

    @Override
    protected void onImpact(RayTraceResult p_onImpact_1_) {
        if (p_onImpact_1_.entityHit != null) {
            p_onImpact_1_.entityHit.attackEntityFrom(DamageSource.causeThrownDamage(this, this.getThrower()), 0.0f);
        }
        if (!this.world.isRemote) {
            if (this.rand.nextInt(8) == 0) {
                int lvt_2_1_ = 1;
                if (this.rand.nextInt(32) == 0) {
                    lvt_2_1_ = 4;
                }
                for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_1_; ++lvt_3_1_) {
                    EntityChicken lvt_4_1_ = new EntityChicken(this.world);
                    lvt_4_1_.setGrowingAge(-24000);
                    lvt_4_1_.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, 0.0f);
                    this.world.spawnEntity(lvt_4_1_);
                }
            }
            this.world.setEntityState(this, (byte)3);
            this.setDead();
        }
    }
}

