/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityEvokerFangs
extends Entity {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 22;
    private boolean clientSideAttackStarted;
    private EntityLivingBase caster;
    private UUID casterUuid;

    public EntityEvokerFangs(World p_i47275_1_) {
        super(p_i47275_1_);
        this.setSize(0.5f, 0.8f);
    }

    public EntityEvokerFangs(World p_i47276_1_, double p_i47276_2_, double p_i47276_4_, double p_i47276_6_, float p_i47276_8_, int p_i47276_9_, EntityLivingBase p_i47276_10_) {
        this(p_i47276_1_);
        this.warmupDelayTicks = p_i47276_9_;
        this.setCaster(p_i47276_10_);
        this.rotationYaw = p_i47276_8_ * 57.295776f;
        this.setPosition(p_i47276_2_, p_i47276_4_, p_i47276_6_);
    }

    @Override
    protected void entityInit() {
    }

    public void setCaster(EntityLivingBase p_setCaster_1_) {
        this.caster = p_setCaster_1_;
        this.casterUuid = p_setCaster_1_ == null ? null : p_setCaster_1_.getUniqueID();
    }

    @Nullable
    public EntityLivingBase getCaster() {
        Entity lvt_1_1_;
        if (this.caster == null && this.casterUuid != null && this.world instanceof WorldServer && (lvt_1_1_ = ((WorldServer)this.world).getEntityFromUuid(this.casterUuid)) instanceof EntityLivingBase) {
            this.caster = (EntityLivingBase)lvt_1_1_;
        }
        return this.caster;
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        this.warmupDelayTicks = p_readEntityFromNBT_1_.getInteger("Warmup");
        this.casterUuid = p_readEntityFromNBT_1_.getUniqueId("OwnerUUID");
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        p_writeEntityToNBT_1_.setInteger("Warmup", this.warmupDelayTicks);
        if (this.casterUuid != null) {
            p_writeEntityToNBT_1_.setUniqueId("OwnerUUID", this.casterUuid);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.world.isRemote) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
                if (this.lifeTicks == 14) {
                    for (int lvt_1_1_ = 0; lvt_1_1_ < 12; ++lvt_1_1_) {
                        double lvt_2_1_ = this.posX + (this.rand.nextDouble() * 2.0 - 1.0) * (double)this.width * 0.5;
                        double lvt_4_1_ = this.posY + 0.05 + this.rand.nextDouble() * 1.0;
                        double lvt_6_1_ = this.posZ + (this.rand.nextDouble() * 2.0 - 1.0) * (double)this.width * 0.5;
                        double lvt_8_1_ = (this.rand.nextDouble() * 2.0 - 1.0) * 0.3;
                        double lvt_10_1_ = 0.3 + this.rand.nextDouble() * 0.3;
                        double lvt_12_1_ = (this.rand.nextDouble() * 2.0 - 1.0) * 0.3;
                        this.world.spawnParticle(EnumParticleTypes.CRIT, lvt_2_1_, lvt_4_1_ + 1.0, lvt_6_1_, lvt_8_1_, lvt_10_1_, lvt_12_1_, new int[0]);
                    }
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -8) {
                List<EntityLivingBase> lvt_1_2_ = this.world.getEntitiesWithinAABB(EntityLivingBase.class, this.getEntityBoundingBox().expand(0.2, 0.0, 0.2));
                for (EntityLivingBase lvt_3_1_ : lvt_1_2_) {
                    this.damage(lvt_3_1_);
                }
            }
            if (!this.sentSpikeEvent) {
                this.world.setEntityState(this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.setDead();
            }
        }
    }

    private void damage(EntityLivingBase p_damage_1_) {
        EntityLivingBase lvt_2_1_ = this.getCaster();
        if (!p_damage_1_.isEntityAlive() || p_damage_1_.getIsInvulnerable() || p_damage_1_ == lvt_2_1_) {
            return;
        }
        if (lvt_2_1_ == null) {
            p_damage_1_.attackEntityFrom(DamageSource.MAGIC, 6.0f);
        } else {
            if (lvt_2_1_.isOnSameTeam(p_damage_1_)) {
                return;
            }
            p_damage_1_.attackEntityFrom(DamageSource.causeIndirectMagicDamage(this, lvt_2_1_), 6.0f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte p_handleStatusUpdate_1_) {
        super.handleStatusUpdate(p_handleStatusUpdate_1_);
        if (p_handleStatusUpdate_1_ == 4) {
            this.clientSideAttackStarted = true;
            if (!this.isSilent()) {
                this.world.playSound(this.posX, this.posY, this.posZ, SoundEvents.EVOCATION_FANGS_ATTACK, this.getSoundCategory(), 1.0f, this.rand.nextFloat() * 0.2f + 0.85f, false);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getAnimationProgress(float p_getAnimationProgress_1_) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int lvt_2_1_ = this.lifeTicks - 2;
        if (lvt_2_1_ <= 0) {
            return 1.0f;
        }
        return 1.0f - ((float)lvt_2_1_ - p_getAnimationProgress_1_) / 20.0f;
    }
}

