/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityFireball
extends Entity {
    public EntityLivingBase shootingEntity;
    private int ticksAlive;
    private int ticksInAir;
    public double accelerationX;
    public double accelerationY;
    public double accelerationZ;

    public EntityFireball(World p_i1759_1_) {
        super(p_i1759_1_);
        this.setSize(1.0f, 1.0f);
    }

    @Override
    protected void entityInit() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double p_isInRangeToRenderDist_1_) {
        double lvt_3_1_ = this.getEntityBoundingBox().getAverageEdgeLength() * 4.0;
        if (Double.isNaN(lvt_3_1_)) {
            lvt_3_1_ = 4.0;
        }
        return p_isInRangeToRenderDist_1_ < (lvt_3_1_ *= 64.0) * lvt_3_1_;
    }

    public EntityFireball(World p_i1760_1_, double p_i1760_2_, double p_i1760_4_, double p_i1760_6_, double p_i1760_8_, double p_i1760_10_, double p_i1760_12_) {
        super(p_i1760_1_);
        this.setSize(1.0f, 1.0f);
        this.setLocationAndAngles(p_i1760_2_, p_i1760_4_, p_i1760_6_, this.rotationYaw, this.rotationPitch);
        this.setPosition(p_i1760_2_, p_i1760_4_, p_i1760_6_);
        double lvt_14_1_ = MathHelper.sqrt(p_i1760_8_ * p_i1760_8_ + p_i1760_10_ * p_i1760_10_ + p_i1760_12_ * p_i1760_12_);
        this.accelerationX = p_i1760_8_ / lvt_14_1_ * 0.1;
        this.accelerationY = p_i1760_10_ / lvt_14_1_ * 0.1;
        this.accelerationZ = p_i1760_12_ / lvt_14_1_ * 0.1;
    }

    public EntityFireball(World p_i1761_1_, EntityLivingBase p_i1761_2_, double p_i1761_3_, double p_i1761_5_, double p_i1761_7_) {
        super(p_i1761_1_);
        this.shootingEntity = p_i1761_2_;
        this.setSize(1.0f, 1.0f);
        this.setLocationAndAngles(p_i1761_2_.posX, p_i1761_2_.posY, p_i1761_2_.posZ, p_i1761_2_.rotationYaw, p_i1761_2_.rotationPitch);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        double lvt_9_1_ = MathHelper.sqrt((p_i1761_3_ += this.rand.nextGaussian() * 0.4) * p_i1761_3_ + (p_i1761_5_ += this.rand.nextGaussian() * 0.4) * p_i1761_5_ + (p_i1761_7_ += this.rand.nextGaussian() * 0.4) * p_i1761_7_);
        this.accelerationX = p_i1761_3_ / lvt_9_1_ * 0.1;
        this.accelerationY = p_i1761_5_ / lvt_9_1_ * 0.1;
        this.accelerationZ = p_i1761_7_ / lvt_9_1_ * 0.1;
    }

    @Override
    public void onUpdate() {
        if (!this.world.isRemote && (this.shootingEntity != null && this.shootingEntity.isDead || !this.world.isBlockLoaded(new BlockPos(this)))) {
            this.setDead();
            return;
        }
        super.onUpdate();
        if (this.isFireballFiery()) {
            this.setFire(1);
        }
        ++this.ticksInAir;
        RayTraceResult lvt_1_1_ = ProjectileHelper.forwardsRaycast(this, true, this.ticksInAir >= 25, this.shootingEntity);
        if (lvt_1_1_ != null) {
            this.onImpact(lvt_1_1_);
        }
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        ProjectileHelper.rotateTowardsMovement(this, 0.2f);
        float lvt_2_1_ = this.getMotionFactor();
        if (this.isInWater()) {
            for (int lvt_3_1_ = 0; lvt_3_1_ < 4; ++lvt_3_1_) {
                float lvt_4_1_ = 0.25f;
                this.world.spawnParticle(EnumParticleTypes.WATER_BUBBLE, this.posX - this.motionX * 0.25, this.posY - this.motionY * 0.25, this.posZ - this.motionZ * 0.25, this.motionX, this.motionY, this.motionZ, new int[0]);
            }
            lvt_2_1_ = 0.8f;
        }
        this.motionX += this.accelerationX;
        this.motionY += this.accelerationY;
        this.motionZ += this.accelerationZ;
        this.motionX *= (double)lvt_2_1_;
        this.motionY *= (double)lvt_2_1_;
        this.motionZ *= (double)lvt_2_1_;
        this.world.spawnParticle(this.getParticleType(), this.posX, this.posY + 0.5, this.posZ, 0.0, 0.0, 0.0, new int[0]);
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    protected boolean isFireballFiery() {
        return true;
    }

    protected EnumParticleTypes getParticleType() {
        return EnumParticleTypes.SMOKE_NORMAL;
    }

    protected float getMotionFactor() {
        return 0.95f;
    }

    protected abstract void onImpact(RayTraceResult var1);

    public static void registerFixesFireball(DataFixer p_registerFixesFireball_0_, String p_registerFixesFireball_1_) {
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        p_writeEntityToNBT_1_.setTag("direction", this.newDoubleNBTList(this.motionX, this.motionY, this.motionZ));
        p_writeEntityToNBT_1_.setTag("power", this.newDoubleNBTList(this.accelerationX, this.accelerationY, this.accelerationZ));
        p_writeEntityToNBT_1_.setInteger("life", this.ticksAlive);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        NBTTagList lvt_2_1_;
        if (p_readEntityFromNBT_1_.hasKey("power", 9) && (lvt_2_1_ = p_readEntityFromNBT_1_.getTagList("power", 6)).tagCount() == 3) {
            this.accelerationX = lvt_2_1_.getDoubleAt(0);
            this.accelerationY = lvt_2_1_.getDoubleAt(1);
            this.accelerationZ = lvt_2_1_.getDoubleAt(2);
        }
        this.ticksAlive = p_readEntityFromNBT_1_.getInteger("life");
        if (p_readEntityFromNBT_1_.hasKey("direction", 9) && p_readEntityFromNBT_1_.getTagList("direction", 6).tagCount() == 3) {
            NBTTagList lvt_2_2_ = p_readEntityFromNBT_1_.getTagList("direction", 6);
            this.motionX = lvt_2_2_.getDoubleAt(0);
            this.motionY = lvt_2_2_.getDoubleAt(1);
            this.motionZ = lvt_2_2_.getDoubleAt(2);
        } else {
            this.setDead();
        }
    }

    @Override
    public boolean canBeCollidedWith() {
        return true;
    }

    @Override
    public float getCollisionBorderSize() {
        return 1.0f;
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        if (this.isEntityInvulnerable(p_attackEntityFrom_1_)) {
            return false;
        }
        this.setBeenAttacked();
        if (p_attackEntityFrom_1_.getEntity() != null) {
            Vec3d lvt_3_1_ = p_attackEntityFrom_1_.getEntity().getLookVec();
            if (lvt_3_1_ != null) {
                this.motionX = lvt_3_1_.xCoord;
                this.motionY = lvt_3_1_.yCoord;
                this.motionZ = lvt_3_1_.zCoord;
                this.accelerationX = this.motionX * 0.1;
                this.accelerationY = this.motionY * 0.1;
                this.accelerationZ = this.motionZ * 0.1;
            }
            if (p_attackEntityFrom_1_.getEntity() instanceof EntityLivingBase) {
                this.shootingEntity = (EntityLivingBase)p_attackEntityFrom_1_.getEntity();
            }
            return true;
        }
        return false;
    }

    @Override
    public float getBrightness(float p_getBrightness_1_) {
        return 1.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float p_getBrightnessForRender_1_) {
        return 0xF000F0;
    }
}

