/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFishHook
extends Entity {
    private static final DataParameter<Integer> DATA_HOOKED_ENTITY = EntityDataManager.createKey(EntityFishHook.class, DataSerializers.VARINT);
    private boolean inGround;
    private int ticksInGround = 0;
    private EntityPlayer angler;
    private int ticksInAir;
    private int ticksCatchable;
    private int ticksCaughtDelay;
    private int ticksCatchableDelay;
    private float fishApproachAngle;
    public Entity caughtEntity;
    private State currentState = State.FLYING;
    private int field_191518_aw;
    private int field_191519_ax;

    @SideOnly(value=Side.CLIENT)
    public EntityFishHook(World p_i47290_1_, EntityPlayer p_i47290_2_, double p_i47290_3_, double p_i47290_5_, double p_i47290_7_) {
        super(p_i47290_1_);
        this.init(p_i47290_2_);
        this.setPosition(p_i47290_3_, p_i47290_5_, p_i47290_7_);
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
    }

    public EntityFishHook(World p_i1766_1_, EntityPlayer p_i1766_2_) {
        super(p_i1766_1_);
        this.init(p_i1766_2_);
        this.shoot();
    }

    private void init(EntityPlayer p_init_1_) {
        this.setSize(0.25f, 0.25f);
        this.ignoreFrustumCheck = true;
        this.angler = p_init_1_;
        this.angler.fishEntity = this;
    }

    public void func_191516_a(int p_191516_1_) {
        this.field_191519_ax = p_191516_1_;
    }

    public void func_191517_b(int p_191517_1_) {
        this.field_191518_aw = p_191517_1_;
    }

    private void shoot() {
        float lvt_1_1_ = this.angler.prevRotationPitch + (this.angler.rotationPitch - this.angler.prevRotationPitch);
        float lvt_2_1_ = this.angler.prevRotationYaw + (this.angler.rotationYaw - this.angler.prevRotationYaw);
        float lvt_3_1_ = MathHelper.cos(-lvt_2_1_ * ((float)Math.PI / 180) - (float)Math.PI);
        float lvt_4_1_ = MathHelper.sin(-lvt_2_1_ * ((float)Math.PI / 180) - (float)Math.PI);
        float lvt_5_1_ = -MathHelper.cos(-lvt_1_1_ * ((float)Math.PI / 180));
        float lvt_6_1_ = MathHelper.sin(-lvt_1_1_ * ((float)Math.PI / 180));
        double lvt_7_1_ = this.angler.prevPosX + (this.angler.posX - this.angler.prevPosX) - (double)lvt_4_1_ * 0.3;
        double lvt_9_1_ = this.angler.prevPosY + (this.angler.posY - this.angler.prevPosY) + (double)this.angler.getEyeHeight();
        double lvt_11_1_ = this.angler.prevPosZ + (this.angler.posZ - this.angler.prevPosZ) - (double)lvt_3_1_ * 0.3;
        this.setLocationAndAngles(lvt_7_1_, lvt_9_1_, lvt_11_1_, lvt_2_1_, lvt_1_1_);
        this.motionX = -lvt_4_1_;
        this.motionY = MathHelper.clamp(-(lvt_6_1_ / lvt_5_1_), -5.0f, 5.0f);
        this.motionZ = -lvt_3_1_;
        float lvt_13_1_ = MathHelper.sqrt(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ);
        this.motionX *= 0.6 / (double)lvt_13_1_ + 0.5 + this.rand.nextGaussian() * 0.0045;
        this.motionY *= 0.6 / (double)lvt_13_1_ + 0.5 + this.rand.nextGaussian() * 0.0045;
        this.motionZ *= 0.6 / (double)lvt_13_1_ + 0.5 + this.rand.nextGaussian() * 0.0045;
        float lvt_14_1_ = MathHelper.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
        this.rotationYaw = (float)(MathHelper.atan2(this.motionX, this.motionZ) * 57.2957763671875);
        this.rotationPitch = (float)(MathHelper.atan2(this.motionY, lvt_14_1_) * 57.2957763671875);
        this.prevRotationYaw = this.rotationYaw;
        this.prevRotationPitch = this.rotationPitch;
    }

    @Override
    protected void entityInit() {
        this.getDataManager().register(DATA_HOOKED_ENTITY, 0);
    }

    @Override
    public void notifyDataManagerChange(DataParameter<?> p_notifyDataManagerChange_1_) {
        if (DATA_HOOKED_ENTITY.equals(p_notifyDataManagerChange_1_)) {
            int lvt_2_1_ = this.getDataManager().get(DATA_HOOKED_ENTITY);
            this.caughtEntity = lvt_2_1_ > 0 ? this.world.getEntityByID(lvt_2_1_ - 1) : null;
        }
        super.notifyDataManagerChange(p_notifyDataManagerChange_1_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double p_isInRangeToRenderDist_1_) {
        double lvt_3_1_ = 64.0;
        return p_isInRangeToRenderDist_1_ < 4096.0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotationDirect(double p_setPositionAndRotationDirect_1_, double p_setPositionAndRotationDirect_3_, double p_setPositionAndRotationDirect_5_, float p_setPositionAndRotationDirect_7_, float p_setPositionAndRotationDirect_8_, int p_setPositionAndRotationDirect_9_, boolean p_setPositionAndRotationDirect_10_) {
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.angler == null) {
            this.setDead();
            return;
        }
        if (!this.world.isRemote && this.shouldStopFishing()) {
            return;
        }
        if (this.inGround) {
            ++this.ticksInGround;
            if (this.ticksInGround >= 1200) {
                this.setDead();
                return;
            }
        }
        float lvt_1_1_ = 0.0f;
        BlockPos lvt_2_1_ = new BlockPos(this);
        IBlockState lvt_3_1_ = this.world.getBlockState(lvt_2_1_);
        if (lvt_3_1_.getMaterial() == Material.WATER) {
            lvt_1_1_ = BlockLiquid.getBlockLiquidHeight(lvt_3_1_, this.world, lvt_2_1_);
        }
        if (this.currentState == State.FLYING) {
            if (this.caughtEntity != null) {
                this.motionX = 0.0;
                this.motionY = 0.0;
                this.motionZ = 0.0;
                this.currentState = State.HOOKED_IN_ENTITY;
                return;
            }
            if (lvt_1_1_ > 0.0f) {
                this.motionX *= 0.3;
                this.motionY *= 0.2;
                this.motionZ *= 0.3;
                this.currentState = State.BOBBING;
                return;
            }
            if (!this.world.isRemote) {
                this.checkCollision();
            }
            if (this.inGround || this.onGround || this.isCollidedHorizontally) {
                this.ticksInAir = 0;
                this.motionX = 0.0;
                this.motionY = 0.0;
                this.motionZ = 0.0;
            } else {
                ++this.ticksInAir;
            }
        } else {
            if (this.currentState == State.HOOKED_IN_ENTITY) {
                if (this.caughtEntity != null) {
                    if (this.caughtEntity.isDead) {
                        this.caughtEntity = null;
                        this.currentState = State.FLYING;
                    } else {
                        this.posX = this.caughtEntity.posX;
                        this.posY = this.caughtEntity.getEntityBoundingBox().minY + (double)this.caughtEntity.height * 0.8;
                        this.posZ = this.caughtEntity.posZ;
                        this.setPosition(this.posX, this.posY, this.posZ);
                    }
                }
                return;
            }
            if (this.currentState == State.BOBBING) {
                this.motionX *= 0.9;
                this.motionZ *= 0.9;
                double lvt_4_1_ = this.posY + this.motionY - (double)lvt_2_1_.getY() - (double)lvt_1_1_;
                if (Math.abs(lvt_4_1_) < 0.01) {
                    lvt_4_1_ += Math.signum(lvt_4_1_) * 0.1;
                }
                this.motionY -= lvt_4_1_ * (double)this.rand.nextFloat() * 0.2;
                if (!this.world.isRemote && lvt_1_1_ > 0.0f) {
                    this.catchingFish(lvt_2_1_);
                }
            }
        }
        if (lvt_3_1_.getMaterial() != Material.WATER) {
            this.motionY -= 0.03;
        }
        this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
        this.updateRotation();
        double lvt_4_2_ = 0.92;
        this.motionX *= 0.92;
        this.motionY *= 0.92;
        this.motionZ *= 0.92;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    private boolean shouldStopFishing() {
        boolean lvt_4_1_;
        ItemStack lvt_1_1_ = this.angler.getHeldItemMainhand();
        ItemStack lvt_2_1_ = this.angler.getHeldItemOffhand();
        boolean lvt_3_1_ = lvt_1_1_.getItem() == Items.FISHING_ROD;
        boolean bl = lvt_4_1_ = lvt_2_1_.getItem() == Items.FISHING_ROD;
        if (this.angler.isDead || !this.angler.isEntityAlive() || !lvt_3_1_ && !lvt_4_1_ || this.getDistanceSqToEntity(this.angler) > 1024.0) {
            this.setDead();
            return true;
        }
        return false;
    }

    private void updateRotation() {
        float lvt_1_1_ = MathHelper.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
        this.rotationYaw = (float)(MathHelper.atan2(this.motionX, this.motionZ) * 57.2957763671875);
        this.rotationPitch = (float)(MathHelper.atan2(this.motionY, lvt_1_1_) * 57.2957763671875);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
    }

    private void checkCollision() {
        Vec3d lvt_1_1_ = new Vec3d(this.posX, this.posY, this.posZ);
        Vec3d lvt_2_1_ = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        RayTraceResult lvt_3_1_ = this.world.rayTraceBlocks(lvt_1_1_, lvt_2_1_, false, true, false);
        lvt_1_1_ = new Vec3d(this.posX, this.posY, this.posZ);
        lvt_2_1_ = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        if (lvt_3_1_ != null) {
            lvt_2_1_ = new Vec3d(lvt_3_1_.hitVec.xCoord, lvt_3_1_.hitVec.yCoord, lvt_3_1_.hitVec.zCoord);
        }
        Entity lvt_4_1_ = null;
        List<Entity> lvt_5_1_ = this.world.getEntitiesWithinAABBExcludingEntity(this, this.getEntityBoundingBox().addCoord(this.motionX, this.motionY, this.motionZ).expandXyz(1.0));
        double lvt_6_1_ = 0.0;
        for (Entity lvt_9_1_ : lvt_5_1_) {
            double lvt_12_1_;
            AxisAlignedBB lvt_10_1_;
            RayTraceResult lvt_11_1_;
            if (!this.canBeHooked(lvt_9_1_) || lvt_9_1_ == this.angler && this.ticksInAir < 5 || (lvt_11_1_ = (lvt_10_1_ = lvt_9_1_.getEntityBoundingBox().expandXyz(0.3f)).calculateIntercept(lvt_1_1_, lvt_2_1_)) == null || !((lvt_12_1_ = lvt_1_1_.squareDistanceTo(lvt_11_1_.hitVec)) < lvt_6_1_) && lvt_6_1_ != 0.0) continue;
            lvt_4_1_ = lvt_9_1_;
            lvt_6_1_ = lvt_12_1_;
        }
        if (lvt_4_1_ != null) {
            lvt_3_1_ = new RayTraceResult(lvt_4_1_);
        }
        if (lvt_3_1_ != null && lvt_3_1_.typeOfHit != RayTraceResult.Type.MISS) {
            if (lvt_3_1_.typeOfHit == RayTraceResult.Type.ENTITY) {
                this.caughtEntity = lvt_3_1_.entityHit;
                this.setHookedEntity();
            } else {
                this.inGround = true;
            }
        }
    }

    private void setHookedEntity() {
        this.getDataManager().set(DATA_HOOKED_ENTITY, this.caughtEntity.getEntityId() + 1);
    }

    private void catchingFish(BlockPos p_catchingFish_1_) {
        WorldServer lvt_2_1_ = (WorldServer)this.world;
        int lvt_3_1_ = 1;
        BlockPos lvt_4_1_ = p_catchingFish_1_.up();
        if (this.rand.nextFloat() < 0.25f && this.world.isRainingAt(lvt_4_1_)) {
            ++lvt_3_1_;
        }
        if (this.rand.nextFloat() < 0.5f && !this.world.canSeeSky(lvt_4_1_)) {
            --lvt_3_1_;
        }
        if (this.ticksCatchable > 0) {
            --this.ticksCatchable;
            if (this.ticksCatchable <= 0) {
                this.ticksCaughtDelay = 0;
                this.ticksCatchableDelay = 0;
            } else {
                this.motionY -= 0.2 * (double)this.rand.nextFloat() * (double)this.rand.nextFloat();
            }
        } else if (this.ticksCatchableDelay > 0) {
            this.ticksCatchableDelay -= lvt_3_1_;
            if (this.ticksCatchableDelay > 0) {
                double lvt_12_1_;
                this.fishApproachAngle = (float)((double)this.fishApproachAngle + this.rand.nextGaussian() * 4.0);
                float lvt_5_1_ = this.fishApproachAngle * ((float)Math.PI / 180);
                float lvt_6_1_ = MathHelper.sin(lvt_5_1_);
                float lvt_7_1_ = MathHelper.cos(lvt_5_1_);
                double lvt_8_1_ = this.posX + (double)(lvt_6_1_ * (float)this.ticksCatchableDelay * 0.1f);
                double lvt_10_1_ = (float)MathHelper.floor(this.getEntityBoundingBox().minY) + 1.0f;
                Block lvt_14_1_ = lvt_2_1_.getBlockState(new BlockPos(lvt_8_1_, lvt_10_1_ - 1.0, lvt_12_1_ = this.posZ + (double)(lvt_7_1_ * (float)this.ticksCatchableDelay * 0.1f))).getBlock();
                if (lvt_14_1_ == Blocks.WATER || lvt_14_1_ == Blocks.FLOWING_WATER) {
                    if (this.rand.nextFloat() < 0.15f) {
                        lvt_2_1_.spawnParticle(EnumParticleTypes.WATER_BUBBLE, lvt_8_1_, lvt_10_1_ - (double)0.1f, lvt_12_1_, 1, (double)lvt_6_1_, 0.1, (double)lvt_7_1_, 0.0, new int[0]);
                    }
                    float lvt_15_1_ = lvt_6_1_ * 0.04f;
                    float lvt_16_1_ = lvt_7_1_ * 0.04f;
                    lvt_2_1_.spawnParticle(EnumParticleTypes.WATER_WAKE, lvt_8_1_, lvt_10_1_, lvt_12_1_, 0, (double)lvt_16_1_, 0.01, (double)(-lvt_15_1_), 1.0, new int[0]);
                    lvt_2_1_.spawnParticle(EnumParticleTypes.WATER_WAKE, lvt_8_1_, lvt_10_1_, lvt_12_1_, 0, (double)(-lvt_16_1_), 0.01, (double)lvt_15_1_, 1.0, new int[0]);
                }
            } else {
                this.motionY = -0.4f * MathHelper.nextFloat(this.rand, 0.6f, 1.0f);
                this.playSound(SoundEvents.ENTITY_BOBBER_SPLASH, 0.25f, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
                double lvt_5_2_ = this.getEntityBoundingBox().minY + 0.5;
                lvt_2_1_.spawnParticle(EnumParticleTypes.WATER_BUBBLE, this.posX, lvt_5_2_, this.posZ, (int)(1.0f + this.width * 20.0f), (double)this.width, 0.0, (double)this.width, (double)0.2f, new int[0]);
                lvt_2_1_.spawnParticle(EnumParticleTypes.WATER_WAKE, this.posX, lvt_5_2_, this.posZ, (int)(1.0f + this.width * 20.0f), (double)this.width, 0.0, (double)this.width, (double)0.2f, new int[0]);
                this.ticksCatchable = MathHelper.getInt(this.rand, 20, 40);
            }
        } else if (this.ticksCaughtDelay > 0) {
            this.ticksCaughtDelay -= lvt_3_1_;
            float lvt_5_3_ = 0.15f;
            if (this.ticksCaughtDelay < 20) {
                lvt_5_3_ = (float)((double)lvt_5_3_ + (double)(20 - this.ticksCaughtDelay) * 0.05);
            } else if (this.ticksCaughtDelay < 40) {
                lvt_5_3_ = (float)((double)lvt_5_3_ + (double)(40 - this.ticksCaughtDelay) * 0.02);
            } else if (this.ticksCaughtDelay < 60) {
                lvt_5_3_ = (float)((double)lvt_5_3_ + (double)(60 - this.ticksCaughtDelay) * 0.01);
            }
            if (this.rand.nextFloat() < lvt_5_3_) {
                double lvt_12_2_;
                double lvt_10_2_;
                float lvt_6_2_ = MathHelper.nextFloat(this.rand, 0.0f, 360.0f) * ((float)Math.PI / 180);
                float lvt_7_2_ = MathHelper.nextFloat(this.rand, 25.0f, 60.0f);
                double lvt_8_2_ = this.posX + (double)(MathHelper.sin(lvt_6_2_) * lvt_7_2_ * 0.1f);
                Block lvt_14_2_ = lvt_2_1_.getBlockState(new BlockPos((int)lvt_8_2_, (int)(lvt_10_2_ = (double)((float)MathHelper.floor(this.getEntityBoundingBox().minY) + 1.0f)) - 1, (int)(lvt_12_2_ = this.posZ + (double)(MathHelper.cos(lvt_6_2_) * lvt_7_2_ * 0.1f)))).getBlock();
                if (lvt_14_2_ == Blocks.WATER || lvt_14_2_ == Blocks.FLOWING_WATER) {
                    lvt_2_1_.spawnParticle(EnumParticleTypes.WATER_SPLASH, lvt_8_2_, lvt_10_2_, lvt_12_2_, 2 + this.rand.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0, new int[0]);
                }
            }
            if (this.ticksCaughtDelay <= 0) {
                this.fishApproachAngle = MathHelper.nextFloat(this.rand, 0.0f, 360.0f);
                this.ticksCatchableDelay = MathHelper.getInt(this.rand, 20, 80);
            }
        } else {
            this.ticksCaughtDelay = MathHelper.getInt(this.rand, 100, 600);
            this.ticksCaughtDelay -= this.field_191519_ax * 20 * 5;
        }
    }

    protected boolean canBeHooked(Entity p_canBeHooked_1_) {
        return p_canBeHooked_1_.canBeCollidedWith() || p_canBeHooked_1_ instanceof EntityItem;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
    }

    public int handleHookRetraction() {
        if (this.world.isRemote || this.angler == null) {
            return 0;
        }
        int lvt_1_1_ = 0;
        if (this.caughtEntity != null) {
            this.bringInHookedEntity();
            this.world.setEntityState(this, (byte)31);
            lvt_1_1_ = this.caughtEntity instanceof EntityItem ? 3 : 5;
        } else if (this.ticksCatchable > 0) {
            LootContext.Builder lvt_2_1_ = new LootContext.Builder((WorldServer)this.world);
            lvt_2_1_.withLuck((float)this.field_191518_aw + this.angler.getLuck());
            for (ItemStack lvt_4_1_ : this.world.getLootTableManager().getLootTableFromLocation(LootTableList.GAMEPLAY_FISHING).generateLootForPools(this.rand, lvt_2_1_.build())) {
                EntityItem lvt_5_1_ = new EntityItem(this.world, this.posX, this.posY, this.posZ, lvt_4_1_);
                double lvt_6_1_ = this.angler.posX - this.posX;
                double lvt_8_1_ = this.angler.posY - this.posY;
                double lvt_10_1_ = this.angler.posZ - this.posZ;
                double lvt_12_1_ = MathHelper.sqrt(lvt_6_1_ * lvt_6_1_ + lvt_8_1_ * lvt_8_1_ + lvt_10_1_ * lvt_10_1_);
                double lvt_14_1_ = 0.1;
                lvt_5_1_.motionX = lvt_6_1_ * 0.1;
                lvt_5_1_.motionY = lvt_8_1_ * 0.1 + (double)MathHelper.sqrt(lvt_12_1_) * 0.08;
                lvt_5_1_.motionZ = lvt_10_1_ * 0.1;
                this.world.spawnEntity(lvt_5_1_);
                this.angler.world.spawnEntity(new EntityXPOrb(this.angler.world, this.angler.posX, this.angler.posY + 0.5, this.angler.posZ + 0.5, this.rand.nextInt(6) + 1));
                Item lvt_16_1_ = lvt_4_1_.getItem();
                if (lvt_16_1_ != Items.FISH && lvt_16_1_ != Items.COOKED_FISH) continue;
                this.angler.addStat(StatList.FISH_CAUGHT, 1);
            }
            lvt_1_1_ = 1;
        }
        if (this.inGround) {
            lvt_1_1_ = 2;
        }
        this.setDead();
        return lvt_1_1_;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte p_handleStatusUpdate_1_) {
        if (p_handleStatusUpdate_1_ == 31 && this.world.isRemote && this.caughtEntity instanceof EntityPlayer && ((EntityPlayer)this.caughtEntity).isUser()) {
            this.bringInHookedEntity();
        }
        super.handleStatusUpdate(p_handleStatusUpdate_1_);
    }

    protected void bringInHookedEntity() {
        if (this.angler == null) {
            return;
        }
        double lvt_1_1_ = this.angler.posX - this.posX;
        double lvt_3_1_ = this.angler.posY - this.posY;
        double lvt_5_1_ = this.angler.posZ - this.posZ;
        double lvt_7_1_ = 0.1;
        this.caughtEntity.motionX += lvt_1_1_ * 0.1;
        this.caughtEntity.motionY += lvt_3_1_ * 0.1;
        this.caughtEntity.motionZ += lvt_5_1_ * 0.1;
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    public void setDead() {
        super.setDead();
        if (this.angler != null) {
            this.angler.fishEntity = null;
        }
    }

    public EntityPlayer getAngler() {
        return this.angler;
    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

