/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLargeFireball
extends EntityFireball {
    public int explosionPower = 1;

    public EntityLargeFireball(World p_i1767_1_) {
        super(p_i1767_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityLargeFireball(World p_i1768_1_, double p_i1768_2_, double p_i1768_4_, double p_i1768_6_, double p_i1768_8_, double p_i1768_10_, double p_i1768_12_) {
        super(p_i1768_1_, p_i1768_2_, p_i1768_4_, p_i1768_6_, p_i1768_8_, p_i1768_10_, p_i1768_12_);
    }

    public EntityLargeFireball(World p_i1769_1_, EntityLivingBase p_i1769_2_, double p_i1769_3_, double p_i1769_5_, double p_i1769_7_) {
        super(p_i1769_1_, p_i1769_2_, p_i1769_3_, p_i1769_5_, p_i1769_7_);
    }

    @Override
    protected void onImpact(RayTraceResult p_onImpact_1_) {
        if (!this.world.isRemote) {
            if (p_onImpact_1_.entityHit != null) {
                p_onImpact_1_.entityHit.attackEntityFrom(DamageSource.causeFireballDamage(this, this.shootingEntity), 6.0f);
                this.applyEnchantments(this.shootingEntity, p_onImpact_1_.entityHit);
            }
            boolean lvt_2_1_ = this.world.getGameRules().getBoolean("mobGriefing");
            this.world.newExplosion(null, this.posX, this.posY, this.posZ, this.explosionPower, lvt_2_1_, lvt_2_1_);
            this.setDead();
        }
    }

    public static void registerFixesLargeFireball(DataFixer p_registerFixesLargeFireball_0_) {
        EntityFireball.registerFixesFireball(p_registerFixesLargeFireball_0_, "Fireball");
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setInteger("ExplosionPower", this.explosionPower);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        if (p_readEntityFromNBT_1_.hasKey("ExplosionPower", 99)) {
            this.explosionPower = p_readEntityFromNBT_1_.getInteger("ExplosionPower");
        }
    }
}

