/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLlamaSpit
extends Entity
implements IProjectile {
    public EntityLlama owner;
    private NBTTagCompound ownerNbt;

    public EntityLlamaSpit(World p_i47272_1_) {
        super(p_i47272_1_);
    }

    public EntityLlamaSpit(World p_i47273_1_, EntityLlama p_i47273_2_) {
        super(p_i47273_1_);
        this.owner = p_i47273_2_;
        this.setPosition(p_i47273_2_.posX - (double)(p_i47273_2_.width + 1.0f) * 0.5 * (double)MathHelper.sin(p_i47273_2_.renderYawOffset * ((float)Math.PI / 180)), p_i47273_2_.posY + (double)p_i47273_2_.getEyeHeight() - (double)0.1f, p_i47273_2_.posZ + (double)(p_i47273_2_.width + 1.0f) * 0.5 * (double)MathHelper.cos(p_i47273_2_.renderYawOffset * ((float)Math.PI / 180)));
        this.setSize(0.25f, 0.25f);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityLlamaSpit(World p_i47274_1_, double p_i47274_2_, double p_i47274_4_, double p_i47274_6_, double p_i47274_8_, double p_i47274_10_, double p_i47274_12_) {
        super(p_i47274_1_);
        this.setPosition(p_i47274_2_, p_i47274_4_, p_i47274_6_);
        for (int lvt_14_1_ = 0; lvt_14_1_ < 7; ++lvt_14_1_) {
            double lvt_15_1_ = 0.4 + 0.1 * (double)lvt_14_1_;
            p_i47274_1_.spawnParticle(EnumParticleTypes.SPIT, p_i47274_2_, p_i47274_4_, p_i47274_6_, p_i47274_8_ * lvt_15_1_, p_i47274_10_, p_i47274_12_ * lvt_15_1_, new int[0]);
        }
        this.motionX = p_i47274_8_;
        this.motionY = p_i47274_10_;
        this.motionZ = p_i47274_12_;
    }

    @Override
    public void onUpdate() {
        Entity lvt_4_1_;
        super.onUpdate();
        if (this.ownerNbt != null) {
            this.restoreOwnerFromSave();
        }
        Vec3d lvt_1_1_ = new Vec3d(this.posX, this.posY, this.posZ);
        Vec3d lvt_2_1_ = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        RayTraceResult lvt_3_1_ = this.world.rayTraceBlocks(lvt_1_1_, lvt_2_1_);
        lvt_1_1_ = new Vec3d(this.posX, this.posY, this.posZ);
        lvt_2_1_ = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        if (lvt_3_1_ != null) {
            lvt_2_1_ = new Vec3d(lvt_3_1_.hitVec.xCoord, lvt_3_1_.hitVec.yCoord, lvt_3_1_.hitVec.zCoord);
        }
        if ((lvt_4_1_ = this.getHitEntity(lvt_1_1_, lvt_2_1_)) != null) {
            lvt_3_1_ = new RayTraceResult(lvt_4_1_);
        }
        if (lvt_3_1_ != null) {
            this.onHit(lvt_3_1_);
        }
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float lvt_5_1_ = MathHelper.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
        this.rotationYaw = (float)(MathHelper.atan2(this.motionX, this.motionZ) * 57.2957763671875);
        this.rotationPitch = (float)(MathHelper.atan2(this.motionY, lvt_5_1_) * 57.2957763671875);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        float lvt_6_1_ = 0.99f;
        float lvt_7_1_ = 0.06f;
        if (!this.world.isMaterialInBB(this.getEntityBoundingBox(), Material.AIR)) {
            this.setDead();
            return;
        }
        if (this.isInWater()) {
            this.setDead();
            return;
        }
        this.motionX *= (double)0.99f;
        this.motionY *= (double)0.99f;
        this.motionZ *= (double)0.99f;
        if (!this.hasNoGravity()) {
            this.motionY -= (double)0.06f;
        }
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setVelocity(double p_setVelocity_1_, double p_setVelocity_3_, double p_setVelocity_5_) {
        this.motionX = p_setVelocity_1_;
        this.motionY = p_setVelocity_3_;
        this.motionZ = p_setVelocity_5_;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float lvt_7_1_ = MathHelper.sqrt(p_setVelocity_1_ * p_setVelocity_1_ + p_setVelocity_5_ * p_setVelocity_5_);
            this.rotationPitch = (float)(MathHelper.atan2(p_setVelocity_3_, lvt_7_1_) * 57.2957763671875);
            this.rotationYaw = (float)(MathHelper.atan2(p_setVelocity_1_, p_setVelocity_5_) * 57.2957763671875);
            this.prevRotationPitch = this.rotationPitch;
            this.prevRotationYaw = this.rotationYaw;
            this.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
        }
    }

    @Nullable
    private Entity getHitEntity(Vec3d p_getHitEntity_1_, Vec3d p_getHitEntity_2_) {
        Entity lvt_3_1_ = null;
        List<Entity> lvt_4_1_ = this.world.getEntitiesWithinAABBExcludingEntity(this, this.getEntityBoundingBox().addCoord(this.motionX, this.motionY, this.motionZ).expandXyz(1.0));
        double lvt_5_1_ = 0.0;
        for (Entity lvt_8_1_ : lvt_4_1_) {
            double lvt_11_1_;
            AxisAlignedBB lvt_9_1_;
            RayTraceResult lvt_10_1_;
            if (lvt_8_1_ == this.owner || (lvt_10_1_ = (lvt_9_1_ = lvt_8_1_.getEntityBoundingBox().expandXyz(0.3f)).calculateIntercept(p_getHitEntity_1_, p_getHitEntity_2_)) == null || !((lvt_11_1_ = p_getHitEntity_1_.squareDistanceTo(lvt_10_1_.hitVec)) < lvt_5_1_) && lvt_5_1_ != 0.0) continue;
            lvt_3_1_ = lvt_8_1_;
            lvt_5_1_ = lvt_11_1_;
        }
        return lvt_3_1_;
    }

    @Override
    public void setThrowableHeading(double p_setThrowableHeading_1_, double p_setThrowableHeading_3_, double p_setThrowableHeading_5_, float p_setThrowableHeading_7_, float p_setThrowableHeading_8_) {
        float lvt_9_1_ = MathHelper.sqrt(p_setThrowableHeading_1_ * p_setThrowableHeading_1_ + p_setThrowableHeading_3_ * p_setThrowableHeading_3_ + p_setThrowableHeading_5_ * p_setThrowableHeading_5_);
        p_setThrowableHeading_1_ /= (double)lvt_9_1_;
        p_setThrowableHeading_3_ /= (double)lvt_9_1_;
        p_setThrowableHeading_5_ /= (double)lvt_9_1_;
        p_setThrowableHeading_1_ += this.rand.nextGaussian() * (double)0.0075f * (double)p_setThrowableHeading_8_;
        p_setThrowableHeading_3_ += this.rand.nextGaussian() * (double)0.0075f * (double)p_setThrowableHeading_8_;
        p_setThrowableHeading_5_ += this.rand.nextGaussian() * (double)0.0075f * (double)p_setThrowableHeading_8_;
        this.motionX = p_setThrowableHeading_1_ *= (double)p_setThrowableHeading_7_;
        this.motionY = p_setThrowableHeading_3_ *= (double)p_setThrowableHeading_7_;
        this.motionZ = p_setThrowableHeading_5_ *= (double)p_setThrowableHeading_7_;
        float lvt_10_1_ = MathHelper.sqrt(p_setThrowableHeading_1_ * p_setThrowableHeading_1_ + p_setThrowableHeading_5_ * p_setThrowableHeading_5_);
        this.rotationYaw = (float)(MathHelper.atan2(p_setThrowableHeading_1_, p_setThrowableHeading_5_) * 57.2957763671875);
        this.rotationPitch = (float)(MathHelper.atan2(p_setThrowableHeading_3_, lvt_10_1_) * 57.2957763671875);
        this.prevRotationYaw = this.rotationYaw;
        this.prevRotationPitch = this.rotationPitch;
    }

    public void onHit(RayTraceResult p_onHit_1_) {
        if (p_onHit_1_.entityHit != null && this.owner != null) {
            p_onHit_1_.entityHit.attackEntityFrom(DamageSource.causeIndirectDamage(this, this.owner).setProjectile(), 1.0f);
        }
        if (!this.world.isRemote) {
            this.setDead();
        }
    }

    @Override
    protected void entityInit() {
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        if (p_readEntityFromNBT_1_.hasKey("Owner", 10)) {
            this.ownerNbt = p_readEntityFromNBT_1_.getCompoundTag("Owner");
        }
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        if (this.owner != null) {
            NBTTagCompound lvt_2_1_ = new NBTTagCompound();
            UUID lvt_3_1_ = this.owner.getUniqueID();
            lvt_2_1_.setUniqueId("OwnerUUID", lvt_3_1_);
            p_writeEntityToNBT_1_.setTag("Owner", lvt_2_1_);
        }
    }

    private void restoreOwnerFromSave() {
        if (this.ownerNbt != null && this.ownerNbt.hasUniqueId("OwnerUUID")) {
            UUID lvt_1_1_ = this.ownerNbt.getUniqueId("OwnerUUID");
            List<EntityLlama> lvt_2_1_ = this.world.getEntitiesWithinAABB(EntityLlama.class, this.getEntityBoundingBox().expandXyz(15.0));
            for (EntityLlama lvt_4_1_ : lvt_2_1_) {
                if (!lvt_4_1_.getUniqueID().equals(lvt_1_1_)) continue;
                this.owner = lvt_4_1_;
                break;
            }
        }
        this.ownerNbt = null;
    }
}

