/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.ItemStackData;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityPotion
extends EntityThrowable {
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.createKey(EntityPotion.class, DataSerializers.OPTIONAL_ITEM_STACK);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Predicate<EntityLivingBase> WATER_SENSITIVE = new Predicate<EntityLivingBase>(){

        public boolean apply(EntityLivingBase p_apply_1_) {
            return EntityPotion.isWaterSensitiveEntity(p_apply_1_);
        }

        public /* synthetic */ boolean apply(Object p_apply_1_) {
            return this.apply((EntityLivingBase)p_apply_1_);
        }
    };

    public EntityPotion(World p_i1788_1_) {
        super(p_i1788_1_);
    }

    public EntityPotion(World p_i1790_1_, EntityLivingBase p_i1790_2_, ItemStack p_i1790_3_) {
        super(p_i1790_1_, p_i1790_2_);
        this.setItem(p_i1790_3_);
    }

    public EntityPotion(World p_i1792_1_, double p_i1792_2_, double p_i1792_4_, double p_i1792_6_, ItemStack p_i1792_8_) {
        super(p_i1792_1_, p_i1792_2_, p_i1792_4_, p_i1792_6_);
        if (!p_i1792_8_.isEmpty()) {
            this.setItem(p_i1792_8_);
        }
    }

    @Override
    protected void entityInit() {
        this.getDataManager().register(ITEM, ItemStack.EMPTY);
    }

    public ItemStack getPotion() {
        ItemStack lvt_1_1_ = this.getDataManager().get(ITEM);
        if (lvt_1_1_.getItem() != Items.SPLASH_POTION && lvt_1_1_.getItem() != Items.LINGERING_POTION) {
            if (this.world != null) {
                LOGGER.error("ThrownPotion entity {} has no item?!", new Object[]{this.getEntityId()});
            }
            return new ItemStack(Items.SPLASH_POTION);
        }
        return lvt_1_1_;
    }

    public void setItem(ItemStack p_setItem_1_) {
        this.getDataManager().set(ITEM, p_setItem_1_);
        this.getDataManager().setDirty(ITEM);
    }

    @Override
    protected float getGravityVelocity() {
        return 0.05f;
    }

    @Override
    protected void onImpact(RayTraceResult p_onImpact_1_) {
        boolean lvt_5_1_;
        if (this.world.isRemote) {
            return;
        }
        ItemStack lvt_2_1_ = this.getPotion();
        PotionType lvt_3_1_ = PotionUtils.getPotionFromItem(lvt_2_1_);
        List<PotionEffect> lvt_4_1_ = PotionUtils.getEffectsFromStack(lvt_2_1_);
        boolean bl = lvt_5_1_ = lvt_3_1_ == PotionTypes.WATER && lvt_4_1_.isEmpty();
        if (p_onImpact_1_.typeOfHit == RayTraceResult.Type.BLOCK && lvt_5_1_) {
            BlockPos lvt_6_1_ = p_onImpact_1_.getBlockPos().offset(p_onImpact_1_.sideHit);
            this.extinguishFires(lvt_6_1_);
            for (EnumFacing lvt_8_1_ : EnumFacing.Plane.HORIZONTAL) {
                this.extinguishFires(lvt_6_1_.offset(lvt_8_1_));
            }
        }
        if (lvt_5_1_) {
            this.applyWater();
        } else if (!lvt_4_1_.isEmpty()) {
            if (this.isLingering()) {
                this.makeAreaOfEffectCloud(lvt_2_1_, lvt_3_1_);
            } else {
                this.applySplash(p_onImpact_1_, lvt_4_1_);
            }
        }
        int lvt_6_2_ = lvt_3_1_.hasInstantEffect() ? 2007 : 2002;
        this.world.playEvent(lvt_6_2_, new BlockPos(this), PotionUtils.getColor(lvt_2_1_));
        this.setDead();
    }

    private void applyWater() {
        AxisAlignedBB lvt_1_1_ = this.getEntityBoundingBox().expand(4.0, 2.0, 4.0);
        List<EntityLivingBase> lvt_2_1_ = this.world.getEntitiesWithinAABB(EntityLivingBase.class, lvt_1_1_, WATER_SENSITIVE);
        if (!lvt_2_1_.isEmpty()) {
            for (EntityLivingBase lvt_4_1_ : lvt_2_1_) {
                double lvt_5_1_ = this.getDistanceSqToEntity(lvt_4_1_);
                if (!(lvt_5_1_ < 16.0) || !EntityPotion.isWaterSensitiveEntity(lvt_4_1_)) continue;
                lvt_4_1_.attackEntityFrom(DamageSource.DROWN, 1.0f);
            }
        }
    }

    private void applySplash(RayTraceResult p_applySplash_1_, List<PotionEffect> p_applySplash_2_) {
        AxisAlignedBB lvt_3_1_ = this.getEntityBoundingBox().expand(4.0, 2.0, 4.0);
        List<EntityLivingBase> lvt_4_1_ = this.world.getEntitiesWithinAABB(EntityLivingBase.class, lvt_3_1_);
        if (!lvt_4_1_.isEmpty()) {
            for (EntityLivingBase lvt_6_1_ : lvt_4_1_) {
                double lvt_7_1_;
                if (!lvt_6_1_.canBeHitWithPotion() || !((lvt_7_1_ = this.getDistanceSqToEntity(lvt_6_1_)) < 16.0)) continue;
                double lvt_9_1_ = 1.0 - Math.sqrt(lvt_7_1_) / 4.0;
                if (lvt_6_1_ == p_applySplash_1_.entityHit) {
                    lvt_9_1_ = 1.0;
                }
                for (PotionEffect lvt_12_1_ : p_applySplash_2_) {
                    Potion lvt_13_1_ = lvt_12_1_.getPotion();
                    if (lvt_13_1_.isInstant()) {
                        lvt_13_1_.affectEntity(this, this.getThrower(), lvt_6_1_, lvt_12_1_.getAmplifier(), lvt_9_1_);
                        continue;
                    }
                    int lvt_14_1_ = (int)(lvt_9_1_ * (double)lvt_12_1_.getDuration() + 0.5);
                    if (lvt_14_1_ <= 20) continue;
                    lvt_6_1_.addPotionEffect(new PotionEffect(lvt_13_1_, lvt_14_1_, lvt_12_1_.getAmplifier(), lvt_12_1_.getIsAmbient(), lvt_12_1_.doesShowParticles()));
                }
            }
        }
    }

    private void makeAreaOfEffectCloud(ItemStack p_makeAreaOfEffectCloud_1_, PotionType p_makeAreaOfEffectCloud_2_) {
        EntityAreaEffectCloud lvt_3_1_ = new EntityAreaEffectCloud(this.world, this.posX, this.posY, this.posZ);
        lvt_3_1_.setOwner(this.getThrower());
        lvt_3_1_.setRadius(3.0f);
        lvt_3_1_.setRadiusOnUse(-0.5f);
        lvt_3_1_.setWaitTime(10);
        lvt_3_1_.setRadiusPerTick(-lvt_3_1_.getRadius() / (float)lvt_3_1_.getDuration());
        lvt_3_1_.setPotion(p_makeAreaOfEffectCloud_2_);
        for (PotionEffect lvt_5_1_ : PotionUtils.getFullEffectsFromItem(p_makeAreaOfEffectCloud_1_)) {
            lvt_3_1_.addEffect(new PotionEffect(lvt_5_1_));
        }
        NBTTagCompound lvt_4_1_ = p_makeAreaOfEffectCloud_1_.getTagCompound();
        if (lvt_4_1_ != null && lvt_4_1_.hasKey("CustomPotionColor", 99)) {
            lvt_3_1_.setColor(lvt_4_1_.getInteger("CustomPotionColor"));
        }
        this.world.spawnEntity(lvt_3_1_);
    }

    private boolean isLingering() {
        return this.getPotion().getItem() == Items.LINGERING_POTION;
    }

    private void extinguishFires(BlockPos p_extinguishFires_1_) {
        if (this.world.getBlockState(p_extinguishFires_1_).getBlock() == Blocks.FIRE) {
            this.world.setBlockState(p_extinguishFires_1_, Blocks.AIR.getDefaultState(), 2);
        }
    }

    public static void registerFixesPotion(DataFixer p_registerFixesPotion_0_) {
        EntityThrowable.registerFixesThrowable(p_registerFixesPotion_0_, "ThrownPotion");
        p_registerFixesPotion_0_.registerWalker(FixTypes.ENTITY, new ItemStackData(EntityPotion.class, "Potion"));
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        ItemStack lvt_2_1_ = new ItemStack(p_readEntityFromNBT_1_.getCompoundTag("Potion"));
        if (lvt_2_1_.isEmpty()) {
            this.setDead();
        } else {
            this.setItem(lvt_2_1_);
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        ItemStack lvt_2_1_ = this.getPotion();
        if (!lvt_2_1_.isEmpty()) {
            p_writeEntityToNBT_1_.setTag("Potion", lvt_2_1_.writeToNBT(new NBTTagCompound()));
        }
    }

    private static boolean isWaterSensitiveEntity(EntityLivingBase p_isWaterSensitiveEntity_0_) {
        return p_isWaterSensitiveEntity_0_ instanceof EntityEnderman || p_isWaterSensitiveEntity_0_ instanceof EntityBlaze;
    }
}

