/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityShulkerBullet
extends Entity {
    private EntityLivingBase owner;
    private Entity target;
    @Nullable
    private EnumFacing direction;
    private int steps;
    private double targetDeltaX;
    private double targetDeltaY;
    private double targetDeltaZ;
    @Nullable
    private UUID ownerUniqueId;
    private BlockPos ownerBlockPos;
    @Nullable
    private UUID targetUniqueId;
    private BlockPos targetBlockPos;

    public EntityShulkerBullet(World p_i46770_1_) {
        super(p_i46770_1_);
        this.setSize(0.3125f, 0.3125f);
        this.noClip = true;
    }

    @Override
    public SoundCategory getSoundCategory() {
        return SoundCategory.HOSTILE;
    }

    @SideOnly(value=Side.CLIENT)
    public EntityShulkerBullet(World p_i46771_1_, double p_i46771_2_, double p_i46771_4_, double p_i46771_6_, double p_i46771_8_, double p_i46771_10_, double p_i46771_12_) {
        this(p_i46771_1_);
        this.setLocationAndAngles(p_i46771_2_, p_i46771_4_, p_i46771_6_, this.rotationYaw, this.rotationPitch);
        this.motionX = p_i46771_8_;
        this.motionY = p_i46771_10_;
        this.motionZ = p_i46771_12_;
    }

    public EntityShulkerBullet(World p_i46772_1_, EntityLivingBase p_i46772_2_, Entity p_i46772_3_, EnumFacing.Axis p_i46772_4_) {
        this(p_i46772_1_);
        this.owner = p_i46772_2_;
        BlockPos lvt_5_1_ = new BlockPos(p_i46772_2_);
        double lvt_6_1_ = (double)lvt_5_1_.getX() + 0.5;
        double lvt_8_1_ = (double)lvt_5_1_.getY() + 0.5;
        double lvt_10_1_ = (double)lvt_5_1_.getZ() + 0.5;
        this.setLocationAndAngles(lvt_6_1_, lvt_8_1_, lvt_10_1_, this.rotationYaw, this.rotationPitch);
        this.target = p_i46772_3_;
        this.direction = EnumFacing.UP;
        this.selectNextMoveDirection(p_i46772_4_);
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        if (this.owner != null) {
            BlockPos lvt_2_1_ = new BlockPos(this.owner);
            NBTTagCompound lvt_3_1_ = NBTUtil.createUUIDTag(this.owner.getUniqueID());
            lvt_3_1_.setInteger("X", lvt_2_1_.getX());
            lvt_3_1_.setInteger("Y", lvt_2_1_.getY());
            lvt_3_1_.setInteger("Z", lvt_2_1_.getZ());
            p_writeEntityToNBT_1_.setTag("Owner", lvt_3_1_);
        }
        if (this.target != null) {
            BlockPos lvt_2_2_ = new BlockPos(this.target);
            NBTTagCompound lvt_3_2_ = NBTUtil.createUUIDTag(this.target.getUniqueID());
            lvt_3_2_.setInteger("X", lvt_2_2_.getX());
            lvt_3_2_.setInteger("Y", lvt_2_2_.getY());
            lvt_3_2_.setInteger("Z", lvt_2_2_.getZ());
            p_writeEntityToNBT_1_.setTag("Target", lvt_3_2_);
        }
        if (this.direction != null) {
            p_writeEntityToNBT_1_.setInteger("Dir", this.direction.getIndex());
        }
        p_writeEntityToNBT_1_.setInteger("Steps", this.steps);
        p_writeEntityToNBT_1_.setDouble("TXD", this.targetDeltaX);
        p_writeEntityToNBT_1_.setDouble("TYD", this.targetDeltaY);
        p_writeEntityToNBT_1_.setDouble("TZD", this.targetDeltaZ);
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        this.steps = p_readEntityFromNBT_1_.getInteger("Steps");
        this.targetDeltaX = p_readEntityFromNBT_1_.getDouble("TXD");
        this.targetDeltaY = p_readEntityFromNBT_1_.getDouble("TYD");
        this.targetDeltaZ = p_readEntityFromNBT_1_.getDouble("TZD");
        if (p_readEntityFromNBT_1_.hasKey("Dir", 99)) {
            this.direction = EnumFacing.getFront(p_readEntityFromNBT_1_.getInteger("Dir"));
        }
        if (p_readEntityFromNBT_1_.hasKey("Owner", 10)) {
            NBTTagCompound lvt_2_1_ = p_readEntityFromNBT_1_.getCompoundTag("Owner");
            this.ownerUniqueId = NBTUtil.getUUIDFromTag(lvt_2_1_);
            this.ownerBlockPos = new BlockPos(lvt_2_1_.getInteger("X"), lvt_2_1_.getInteger("Y"), lvt_2_1_.getInteger("Z"));
        }
        if (p_readEntityFromNBT_1_.hasKey("Target", 10)) {
            NBTTagCompound lvt_2_2_ = p_readEntityFromNBT_1_.getCompoundTag("Target");
            this.targetUniqueId = NBTUtil.getUUIDFromTag(lvt_2_2_);
            this.targetBlockPos = new BlockPos(lvt_2_2_.getInteger("X"), lvt_2_2_.getInteger("Y"), lvt_2_2_.getInteger("Z"));
        }
    }

    @Override
    protected void entityInit() {
    }

    private void setDirection(EnumFacing p_setDirection_1_) {
        this.direction = p_setDirection_1_;
    }

    private void selectNextMoveDirection(EnumFacing.Axis p_selectNextMoveDirection_1_) {
        BlockPos lvt_2_2_;
        double lvt_3_1_ = 0.5;
        if (this.target == null) {
            BlockPos lvt_2_1_ = new BlockPos(this).down();
        } else {
            lvt_3_1_ = (double)this.target.height * 0.5;
            lvt_2_2_ = new BlockPos(this.target.posX, this.target.posY + lvt_3_1_, this.target.posZ);
        }
        double lvt_5_1_ = (double)lvt_2_2_.getX() + 0.5;
        double lvt_7_1_ = (double)lvt_2_2_.getY() + lvt_3_1_;
        double lvt_9_1_ = (double)lvt_2_2_.getZ() + 0.5;
        EnumFacing lvt_11_1_ = null;
        if (lvt_2_2_.distanceSqToCenter(this.posX, this.posY, this.posZ) >= 4.0) {
            BlockPos lvt_12_1_ = new BlockPos(this);
            ArrayList lvt_13_1_ = Lists.newArrayList();
            if (p_selectNextMoveDirection_1_ != EnumFacing.Axis.X) {
                if (lvt_12_1_.getX() < lvt_2_2_.getX() && this.world.isAirBlock(lvt_12_1_.east())) {
                    lvt_13_1_.add(EnumFacing.EAST);
                } else if (lvt_12_1_.getX() > lvt_2_2_.getX() && this.world.isAirBlock(lvt_12_1_.west())) {
                    lvt_13_1_.add(EnumFacing.WEST);
                }
            }
            if (p_selectNextMoveDirection_1_ != EnumFacing.Axis.Y) {
                if (lvt_12_1_.getY() < lvt_2_2_.getY() && this.world.isAirBlock(lvt_12_1_.up())) {
                    lvt_13_1_.add(EnumFacing.UP);
                } else if (lvt_12_1_.getY() > lvt_2_2_.getY() && this.world.isAirBlock(lvt_12_1_.down())) {
                    lvt_13_1_.add(EnumFacing.DOWN);
                }
            }
            if (p_selectNextMoveDirection_1_ != EnumFacing.Axis.Z) {
                if (lvt_12_1_.getZ() < lvt_2_2_.getZ() && this.world.isAirBlock(lvt_12_1_.south())) {
                    lvt_13_1_.add(EnumFacing.SOUTH);
                } else if (lvt_12_1_.getZ() > lvt_2_2_.getZ() && this.world.isAirBlock(lvt_12_1_.north())) {
                    lvt_13_1_.add(EnumFacing.NORTH);
                }
            }
            lvt_11_1_ = EnumFacing.random(this.rand);
            if (lvt_13_1_.isEmpty()) {
                for (int lvt_14_1_ = 5; !this.world.isAirBlock(lvt_12_1_.offset(lvt_11_1_)) && lvt_14_1_ > 0; --lvt_14_1_) {
                    lvt_11_1_ = EnumFacing.random(this.rand);
                }
            } else {
                lvt_11_1_ = (EnumFacing)lvt_13_1_.get(this.rand.nextInt(lvt_13_1_.size()));
            }
            lvt_5_1_ = this.posX + (double)lvt_11_1_.getFrontOffsetX();
            lvt_7_1_ = this.posY + (double)lvt_11_1_.getFrontOffsetY();
            lvt_9_1_ = this.posZ + (double)lvt_11_1_.getFrontOffsetZ();
        }
        this.setDirection(lvt_11_1_);
        double lvt_12_2_ = lvt_5_1_ - this.posX;
        double lvt_14_2_ = lvt_7_1_ - this.posY;
        double lvt_16_1_ = lvt_9_1_ - this.posZ;
        double lvt_18_1_ = MathHelper.sqrt(lvt_12_2_ * lvt_12_2_ + lvt_14_2_ * lvt_14_2_ + lvt_16_1_ * lvt_16_1_);
        if (lvt_18_1_ == 0.0) {
            this.targetDeltaX = 0.0;
            this.targetDeltaY = 0.0;
            this.targetDeltaZ = 0.0;
        } else {
            this.targetDeltaX = lvt_12_2_ / lvt_18_1_ * 0.15;
            this.targetDeltaY = lvt_14_2_ / lvt_18_1_ * 0.15;
            this.targetDeltaZ = lvt_16_1_ / lvt_18_1_ * 0.15;
        }
        this.isAirBorne = true;
        this.steps = 10 + this.rand.nextInt(5) * 10;
    }

    @Override
    public void onUpdate() {
        if (!this.world.isRemote && this.world.getDifficulty() == EnumDifficulty.PEACEFUL) {
            this.setDead();
            return;
        }
        super.onUpdate();
        if (!this.world.isRemote) {
            if (this.target == null && this.targetUniqueId != null) {
                List<EntityLivingBase> lvt_1_1_ = this.world.getEntitiesWithinAABB(EntityLivingBase.class, new AxisAlignedBB(this.targetBlockPos.add(-2, -2, -2), this.targetBlockPos.add(2, 2, 2)));
                for (EntityLivingBase lvt_3_1_ : lvt_1_1_) {
                    if (!lvt_3_1_.getUniqueID().equals(this.targetUniqueId)) continue;
                    this.target = lvt_3_1_;
                    break;
                }
                this.targetUniqueId = null;
            }
            if (this.owner == null && this.ownerUniqueId != null) {
                List<EntityLivingBase> lvt_1_2_ = this.world.getEntitiesWithinAABB(EntityLivingBase.class, new AxisAlignedBB(this.ownerBlockPos.add(-2, -2, -2), this.ownerBlockPos.add(2, 2, 2)));
                for (EntityLivingBase lvt_3_2_ : lvt_1_2_) {
                    if (!lvt_3_2_.getUniqueID().equals(this.ownerUniqueId)) continue;
                    this.owner = lvt_3_2_;
                    break;
                }
                this.ownerUniqueId = null;
            }
            if (!(this.target == null || !this.target.isEntityAlive() || this.target instanceof EntityPlayer && ((EntityPlayer)this.target).isSpectator())) {
                this.targetDeltaX = MathHelper.clamp(this.targetDeltaX * 1.025, -1.0, 1.0);
                this.targetDeltaY = MathHelper.clamp(this.targetDeltaY * 1.025, -1.0, 1.0);
                this.targetDeltaZ = MathHelper.clamp(this.targetDeltaZ * 1.025, -1.0, 1.0);
                this.motionX += (this.targetDeltaX - this.motionX) * 0.2;
                this.motionY += (this.targetDeltaY - this.motionY) * 0.2;
                this.motionZ += (this.targetDeltaZ - this.motionZ) * 0.2;
            } else if (!this.hasNoGravity()) {
                this.motionY -= 0.04;
            }
            RayTraceResult lvt_1_3_ = ProjectileHelper.forwardsRaycast(this, true, false, this.owner);
            if (lvt_1_3_ != null) {
                this.bulletHit(lvt_1_3_);
            }
        }
        this.setPosition(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        ProjectileHelper.rotateTowardsMovement(this, 0.5f);
        if (this.world.isRemote) {
            this.world.spawnParticle(EnumParticleTypes.END_ROD, this.posX - this.motionX, this.posY - this.motionY + 0.15, this.posZ - this.motionZ, 0.0, 0.0, 0.0, new int[0]);
        } else if (this.target != null && !this.target.isDead) {
            if (this.steps > 0) {
                --this.steps;
                if (this.steps == 0) {
                    this.selectNextMoveDirection(this.direction == null ? null : this.direction.getAxis());
                }
            }
            if (this.direction != null) {
                BlockPos lvt_1_4_ = new BlockPos(this);
                EnumFacing.Axis lvt_2_1_ = this.direction.getAxis();
                if (this.world.isBlockNormalCube(lvt_1_4_.offset(this.direction), false)) {
                    this.selectNextMoveDirection(lvt_2_1_);
                } else {
                    BlockPos lvt_3_3_ = new BlockPos(this.target);
                    if (lvt_2_1_ == EnumFacing.Axis.X && lvt_1_4_.getX() == lvt_3_3_.getX() || lvt_2_1_ == EnumFacing.Axis.Z && lvt_1_4_.getZ() == lvt_3_3_.getZ() || lvt_2_1_ == EnumFacing.Axis.Y && lvt_1_4_.getY() == lvt_3_3_.getY()) {
                        this.selectNextMoveDirection(lvt_2_1_);
                    }
                }
            }
        }
    }

    @Override
    public boolean isBurning() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double p_isInRangeToRenderDist_1_) {
        return p_isInRangeToRenderDist_1_ < 16384.0;
    }

    @Override
    public float getBrightness(float p_getBrightness_1_) {
        return 1.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float p_getBrightnessForRender_1_) {
        return 0xF000F0;
    }

    protected void bulletHit(RayTraceResult p_bulletHit_1_) {
        if (p_bulletHit_1_.entityHit == null) {
            ((WorldServer)this.world).spawnParticle(EnumParticleTypes.EXPLOSION_LARGE, this.posX, this.posY, this.posZ, 2, 0.2, 0.2, 0.2, 0.0, new int[0]);
            this.playSound(SoundEvents.ENTITY_SHULKER_BULLET_HIT, 1.0f, 1.0f);
        } else {
            boolean lvt_2_1_ = p_bulletHit_1_.entityHit.attackEntityFrom(DamageSource.causeIndirectDamage(this, this.owner).setProjectile(), 4.0f);
            if (lvt_2_1_) {
                this.applyEnchantments(this.owner, p_bulletHit_1_.entityHit);
                if (p_bulletHit_1_.entityHit instanceof EntityLivingBase) {
                    ((EntityLivingBase)p_bulletHit_1_.entityHit).addPotionEffect(new PotionEffect(MobEffects.LEVITATION, 200));
                }
            }
        }
        this.setDead();
    }

    @Override
    public boolean canBeCollidedWith() {
        return true;
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        if (!this.world.isRemote) {
            this.playSound(SoundEvents.ENTITY_SHULKER_BULLET_HURT, 1.0f, 1.0f);
            ((WorldServer)this.world).spawnParticle(EnumParticleTypes.CRIT, this.posX, this.posY, this.posZ, 15, 0.2, 0.2, 0.2, 0.0, new int[0]);
            this.setDead();
        }
        return true;
    }
}

