/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntitySmallFireball
extends EntityFireball {
    public EntitySmallFireball(World p_i1770_1_) {
        super(p_i1770_1_);
        this.setSize(0.3125f, 0.3125f);
    }

    public EntitySmallFireball(World p_i1771_1_, EntityLivingBase p_i1771_2_, double p_i1771_3_, double p_i1771_5_, double p_i1771_7_) {
        super(p_i1771_1_, p_i1771_2_, p_i1771_3_, p_i1771_5_, p_i1771_7_);
        this.setSize(0.3125f, 0.3125f);
    }

    public EntitySmallFireball(World p_i1772_1_, double p_i1772_2_, double p_i1772_4_, double p_i1772_6_, double p_i1772_8_, double p_i1772_10_, double p_i1772_12_) {
        super(p_i1772_1_, p_i1772_2_, p_i1772_4_, p_i1772_6_, p_i1772_8_, p_i1772_10_, p_i1772_12_);
        this.setSize(0.3125f, 0.3125f);
    }

    public static void registerFixesSmallFireball(DataFixer p_registerFixesSmallFireball_0_) {
        EntityFireball.registerFixesFireball(p_registerFixesSmallFireball_0_, "SmallFireball");
    }

    @Override
    protected void onImpact(RayTraceResult p_onImpact_1_) {
        if (!this.world.isRemote) {
            if (p_onImpact_1_.entityHit != null) {
                boolean lvt_2_1_;
                if (!p_onImpact_1_.entityHit.isImmuneToFire() && (lvt_2_1_ = p_onImpact_1_.entityHit.attackEntityFrom(DamageSource.causeFireballDamage(this, this.shootingEntity), 5.0f))) {
                    this.applyEnchantments(this.shootingEntity, p_onImpact_1_.entityHit);
                    p_onImpact_1_.entityHit.setFire(5);
                }
            } else {
                BlockPos lvt_3_1_;
                boolean lvt_2_2_ = true;
                if (this.shootingEntity != null && this.shootingEntity instanceof EntityLiving) {
                    lvt_2_2_ = this.world.getGameRules().getBoolean("mobGriefing");
                }
                if (lvt_2_2_ && this.world.isAirBlock(lvt_3_1_ = p_onImpact_1_.getBlockPos().offset(p_onImpact_1_.sideHit))) {
                    this.world.setBlockState(lvt_3_1_, Blocks.FIRE.getDefaultState());
                }
            }
            this.setDead();
        }
    }

    @Override
    public boolean canBeCollidedWith() {
        return false;
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        return false;
    }
}

