/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySnowball
extends EntityThrowable {
    public EntitySnowball(World p_i1773_1_) {
        super(p_i1773_1_);
    }

    public EntitySnowball(World p_i1774_1_, EntityLivingBase p_i1774_2_) {
        super(p_i1774_1_, p_i1774_2_);
    }

    public EntitySnowball(World p_i1775_1_, double p_i1775_2_, double p_i1775_4_, double p_i1775_6_) {
        super(p_i1775_1_, p_i1775_2_, p_i1775_4_, p_i1775_6_);
    }

    public static void registerFixesSnowball(DataFixer p_registerFixesSnowball_0_) {
        EntityThrowable.registerFixesThrowable(p_registerFixesSnowball_0_, "Snowball");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte p_handleStatusUpdate_1_) {
        if (p_handleStatusUpdate_1_ == 3) {
            for (int lvt_2_1_ = 0; lvt_2_1_ < 8; ++lvt_2_1_) {
                this.world.spawnParticle(EnumParticleTypes.SNOWBALL, this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    protected void onImpact(RayTraceResult p_onImpact_1_) {
        if (p_onImpact_1_.entityHit != null) {
            int lvt_2_1_ = 0;
            if (p_onImpact_1_.entityHit instanceof EntityBlaze) {
                lvt_2_1_ = 3;
            }
            p_onImpact_1_.entityHit.attackEntityFrom(DamageSource.causeThrownDamage(this, this.getThrower()), lvt_2_1_);
        }
        if (!this.world.isRemote) {
            this.world.setEntityState(this, (byte)3);
            this.setDead();
        }
    }
}

