/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.World;

public class EntitySpectralArrow
extends EntityArrow {
    private int duration = 200;

    public EntitySpectralArrow(World p_i46767_1_) {
        super(p_i46767_1_);
    }

    public EntitySpectralArrow(World p_i46768_1_, EntityLivingBase p_i46768_2_) {
        super(p_i46768_1_, p_i46768_2_);
    }

    public EntitySpectralArrow(World p_i46769_1_, double p_i46769_2_, double p_i46769_4_, double p_i46769_6_) {
        super(p_i46769_1_, p_i46769_2_, p_i46769_4_, p_i46769_6_);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.world.isRemote && !this.inGround) {
            this.world.spawnParticle(EnumParticleTypes.SPELL_INSTANT, this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    protected ItemStack getArrowStack() {
        return new ItemStack(Items.SPECTRAL_ARROW);
    }

    @Override
    protected void arrowHit(EntityLivingBase p_arrowHit_1_) {
        super.arrowHit(p_arrowHit_1_);
        PotionEffect lvt_2_1_ = new PotionEffect(MobEffects.GLOWING, this.duration, 0);
        p_arrowHit_1_.addPotionEffect(lvt_2_1_);
    }

    public static void registerFixesSpectralArrow(DataFixer p_registerFixesSpectralArrow_0_) {
        EntityArrow.registerFixesArrow(p_registerFixesSpectralArrow_0_, "SpectralArrow");
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        if (p_readEntityFromNBT_1_.hasKey("Duration")) {
            this.duration = p_readEntityFromNBT_1_.getInteger("Duration");
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setInteger("Duration", this.duration);
    }
}

