/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityThrowable
extends Entity
implements IProjectile {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    protected boolean inGround;
    public int throwableShake;
    private EntityLivingBase thrower;
    private String throwerName;
    private int ticksInGround;
    private int ticksInAir;
    public Entity ignoreEntity;
    private int ignoreTime;

    public EntityThrowable(World p_i1776_1_) {
        super(p_i1776_1_);
        this.setSize(0.25f, 0.25f);
    }

    public EntityThrowable(World p_i1778_1_, double p_i1778_2_, double p_i1778_4_, double p_i1778_6_) {
        this(p_i1778_1_);
        this.setPosition(p_i1778_2_, p_i1778_4_, p_i1778_6_);
    }

    public EntityThrowable(World p_i1777_1_, EntityLivingBase p_i1777_2_) {
        this(p_i1777_1_, p_i1777_2_.posX, p_i1777_2_.posY + (double)p_i1777_2_.getEyeHeight() - (double)0.1f, p_i1777_2_.posZ);
        this.thrower = p_i1777_2_;
    }

    @Override
    protected void entityInit() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double p_isInRangeToRenderDist_1_) {
        double d0 = this.getEntityBoundingBox().getAverageEdgeLength() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return p_isInRangeToRenderDist_1_ < (d0 *= 64.0) * d0;
    }

    public void setHeadingFromThrower(Entity p_setHeadingFromThrower_1_, float p_setHeadingFromThrower_2_, float p_setHeadingFromThrower_3_, float p_setHeadingFromThrower_4_, float p_setHeadingFromThrower_5_, float p_setHeadingFromThrower_6_) {
        float f = -MathHelper.sin(p_setHeadingFromThrower_3_ * ((float)Math.PI / 180)) * MathHelper.cos(p_setHeadingFromThrower_2_ * ((float)Math.PI / 180));
        float f1 = -MathHelper.sin((p_setHeadingFromThrower_2_ + p_setHeadingFromThrower_4_) * ((float)Math.PI / 180));
        float f2 = MathHelper.cos(p_setHeadingFromThrower_3_ * ((float)Math.PI / 180)) * MathHelper.cos(p_setHeadingFromThrower_2_ * ((float)Math.PI / 180));
        this.setThrowableHeading(f, f1, f2, p_setHeadingFromThrower_5_, p_setHeadingFromThrower_6_);
        this.motionX += p_setHeadingFromThrower_1_.motionX;
        this.motionZ += p_setHeadingFromThrower_1_.motionZ;
        if (!p_setHeadingFromThrower_1_.onGround) {
            this.motionY += p_setHeadingFromThrower_1_.motionY;
        }
    }

    @Override
    public void setThrowableHeading(double p_setThrowableHeading_1_, double p_setThrowableHeading_3_, double p_setThrowableHeading_5_, float p_setThrowableHeading_7_, float p_setThrowableHeading_8_) {
        float f = MathHelper.sqrt(p_setThrowableHeading_1_ * p_setThrowableHeading_1_ + p_setThrowableHeading_3_ * p_setThrowableHeading_3_ + p_setThrowableHeading_5_ * p_setThrowableHeading_5_);
        p_setThrowableHeading_1_ /= (double)f;
        p_setThrowableHeading_3_ /= (double)f;
        p_setThrowableHeading_5_ /= (double)f;
        p_setThrowableHeading_1_ += this.rand.nextGaussian() * (double)0.0075f * (double)p_setThrowableHeading_8_;
        p_setThrowableHeading_3_ += this.rand.nextGaussian() * (double)0.0075f * (double)p_setThrowableHeading_8_;
        p_setThrowableHeading_5_ += this.rand.nextGaussian() * (double)0.0075f * (double)p_setThrowableHeading_8_;
        this.motionX = p_setThrowableHeading_1_ *= (double)p_setThrowableHeading_7_;
        this.motionY = p_setThrowableHeading_3_ *= (double)p_setThrowableHeading_7_;
        this.motionZ = p_setThrowableHeading_5_ *= (double)p_setThrowableHeading_7_;
        float f1 = MathHelper.sqrt(p_setThrowableHeading_1_ * p_setThrowableHeading_1_ + p_setThrowableHeading_5_ * p_setThrowableHeading_5_);
        this.rotationYaw = (float)(MathHelper.atan2(p_setThrowableHeading_1_, p_setThrowableHeading_5_) * 57.29577951308232);
        this.rotationPitch = (float)(MathHelper.atan2(p_setThrowableHeading_3_, f1) * 57.29577951308232);
        this.prevRotationYaw = this.rotationYaw;
        this.prevRotationPitch = this.rotationPitch;
        this.ticksInGround = 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setVelocity(double p_setVelocity_1_, double p_setVelocity_3_, double p_setVelocity_5_) {
        this.motionX = p_setVelocity_1_;
        this.motionY = p_setVelocity_3_;
        this.motionZ = p_setVelocity_5_;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float f = MathHelper.sqrt(p_setVelocity_1_ * p_setVelocity_1_ + p_setVelocity_5_ * p_setVelocity_5_);
            this.rotationYaw = (float)(MathHelper.atan2(p_setVelocity_1_, p_setVelocity_5_) * 57.29577951308232);
            this.rotationPitch = (float)(MathHelper.atan2(p_setVelocity_3_, f) * 57.29577951308232);
            this.prevRotationYaw = this.rotationYaw;
            this.prevRotationPitch = this.rotationPitch;
        }
    }

    @Override
    public void onUpdate() {
        this.lastTickPosX = this.posX;
        this.lastTickPosY = this.posY;
        this.lastTickPosZ = this.posZ;
        super.onUpdate();
        if (this.throwableShake > 0) {
            --this.throwableShake;
        }
        if (this.inGround) {
            if (this.world.getBlockState(new BlockPos(this.xTile, this.yTile, this.zTile)).getBlock() == this.inTile) {
                ++this.ticksInGround;
                if (this.ticksInGround == 1200) {
                    this.setDead();
                }
                return;
            }
            this.inGround = false;
            this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
            this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
            this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
            this.ticksInGround = 0;
            this.ticksInAir = 0;
        } else {
            ++this.ticksInAir;
        }
        Vec3d vec3d = new Vec3d(this.posX, this.posY, this.posZ);
        Vec3d vec3d1 = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        RayTraceResult raytraceresult = this.world.rayTraceBlocks(vec3d, vec3d1);
        vec3d = new Vec3d(this.posX, this.posY, this.posZ);
        vec3d1 = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.hitVec.xCoord, raytraceresult.hitVec.yCoord, raytraceresult.hitVec.zCoord);
        }
        Entity entity = null;
        List<Entity> list = this.world.getEntitiesWithinAABBExcludingEntity(this, this.getEntityBoundingBox().addCoord(this.motionX, this.motionY, this.motionZ).expandXyz(1.0));
        double d0 = 0.0;
        boolean flag = false;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            Entity entity1 = list.get(i);
            if (!entity1.canBeCollidedWith()) continue;
            if (entity1 == this.ignoreEntity) {
                flag = true;
                continue;
            }
            if (this.thrower != null && this.ticksExisted < 2 && this.ignoreEntity == null) {
                this.ignoreEntity = entity1;
                flag = true;
                continue;
            }
            flag = false;
            AxisAlignedBB axisalignedbb = entity1.getEntityBoundingBox().expandXyz(0.3f);
            RayTraceResult raytraceresult1 = axisalignedbb.calculateIntercept(vec3d, vec3d1);
            if (raytraceresult1 == null || !((d1 = vec3d.squareDistanceTo(raytraceresult1.hitVec)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        if (this.ignoreEntity != null) {
            if (flag) {
                this.ignoreTime = 2;
            } else if (this.ignoreTime-- <= 0) {
                this.ignoreEntity = null;
            }
        }
        if (entity != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null) {
            if (raytraceresult.typeOfHit == RayTraceResult.Type.BLOCK && this.world.getBlockState(raytraceresult.getBlockPos()).getBlock() == Blocks.PORTAL) {
                this.setPortal(raytraceresult.getBlockPos());
            } else if (!ForgeHooks.onThrowableImpact(this, raytraceresult)) {
                this.onImpact(raytraceresult);
            }
        }
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float f = MathHelper.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
        this.rotationYaw = (float)(MathHelper.atan2(this.motionX, this.motionZ) * 57.29577951308232);
        this.rotationPitch = (float)(MathHelper.atan2(this.motionY, f) * 57.29577951308232);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        float f1 = 0.99f;
        float f2 = this.getGravityVelocity();
        if (this.isInWater()) {
            for (int j = 0; j < 4; ++j) {
                float f3 = 0.25f;
                this.world.spawnParticle(EnumParticleTypes.WATER_BUBBLE, this.posX - this.motionX * 0.25, this.posY - this.motionY * 0.25, this.posZ - this.motionZ * 0.25, this.motionX, this.motionY, this.motionZ, new int[0]);
            }
            f1 = 0.8f;
        }
        this.motionX *= (double)f1;
        this.motionY *= (double)f1;
        this.motionZ *= (double)f1;
        if (!this.hasNoGravity()) {
            this.motionY -= (double)f2;
        }
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    protected abstract void onImpact(RayTraceResult var1);

    public static void registerFixesThrowable(DataFixer p_registerFixesThrowable_0_, String p_registerFixesThrowable_1_) {
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        p_writeEntityToNBT_1_.setInteger("xTile", this.xTile);
        p_writeEntityToNBT_1_.setInteger("yTile", this.yTile);
        p_writeEntityToNBT_1_.setInteger("zTile", this.zTile);
        ResourceLocation resourcelocation = Block.REGISTRY.getNameForObject(this.inTile);
        p_writeEntityToNBT_1_.setString("inTile", resourcelocation == null ? "" : resourcelocation.toString());
        p_writeEntityToNBT_1_.setByte("shake", (byte)this.throwableShake);
        p_writeEntityToNBT_1_.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        if ((this.throwerName == null || this.throwerName.isEmpty()) && this.thrower instanceof EntityPlayer) {
            this.throwerName = this.thrower.getName();
        }
        p_writeEntityToNBT_1_.setString("ownerName", this.throwerName == null ? "" : this.throwerName);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        this.xTile = p_readEntityFromNBT_1_.getInteger("xTile");
        this.yTile = p_readEntityFromNBT_1_.getInteger("yTile");
        this.zTile = p_readEntityFromNBT_1_.getInteger("zTile");
        this.inTile = p_readEntityFromNBT_1_.hasKey("inTile", 8) ? Block.getBlockFromName(p_readEntityFromNBT_1_.getString("inTile")) : Block.getBlockById(p_readEntityFromNBT_1_.getByte("inTile") & 0xFF);
        this.throwableShake = p_readEntityFromNBT_1_.getByte("shake") & 0xFF;
        this.inGround = p_readEntityFromNBT_1_.getByte("inGround") == 1;
        this.thrower = null;
        this.throwerName = p_readEntityFromNBT_1_.getString("ownerName");
        if (this.throwerName != null && this.throwerName.isEmpty()) {
            this.throwerName = null;
        }
        this.thrower = this.getThrower();
    }

    @Nullable
    public EntityLivingBase getThrower() {
        if (this.thrower == null && this.throwerName != null && !this.throwerName.isEmpty()) {
            this.thrower = this.world.getPlayerEntityByName(this.throwerName);
            if (this.thrower == null && this.world instanceof WorldServer) {
                try {
                    Entity entity = ((WorldServer)this.world).getEntityFromUuid(UUID.fromString(this.throwerName));
                    if (entity instanceof EntityLivingBase) {
                        this.thrower = (EntityLivingBase)entity;
                    }
                }
                catch (Throwable var2) {
                    this.thrower = null;
                }
            }
        }
        return this.thrower;
    }
}

