/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityTippedArrow
extends EntityArrow {
    private static final DataParameter<Integer> COLOR = EntityDataManager.createKey(EntityTippedArrow.class, DataSerializers.VARINT);
    private PotionType potion = PotionTypes.EMPTY;
    private final Set<PotionEffect> customPotionEffects = Sets.newHashSet();
    private boolean field_191509_at;

    public EntityTippedArrow(World p_i46756_1_) {
        super(p_i46756_1_);
    }

    public EntityTippedArrow(World p_i46757_1_, double p_i46757_2_, double p_i46757_4_, double p_i46757_6_) {
        super(p_i46757_1_, p_i46757_2_, p_i46757_4_, p_i46757_6_);
    }

    public EntityTippedArrow(World p_i46758_1_, EntityLivingBase p_i46758_2_) {
        super(p_i46758_1_, p_i46758_2_);
    }

    public void setPotionEffect(ItemStack p_setPotionEffect_1_) {
        if (p_setPotionEffect_1_.getItem() == Items.TIPPED_ARROW) {
            int lvt_3_1_;
            this.potion = PotionUtils.getPotionFromItem(p_setPotionEffect_1_);
            List<PotionEffect> lvt_2_1_ = PotionUtils.getFullEffectsFromItem(p_setPotionEffect_1_);
            if (!lvt_2_1_.isEmpty()) {
                for (PotionEffect lvt_4_1_ : lvt_2_1_) {
                    this.customPotionEffects.add(new PotionEffect(lvt_4_1_));
                }
            }
            if ((lvt_3_1_ = EntityTippedArrow.func_191508_b(p_setPotionEffect_1_)) == -1) {
                this.refreshColor();
            } else {
                this.func_191507_d(lvt_3_1_);
            }
        } else if (p_setPotionEffect_1_.getItem() == Items.ARROW) {
            this.potion = PotionTypes.EMPTY;
            this.customPotionEffects.clear();
            this.dataManager.set(COLOR, -1);
        }
    }

    public static int func_191508_b(ItemStack p_191508_0_) {
        NBTTagCompound lvt_1_1_ = p_191508_0_.getTagCompound();
        if (lvt_1_1_ != null && lvt_1_1_.hasKey("CustomPotionColor", 99)) {
            return lvt_1_1_.getInteger("CustomPotionColor");
        }
        return -1;
    }

    private void refreshColor() {
        this.field_191509_at = false;
        this.dataManager.set(COLOR, PotionUtils.getPotionColorFromEffectList(PotionUtils.mergeEffects(this.potion, this.customPotionEffects)));
    }

    public void addEffect(PotionEffect p_addEffect_1_) {
        this.customPotionEffects.add(p_addEffect_1_);
        this.getDataManager().set(COLOR, PotionUtils.getPotionColorFromEffectList(PotionUtils.mergeEffects(this.potion, this.customPotionEffects)));
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(COLOR, -1);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.world.isRemote) {
            if (this.inGround) {
                if (this.timeInGround % 5 == 0) {
                    this.spawnPotionParticles(1);
                }
            } else {
                this.spawnPotionParticles(2);
            }
        } else if (this.inGround && this.timeInGround != 0 && !this.customPotionEffects.isEmpty() && this.timeInGround >= 600) {
            this.world.setEntityState(this, (byte)0);
            this.potion = PotionTypes.EMPTY;
            this.customPotionEffects.clear();
            this.dataManager.set(COLOR, -1);
        }
    }

    private void spawnPotionParticles(int p_spawnPotionParticles_1_) {
        int lvt_2_1_ = this.getColor();
        if (lvt_2_1_ == -1 || p_spawnPotionParticles_1_ <= 0) {
            return;
        }
        double lvt_3_1_ = (double)(lvt_2_1_ >> 16 & 0xFF) / 255.0;
        double lvt_5_1_ = (double)(lvt_2_1_ >> 8 & 0xFF) / 255.0;
        double lvt_7_1_ = (double)(lvt_2_1_ >> 0 & 0xFF) / 255.0;
        for (int lvt_9_1_ = 0; lvt_9_1_ < p_spawnPotionParticles_1_; ++lvt_9_1_) {
            this.world.spawnParticle(EnumParticleTypes.SPELL_MOB, this.posX + (this.rand.nextDouble() - 0.5) * (double)this.width, this.posY + this.rand.nextDouble() * (double)this.height, this.posZ + (this.rand.nextDouble() - 0.5) * (double)this.width, lvt_3_1_, lvt_5_1_, lvt_7_1_, new int[0]);
        }
    }

    public int getColor() {
        return this.dataManager.get(COLOR);
    }

    private void func_191507_d(int p_191507_1_) {
        this.field_191509_at = true;
        this.dataManager.set(COLOR, p_191507_1_);
    }

    public static void registerFixesTippedArrow(DataFixer p_registerFixesTippedArrow_0_) {
        EntityArrow.registerFixesArrow(p_registerFixesTippedArrow_0_, "TippedArrow");
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        if (this.potion != PotionTypes.EMPTY && this.potion != null) {
            p_writeEntityToNBT_1_.setString("Potion", PotionType.REGISTRY.getNameForObject(this.potion).toString());
        }
        if (this.field_191509_at) {
            p_writeEntityToNBT_1_.setInteger("Color", this.getColor());
        }
        if (!this.customPotionEffects.isEmpty()) {
            NBTTagList lvt_2_1_ = new NBTTagList();
            for (PotionEffect lvt_4_1_ : this.customPotionEffects) {
                lvt_2_1_.appendTag(lvt_4_1_.writeCustomPotionEffectToNBT(new NBTTagCompound()));
            }
            p_writeEntityToNBT_1_.setTag("CustomPotionEffects", lvt_2_1_);
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        if (p_readEntityFromNBT_1_.hasKey("Potion", 8)) {
            this.potion = PotionUtils.getPotionTypeFromNBT(p_readEntityFromNBT_1_);
        }
        for (PotionEffect lvt_3_1_ : PotionUtils.getFullEffectsFromTag(p_readEntityFromNBT_1_)) {
            this.addEffect(lvt_3_1_);
        }
        if (p_readEntityFromNBT_1_.hasKey("Color", 99)) {
            this.func_191507_d(p_readEntityFromNBT_1_.getInteger("Color"));
        } else {
            this.refreshColor();
        }
    }

    @Override
    protected void arrowHit(EntityLivingBase p_arrowHit_1_) {
        super.arrowHit(p_arrowHit_1_);
        for (PotionEffect lvt_3_1_ : this.potion.getEffects()) {
            p_arrowHit_1_.addPotionEffect(new PotionEffect(lvt_3_1_.getPotion(), Math.max(lvt_3_1_.getDuration() / 8, 1), lvt_3_1_.getAmplifier(), lvt_3_1_.getIsAmbient(), lvt_3_1_.doesShowParticles()));
        }
        if (!this.customPotionEffects.isEmpty()) {
            for (PotionEffect lvt_3_2_ : this.customPotionEffects) {
                p_arrowHit_1_.addPotionEffect(lvt_3_2_);
            }
        }
    }

    @Override
    protected ItemStack getArrowStack() {
        if (this.customPotionEffects.isEmpty() && this.potion == PotionTypes.EMPTY) {
            return new ItemStack(Items.ARROW);
        }
        ItemStack lvt_1_1_ = new ItemStack(Items.TIPPED_ARROW);
        PotionUtils.addPotionToItemStack(lvt_1_1_, this.potion);
        PotionUtils.appendEffects(lvt_1_1_, this.customPotionEffects);
        if (this.field_191509_at) {
            NBTTagCompound lvt_2_1_ = lvt_1_1_.getTagCompound();
            if (lvt_2_1_ == null) {
                lvt_2_1_ = new NBTTagCompound();
                lvt_1_1_.setTagCompound(lvt_2_1_);
            }
            lvt_2_1_.setInteger("CustomPotionColor", this.getColor());
        }
        return lvt_1_1_;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte p_handleStatusUpdate_1_) {
        if (p_handleStatusUpdate_1_ == 0) {
            int lvt_2_1_ = this.getColor();
            if (lvt_2_1_ != -1) {
                double lvt_3_1_ = (double)(lvt_2_1_ >> 16 & 0xFF) / 255.0;
                double lvt_5_1_ = (double)(lvt_2_1_ >> 8 & 0xFF) / 255.0;
                double lvt_7_1_ = (double)(lvt_2_1_ >> 0 & 0xFF) / 255.0;
                for (int lvt_9_1_ = 0; lvt_9_1_ < 20; ++lvt_9_1_) {
                    this.world.spawnParticle(EnumParticleTypes.SPELL_MOB, this.posX + (this.rand.nextDouble() - 0.5) * (double)this.width, this.posY + this.rand.nextDouble() * (double)this.height, this.posZ + (this.rand.nextDouble() - 0.5) * (double)this.width, lvt_3_1_, lvt_5_1_, lvt_7_1_, new int[0]);
                }
            }
        } else {
            super.handleStatusUpdate(p_handleStatusUpdate_1_);
        }
    }
}

